#include "StdAfx.h"
#include "Gauge.h"
#include "Token.h"
#include "UISkinLexer.h"
#include "Parser.h"

#include "UIImage.h"
#include "UIContainer.h"
#include "FontAgent.h"
#include "PlaneObject.h"

cGauge::cGauge( eUINodeType type )
: cUINode( type )
, mpGaugeImage(0)
, mValue(0)
, mDestValue(0)
, mMaxValue(0)
, mPercent(0)
, mSpeed(0)
, mState( eGaugeState_None )
, mStartTime(0)
, mShowPercent( false )
, mShowText( true )
, mTextX(0)
, mTextY(0)
, mpImageTexture(0)
, mImagePos(0, 0)
, mImageSize(0, 0)
, mImageTexpos(0, 0)
, mGaugeSize(0, 0)
, mImageStart( true )
, mRightDecrease( false )
{

	mProcessEnable = true;
}

cGauge::~cGauge()
{
	SAFE_DELETE( mpGaugeImage );
}

void cGauge::Clear()
{
	mMaxValue = 0;
	mValue = 0;
	mDestValue = 0;
	mPercent = 0;
	mText.Clear();

	///
	UpdateGauge();
}

void cGauge::ClearFront()
{
	mValue = 0;
	mDestValue = 0;
	mState = eGaugeState_End;
	mText.Clear();

	///
	UpdateGauge();
}

bool cGauge::OnCreate( cUINodeProperty* pproperty )
{
	if( cUINode::OnCreate( pproperty ) == false )
		return false;

	if( mpImageTexture )
	{
		unsigned short x = GetAbsoluteRect().mLeft + mImagePos.mX;
		unsigned short y = GetAbsoluteRect().mTop + mImagePos.mY;

		mpGaugeImage = new cPlaneObject;
		if( mpGaugeImage->Create( mpImageTexture, x, y, mImageSize.mWidth, mImageSize.mHeight, 
								  mImageTexpos.mX, mImageTexpos.mY, 
								  mImageTexpos.mX + mImageSize.mWidth, 
								  mImageTexpos.mY + mImageSize.mHeight ) == false )
		{
			assert( 0 && "failed to create gauge image");
			return false;
		}
	}

	return true;
}

bool cGauge::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_GAUGE ) == false )
	{
		assert( 0 && "not gauge skin type" );
		return false;
	}
	
	if( cUINode::SetSkin( pskin ) == false )
		return false;

	cUISkin* pUISkin = UIMAN->GetSkin();
	if( !pskin )
	{
		assert(0);
		return false;
	}

	cGaugeSkin* p = (cGaugeSkin*)pskin;
	mSpeed = p->mGaugeSpeed;
	mShowPercent = p->mShowPercent;
	mShowText = p->mShowText;

	mpImageTexture = p->mpImageTexture;
	mImagePos = p->mImagePos;
	mImageSize = p->mImageSize;
	mImageTexpos = p->mImageTexpos;
	mGaugeSize = p->mGaugeSize;
	mImageStart = p->mImageStart;

	UpdateText();
	return true;
}

void cGauge::UpdateRect()
{
	cUINode::UpdateRect();

	if( mpGaugeImage )
		mpGaugeImage->SetScreenXY( (short)GetAbsoluteRect().mLeft + mImagePos.mX, (short)GetAbsoluteRect().mTop + mImagePos.mY );

	if( mRightDecrease )
	{
		short x = GetAbsoluteRect().mLeft + mImagePos.mX;
		x += (mGaugeSize.mWidth - mpGaugeImage->GetScreenW());

		if( mpGaugeImage )
			mpGaugeImage->SetScreenX( x );
	}

	///
	UpdateText();
}

void cGauge::UpdateSkin()
{
	cUINode::UpdateSkin();

	if( mpGaugeImage )
		mpGaugeImage->UpdateImage();
}

///
void cGauge::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	if( mState == eGaugeState_End || mState == eGaugeState_None )
		return;

	if( mState == eGaugeState_Start )
		mStartTime = accumTime;

	if( mValue == mDestValue )
	{
		mStartTime = 0;
		mState = eGaugeState_End;
	}

	float elapsedTime = (float)(accumTime - mStartTime) * 0.001f;
	mStartTime = accumTime;

	///    ġ ,  .
	if( mValue < mDestValue )
	{
		mValue += (elapsedTime * mSpeed);
		mState = eGaugeState_Process;

		/// ʰ ش 
		if( mValue > mDestValue )
		{
			mStartTime = 0;
			mValue = mDestValue;
			mState = eGaugeState_End;

			cUIEvent event;
			event.mpCaller = this;
			event.mType = eUIEVENT_GAUGE_END;
			mpParent->HandleEvent( event );
		}
	}
	/// ġ  쿡 ҽŲ 
	else if( mValue > mDestValue )
	{
		mValue = mDestValue;
		mState = eGaugeState_End;
		mStartTime = 0;
	}

	///  ŵǾ   Ų
	UpdateGauge();

	if( mRightDecrease )
	{
		short x = GetAbsoluteRect().mLeft + mImagePos.mX;
		x += (mGaugeSize.mWidth - mpGaugeImage->GetScreenW());

		if( mpGaugeImage )
			mpGaugeImage->SetScreenX( x );
	}
}

void cGauge::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mpImage )
		mpImage->Draw();

	/// ̹ 
	if( mpGaugeImage )
		mpGaugeImage->Draw();

	/// ۾ 
	if( mShowText )
		pKeeper->AddFontItem( cFontAgent::eFont_System, const_cast<LPTSTR>(mText.Cstr()), mTextX, mTextY, eCOLOR_WHITE );
}

/// ǥ ؼ ִϸ̼ Ų
void cGauge::SetGaugeAni( float value )
{
	if( mDestValue == value )
		return;

	if( value > mMaxValue )
		value = mMaxValue;
	else if( value < 0 )
		value = 0;

	mDestValue = value;

	/// ̹ μ̸ ׳ ̾ Ѵ 
	if( mState != eGaugeState_Process)
		mState = eGaugeState_Start;

	UpdateDestGauge();
}

///  ִϸ̼  
void cGauge::SetGaugeNoAni( float value )
{
	if( mValue == value )
		return;

	if( value > mMaxValue )
		value = mMaxValue;
	else if( value < 0 )
		value = 0;

	mValue = value;
	mDestValue = value;

	///  
	UpdateGauge();
}

///
void cGauge::SetMaxValue( float value )
{
	if( value <= 0 )
		return;

	if( value != mMaxValue )
	{
		mMaxValue = value;

		if( mValue > mMaxValue )
			mValue = mMaxValue;

		if( mDestValue > mMaxValue )
			mDestValue = mMaxValue;

		UpdateGauge();
	}
}

void cGauge::UpdateGauge()
{
	if( mMaxValue > 0 )
	{
		mPercent = (mValue * 100) / mMaxValue;

		int maxSize = ( (int)GetScreenWidth() < mGaugeSize.mWidth ) ? GetScreenWidth() : mGaugeSize.mWidth;

		///  
		unsigned short w = (unsigned short)( maxSize * mPercent * 0.01f );
		if( mpGaugeImage )
		{
			mpGaugeImage->SetScreenWH( w, mGaugeSize.mHeight );
		}

		///  
		UpdateText();
	}
}

/// ǻ :   ѷ ġ Ʈ 
void cGauge::UpdateText()
{
	if( mShowText )
	{
		/// ġ ״ ϷѴٸ,
		if( mShowPercent == false )
			mText.Format( _T("%d / %d"), (int)mValue, (int)mMaxValue );
		/// ۼƮ  ٿ Ϸ Ѵٸ,
		else
			mText.Format( _T("%.2f%%"), mPercent );

		/// ġ 
		cUIRect rc = GetAbsoluteRect();
		mTextX = rc.mLeft + ( rc.GetWidth() - FONTAGENT->GetTextExtent( cFontAgent::eFont_System, mText.Cstr(), mText.GetLength() )) / 2;
		mTextY = rc.mTop + ( rc.GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_System)) / 2;
	}
}

/////////////////////////////////////////////////////////////////////////
/// ߰
cDoubleGauge::cDoubleGauge( eUINodeType type )
: cGauge( type )
, mpDestGaugeImage(0)
{

}

cDoubleGauge::~cDoubleGauge()
{
	SAFE_DELETE( mpDestGaugeImage );
	SAFE_DELETE( mpGaugeImage );
}

void cDoubleGauge::Clear()
{
	cGauge::Clear();

	///
	UpdateDestGauge();
}

void cDoubleGauge::ClearFront()
{
	cGauge::ClearFront();

	///
	UpdateDestGauge();
}

bool cDoubleGauge::OnCreate( cUINodeProperty* pproperty )
{
	if( cUINode::OnCreate( pproperty ) == false )
		return false;

	if( mpImageTexture )
	{
		unsigned short x = GetAbsoluteRect().mLeft + mImagePos.mX;
		unsigned short y = GetAbsoluteRect().mTop + mImagePos.mY;

		mpGaugeImage = new cPlaneObject;
		if( mpGaugeImage->Create( mpImageTexture, x, y, mImageSize.mWidth, mImageSize.mHeight, 
									mImageTexpos.mX, mImageTexpos.mY, 
									mImageTexpos.mX + mImageSize.mWidth, 
									mImageTexpos.mY + mImageSize.mHeight ) == false )
		{
			assert( 0 && "failed to create gauge image");
			return false;
		}
	}

	if( mpDestImageTexture )
	{
		unsigned short x = GetAbsoluteRect().mLeft + mDestImagePos.mX;
		unsigned short y = GetAbsoluteRect().mTop + mDestImagePos.mY;

		mpDestGaugeImage = new cPlaneObject;
		if( mpDestGaugeImage->Create( mpDestImageTexture, x, y, mDestImageSize.mWidth, mDestImageSize.mHeight, 
										mDestImageTexpos.mX, mDestImageTexpos.mY, 
										mDestImageTexpos.mX + mDestImageSize.mWidth, 
										mDestImageTexpos.mY + mDestImageSize.mHeight ) == false )
		{
			assert( 0 && "failed to create gauge image");
			return false;
		}
	}

	return true;
}

bool cDoubleGauge::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_DOUBLEGAUGE ) == false )
	{
		assert( 0 && "not gaugebar skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
		return false;

	cUISkin* pUISkin = UIMAN->GetSkin();
	if( !pskin )
	{
		assert(0);
		return false;
	}

	cGaugeSkin* p = (cGaugeSkin*)pskin;
	mSpeed = p->mGaugeSpeed;
	mShowPercent = p->mShowPercent;
	mShowText = p->mShowText;

	mpImageTexture	= p->mpImageTexture;
	mImagePos		= p->mImagePos;
	mImageSize		= p->mImageSize;
	mImageTexpos	= p->mImageTexpos;
	mGaugeSize		= p->mGaugeSize;
	mImageStart		= p->mImageStart;

	mpDestImageTexture	= p->mpDestImageTexture;
	mDestImagePos		= p->mDestImagePos;
	mDestImageSize		= p->mDestImageSize;
	mDestImageTexpos	= p->mDestImageTexpos;
	mDestGaugeSize		= p->mDestGaugeSize;
	mDestImageStart		= p->mDestImageStart;

	UpdateText();
	return true;
}

void cDoubleGauge::UpdateRect()
{
	cGauge::UpdateRect();

	if( mpDestGaugeImage )
	{
		mpDestGaugeImage->SetScreenXY( (short)GetAbsoluteRect().mLeft + mDestImagePos.mX, 
									   (short)GetAbsoluteRect().mTop + mDestImagePos.mY );
	}

	if( mRightDecrease )
	{
		short x = GetAbsoluteRect().mLeft + mImagePos.mX;
		x += (mGaugeSize.mWidth - mpDestGaugeImage->GetScreenW());

		if( mpDestGaugeImage )
			mpDestGaugeImage->SetScreenX( x );
	}
}

void cDoubleGauge::UpdateSkin()
{
	cGauge::UpdateSkin();
	
	if( mpDestGaugeImage )
		mpDestGaugeImage->UpdateImage();
}

void cDoubleGauge::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	if( mRightDecrease )
	{
		short x = GetAbsoluteRect().mLeft + mImagePos.mX;
		x += (mGaugeSize.mWidth - mpDestGaugeImage->GetScreenW());

		if( mpDestGaugeImage )
			mpDestGaugeImage->SetScreenX( x );
	}

	cGauge::OnProcess( deltaTime, accumTime );
}

void cDoubleGauge::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mpDestGaugeImage )
		mpDestGaugeImage->Draw();

	cGauge::OnRender( pKeeper );
}

/// ߾ִϸ̼   
void cDoubleGauge::SetGaugeNoAni( float value )
{
	cGauge::SetGaugeNoAni( value );
	UpdateDestGauge();
}

void cDoubleGauge::SetMaxValue( float value )	
{	
	cGauge::SetMaxValue( value );

	/// ǥġ  
	UpdateDestGauge();
}

void cDoubleGauge::UpdateDestGauge()
{
	if( mMaxValue > 0 )
	{
		float percent = (mDestValue * 100) / mMaxValue;
		unsigned short w = (unsigned short)( mDestGaugeSize.mWidth * percent * 0.01f );

 		if( mpDestGaugeImage )
		{
			mpDestGaugeImage->SetScreenWH( w, mDestGaugeSize.mHeight );
		}
	}
}

//////////////////////////////////////////////////////////////////////////
cGaugeTB::cGaugeTB( eUINodeType type )
: cGauge( type )
{

}

cGaugeTB::~cGaugeTB()
{

}

bool cGaugeTB::OnCreate( cUINodeProperty* pproperty )
{
	if( cUINode::OnCreate( pproperty ) == false )
		return false;

	if( mpImageTexture )
	{
		unsigned short x = GetAbsoluteRect().mLeft + mImagePos.mX;
		unsigned short y = GetAbsoluteRect().mBottom - mImagePos.mY;

		mpGaugeImage = new cPlaneObject;
		if( mpGaugeImage->Create( mpImageTexture, x, y, mImageSize.mWidth, mImageSize.mHeight, 
			mImageTexpos.mX, mImageTexpos.mY, 
			mImageTexpos.mX + mImageSize.mWidth, 
			mImageTexpos.mY + mImageSize.mHeight ) == false )
		{
			assert( 0 && "failed to create gauge image");
			return false;
		}
	}

	return true;
}

bool cGaugeTB::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_GAUGETB ) == false )
	{
		assert( 0 && "not gauge skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
		return false;

	cUISkin* pUISkin = UIMAN->GetSkin();
	if( !pskin )
	{
		assert(0);
		return false;
	}

	cGaugeSkin* p = (cGaugeSkin*)pskin;
	mSpeed = p->mGaugeSpeed;
	mShowPercent = p->mShowPercent;
	mShowText = p->mShowText;

	mpImageTexture = p->mpImageTexture;
	mImagePos = p->mImagePos;
	mImageSize = p->mImageSize;
	mImageTexpos = p->mImageTexpos;
	mGaugeSize = p->mGaugeSize;
	mImageStart = p->mImageStart;

	return true;
}

void cGaugeTB::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	if( mState == eGaugeState_End || mState == eGaugeState_None )
		return;

	if( mState == eGaugeState_Start )
		mStartTime = accumTime;

	if( mValue == mDestValue )
	{
		mStartTime = 0;
		mState = eGaugeState_End;
	}

	float elapsedTime = (float)(accumTime - mStartTime) * 0.001f;
	mStartTime = accumTime;

	///    ġ ,  .
	if( mValue < mDestValue )
	{
		mValue += (elapsedTime * mSpeed);
		mState = eGaugeState_Process;

		/// ʰ ش 
		if( mValue > mDestValue )
		{
			mStartTime = 0;
			mValue = mDestValue;
			mState = eGaugeState_End;

			cUIEvent event;
			event.mpCaller = this;
			event.mType = eUIEVENT_GAUGE_END;
			mpParent->HandleEvent( event );
		}
	}
	/// ġ  쿡 ҽŲ 
	else if( mValue > mDestValue )
	{
		mValue = mDestValue;
		mState = eGaugeState_End;
		mStartTime = 0;
	}

	///  ŵǾ   Ų
	UpdateGauge();

	///
	if( mpGaugeImage )
	{
		short y = GetAbsoluteRect().mBottom - mImagePos.mY;
		y -= mpGaugeImage->GetScreenH();

		mpGaugeImage->SetScreenY( y );
	}
}

void cGaugeTB::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mpGaugeImage )
		mpGaugeImage->Draw();

	if( mpImage )
		mpImage->Draw();

	/// ۾ 
	if( mShowText )
		pKeeper->AddFontItem( cFontAgent::eFont_System, const_cast<LPTSTR>(mText.Cstr()), mTextX, mTextY, mDefaultColor );
}


void cGaugeTB::UpdateRect()
{
	cUINode::UpdateRect();

	if( mpGaugeImage )
	{
		mpGaugeImage->SetScreenXY( (short)GetAbsoluteRect().mLeft + mImagePos.mX, (short)GetAbsoluteRect().mBottom );

		///
		short y = GetAbsoluteRect().mBottom - mImagePos.mY;
		y -= mpGaugeImage->GetScreenH();

		mpGaugeImage->SetScreenY( y );
	}

	///
	UpdateText();
}

void cGaugeTB::UpdateGauge()
{
	if( mMaxValue > 0 )
	{
		mPercent = (mValue * 100) / mMaxValue;

		///  
		unsigned short h = (unsigned short)( mGaugeSize.mHeight * mPercent * 0.01f );
		if( mpGaugeImage )
			mpGaugeImage->SetScreenWH( mGaugeSize.mWidth, h );

		///  
		UpdateRect();
	}
}

/////////////////////////////////////////////////////////////////////////////
cGaugeSkin::cGaugeSkin( eUINodeType type )
: cUINodeSkin( type )
, mGaugeSpeed( 0 )
, mShowPercent( false )
, mShowText( true )
, mpImageTexture(0)
, mImagePos(0, 0)
, mImageSize(0, 0)
, mImageTexpos(0, 0)
, mGaugeSize(0, 0)
, mImageStart( true )
, mpDestImageTexture(0)
, mDestImagePos(0, 0)
, mDestImageSize(0, 0)
, mDestImageTexpos(0, 0)
, mDestGaugeSize(0, 0)
, mDestImageStart( true )
{	
}

cGaugeSkin::~cGaugeSkin()
{

}

/// ǻ : ũƮ  о鿩  Ѵ
bool cGaugeSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	/// ״ū  ˻
	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_GAUGEIMAGEINDEX:
			{
				int i = parser.ParseInt();
				mpImageTexture = UIMAN->GetSkin()->GetTexture( i );
			}
			break;
		case eTOKEN_GAUGEPOS:
			{
				mImagePos.mX = (unsigned short)parser.ParseInt();
				mImagePos.mY = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGESIZE:
			{
				mImageSize.mWidth = (unsigned short)parser.ParseInt();
				mImageSize.mHeight = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGETEXPOS:
			{
				mImageTexpos.mX = (unsigned short)parser.ParseInt();
				mImageTexpos.mY = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGEWIDTH:
			{
				mGaugeSize.mWidth = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGEHEIGTH:
			{
				mGaugeSize.mHeight = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGESTART:
			{
				///
				lexer->GetNextToken( &token );

				if( token.mType == eALIGN_LEFT )
				{
					mImageStart = true;
				}
				else if( token.mType == eTOKEN_RIGHT )
				{
					mImageStart = false;
				}
			}
			break;
		case eTOKEN_GAUGEIMAGEINDEX_DEST:
			{
				int i = parser.ParseInt();
				mpDestImageTexture = UIMAN->GetSkin()->GetTexture( i );
			}
			break;
		case eTOKEN_GAUGEPOS_DEST:
			{
				mDestImagePos.mX = (unsigned short)parser.ParseInt();
				mDestImagePos.mY = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGESIZE_DEST:
			{
				mDestImageSize.mWidth = (unsigned short)parser.ParseInt();
				mDestImageSize.mHeight = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGETEXPOS_DEST:
			{
				mDestImageTexpos.mX = (unsigned short)parser.ParseInt();
				mDestImageTexpos.mY = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGEWIDTH_DEST:
			{
				mDestGaugeSize.mWidth = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGEHEIGTH_DEST:
			{
				mDestGaugeSize.mHeight = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_GAUGESTART_DEST:
			{
				///
				lexer->GetNextToken( &token );

				if( token.mType == eALIGN_LEFT )
				{
					mDestImageStart = true;
				}
				else if( token.mType == eTOKEN_RIGHT )
				{
					mDestImageStart = false;
				}
			}
			break;
		case eTOKEN_GAUGE_SPEED:
			{
				mGaugeSpeed = parser.ParseFloat();
			}
			break;
		case eTOKEN_SHOW_LABEL_PERCENT:
			{
				lexer->GetNextToken( &token );

				if( token.mType == eTOKEN_TRUE )
				{
					mShowPercent = true;
				}
				else if( token.mType == eTOKEN_FALSE )
				{
					mShowPercent = false;
				}
				else
				{
					assert( 0 && "invalid token" );
					return false;
				}
			}
			break;
		case eTOKEN_SHOW_TEXT:
			{
				lexer->GetNextToken( &token );

				if( token.mType == eTOKEN_TRUE )
				{
					mShowText = true;
				}
				else if( token.mType == eTOKEN_FALSE )
				{
					mShowText = false;
				}
				else
				{
					assert( 0 && "invalid token" );
					return false;
				}
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}
	return true;
}

