/* ==========================================================================
*      : Gauge.h
*      : 
*    : 谡
*    : 2006-11-07
* ǻ :
*===========================================================================*/
#pragma once
#include "UINode.h"
#include "UINodeData.h"

///  ȭ , شġ  ׶̼ ÷ ִ´.
const float GRADATION_VALUE = 10.0f;

class cPlaneObject;
/// ⺻ 
class cGauge : public cUINode
{
public:
	enum
	{
		eGaugeState_Start = 0,
		eGaugeState_Process,
		eGaugeState_End,

		eGaugeState_None,
	};

	cGauge( eUINodeType type = eUINODE_GAUGE );
	virtual ~cGauge();

	/// ʱȭ
	void Clear();
	void ClearFront();		///	տ  ͸ Ŭ
	
	///   ӵ  
	void SetGaugeSpeed( float s );
	
	/// ִ ġ 
	virtual void SetMaxValue( float value );

	///   ( ִϸ̼ 뿩 )
	void SetGaugeAni( float value );
	virtual void SetGaugeNoAni( float value );	

	float GetMaxValue() const;	/// ִ ġ  
	float GetValue() const;		///  ġ 
	float GetPercent() const;	///  ۼƮ ġ  

	inline void SetRightDecreasing( bool set ) { mRightDecrease = set; }

protected:
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void UpdateRect();
	virtual void UpdateSkin();
	
	virtual void UpdateGauge();
	virtual void UpdateDestGauge() {};
	virtual void UpdateText();

protected:
	/// 
	cPlaneObject* mpGaugeImage;

	///  
	float mValue;

	/// ǥ  (ִϸ̼Ǹǥ)
	float mDestValue;

	/// ִ 
	float mMaxValue;

	///  ۼƮ
	float mPercent;
	
	///  
	unsigned int mState;

	/// ð
	unsigned long mStartTime;

	///   ӵ
	float mSpeed;

	/// ۼƮ 
	bool mShowPercent;

	///    
	bool mShowText;
	int mTextX, mTextY;
	cStringT mText;
	
	///  ؽ
	NiTexture*	mpImageTexture;		

	///  ǥ
	cUIPos		mImagePos;

	///  ؽ 
	cUISize		mImageSize;

	///  ؽ ǥ
	cUIPos		mImageTexpos;

	///  100%  
	cUISize		mGaugeSize;

	///   
	bool		mImageStart;

	bool		mRightDecrease;
};

inline void cGauge::SetGaugeSpeed( float s )
{
	mSpeed = s;
}

inline float cGauge::GetValue() const
{
	return mValue;
}

inline float cGauge::GetMaxValue() const
{
	return mMaxValue;
}

inline float cGauge::GetPercent() const
{
	return mPercent;
}

/////////////////////////////////////////////////////////////
///   
class cDoubleGauge : public cGauge
{
public:
	cDoubleGauge( eUINodeType type = eUINODE_DOUBLEGAUGE );
	virtual ~cDoubleGauge();

	/// ʱȭ
	void Clear();
	void ClearFront();		///	տ  ͸ Ŭ

	/// ִ ġ 
	void SetMaxValue( float value );

	///  ΰ  
	virtual void SetGaugeNoAni( float value );	

protected:
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );     
	virtual void UpdateRect();
	virtual void UpdateSkin();

	/// ǥ 
	void UpdateDestGauge();

protected:
	/// 
	cPlaneObject* mpDestGaugeImage;

	///  ؽ
	NiTexture*	mpDestImageTexture;		

	///  ǥ
	cUIPos		mDestImagePos;

	///  ؽ 
	cUISize		mDestImageSize;

	///  ؽ ǥ
	cUIPos		mDestImageTexpos;

	///  100%  
	cUISize		mDestGaugeSize;

	///   
	bool		mDestImageStart;
};

class cGaugeTB : public cGauge
{
public:
	cGaugeTB( eUINodeType type = eUINODE_GAUGETB );
	virtual ~cGaugeTB();

protected:
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void UpdateRect();

	virtual void UpdateGauge();
	virtual void UpdateText() {}
};

//////////////////////////////////////////////////////////////////////////////////
class cGaugeSkin : public cUINodeSkin
{
public:
	cGaugeSkin( eUINodeType type = eUINODE_GAUGE );
	virtual ~cGaugeSkin();
	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ۼƮ 
	bool mShowPercent;
	bool mShowText;

	///   ӵ
	float mGaugeSpeed;

	///   
	NiTexture*	mpImageTexture;
	cUIPos		mImagePos;
	cUISize		mImageSize;
	cUIPos		mImageTexpos;
	cUISize		mGaugeSize;
	bool		mImageStart;

	NiTexture*	mpDestImageTexture;
	cUIPos		mDestImagePos;
	cUISize		mDestImageSize;
	cUIPos		mDestImageTexpos;
	cUISize		mDestGaugeSize;
	bool		mDestImageStart;
};
