#include "stdafx.h"
#include "GuildManager.h"
#include "GameResourceManager.h"
#include "ChatManager.h"
#include "GameUIManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "UIMsgboxEvent.h"
#include "Npc_Common.h"
#include "GuildWindow.h"
#include "ResourceManager.h"
#include "SendNoteWindow.h"

#include "FileSystem.h"
#include "MemFile.h"

cGuildManager* cGuildManager::mpSingleton = 0;

cGuildManager::cGuildManager()
: mConnectCount(0)
, mTempNpcIndex(0)
, mTempCutPlayerIdx(0)
{
	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;

	::memset( &mGuildInfo, 0, sizeof(mGuildInfo) );
	::memset( &mMarkBuffer, 0, sizeof(mMarkBuffer) );
}

cGuildManager::~cGuildManager()
{
	cGuildUserMap::cIterator i = mGuildUserMap.Begin();
	cGuildUserMap::cIterator end = mGuildUserMap.End();
	for( ; i != end; ++i )
	{
		sGuildUserInfo* p = (sGuildUserInfo*)(i->mSecond);
		SAFE_DELETE( p );
	}
	mGuildUserMap.Clear();

	///
	mGuildMarkMap.Clear();

	/// 
	mRequestMarkMap.Clear();

	///
	mpSingleton = 0;
}

void cGuildManager::Close()
{
	Clear();
	ClearUI();
}

void cGuildManager::Clear()
{
	::memset( &mGuildInfo, 0, sizeof(mGuildInfo) );
	mConnectCount = 0;
	
	/// 
	cGuildUserMap::cIterator i = mGuildUserMap.Begin();
	cGuildUserMap::cIterator end = mGuildUserMap.End();
	for( ; i != end; ++i )
	{
		sGuildUserInfo* p = (sGuildUserInfo*)(i->mSecond);
		SAFE_DELETE( p );
	}
	mGuildUserMap.Clear();

	ClearTempData();

	mTempCutPlayerIdx = 0;
}

void cGuildManager::ClearUI()
{
	cGuildWindow* guildWindow = GAMEUI->GetGuildWindow();
	if( guildWindow )
		guildWindow->Clear();
}

void cGuildManager::ClearTempData()
{
	mTempName.Clear();

	mTempNpcIndex = 0;
}

void cGuildManager::ResGuildCreate( MSG_RES_NPC_GUILD_CREATE* pmsg )
{
	cStringT str;

	switch( pmsg->ErrorCode )
	{
	case ERROR_NPC_GUILD_CREATE_SUCESS:			// 
		str.Format( GAMERESOURCEMAN->GetGameText( 1200 ), (LPCTSTR)mTempName.Cstr() );
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			(LPCTSTR)str.Cstr(),
			GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
			eSKIN_OK
			);	

		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
		break;
	case ERROR_NPC_GUILD_CREATE_FAIL:			// 
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 1201 ),	// 
			GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
			eSKIN_OK
			);	
		break;
	case ERROR_NPC_GUILD_CREATE_CONDITION:		//  -  ȵ
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 1232 ),	// 
			GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
			eSKIN_OK
			);	
		break;
	case ERROR_NPC_GUILD_CREATE_ALREADY:		//  - ̹  
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 1202 ),	// 
			GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
			eSKIN_OK
			);	
		break;
	case ERROR_NPC_GUILD_CREATE_ERRORNAME:		//  -  ų 12 
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 1203 ),	// 
			GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
			eSKIN_OK
			);	
		break;
	case ERROR_NPC_GUILD_CREATE_EXISTNAME:		//  -  ߺ
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 1204 ),	// 
			GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
			eSKIN_OK
			);	
		break;
	case ERROR_NPC_GUILD_CREATE_NPC:	//  - npc
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 420 ),	// 
			GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
			eSKIN_OK
			);
		break;
	}

	ClearTempData();
}

void cGuildManager::NetworkMsgParser( char* msg )
{
	MSGROOT* tempMsg = (MSGROOT*)msg;

	cStringT str;
	switch( tempMsg->Protocol )
	{
	case NM_GUILD_LIST_SYN:
		{
			MSG_SYN_GUILD_LIST* pmsg = (MSG_SYN_GUILD_LIST*)msg;

			/// ʱȭ
			Clear();

			/// 
			mGuildInfo = pmsg->data;

			sGuildUserInfo* user = pmsg->table;
			for( long i = 0; i < pmsg->rowCount; ++i, ++user )
			{
				AddGuildUser( user );
			}

			sGuildUserInfo* info = (sGuildUserInfo*)mGuildUserMap.GetAt( HERO->GetObjectID() );
			if( info )
			{
				/// ⺻ ä 
				info->channelNum = HERO->GetChannelNum();
				info->mapnum	 = (short)HERO->GetMapNum();
				HERO->SetGuild( mGuildInfo.idx, mGuildInfo.name, info->position, mGuildInfo.markIndex );
			}

			/// UI 
			UpdateInfoSheet();
			UpdateNotice();
			UpdateGuildMark();
		}
		break;
	case NM_GUILD_CREATEDATA_RES:
		{	
			///  
			MSG_RES_GUILD_CREATEDATA* pmsg = (MSG_RES_GUILD_CREATEDATA*)msg;

			/// ʱȭ
			Clear();
			ClearUI();

			/// 1.   
			mGuildInfo.idx = pmsg->idx;
			mGuildInfo.masterIndex = HERO->GetObjectID();
			mGuildInfo.position = eGUILD_MASTER;
			mGuildInfo.markIndex = 0;
			mConnectCount = 1;
			::Sstrncpy( mGuildInfo.name, MAX_GUILDNAME_BUFFER_SIZE, pmsg->name, MAX_GUILDNAME_SIZE );
			::Sstrncpy( mGuildInfo.masterName, MAX_NAME_BUFFER_SIZE, HERO->GetName(), MAX_NAME_SIZE );

			/// 2. Ʈ 
			sGuildUserInfo* userInfo = new sGuildUserInfo;
			userInfo->characterIdx = HERO->GetObjectID();
			userInfo->level = HERO->GetLevel();
			userInfo->job = HERO->GetJob();
			userInfo->mapnum = (short)HERO->GetMapNum();
			userInfo->position = eGUILD_MASTER;
			userInfo->channelNum = HERO->GetChannelNum();
			::Sstrncpy( userInfo->name, MAX_NAME_BUFFER_SIZE, HERO->GetName(), MAX_NAME_SIZE );

			if( mGuildUserMap.Insert( userInfo->characterIdx, userInfo ) == false )
			{
				assert( 0 && "failed to insert guild user" );
			}

			/// UI 
			UpdateInfoSheet();
			UpdateNotice();
			
			/// 
			HERO->SetGuild( mGuildInfo.idx, mGuildInfo.name, mGuildInfo.position, mGuildInfo.markIndex );
		}
		break;
	case NM_GUILD_ADD_RES:
		{
			// ʴ  ( Ұϰ ־ )
			MSG_RES_GUILD_ADD* pmsg = (MSG_RES_GUILD_ADD*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_GUILD_ADD_SUCCESS:		//  -  û 
				{
					cStringT str;
					str.Format( GAMERESOURCEMAN->GetGameText( 1216 ), (LPCTSTR)mTempAddName.Cstr() );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
				}
				break;
			case ERROR_GUILD_ADD_FAIL:			// 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1206 ) );
				break;	
			case ERROR_GUILD_ADD_REQUEST:		//  - ̹ û
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1207 ) );
				break;
			case ERROR_GUILD_ADD_NOTEXIST:		//  - 밡  
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1208 ) );
				break;
			case ERROR_GUILD_ADD_HAVEGUILD:		//  - 밡 ̹  
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1209 ) );
				break;
			case ERROR_GUILD_ADD_MAXGUILD:		//  -  ο 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1210 ) );
				break;
			case ERROR_GUILD_ADD_REFUSE:		//  -   
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1218 ) );
				break;
			}

			mTempAddName.Clear();
		}
		break;
	case NM_GUILD_ADD_SYN:
		{
			/// ٸ κ ʴ 
			MSG_SYN_GUILD_ADD* pmsg = (MSG_SYN_GUILD_ADD*)msg;
			
			str.Format( GAMERESOURCEMAN->GetGameText( 1215 ), pmsg->name, pmsg->guildName );
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_GUILD_ADD, 
								(LPCTSTR)str.Cstr(),					// û ޽
								GAMERESOURCEMAN->GetGameText( 1214 ),	//  û
								eSKIN_YESNO
								, 0, GUILD_WAIT_TIME, false, false );
		}
		break;
	case NM_GUILD_REPLY_RES:
		{
			/// ʴ 亯  
			MSG_RES_GUILD_REPLY* pmsg = (MSG_RES_GUILD_REPLY*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_GUILD_ADDREPLY_SUCCESS:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1211 ) );
				break;
			case ERROR_GUILD_ADDREPLY_FAIL:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1212 ) );
				break;
			case ERROR_GUILD_ADDREPLY_REFUSE:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1213 ) );
				break;
			}
		}
		break;
	case NM_GUILD_USERADD_SYN:
		{
			/// ߰  
			MSG_SYN_GUILD_USERADD* pmsg = (MSG_SYN_GUILD_USERADD*)msg;

			//   ߰
			AddGuildUser( &pmsg->user );

			// UI 
			UpdateInfoSheetByUser();

			//
			str.Format( GAMERESOURCEMAN->GetGameText( 1217 ), &pmsg->user.name );
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, str.Cstr() );
		}
		break;
	case NM_GUILD_OUT_RES:
		{
			///  Ż 
			MSG_RES_GUILD_OUT* pmsg = (MSG_RES_GUILD_OUT*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_GUILD_OUT_SUCCESS:
				{
					// Ż 
					Clear();
					ClearUI();

					HERO->SetGuild( 0, _T(""), eGUILD_NONE, 0 );

					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1219 ) );
				}
				break;
			case ERROR_GUILD_OUT_FAIL:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1220 ) );
				break;
			case ERROR_GUILD_OUT_MASTER:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1221 ) );
				break;
			}
		}
		break;
	case NM_GUILD_OUT_SYN:
		{
			///  Ż 
			MSG_SYN_GUILD_OUT* pmsg = (MSG_SYN_GUILD_OUT*)msg;

			cGuildUserMap::cIterator i = mGuildUserMap.Find( pmsg->characterIdx );
			if( i != mGuildUserMap.End() )
			{
				sGuildUserInfo* user = (sGuildUserInfo*)(i->mSecond);
				
				// Ż ˸
				str.Format( GAMERESOURCEMAN->GetGameText( 1222 ), user->name );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );

				// 
				SAFE_DELETE( user );
				mGuildUserMap.Erase( i );

				// UI 
				UpdateInfoSheetByUser();
			}
		}
		break;
	case NM_GUILD_CUT_RES:
		{
			///  ߹û 
			MSG_RES_GUILD_CUT* pmsg = (MSG_RES_GUILD_CUT*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_GUILD_CUT_SUCCESS:
				{
					/// ߹  
					cSendNoteWindow* win = GAMEUI->GetSendNoteWindow();
					if( win )
					{
						cGuildUserMap::cIterator i = mGuildUserMap.Find( mTempCutPlayerIdx );
						if( i != mGuildUserMap.End() )
						{
							sGuildUserInfo* user = (sGuildUserInfo*)(i->mSecond);
							win->SendNoteBySystem( user->name, GAMERESOURCEMAN->GetGameText( 1257 ) );
						}
					}
				}
				break;
			case ERROR_GUILD_CUT_FAIL:		// 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1223 ) );
				break;
			case ERROR_GUILD_CUT_MASTER:	//  - 常 ߹氡
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1224 ) );
				break;
			}

			mTempCutPlayerIdx = 0;
		}
		break;
	case NM_GUILD_CUT_SYN:
		{
			/// ڱڽ ߹
			Clear();
			ClearUI();

			HERO->SetGuild( 0, _T(""), eGUILD_NONE, 0 );

			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1225 ) );
		}
		break;
	case NM_GUILD_USERCUT_SYN:
		{
			///  ߹
			MSG_SYN_GUILD_USERCUT* pmsg = (MSG_SYN_GUILD_USERCUT*)msg;

			cGuildUserMap::cIterator i = mGuildUserMap.Find( pmsg->characterIdx );
			if( i != mGuildUserMap.End() )
			{
				sGuildUserInfo* user = (sGuildUserInfo*)(i->mSecond);

				// Ż ˸
				str.Format( GAMERESOURCEMAN->GetGameText( 1226 ), user->name );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );

				// 
				SAFE_DELETE( user );
				mGuildUserMap.Erase( i );

				// UI 
				UpdateInfoSheetByUser();
			}
		}
		break;
	case NM_GUILD_DELETE_RES:
		{
			MSG_RES_GUILD_DELETE* pmsg = (MSG_RES_GUILD_DELETE*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_GUILD_DELETE_SUCCESS:
				{
					// ü 
					Clear();
					ClearUI();

					HERO->SetGuild( 0, _T(""), eGUILD_NONE, 0 );

					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1230 ) );
				}
				break;
			case ERROR_GUILD_DELETE_FAIL:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1229 ) );
				break;
			case ERROR_GUILD_DELETE_MASTER:		//  - 常 ü 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1227 ) );
				break;
			case ERROR_GUILD_DELETE_USEREXIST:	//  -  
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1228 ) );
				break;
			}
		}
		break;
	case NM_GUILD_UPDATE_SYN:
		{
			/// ð    
			MSG_SYN_GUILD_UPDATE* pmsg = (MSG_SYN_GUILD_UPDATE*)msg;
			
			// 
			sGuildUserUpdate* data = pmsg->table;
			for( long i = 0; i < pmsg->rowCount; ++i, ++data )
			{
				sGuildUserInfo* user = (sGuildUserInfo*)mGuildUserMap.GetAt( data->characterIdx );
				if( user )
				{
					user->level  = data->level;
					user->job	 = data->job;
					user->mapnum = data->mapnum;
					user->channelNum = data->channelNum;
				}
			}
		
			/// UI 
            UpdateInfoSheetByUser();
		}
		break;
	case NM_GUILD_GIVEPOSITION_RES:
		{
			///  û 
			MSG_RES_GUILD_GIVEPOSITION* pmsg = (MSG_RES_GUILD_GIVEPOSITION*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_GUILD_GIVEPOSITION_SUCCESS:
				break;
			case ERROR_GUILD_GIVEPOSITION_FAIL:			/// 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1244 ) );
				break;
			case ERROR_GUILD_GIVEPOSITION_POSITION:		/// 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1245 ) );
				break;
			}
		}
		break;
	case NM_GUILD_GIVEPOSITION_SYN:
		{
			///  
			MSG_SYN_GUILD_GIVEPOSITION* pmsg = (MSG_SYN_GUILD_GIVEPOSITION*)msg;

			///  ΰ 
			if( pmsg->position == eGUILD_MASTER && HERO->GetObjectID() == mGuildInfo.masterIndex )
			{
				mGuildInfo.position = eGUILD_GENERAL;
			}
			else if( pmsg->characterIdx == HERO->GetObjectID() )
			{
				mGuildInfo.position = pmsg->position;
			}
	
			///   Ʈ 
			sGuildUserInfo* newInfo = (sGuildUserInfo*)mGuildUserMap.GetAt( pmsg->characterIdx );
			if( newInfo )
			{
				newInfo->position = pmsg->position;

				/// ο   ߰ ó
				if( pmsg->position == eGUILD_MASTER )
				{
					///    
					sGuildUserInfo* userInfo = (sGuildUserInfo*)mGuildUserMap.GetAt( mGuildInfo.masterIndex );
					if( userInfo )
					{
						userInfo->position = eGUILD_GENERAL;
					}
					else
					{
						assert(0);
					}

					///    
					mGuildInfo.masterIndex = pmsg->characterIdx;
					::Sstrncpy( mGuildInfo.masterName, MAX_NAME_BUFFER_SIZE, newInfo->name, MAX_NAME_SIZE );
				}

				///  ˸
				str.Format( GAMERESOURCEMAN->GetGameText( 1246 ), newInfo->name, GetTextIndex( pmsg->position ) );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
			}
			else
			{
				assert(0);
			}

			/// UI 
			UpdateInfoSheet();
			UpdateGuildMark();
			UpdateNotice( false );

			///
			HERO->SetGuildPosition( mGuildInfo.position );
		}
		break;
	case NM_GUILD_NOTICE_RES:
		{
			MSG_RES_GUILD_NOTICE* pmsg = (MSG_RES_GUILD_NOTICE*)msg;

			if( pmsg->ErrorCode == ERROR_GUILD_NOTICE_FAIL )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1250 ) );
			}
		}
		break;
	case NM_GUILD_NOTICE_SYN:
		{
			MSG_SYN_GUILD_NOTICE* pmsg = (MSG_SYN_GUILD_NOTICE*)msg;

			/// 
			::Sstrncpy( mGuildInfo.notice, MAX_GUILD_NOTICE_BUFFER_SIZE, pmsg->notice, MAX_GUILD_NOTICE_SIZE );

			/// UI
			UpdateNotice();
		}
		break;
	case NM_GUILDMARK_UPDATE_RES:
		{
			/// 帶ũ  
			MSG_RES_GUILDMARK_UPDATE* pmsg = (MSG_RES_GUILDMARK_UPDATE*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_GUILDMARK_UPDATE_FAIL:			// 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1252 ) );
				break;
			case ERROR_GUILDMARK_UPDATE_POSITION:		// ѽ
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1253 ) );
				break;
			}
		}
		break;
	case NM_GUILDMARK_UPDATE_SYN:
		{
			/// ڽ  ũ 
			MSG_SYN_GUILDMARK_UPDATE* pmsg = (MSG_SYN_GUILDMARK_UPDATE*)msg;
			
			/// 
			mGuildInfo.markIndex = pmsg->markIndex;

			///  UIũ 
			UpdateGuildMark();

			/// ش 帶ũ ϴ ˻.
			HERO->ChangeGuildMark( pmsg->markIndex );

			///  ˸
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1254 ) );
		}
		break;
	case NM_GUILDMARK_SEND_RES:
		{
			MSG_RES_GUILDMARK_SEND* pmsg = (MSG_RES_GUILDMARK_SEND*)msg;

			/// ο 帶ũ  
			if( pmsg->ErrorCode == ERROR_GUILDMARK_SEND_SUCCESS )
			{
				/// 帶ũ ޾Ƽ  Ϸ 
				cString str;
				str.Format( "./GuildMark/mark%d_%d.tga", pmsg->guildIndex, pmsg->markIndex );
				cFileToWrite* newfile = FILESYSTEM->OpenFileToWrite( str );
				if( newfile )
				{
					int writeLen = newfile->Write( pmsg->mark, MARK_SIZE );
					/*if( writeLen != MARK_SIZE )
					{
						assert(0);
					}*/
					newfile->Close();
					SAFE_DELETE( newfile );
				}

				/// 帶ũ ڿ 
				NiTexture* tex = LoadGuildMark( str );
				if( tex )
				{
					if( mGuildMarkMap.Insert( pmsg->markIndex, tex ) == false )
					{
						assert(0);
					}

					/// 帶ũ 
					OBJECTMANAGER->UpdateGuildMark( pmsg->guildIndex, pmsg->markIndex );

					///  UI 
					if( pmsg->guildIndex == HERO->GetGuildIndex() )
					{
						cGuildWindow* win = GAMEUI->GetGuildWindow();
						if( win )
						{
							win->ChangeMark( tex );
						}
						else
						{
							assert(0);
						}
					}
				}
			}
			else
			{
				assert(0);
			}

			/// û κ 
			mRequestMarkMap.Erase( pmsg->guildIndex );
		}
		break;
	}
}

void cGuildManager::UpdateGuildMark()
{
	cGuildWindow* win = GAMEUI->GetGuildWindow();
	if( win )
	{
		/// ڿ  ãƼ 
		NiTexture* tex = (NiTexture*)mGuildMarkMap.GetAt( mGuildInfo.markIndex );
		if( tex )
		{
			win->ChangeMark( tex );
		}
		else
		{
			///  ϸ ã
			cString str;
			str.Format( "./GuildMark/mark%d_%d.tga", mGuildInfo.idx, mGuildInfo.markIndex );
			tex = LoadGuildMark( str );
			if( tex )
			{
				if( mGuildMarkMap.Insert( mGuildInfo.markIndex, tex ) == false )
				{
					assert(0);
				}

				win->ChangeMark( tex );
			}
		}
	}
}

NiTexture* cGuildManager::CheckGuildMark( unsigned long guildIndex, unsigned long markIndex )
{
	/// ڿ  ãƼ 
	NiTexture* tex = 0;

	tex = (NiTexture*)mGuildMarkMap.GetAt( markIndex );
	if( tex )
		return tex;

	///  ϸ ã
	cString str;
	str.Format( "./GuildMark/mark%d_%d.tga", guildIndex, markIndex );
	
	tex = LoadGuildMark( str );
	if( tex )
	{
		if( mGuildMarkMap.Insert( markIndex, tex ) == false )
		{
			assert(0);
		}
	}
	else
	{
		///
		cRequestMarkMap::cIterator i = mRequestMarkMap.Find( guildIndex );
		if( i == mRequestMarkMap.End() )
		{
			/// Ϸε    û
			MSG_REQ_GUILDMARK_SEND sendmsg;
			::memset( &sendmsg, 0, sizeof(sendmsg) );
			sendmsg.Category = NM_GUILD;
			sendmsg.Protocol = NM_GUILDMARK_SEND_REQ;
			sendmsg.guildIndex = guildIndex;
			NETWORK->SendNetworkMsg( (char*)&sendmsg, sizeof(sendmsg) );

			/// û ʿ 
			if( mRequestMarkMap.Insert( guildIndex, markIndex ) == false )
			{
				assert(0);
			}
		}
	}
	return tex;
}

void cGuildManager::AddGuildUser( sGuildUserInfo* user )
{
	sGuildUserInfo* userInfo = new sGuildUserInfo;

	/// 
	*userInfo = *user;

	if( mGuildUserMap.Insert( userInfo->characterIdx, userInfo ) == false )
	{
		assert( 0 && "failed to insert guild user" );
	}
}

void cGuildManager::SetTempData( LPCTSTR name, unsigned long npcIdx )
{
	mTempName = name;
	mTempNpcIndex = npcIdx;
}

///    ˻
bool cGuildManager::CheckCreate( unsigned long npcIdx )
{
	// 1.  ԰˻
	if( HERO->GetGuildIndex() > 0 )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 1202 ),	
							GAMERESOURCEMAN->GetGameText( 1233 ),	//  
							eSKIN_OK );

		UIMAN->HideNpcBack();
		return false;
	}

	// 2.  ˻
	if( HERO->GetLevel() < GUILDLIMIT_LEVEL )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 1237 ),	
							GAMERESOURCEMAN->GetGameText( 1233 ),	//  
							eSKIN_OK );

		UIMAN->HideNpcBack();
		return false;
	}

	// 3. ݾ ˻
	if( HERO->GetMoney() < GUILDLIMIT_MONEY )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 1238 ),	
							GAMERESOURCEMAN->GetGameText( 1233 ),	//  
							eSKIN_OK );

		UIMAN->HideNpcBack();
		return false;
	}
	return true;
}

///   û
bool cGuildManager::GuildCreate()
{
	if( HERO->GetGuildIndex() > 0 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1202 ) );
		return false;
	}

	//  ˻ 
	if( mTempName.IsEmpty() )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1203 ) );
		return false;
	}

	// npc 
	if( mTempNpcIndex == 0 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 420 ) );
		return false;
	}

	MSG_REQ_NPC_GUILD_CREATE msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_NPC;
	msg.Protocol = NM_NPC_GUILD_CREATE_REQ;
	msg.npcIndex = mTempNpcIndex;
	::Sstrncpy( msg.name, MAX_GUILDNAME_BUFFER_SIZE, (LPCTSTR)mTempName.Cstr(), MAX_GUILDNAME_SIZE );

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
	return true;
}

///  ʴ û
void cGuildManager::GuildAdd( cStringT name )
{
	if( HERO->GetGuildIndex() == 0 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
		return;
	}

	if( name.IsEmpty() )
	{
		cBaseObject* pTarget = HERO->GetTargetObject();
		if( pTarget && pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
		{
			name = pTarget->GetName();
		}
		else
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 102 ) );
			return;
		}
	}

	/// ڱڽ ʴҰ
	if( ::_tcscmp( (LPCTSTR)name.Cstr(), HERO->GetName() ) == 0 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 142 ) );
		return;
	}

	///
	mTempAddName = name;

	///
	MSG_REQ_GUILD_ADD msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_GUILD;
	msg.Protocol = NM_GUILD_ADD_REQ;
	::Sstrncpy( msg.name, MAX_NAME_BUFFER_SIZE, (LPCTSTR)name.Cstr(), MAX_NAME_SIZE );

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

///  Ż û
void cGuildManager::GuildOut()
{
	if( HERO->GetGuildPosition() == eGUILD_NONE )
	{
		assert(0);
		return;
	}
	if( HERO->GetGuildPosition() == eGUILD_MASTER )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1221 ) );
		return;
	}

	MSG_REQ_GUILD_OUT msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_GUILD;
	msg.Protocol = NM_GUILD_OUT_REQ;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

///  ߹ û
void cGuildManager::GuildCut( unsigned long characterIdx )
{
	sGuildUserInfo* info = (sGuildUserInfo*)mGuildUserMap.GetAt( characterIdx );
	if( info != NULL )
	{
		mTempCutPlayerIdx = characterIdx;

		MSG_REQ_GUILD_CUT msg;
		::memset( &msg, 0, sizeof(msg) );
		msg.Category = NM_GUILD;
		msg.Protocol = NM_GUILD_CUT_REQ;
		msg.characterIdx = characterIdx;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
	}
	else
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1224 ) );
	}
}

///
void cGuildManager::GuildDelete()
{
	//  ִ ˻
	if( mGuildUserMap.GetSize() > 1 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1228 ) );
		return;
	}

	MSG_REQ_GUILD_DELETE msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_GUILD;
	msg.Protocol = NM_GUILD_DELETE_REQ;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

///
void cGuildManager::GuildGivePosition( unsigned long characterIdx, unsigned char position, unsigned char newPosition )
{
	if( HERO->GetGuildIndex() == 0 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
		return;
	}
	
	char heroPos = HERO->GetGuildPosition();
	if( !(heroPos == eGUILD_MASTER || heroPos == eGUILD_SUBMASTER) )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1245 ) );
		return;
	}
	
	///  ƴѰ
	/// ش   ڽŰ ų  
	///   ڽŰ ų  
	if( heroPos != eGUILD_MASTER )
	{
		if( !(heroPos < position && heroPos < newPosition) )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1245 ) );
			return;
		}
	}
	else if( heroPos == eGUILD_MASTER )
	{
		/// ش ϼ
		if( !(heroPos < position) )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1245 ) );
			assert(0);
			return;
		}
	}

	/// û
	MSG_REQ_GUILD_GIVEPOSITION msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_GUILD;
	msg.Protocol = NM_GUILD_GIVEPOSITION_REQ;
	msg.characterIdx = characterIdx;
	msg.position = newPosition;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

void cGuildManager::GuildNotice( LPCTSTR notice )
{
	if( HERO->GetGuildIndex() == 0 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
		return;
	}

	///
	MSG_REQ_GUILD_NOTICE msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_GUILD;
	msg.Protocol = NM_GUILD_NOTICE_REQ;
	::Sstrncpy( msg.notice, MAX_GUILD_NOTICE_BUFFER_SIZE, notice, MAX_GUILD_NOTICE_SIZE );
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

void cGuildManager::GuildMarkUpdate()
{
	MSG_REQ_GUILDMARK_UPDATE msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_GUILD;
	msg.Protocol = NM_GUILDMARK_UPDATE_REQ;
	memcpy( &msg.mark, &mMarkBuffer, MARK_SIZE );

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

bool GuildUserSort( const void *arg1, const void *arg2 )
{
	sGuildUserInfo* data1 = (sGuildUserInfo*)arg1;
	sGuildUserInfo* data2 = (sGuildUserInfo*)arg2;

	return (data2->position - data1->position > 0);
}

/// UI 
void cGuildManager::UpdateInfoSheet()
{
	if( mGuildInfo.idx == 0 )
		return;

	typedef tList<void*> cSortList;
	cSortList list;

	cGuildWindow* guildWindow = GAMEUI->GetGuildWindow();
	if( guildWindow )
	{
		mConnectCount = 0;
		guildWindow->Clear();

		///   
		guildWindow->SetGuildName( mGuildInfo.name );
		guildWindow->SetMasterName( mGuildInfo.masterName );
		guildWindow->SetPosition( mGuildInfo.position );
		guildWindow->SetTotalCount( mGuildUserMap.GetSize() );

		/// Ʈ 
		cGuildUserMap::cIterator i = mGuildUserMap.Begin();
		cGuildUserMap::cIterator end = mGuildUserMap.End();
		for( ; i != end; ++i )
		{
			sGuildUserInfo* p = (sGuildUserInfo*)(i->mSecond);
			list.PushBack( p );
		}

		list.Sort( GuildUserSort );

		///
		cSortList::cIterator li = list.Begin();
		cSortList::cIterator lend = list.End();
		for( ; li != lend; ++li )
		{
			sGuildUserInfo* p = (sGuildUserInfo*)(*li);
			guildWindow->AddGuildPlayer( p );

			// μ 
			if( p->channelNum > 0 )
				mConnectCount++;
		}

		guildWindow->SetConnectCount( mConnectCount );
	}
}

/// UI  -  /Ż  
void cGuildManager::UpdateInfoSheetByUser()
{
	typedef tList<void*> cSortList;
	cSortList list;

	cGuildWindow* guildWindow = GAMEUI->GetGuildWindow();
	if( guildWindow )
	{
		mConnectCount = 0;

		guildWindow->SetTotalCount( mGuildUserMap.GetSize() );

		unsigned int selectrow = guildWindow->GetSelectRow();

		/// Ʈ 
		guildWindow->ClearList();
		cGuildUserMap::cIterator i = mGuildUserMap.Begin();
		cGuildUserMap::cIterator end = mGuildUserMap.End();
		for( ; i != end; ++i )
		{
			sGuildUserInfo* p = (sGuildUserInfo*)(i->mSecond);
			list.PushBack( p );
		}

		list.Sort( GuildUserSort );

		///
		cSortList::cIterator li = list.Begin();
		cSortList::cIterator lend = list.End();
		for( ; li != lend; ++li )
		{
			sGuildUserInfo* p = (sGuildUserInfo*)(*li);
			guildWindow->AddGuildPlayer( p );

			// μ 
			if( p->channelNum > 0 )
				mConnectCount++;
		}

		//
		guildWindow->SetConnectCount( mConnectCount );
		guildWindow->SetSelectRow( selectrow );
	}
}

///   
void cGuildManager::UpdateNotice( bool sendChat )
{
	int len = ::_tcslen( mGuildInfo.notice );
	if( len > 0 )
	{
		if( sendChat == true )
		{
			cStringT str;
			str.Format( GAMERESOURCEMAN->GetGameText( 1251 ), mGuildInfo.notice );
			CHATMANAGER->AddChatMsg( (LPCTSTR)str.Cstr(), eCHAT_GUILD );
		}

		///
		cGuildWindow* win = GAMEUI->GetGuildWindow();
		if( win )
			win->UpdateGuildNotice( mGuildInfo.notice );
	}
}

///   ؽƮ ε 
LPCTSTR cGuildManager::GetTextIndex( unsigned char position )
{
	unsigned int textIdx = 0;
	switch( position )
	{
	case eGUILD_NONE:		textIdx = 1299;		break;		/// 
	case eGUILD_MASTER:		textIdx = 1300;		break;		/// 
	case eGUILD_SUBMASTER:	textIdx = 1301;		break;		///  
	case eGUILD_ELDER:		textIdx = 1302;		break;		/// 
	case eGUILD_UPPERHOUSE:	textIdx = 1303;		break;		///  ǿ
	case eGUILD_LOWERHOUSE:	textIdx = 1304;		break;		/// Ͽ ǿ
	case eGUILD_GENERAL:	textIdx = 1305;		break;		/// Ϲ
	default:		
		assert(0);		
		return 0;
	}

	return GAMERESOURCEMAN->GetGameText( textIdx );
}

///  ũ  ui  ε
NiTexture* cGuildManager::LoadGuildMark( const cString& pathName, bool tempMark )
{
	cFileToRead* file = FILESYSTEM->OpenFileToRead( pathName );

	/// 1.   ˻
	if( !file )
		return 0;

	/// 2.  ˻
	if( file->IsEmpty() == true )
		return 0;

	unsigned char ucharTemp = 0;
	short int sintTemp = 0;

	TARGAFILEHEADER header;
	::memset( &header, 0, sizeof(header) );

	file->Read( &ucharTemp, sizeof(unsigned char) );
	file->Read( &ucharTemp, sizeof(unsigned char) );
	file->Read( &header.imageTypeCode, sizeof(unsigned char) );
	file->Read( &sintTemp, sizeof(short int) );
	file->Read( &sintTemp, sizeof(short int) );
	file->Read( &ucharTemp, sizeof(unsigned char) );
	file->Read( &sintTemp, sizeof(short int) );
	file->Read( &sintTemp, sizeof(short int) );
	file->Read( &header.imageWidth, sizeof(short int) );
	file->Read( &header.imageHeight, sizeof(short int) );
	file->Read( &header.bitCount, sizeof(unsigned char) );
	file->Read( &header.imageDescriptor, sizeof(unsigned char) );

	/// 3. tga ̹Ÿ ˻ ( 2 :  RGB )
	if( header.imageTypeCode != 2 )
		return 0;

	/// 4.   ˻
	if( !(header.imageWidth == 24 && header.imageHeight == 24) )
		return 0;

	/// 4.   ˻ (  ˻)
	unsigned int len = file->GetSize();
	if( len > MARK_SIZE )
		return 0;

	int fileSize = header.imageWidth * header.imageHeight * (header.bitCount / 8) + MARK_HEADER_SIZE + TGA_EXTENSION;
	//if( fileSize != len )
	//	return 0;*/

	/// 帶ũ Ͽ  ˻
	if( tempMark == true )
	{
		///  ü 
		file->Seek( 0 );
		::memset( &mMarkBuffer, 0, sizeof(mMarkBuffer) );
		int readLen = file->Read( &mMarkBuffer, fileSize );
		/*if( readLen != MARK_SIZE )
		{
			assert(0);
			return 0;
		}*/
	}
	
	/// ؽ ε
	file->Seek( 0 );
	NiTexture* tex = RESOURCEMAN->LoadGuildMark( pathName, file, tempMark );
	file->Close();

	SAFE_DELETE( file );
	return tex;
}
