/* ==========================================================================
*      : GuildManager.h
*      : 
*    : 谡
*    : 2008-10-31
* ǻ :
*===========================================================================*/
#include "BaseStage.h"
#include "Guild_Common.h"

#define REGIST_GUILDMARK	"./GuildMark/mark.tga"

typedef struct tgaTARGAFILEHEADER
{
	unsigned char imageIDLength;		/// ĺ ʵ 	: 0 ̸ ĺʵ Ծȵ
	unsigned char colorMapType;			///   		: ׻ 0
	unsigned char imageTypeCode;		/// 2 : ȵ RGB, 3 : ȵ ׷ 

	short int colorMapOrigin;			///   ġ	: ׻ 0
	short int colorMapLength;			///   		: ׻ 0
	unsigned char colorMapEntrySize;	///   ׸ũ  : ׻ 0
	short int imageXOrigin;				/// ̹  ϴ x ǥ : ׻ 0
	short int imageYOrigin;				/// ̹  ϴ y ǥ
	short int imageWidth;				/// ̹ ȼ  ʺ
	short int imageHeight;				/// ̹ ȼ  
	unsigned char bitCount;				///  Ʈ 
	unsigned char imageDescriptor;		/// 24Ʈ : 0x00, 32Ʈ : 0x08

} TARGAFILEHEADER;

const unsigned long GUILD_WAIT_TIME = 10000;		// ʴ ӽð

struct MSG_RES_NPC_GUILD_CREATE;

class cGuildManager
{
public: 
	cGuildManager();
	~cGuildManager();

	void Close();
	
	///
	bool CheckCreate( unsigned long npcIdx );				///    ˻
	bool GuildCreate();
	void GuildAdd( cStringT name );
	void GuildOut();
	void GuildCut( unsigned long characterIdx );
	void GuildDelete();
	void GuildGivePosition( unsigned long characterIdx, unsigned char position, unsigned char newPosition );
	void GuildNotice( LPCTSTR notice );
	void GuildMarkUpdate();

	void ResGuildCreate( MSG_RES_NPC_GUILD_CREATE* pmsg );

	///
	void NetworkMsgParser( char* msg );

	///  ؽƮ ε 
	LPCTSTR GetTextIndex( unsigned char position );

	void SetTempData( LPCTSTR name, unsigned long npcIdx );
	void ClearTempData();
	unsigned long GetMasterIndex() { return mGuildInfo.masterIndex; }
	wchar_t* GetGuildNotice() { return mGuildInfo.notice; }

public:
	static cGuildManager* mpSingleton;	
	static cGuildManager* GetSingleton();

protected:
	void Clear();
	void ClearUI();

	///   Ʈ 
	void UpdateInfoSheet();

	///  /Ż   
	void UpdateInfoSheetByUser();

	///   
	void UpdateNotice( bool sendChat = true );

	///  ũ 
	void UpdateGuildMark();

	///
	void AddGuildUser( sGuildUserInfo* user );

public:
	///  ũ ؽ ̱
	NiTexture* LoadGuildMark( const cString& pathName, bool tempMark = false );

	/// 
	NiTexture* CheckGuildMark( unsigned long guildIndex, unsigned long markIndex );

	/// 帶ũ 
	BYTE			mMarkBuffer[MARK_SIZE];

	/// 帶ũ ( ũε, NiTexture*)
	typedef tPointerHashMap<unsigned long, void*> cGuildMarkMap;
	cGuildMarkMap	mGuildMarkMap;

	/// 帶ũ û ( ε, ũε)
	typedef tHashMap<unsigned long, unsigned long> cRequestMarkMap;
	cRequestMarkMap		mRequestMarkMap;

private:
	///  
	sGuildInfo		mGuildInfo;

	///  Ʈ (sGuildUserInfo)
	typedef tPointerHashMap<unsigned long, void*> cGuildUserMap;
	cGuildUserMap	mGuildUserMap;

	///  ο 
	unsigned long	mConnectCount;

	/// ̸ 
	cStringT		mTempName;
	unsigned long	mTempNpcIndex;

	/// ߹ ε ӽ 
	unsigned long	mTempCutPlayerIdx;

	///  ߰  
	cStringT		mTempAddName;
};

inline cGuildManager* cGuildManager::GetSingleton()
{
	return mpSingleton;
}

#define GUILDMAN cGuildManager::GetSingleton()

