#include "StdAfx.h"
#include "GuildWindow.h"
#include "ChatManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "GameResourceManager.h"

#include "ListBox.h"
#include "Label.h"
#include "EditBox.h"
#include "GuildManager.h"
#include "TipWindow.h"
#include "GameUIManager.h"
#include "UIMsgboxEvent.h"
#include "ChatManager.h"
#include "UIImage.h"
#include "FilterManager.h"

cGuildWindow::cGuildWindow()
: mpName(0)
, mpMasterName(0)
, mpPosition(0)
, mpTotal(0)
, mpConnectCount(0)
, mpList(0)
, mpNoticeEdit(0)
, mpGuildAdd(0)
, mpGuildMemDrop(0)
, mpGuildOut(0)
, mpGuildBreak(0)
, mpGuildGivePosition(0)
, mpNotice(0)
, mpMarkImage(0)
, mpMarkSkin(0)
, mShowMark(false)
{

}

cGuildWindow::~cGuildWindow()
{
	SAFE_DELETE( mpMarkImage );
}

void cGuildWindow::Toggle()
{
	if( IsVisible() == false )
	{
		if( HERO->GetGuildIndex() == 0 )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
			return;
		}
	}

	cUIWindow::Toggle();
}

void cGuildWindow::Clear()
{
	if( mpName )
		mpName->Clear();

	if( mpMasterName )
		mpMasterName->Clear();
	
	if( mpTotal )
		mpTotal->Clear();

	if( mpConnectCount )
		mpConnectCount->Clear();

	if( mpPosition )
		mpPosition->Clear();

	if( mpList )
		mpList->Clear();

	if( mpNoticeEdit )
		mpNoticeEdit->Clear();

	mShowMark = false;
}

void cGuildWindow::ClearList()
{
	if( mpList )
		mpList->Clear();
}

void cGuildWindow::OnShow()
{
	cUIWindow::OnShow();

	if( HERO->GetGuildIndex() > 0 )
	{
		if( mpNoticeEdit )
		{
			mpNoticeEdit->Clear();

			UpdateGuildNotice( GUILDMAN->GetGuildNotice() );
		}
	}
}

bool cGuildWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpName = (cLabel*)GetChild( eUIID_GUILD_NAME );
	mpMasterName = (cLabel*)GetChild( eUIID_GUILD_MASTERNAME );
	mpPosition = (cLabel*)GetChild( eUIID_GUILD_POSITION );
	mpTotal = (cLabel*)GetChild( eUIID_GUILD_TOTAL );
	mpConnectCount = (cLabel*)GetChild( eUIID_GUILD_CONNECTCOUNT );
	mpList = (cListBox*)GetChild( eUIID_GUILD_MEMBERLIST );
	mpNoticeEdit = (cEditBox*)GetChild( eUIID_GUILD_NOTICEEDIT );

	mpGuildAdd = GetChild( eUIID_GUILD_ADD );
	mpGuildMemDrop = GetChild( eUIID_GUILD_MEMBERDROP );
	mpGuildOut = GetChild( eUIID_GUILD_OUT );
	mpGuildBreak = GetChild( eUIID_GUILD_BREAK );
	mpGuildGivePosition = GetChild( eUIID_GUILD_GIVEPOSITION );
	mpNotice = GetChild( eUIID_GUILD_NOTICE );

	/// 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return 0;
	}

	mpMarkSkin = pSkin->GetNodeSkin( "Guild_Mark" );
	if( mpMarkSkin )
	{
		mpMarkImage = new cUIImage;
		if( mpMarkImage )
		{
			unsigned int x = mpMarkSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			unsigned int y = mpMarkSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
			mpMarkImage->SetScreenRect( cUIRect(x, y, x+MARK_WIDTH, y+MARK_HEIGHT) );
		}
	}

	///
	Clear();
	return true;
}

void cGuildWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	cUIWindow* win = (cUIWindow*)GAMEUI->GetGuildButtonWindow();
	if( mpGuildGivePosition && win )
	{
		unsigned short x = mpGuildGivePosition->GetAbsoluteRect().mLeft;
		unsigned short y = mpGuildGivePosition->GetAbsoluteRect().mBottom;
		win->SetRelativePos( cUIPos(x, y) );
	}

	if( mpMarkSkin && mpMarkImage )
	{
		unsigned int x = mpMarkSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpMarkSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpMarkImage->SetScreenRect( cUIRect(x, y, x+MARK_WIDTH, y+MARK_HEIGHT) );
	}
}

void cGuildWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mpMarkImage && mShowMark )
		mpMarkImage->Draw();
}

void cGuildWindow::OnCommand( cUINode* , unsigned int id )
{
	switch( id )
	{
	case eUIID_GUILD_CLOSE:
		{
			Hide();
		}
		break;
	case eUIID_GUILD_NOTICE:
		{
			if( mpNoticeEdit )
			{
				///   
				LPCTSTR notice = mpNoticeEdit->GetText();
				int len = ::_tcslen( notice );
				if( len > 0 )
				{
					if( FILTERMAN->CheckPartMatch( notice ) == false )
					{
						GUILDMAN->GuildNotice( notice );
						mpNoticeEdit->Clear();
					}
					else
					{
						/// ͸ 
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 336 ) );
					}
				}
				else
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1249 ) );
				}
			}
			else
			{
				assert(0);
			}
		}
		break;
	case eUIID_GUILD_ADD:
		{
			///  ʴ
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_GUILD_ADDUSERNAME, 
								GAMERESOURCEMAN->GetGameText( 1258 ),	
								GAMERESOURCEMAN->GetGameText( 1243 ),	//   ʴ
								eSKIN_EDIT, 0, 0, false, false, MAX_NAME_SIZE );
		}
		break;
	case eUIID_GUILD_MARKCHANGE:
		{
			if( HERO->GetGuildIndex() == 0 )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
				return;
			}

			///  ˻
			if( GUILDMAN->GetMasterIndex() != HERO->GetObjectID() )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1253 ) );
				return;
			}

			///  ũ 
			NiTexture* texture = GUILDMAN->LoadGuildMark( REGIST_GUILDMARK, true );
			if( texture )
			{
				/// 帶ũ ̸
				HERO->PreviewGuildMark( texture );

				cGuildMarkWindow* win = GAMEUI->GetGuildMarkWindow();
				if( win )
				{
					win->ChangeMarkRegist( texture );
					win->ShowTop();
				}
			}
			else
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1255 ) );
			}
		}
		break;
	case eUIID_GUILD_GIVEPOSITION:
		{
			///   ο
			cUIWindow* win = (cUIWindow*)GAMEUI->GetGuildButtonWindow();
			if( win )
			{
				if( win->IsVisible() )
					win->Hide();
				else
					win->ShowTop();
			}
		}
		break;
	case eUIID_GUILD_NOTESEND:
		{
			///  
			cUIWindow* win = (cUIWindow*)GAMEUI->GetGuildSendNoteWindow();
			if( win )
				win->ShowTop();
		}
		break;
	case eUIID_GUILD_MEMBERDROP:
		{
			if( HERO->GetGuildIndex() == 0 )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
				return;
			}

			///  ˻
			if( GUILDMAN->GetMasterIndex() != HERO->GetObjectID() )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1224 ) );
				return;
			}

			//  
			sGuildUserInfo* data = GetSelectUserInfo();
			if( data )
			{
				if( HERO->GetObjectID() == data->characterIdx )
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1223 ) );
					return;
				}

				TCHAR str[128]={0,};
				::_stprintf( str, GAMERESOURCEMAN->GetGameText( 1239 ), data->name );

				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_GUILD_MEMBERDROP, 
					str,
					GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
					eSKIN_YESNO, 
					(void*)data->characterIdx
					);	
			}
			else
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1242 ) );
			}
		}
		break;
	case eUIID_GUILD_OUT:
		{
			if( HERO->GetGuildIndex() == 0 )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
				return;
			}

			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_GUILD_OUT, 
				GAMERESOURCEMAN->GetGameText( 1240 ),
				GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
				eSKIN_YESNO
				);	
		}
		break;
	case eUIID_GUILD_BREAK:
		{
			if( HERO->GetGuildIndex() == 0 )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1205 ) );
				return;
			}

			// ˻
			if( GUILDMAN->GetMasterIndex() != HERO->GetObjectID() )
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1227 ) );
				return;
			}

			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_GUILD_BREAK, 
				GAMERESOURCEMAN->GetGameText( 1241 ),
				GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
				eSKIN_YESNO
				);	
		}
		break;
	}
}

///
void cGuildWindow::OnListBoxRowHovered( cUINode* , unsigned int , const cUIPos& pos, void* extraData )
{
	sGuildUserInfo* data = (sGuildUserInfo*)extraData;
	if( data )
	{
		UIMAN->HideTip();

		LPCTSTR tooltip = 0;
		if( data->channelNum > 0 )
		{
			if( HERO->GetChannelNum() == data->channelNum )
			{
				UIMAN->ShowCommunityTip( GAMEUI->GetSimpleTip(), pos, GAMERESOURCEMAN->GetMapName( data->mapnum ) );
			}
			else
			{
				TCHAR temp[128]={0,};
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 1260 ), data->channelNum );
				UIMAN->ShowCommunityTip( GAMEUI->GetSimpleTip(), pos, temp );
			}
		}
		else
		{
			UIMAN->ShowCommunityTip( GAMEUI->GetSimpleTip(), pos, GAMERESOURCEMAN->GetGameText( 1236 ) );
		}
	}
}

void cGuildWindow::OnListBoxRowLeft(cUINode* , unsigned int )
{
	UIMAN->HideTip();
}

///   ߰
void cGuildWindow::AddGuildPlayer( sGuildUserInfo* data )
{
	if( !mpList )
	{
		assert(0);
		return;
	}

	LPCTSTR posText = GUILDMAN->GetTextIndex( data->position );

	eText_Color color = mDefaultColor;

	if( data->channelNum > 0 )
	{
		/// ٸäο  
		if( HERO->GetChannelNum() != data->channelNum )
			color = eCOLOR_BROWN;
	}
	else
	{
		color = eCOLOR_DARKGRAY;
	}

	/// 
	int row = mpList->AddRow( posText, color, (void*)data );
	if( row > -1 )
	{
		/// ̸
		mpList->AddColume( row, data->name, color );

		/// 
		cStringT str;
		str.Format( _T("%dLv"), data->level );
		mpList->AddColume( row, (LPCTSTR)str.Cstr(), color );

		/// 
		LPCTSTR jobName = GAMERESOURCEMAN->GetJobName( data->job );
		mpList->AddColume( row, jobName, color );
	}
	else
	{
		assert(0);
	}
}

void cGuildWindow::SetGuildName( LPCTSTR name )
{
	if( mpName )
		mpName->SetText( name );
}

void cGuildWindow::SetMasterName( LPCTSTR name )
{
	if( mpMasterName )
		mpMasterName->SetText( name );
}

void cGuildWindow::SetTotalCount( unsigned int count )
{
	if( mpTotal )
		mpTotal->SetValue( count );
}

void cGuildWindow::SetConnectCount( unsigned int count )
{
	if( mpConnectCount )
		mpConnectCount->SetValue( count );
}

void cGuildWindow::SetPosition( unsigned char position )
{
	if( mpPosition )
	{
		LPCTSTR str = GUILDMAN->GetTextIndex( position );
		mpPosition->SetText( str );

		cGuildButtonWindow* win = GAMEUI->GetGuildButtonWindow();
		if( win )
			win->SetPosition( position );

		bool set = ( position == eGUILD_MASTER || position == eGUILD_SUBMASTER );
		if( mpGuildGivePosition )
			mpGuildGivePosition->SetEnabled( set );
	}
}

bool cGuildWindow::ChangeMark( NiTexture* tex )
{
	if( tex && mpMarkImage )
	{
		mpMarkImage->SetTexture( tex );
		mpMarkImage->SetTextureRect( 0, 0, MARK_WIDTH, MARK_HEIGHT );
		mShowMark = true;
	}
	else
	{
		assert(0);
		return false;
	}
	return true;
}

cUIRect cGuildWindow::GetGivePositionBtnRect()
{
	cUIRect rc(0, 0, 0, 0);
	if( mpGuildGivePosition )
		rc = mpGuildGivePosition->GetAbsoluteRect();
	return rc;
}

/// õ  
sGuildUserInfo* cGuildWindow::GetSelectUserInfo()
{
	if( !mpList )
	{
		assert(0);
		return 0;
	}

	int row = mpList->GetSelectIndex();
	sGuildUserInfo* data = (sGuildUserInfo*)mpList->GetExtraData( row );
	return data;
}

unsigned int cGuildWindow::GetSelectRow()
{
	if( mpList )
		return mpList->GetSelectIndex();
	return 0;
}

void cGuildWindow::SetSelectRow( unsigned int row )
{
	if( mpList )
		mpList->ChangeSelectRow( row );
}

void cGuildWindow::UpdateGuildNotice( LPCTSTR notice )
{
	if( mpNoticeEdit )
		mpNoticeEdit->SetText( notice );
}

void cGuildWindow::OnNetLock( int lockTry )
{
	if( mpGuildAdd )
		mpGuildAdd->NetLock( lockTry );

	if( mpGuildMemDrop )
		mpGuildMemDrop->NetLock( lockTry );

	if( mpGuildOut )
		mpGuildOut->NetLock( lockTry );

	if( mpGuildBreak )
		mpGuildBreak->NetLock( lockTry );
}

void cGuildWindow::OnNetUnLock( int lockTry )
{
	if( mpGuildAdd )
		mpGuildAdd->NetUnLock( lockTry );

	if( mpGuildMemDrop )
		mpGuildMemDrop->NetUnLock( lockTry );

	if( mpGuildOut )
		mpGuildOut->NetUnLock( lockTry );

	if( mpGuildBreak )
		mpGuildBreak->NetUnLock( lockTry );
}


//////////////////////////////////////////////////////////////////
//// ư 
cGuildButtonWindow::cGuildButtonWindow()
: mpMaster(0)
, mpSubMaster(0)
, mpElder(0)
, mpUpperHouse(0)
, mpLowerHouse(0)
, mpGeneral(0)
{

}

cGuildButtonWindow::~cGuildButtonWindow()
{
}

bool cGuildButtonWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	UIMAN->AddEventOtherClick( this );

	mpMaster = GetChild( eUIID_GUILDPOSITION_MASTER );
	mpSubMaster = GetChild( eUIID_GUILDPOSITION_SUBMASTER );
	mpElder = GetChild( eUIID_GUILDPOSITION_ELDER );
	mpUpperHouse = GetChild( eUIID_GUILDPOSITION_UPPERHOUSE );
	mpLowerHouse = GetChild( eUIID_GUILDPOSITION_LOWERHOUSE );
	mpGeneral = GetChild( eUIID_GUILDPOSITION_GENERAL );

	return true;
}

void cGuildButtonWindow::OnCommand( cUINode* , unsigned int id )
{
	cGuildWindow* win = GAMEUI->GetGuildWindow();	
	if( !win )
	{
		assert(0);
		return;
	}

	char heroPos = HERO->GetGuildPosition();

	TCHAR str[128]={0,};
	char position = eGUILD_NONE;

	switch( id )
	{
	case eUIID_GUILDPOSITION_MASTER:	/// 
		if( HERO->GetGuildPosition() == eGUILD_MASTER )
			position = eGUILD_MASTER;
		break;		
	case eUIID_GUILDPOSITION_SUBMASTER:	/// α
		if( HERO->GetGuildPosition() == eGUILD_MASTER )
			position = eGUILD_SUBMASTER;
		break;
	case eUIID_GUILDPOSITION_ELDER:		/// 
		if( HERO->GetGuildPosition() == eGUILD_MASTER ||  HERO->GetGuildPosition() == eGUILD_SUBMASTER )
			position = eGUILD_ELDER;
		break;
	case eUIID_GUILDPOSITION_UPPERHOUSE:	///  ǿ
		if( HERO->GetGuildPosition() == eGUILD_MASTER ||  HERO->GetGuildPosition() == eGUILD_SUBMASTER )
			position = eGUILD_UPPERHOUSE;
		break;
	case eUIID_GUILDPOSITION_LOWERHOUSE:	/// Ͽ ǿ
		if( HERO->GetGuildPosition() == eGUILD_MASTER ||  HERO->GetGuildPosition() == eGUILD_SUBMASTER )
			position = eGUILD_LOWERHOUSE;
		break;
	case eUIID_GUILDPOSITION_GENERAL:		/// Ϲ
		if( HERO->GetGuildPosition() == eGUILD_MASTER ||  HERO->GetGuildPosition() == eGUILD_SUBMASTER )
			position = eGUILD_GENERAL;
		break;
	default:
		Hide();
		return;
	}

	/// ˸â 
	if( position != eGUILD_NONE )
	{
		sGuildUserInfo* info = win->GetSelectUserInfo();
		if( info )
		{
			/// ڱڽ Ұ
			if( HERO->GetObjectID() != info->characterIdx )
			{
				LPCTSTR positionStr = GUILDMAN->GetTextIndex( position );
				::_stprintf( str, GAMERESOURCEMAN->GetGameText( 1247 ), info->name, positionStr );

				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_GUILD_GIVEPOSITION, 
					str,
					GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
					eSKIN_YESNO, 
					(void*)position
					);	
			}
			else
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1248 ) );
			}
		}
	}
	else
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1245 ) );
	}

	Hide();
}

void cGuildButtonWindow::OnMouseOtherClick( const cUIPos& pos )
{
	cGuildWindow* win = GAMEUI->GetGuildWindow();
	if( win )
	{
		cUIRect& rect = win->GetGivePositionBtnRect();
		if( mAbsoluteRect.ContainPoint( pos ) == false && 
			rect.ContainPoint( pos ) == false )
		{
			Hide();
		}
	}
}

void cGuildButtonWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	cGuildWindow* win = GAMEUI->GetGuildWindow();
	if( win )
	{
		cUIRect& rect = win->GetGivePositionBtnRect();
		unsigned short x = rect.mLeft;
		unsigned short y = rect.mBottom;
		SetRelativePos( cUIPos(x, y) );
	}
}

void cGuildButtonWindow::SetPosition( unsigned char position )
{
	bool otherSet = false;

	if( position == eGUILD_MASTER )
	{
		if( mpMaster )
			mpMaster->SetEnabled( true );
		if( mpSubMaster )
			mpSubMaster->SetEnabled( true );

		otherSet = true;
	}
	else if( position == eGUILD_SUBMASTER )
	{
		if( mpMaster )
			mpMaster->SetEnabled( false );
		if( mpSubMaster )
			mpSubMaster->SetEnabled( false );

		otherSet = true;
	}
	else
	{
		Hide();
	}
	
	if( mpElder )
		mpElder->SetEnabled( otherSet );
	if( mpUpperHouse )
		mpUpperHouse->SetEnabled( otherSet );
	if( mpLowerHouse )
		mpLowerHouse->SetEnabled( otherSet );
	if( mpGeneral )
		mpGeneral->SetEnabled( otherSet );
}

///////////////////////////////////////////////////////////////////////
// 帶ũ  UI
cGuildMarkWindow::cGuildMarkWindow()
: mpMarkImage(0)
, mpMarkSkin(0)
{
}

cGuildMarkWindow::~cGuildMarkWindow()
{
	SAFE_DELETE( mpMarkImage );
}

void cGuildMarkWindow::OnHide()
{
	SAFE_DELETE( mpMarkImage );
}

bool cGuildMarkWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return 0;
	}

	mpMarkSkin = pSkin->GetNodeSkin( "GuildMark_Mark" );
	if( !mpMarkSkin )
	{
		assert(0);
		return 0;
	}
	return true;
}

void cGuildMarkWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mpMarkImage )
		mpMarkImage->Draw();
}

void cGuildMarkWindow::OnCommand( cUINode* , unsigned int id )
{
	if( id == eUIID_GUILDMARK_YES )
	{
		GUILDMAN->GuildMarkUpdate();
	}

	/// ̸ 
	HERO->UpdateGuildMark();
	Hide();
}

void cGuildMarkWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpMarkSkin && mpMarkImage )
	{
		unsigned int x = mpMarkSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpMarkSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpMarkImage->SetScreenRect( cUIRect(x, y, x+MARK_WIDTH, y+MARK_HEIGHT) );
	}
}

bool cGuildMarkWindow::ChangeMarkRegist( NiTexture* tex )
{
	if( mpMarkSkin && tex )
	{
		/// ؽó 
		mpMarkImage = new cUIImage( tex );
		unsigned int x = mpMarkSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpMarkSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;

		mpMarkImage->SetTextureRect( 0, 0, MARK_WIDTH, MARK_HEIGHT );
		mpMarkImage->SetScreenRect( cUIRect(x, y, x+MARK_WIDTH, y+MARK_HEIGHT) );
	}
	else
	{
		assert(0);
		return false;
	}
	return true;
}