#include "stdafx.h"
#include "hero.h"

#include "PlayerSceneNode.h"
#include "TransMonSceneNode.h"
#include "ObjectNameCard.h"

#include "SoundSystem.h"
#include "InputSystem.h"

#include "SceneManager.h"
#include "Application.h"

#include "ObjectManager.h"
#include "GameResourceManager.h"
#include "WorldManager.h"
#include "SkillExecuter.h"
#include "SkillManager.h"
#include "SkillScript.h"
#include "StageScript.h"
#include "MonsterScript.h"
#include "GatheringScript.h"

#include "CameraManager.h"
#include "LookAtCamera.h"
#include "CommonNetworkMsgStruct.h"
#include "Protocol.h"
#include "Pathfinder.h"
#include "RangeCheck.h"

//#include "Skill_Common.h"
#include "Item_Common.h"
#include "SoundSystem.h"
#include "AppTimer.h"
#include "Duel_Common.h"
#include "Gathering_Common.h"

#include "CastingBar.h"
#include "HeroInfoWindow.h"
#include "HeroStateWindow.h"
#include "TargetWindow.h"
#include "SmallMiniMapWindow.h"
#include "MiniMapWindow.h"

#include "skillwindow.h"
#include "BuffWindow.h"

#include "PVPManager.h"
#include "DuelManager.h"
#include "DuelWindow.h"

#include "GameUIManager.h"
#include "PartyManager.h"
#include "DamagePrintManager.h"
#include "DramaturgyManager.h"
#include "QuestManager.h"
#include "TitleManager.h"
#include "ItemMixManager.h"

#include "Npc.h"
#include "Monster.h"
#include "MonsterSceneNode.h"
#include "VehicleSceneNode.h"
#include "ChatManager.h"

#include "Tarot_Common.h"
#include "ItemManager.h"
#include "QuickManager.h"

#include "uicursor.h"
//
#include "TrailGeometry.h"
#include "UIMsgboxEvent.h"

#include "DuelMsgWindow.h"
#include "EffectSceneNode.h"
#ifdef _GMTOOL
/// ġƮ
#include "CheatManager.h"
#endif

cPlayerSceneNodeParam  gTempParam;
cMonsterSceneNodeParam gTempParamMon;

cHero::cHero( unsigned char type )
: cPlayer(type)
{
	mpCamera = NULL;
	mDefaultCameraOffset = 0.0f;
	mCameraOffset = 0.0f;

	/// ã
	mPathFinder = NULL;
	mPathIndex = 0;
	mPathCount = 0;

	mIsCalcStatus = false;
	mIsUdateHeroInfo = false;

	/// default ⺻
	mWaitSkillIdx = 0;
	mWaitWeaponSwitch = false;

	///  ̵  (Attack¿ ȿϴ)
	mWaitMove = false;

	mAfterAction.mActionType = eAfterAction_None;

	InitStatusInfoType();

	mMageJobType = false;

	mMoney = 0;
	mDeposit = 0;
	mArmorSets  = ARMOR_SETS_NONE;

	mNpcIdx = 0;

	mPeaceToggleTime = 0;
	mPeaceToggleFlag = true;

	mSwitchWeaponTime = 0;
	mSwitchWeaponFlag = false;

	mMoveTargetEffect = 0;
	mMoveTargetEffectIdx = (unsigned long)-1;

	mJobUsedSkillPoint.Resize( 5 );

	mDamageAfterAnim = ANITYPE_IDLE;
}

cHero::~cHero()
{
	mMoveTargetEffect = 0;
	mMoveTargetEffectIdx = (unsigned long)-1;

	ClearTabTargetList();

	mJobUsedSkillPoint.Clear();
}

bool cHero::Create( sPlayerInfo* pBaseInfo, sPlayerWearInfo* pWearInfo, sPlayerWeaponInfo* pWeaponInfo, 
				   sPlayerExrInfo* pExrInfo, NiPoint3 sPos, NiMatrix3 sRot, float fScale )
{
	::memcpy( &mPlayerInfo, pBaseInfo, sizeof(sPlayerInfo) );
	::memcpy( &mPlayerExrInfo, pExrInfo, sizeof(sPlayerExrInfo) );
	::memcpy( &mPlayerWearInfo, pWearInfo, sizeof(sPlayerWearInfo) );
	::memcpy( &mPlayerWeaponInfo, pWeaponInfo, sizeof(sPlayerWeaponInfo) );

	gTempParam.mpObject = gTempParamMon.mpObject = this;
	gTempParam.mTranslate = gTempParamMon.mTranslate = sPos;
	gTempParam.mRotate = gTempParamMon.mRotate = sRot;
	gTempParam.mScale = gTempParamMon.mScale = fScale;

	mCantMove = false;
	mCantSkill = false;

	///
	mDelay = 0;
	mAngle = 0.0f;
	mAccumAngle = 0.0f;
	mAxis = NiPoint3::UNIT_Z;

	mMoveTargetEffect = 0;
	mMoveTargetEffectIdx = (unsigned long)-1;

	mSitDownStartTime = 0;
	mSitDownStatusCalc = false;

//	mMoveTargetList.Clear();

	return true;
}

void cHero::SetHeroInfoNet( MSGROOT* pInfo )
{
	MSG_HEROINFO* pHInfo = (MSG_HEROINFO*)pInfo;

	memcpy( HERO->GetHeroInfo(), &pHInfo->mHeroInfo, sizeof(sHeroInfo) );
	memcpy( HERO->GetHeroExrInfo(), &pHInfo->mExrInfo, sizeof(sPlayerExrInfo) );

	if( pHInfo->mExrInfo.mChgMonsterIdx == 0 )
	{
		const char* strFile = GAMERESOURCEMAN->GetModelFileName( (mPlayerInfo.Race * eGENDER_MAX) + mPlayerInfo.Gender );
		gTempParam.mPathName = strFile;
	}
	else
	{
		///  ȭ
		sMonsterScript* pMonsterInfo;
		pMonsterInfo = MONSTERSCRIPT->GetMonsterListInfo( mPlayerExrInfo.mChgMonsterIdx );
		if( pMonsterInfo == NULL )
		{
			assert(0);
			return;
		}

		float scale = 1.0f;
		if( pMonsterInfo->mMonsterScale == 0.0f )
			scale = pMonsterInfo->mMonsterScale;

		const char* strFile = GAMERESOURCEMAN->GetModelFileName( pMonsterInfo->mKfmIdx );

		cString path;
		path.Format( "./Data/Monster/%s", strFile );

		gTempParamMon.mPathName = path;
		gTempParamMon.mScale = scale;
	}
}


bool cHero::GameIn( unsigned long channelNum )
{
	if( mPlayerExrInfo.mChgMonsterIdx == 0 )
	{
		if( WORLDMAN->CalcHeight( &gTempParam.mTranslate.z, gTempParam.mTranslate.x, gTempParam.mTranslate.y ) == false )
			assert(NULL);

		gTempParam.mWoldAccumTime = THEAPP->GetWorldAccumTime();

		mpObjectSceneNode = CreateSceneNode( &gTempParam );
		if( mpObjectSceneNode == 0 )
		{
			assert(0);
			return false;
		}

		/// head  
		ChangeBaseHair( mPlayerInfo.HeadInfo[eHEAD_HAIR] );
		SetBaseFace();

		if( mPlayerInfo.HeadInfo[eHEAD_FACE_STATIC] != 0 )
			ChangeFaceTexture( mPlayerInfo.HeadInfo[eHEAD_FACE_STATIC], true );
		else
			ChangeFaceTexture( mPlayerInfo.HeadInfo[eHEAD_FACE], true );


//		if( PVPMAN->IsEnableBattle() == true )
//		{
//			///    
//		}
//		else
		{
			///   
			for( unsigned int ui=0; ui<eWEAR_MAX; ui++ )
			{
				if( mPlayerWearInfo.WearIdx[ui] == 0 )
				{
					if( ui != eWEAR_HAT ) 
					{
						///   ؾ ϴ 
						ChangeBaseWear( ePART_BODY1 + ui );
					}
				}
				else
				{
					///  
					EquipWearItem( mPlayerWearInfo.WearIdx[ui] );
				}
			}
		}

		///   
		/// ʱȭ ̹Ƿ  Ѵ..
		EquipWeaponItem( &mPlayerWeaponInfo );
	}
	else
	{
		if( WORLDMAN->CalcHeight( &gTempParamMon.mTranslate.z, gTempParamMon.mTranslate.x, gTempParamMon.mTranslate.y ) == false )
			assert(NULL);

		gTempParamMon.mWoldAccumTime = THEAPP->GetWorldAccumTime();

		mpObjectSceneNode = (cDynamicSceneNode*)SCENEMAN->CreateTransMonster( gTempParamMon, true );
		if( mpObjectSceneNode == 0 )
		{
			assert(0);
			return false;
		}

		sMonsterScript* pMonsterInfo;
		pMonsterInfo = MONSTERSCRIPT->GetMonsterListInfo( mPlayerExrInfo.mChgMonsterIdx );
		if( pMonsterInfo == NULL )
		{
			assert(0);
			return false;
		}

		float monsterSize = 1.0f;
		if( pMonsterInfo->mMonsterFixSize != 0.0f )
			monsterSize = pMonsterInfo->mMonsterFixSize;
	}

	SetFixedObjectSizeScale( mPlayerExrInfo.mFixedObjectSizePer );

	ShowNameGauge( true );

	mChannelNum = channelNum;

	SetState( eOBJECT_STATE_IDLE );
	mPlayerExrInfo.mStateIdle = eIDLE_NORMAL;
	mPlayerExrInfo.mStateStop = eSTOP_NONE;

	/// Hero  ٴϴ ī޶ .. 
	CAMERAMAN->ChangeCamera( eCamera_Hero );
	cLookAtCamera* pCamera = (cLookAtCamera*)CAMERAMAN->GetCurrent();

	NiPoint3 sCenter = mpObjectSceneNode->GetObjectCenter();
	NiPoint3 sFoot = mpObjectSceneNode->GetObjectFoot();
	mDefaultCameraOffset = sCenter.z - sFoot.z +22.0f;
	mCameraOffset = mDefaultCameraOffset;

	pCamera->SetLookAt( NiPoint3( sFoot.x, sFoot.y, sFoot.z + mCameraOffset ) );

	NiPoint3 sHead = mpObjectSceneNode->GetObjectHead();
	mStatureValue = (sHead.z - sFoot.z) / mpObjectSceneNode->GetWorldScale();

	///
	mDesiredDir = mpObjectSceneNode->GetRotate()*mDesiredDir;
	mDesiredDir.Unitize();

	pCamera->ViewHeroFront( -mDesiredDir );

	/// ã 
	SetPathFinder( WORLDMAN->GetPathFinder() );

	///  ..
	STATUSCALC->CalcPlayerInit();

	mpObjectSceneNode->UpdateNameCardTextValue();
//	mpObjectSceneNode->UpdateNameCardGaugeValue();

	/// ųâ 
	cSkillWindow* skillWindow = GAMEUI->GetSkillWindow();
	if( skillWindow )
	{
		tArray<unsigned long>* parray = GAMERESOURCEMAN->GetParentJob( mPlayerInfo.Job );
		if( parray )
		{
			assert( parray->IsEmpty() == false );

			if( parray->IsEmpty() == false )
			{
				for( unsigned int i=0;i<parray->GetSize();++i)
					skillWindow->AddJobTab( (*parray)[i] );
			}
		}
		
		skillWindow->AddJobTab( mPlayerInfo.Job );
		skillWindow->SetCurrent( 0 );
	}

	/// ų  
	SKILLMAN->UpdateAllSkill();

	mMageJobType = GAMERESOURCEMAN->IsCorrelateMageJob( mPlayerInfo.Job );

	mIsCalcStatus = true;
	mIsUdateHeroInfo = true;
	GAMEUI->UpdateSkillPoint();

	/// 
	ITEMMAN->CheckEquipAbility();

	///   
	ResetArmorSets();

	/// hero  ʱȭ
	GAMEUI->InitHeroInfo();

	/// ü   
	ITEMMAN->SetMaxWeightGauge( (float)GetMaxWeight() );

	/// ü  Ÿ  
	ITEMMAN->SetAllItemCool();

	/// ȣĪ  
	TITLEMAN->Open();

	/// Vehicle Check
	if( mPlayerExrInfo.mVehicleIdx != 0 )
	{
		if( mPlayerExrInfo.mChgMonsterIdx == 0 )
		{
			RideVehicle( mPlayerExrInfo.mVehicleIdx );
		}
		else
		{
			assert(0);
		}
	}

	///   Ʈ
	PVPMAN->LinkPvpForceEffect( this, mPlayerExrInfo.mForceType );

	SetLinkdEffect( eLINK_FOOT, "./Data/Effect/Eff_PC_LogIn_01.nif", 0 );

	return true;
}

void cHero::ReCreate( char race, char gender )
{
	if( mpObjectSceneNode->GetTargetAnimation() != 0 )
		return;

	cPlayer::ReCreate( race, gender );

	cLookAtCamera* pCamera = (cLookAtCamera*)CAMERAMAN->GetCurrent();

	NiPoint3 sCenter = mpObjectSceneNode->GetObjectCenter();
	NiPoint3 sFoot = mpObjectSceneNode->GetObjectFoot();
	mDefaultCameraOffset = sCenter.z - sFoot.z +22.0f;
	mCameraOffset = mDefaultCameraOffset;

	pCamera->SetLookAt( NiPoint3( sFoot.x, sFoot.y, sFoot.z + mCameraOffset ) );
}

void cHero::SetState( unsigned int state, bool bShowAni )
{
	mIdleTime = 0;

	///      Ⱑ ; Ѵ.
	if( mPlayerExrInfo.mState == eOBJECT_STATE_DIE )
	{
		if( state != eOBJECT_STATE_IDLE )
		{
			assert(0);
			return;
		}

		SetReadyUseSkill( true );

		mAfterAction.mActionType = eAfterAction_None;
		mWaitMove = false;
		mWaitSkillIdx = 0;
	}

	if( mPlayerExrInfo.mState == ePLAYER_STATE_GATHERING && state != ePLAYER_STATE_GATHERING )
	{
		if( mGatheringToolObj != UINT_MAX )
		{
			mpObjectSceneNode->UnLinkObject( mGatheringToolObj );
			mGatheringToolObj = UINT_MAX;
		}
	}

	if( mPlayerExrInfo.mState == eOBJECT_STATE_MOVE )
	{
		if( state != eOBJECT_STATE_MOVE )
		{
			if( mMoveTargetEffectIdx != (unsigned long)-1 )
			{
				cEffectSceneNode* node = SCENEMAN->GetEffectSceneNode( mMoveTargetEffectIdx );
				if( node )
				{
					assert( node == mMoveTargetEffect );
					node->Remove();
				}
				mMoveTargetEffect = 0;
				mMoveTargetEffectIdx = (unsigned long)-1;
			}
		}
	}

	/// 081209 PKH Ͼ  -  
	if( mPlayerExrInfo.mState == ePLAYER_STATE_SITDOWN && state != ePLAYER_STATE_SITDOWN )
	{		
		if( IsSitDownCalc() == true )
			CalcStatus();
		mSitDownStartTime = 0;
		mSitDownStatusCalc = false;

	}

	if( state == ePLAYER_STATE_ITEMPICK || state == ePLAYER_STATE_GATHERING )
	{
		CURSOR->SetCursor( eCURSOR_DEFAULT );
	}

	if( state != ePLAYER_STATE_SITDOWN )
		mSitDownFlag = false;

	if( state != eOBJECT_STATE_STOP )
		mPlayerExrInfo.mStateStop = eSTOP_NONE;

	if( state == eOBJECT_STATE_IDLE )
	{
		SetReadyUseSkill( true );

		mAfterAction.mActionType = eAfterAction_None;
		mWaitMove = false;
		mWaitSkillIdx = 0;
	}
	else if( state == eOBJECT_STATE_ATTACK )
	{
		ShowWeapon( true );
		mPlayerExrInfo.mState = (eOBJECTSTATE)state;
		SetIdleFlag(eIDLE_NORMAL);

		return;
	}
	else if( state == eOBJECT_STATE_DIE )
	{
		/// npc ȭ ̾ ȭ ʱȭѴ.
		mNpcIdx = 0;
		SetReadyUseSkill( true );

		/// ױ ¿  UI ݱ
		GAMEUI->HideUIByDie();

		///   ȿ ..
		ClearDieBuff();
		mCantMove = false;
		mCantSkill = false;
		mIsStun = false;
		mIsSleep = false;
	}

	cPlayer::SetState( state, bShowAni );
}

void cHero::SetTargetObject( unsigned char type, unsigned long idx )
{
	if( mTarget.type == type && mTarget.index == idx )
		return;

	if( type == eOBJECTTYPE_NONE )
		ClearTabTargetList();

	///  Ÿ
	cBaseObject* obj = GetTargetObject();
	if( obj )
	{
		obj->SetOverFlag( false );
		OBJECTMAN->ResetOverObject();
	}

	cBaseObject::SetTargetObject( type, idx );

	///  Ÿ
	cTargetWindow* targetWindow = GAMEUI->GetTargetWindow();
	obj = GetTargetObject();
	if( obj )
	{		
		obj->SetOverFlag( true );

		/// Ÿâ 
		if( targetWindow )
		{
			targetWindow->ClearBuff();

			/// Ÿ  
			typedef tPointerHashMap<unsigned long, void*> cTargetBuffMap;
			cTargetBuffMap* buffMap = obj->GetBufMap();
			if( buffMap )
			{
				if( buffMap->GetSize() > 0 )
				{
					cTargetBuffMap::cIterator i = buffMap->Begin();
					cTargetBuffMap::cIterator end = buffMap->End();
					for( ; i != end; ++i )
					{
						cInfluenceObject* p = (cInfluenceObject*)(i->mSecond);
						if( p )
						{
							/// ȿ ųε ȿε .
							/// /  
							targetWindow->AddBuff( p->GetManagedKey(), p->GetInfluenceIdx() );
						}
					}
				}
			}

			/// Ÿ  
			typedef tPointerHashMap<unsigned long, void*> cTargetDebuffMap;
			cTargetDebuffMap* debuffMap = obj->GetDeBufMap();
			if( debuffMap )
			{
				if( debuffMap->GetSize() > 0 )
				{
					cTargetDebuffMap::cIterator i = debuffMap->Begin();
					cTargetDebuffMap::cIterator end = debuffMap->End();
					for( ; i != end; ++i )
					{
						cInfluenceObject* p = (cInfluenceObject*)(i->mSecond);
						if( p )
						{
							/// ȿ ųε ȿε .
							/// /  
							targetWindow->AddBuff( p->GetManagedKey(), p->GetInfluenceIdx() );
						}
					}
				}
			}
		}
	}
	else
	{
		if( targetWindow )
			targetWindow->Hide();
	}
	targetWindow->UpdateWindow();

	PARTYMAN->ChangeTarget( idx );
//	SKILLEXECUTER->ResetAttackFlag();
}

void cHero::HPChange( unsigned long objectHP, unsigned long objectMaxHP, bool die )
{
	if( die ) 
	{
		assert(objectHP==0);
		assert( GetState() != eOBJECT_STATE_DIE );

		if( GetState() != eOBJECT_STATE_DIE )
		{
			if( IsRideVehicle() == true )
				AlightVehicle();

			SetState( eOBJECT_STATE_DIE );
			SKILLMAN->CreateApplyObject( 0, this, 0, eAPPLYDRAMA_DIE1 );
		}

		///   ȿ ..
		ClearDieBuff();
		mCantMove = false;
		mCantSkill = false;
		mIsStun = false;
		mIsSleep = false;

		CalcStatus();
		
		mPlayerExrInfo.RestHP = 0;
		mPlayerExrInfo.RestMP = 0;
	}
	else
	{
		mPlayerExrInfo.RestHP = objectHP;
		mPlayerExrInfo.MaxHP = objectMaxHP;
	}

	mpObjectSceneNode->UpdateNameCardGaugeValue();

	/// 
	GAMEUI->UpdateHeroHPMP();
}

void cHero::HPChange( sTargetDamageHP* damage, cBaseObject* attacker )
{
	if( damage == 0 )
	{
		assert(0);
		return;
	}

	if( damage->mDie ) 
	{
		assert( damage->mObjectHP == 0 );
		assert( GetState() != eOBJECT_STATE_DIE );

		if( GetState() != eOBJECT_STATE_DIE )
		{
			if( IsRideVehicle() == true )
				AlightVehicle();

			if( attacker )
				SetDesiredDir( GetPos(), attacker->GetPos() );

			SetState( eOBJECT_STATE_DIE );
			if( damage->mDamageKind == eDAMAGE_CRITICAL )
			{
				ChangeAnimation( ANITYPE_DIE2 );
				SKILLMAN->CreateApplyObject( attacker, this, 0, eAPPLYDRAMA_DIE2 );
			}
			else
			{
				SKILLMAN->CreateApplyObject( attacker, this, 0, eAPPLYDRAMA_DIE1 );
			}
		}

		///   ȿ ..
		ClearDieBuff();
		mCantMove = false;
		mCantSkill = false;
		mIsStun = false;
		mIsSleep = false;


		mPlayerExrInfo.RestHP = 0;
		mPlayerExrInfo.RestMP = 0;

		CalcStatus();
	}
	else
	{
		mPlayerExrInfo.RestHP = damage->mObjectHP;
		mPlayerExrInfo.MaxHP = damage->mObjectMaxHP;
	}

	assert( GetHP() <= GetMaxHP() );
	mpObjectSceneNode->UpdateNameCardGaugeValue();

	/// 
	GAMEUI->UpdateHeroHPMP();
}

void cHero::MPChange( unsigned long objectMP, unsigned long objectMaxMP )
{
	if( GetState() == eOBJECT_STATE_DIE )
	{
		assert(objectMP == 0);
	}

	mPlayerExrInfo.RestMP = objectMP;
	mPlayerExrInfo.MaxMP = objectMaxMP;

	assert( GetMP() <= GetMaxMP() );
	mpObjectSceneNode->UpdateNameCardGaugeValue();

	///
	GAMEUI->UpdateHeroHPMP();
	QUICKMAN->CheckSkillIcon();
}

void cHero::AfterAttack( cBaseObject* pTarget )
{
	if( GatheringCancel() == false )
		return;

	/// ⺻  ó
	if( pTarget == 0 )
		return;

	/// 080508 PKH  ϶ Ϲݰ ϸ ϸ̼ ٲ üũ
	if( GetState() == eOBJECT_STATE_STOP )
		return;

	unsigned long attackIdx = SKILLEXECUTER->GetChargeSkill();
	if( IsReadyUseSkill() == false )
	{
		SKILLEXECUTER->ChargeOff( attackIdx );
		return;
	}

	///  ɰŸ  üũ
	NiPoint3 targetPos = pTarget->GetPos();
//	targetPos.z = 0.0f;
	NiPoint3 heroPos = GetPos();
//	heroPos.z = 0.0f;

	/// 071127 PKH 
	float range = SKILLEXECUTER->GetChargeSkillRange();
	float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, range );
	cRangeCheck rangecheck( tempRange );
	if( rangecheck.IsRange( heroPos, targetPos ) )
	{
		///  ..
		if( StartAttack( attackIdx, pTarget ) == false )
		{
			///   
			SetState( eOBJECT_STATE_ATTACK );
			SetReadyUseSkill( true );
		}
	}
	else
	{
		/// ó Ѵ.
		mAfterAction.mActionType = eAfterAction_Attack;
		mAfterAction.mTarget.index = pTarget->GetObjectID();
		mAfterAction.mTarget.type = pTarget->GetObjectType();
		mAfterAction.mDestPos = pTarget->GetPos();
		mAfterAction.mRange = range;
		mAfterAction.mExData1 = attackIdx;

		/// Ÿ ġ ̵  ( ġüũ    processAfterAction ±. )
		if( ResetActionMovePath( pTarget->GetXPos(), pTarget->GetYPos(), range ) == false )
		{
			mAfterAction.mActionType = eAfterAction_None;
		}
	}

	SKILLEXECUTER->ChargeOff( attackIdx );
}

void cHero::AfterUseSkill( cBaseObject* pTarget )
{
	if( GatheringCancel() == false )
		return;

	unsigned long skillIdx = SKILLEXECUTER->GetChargeSkill();
	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 || pInfo->mBoundType == eBOUNDTYPE_FIELD )
	{
		assert(0);
		SKILLEXECUTER->ChargeOff( skillIdx );
		return;
	}

	if( pInfo->mBoundType == eBOUNDTYPE_SELF_NOTARGET )
	{
		///   ų 
		if( IsReadyUseSkill() )
		{
			UseTargetSkill( skillIdx, 0 );
		}
		else
		{
			SKILLEXECUTER->ChargeOff( skillIdx );
			mWaitSkillIdx = skillIdx;
		}

		return;
	}

	float range = SKILLEXECUTER->GetChargeSkillRange();
	NiPoint3 targetPos = pTarget->GetPos();
	NiPoint3 heroPos = GetPos();

	float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, range );
	cRangeCheck rangecheck( tempRange );
	if( rangecheck.IsRange( heroPos, targetPos ) )
	{
		/// 
		if( IsReadyUseSkill() )
		{
			UseTargetSkill( skillIdx, pTarget );
			return;
		}
		else
		{
			mWaitSkillIdx = skillIdx;
		}
	}
	else
	{
		if( IsReadyUseSkill() )
		{
			/// ó Ѵ.
			mAfterAction.mActionType = eAfterAction_UseTargetSkill;
			mAfterAction.mTarget.index = pTarget->GetObjectID();
			mAfterAction.mTarget.type = pTarget->GetObjectType();
			mAfterAction.mDestPos = pTarget->GetPos();
			mAfterAction.mRange = range;
			mAfterAction.mExData1 = skillIdx;

			/// Ÿ ġ ̵  ( ġüũ    processAfterAction ±. )
			
			if( ResetActionMovePath( pTarget->GetXPos(), pTarget->GetYPos(), range ) == false )
			{
				mAfterAction.mActionType = eAfterAction_None;
			}
		}
		else
		{
			mWaitSkillIdx = skillIdx;
		}
	}

	SKILLEXECUTER->ChargeOff( skillIdx );
}

void cHero::AfterUseSkill( NiPoint3 fieldPos )
{
	if( GatheringCancel() == false )
		return;

	unsigned long skillIdx = SKILLEXECUTER->GetChargeSkill();
	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 || pInfo->mBoundType != eBOUNDTYPE_FIELD )
	{
		assert(0);
		return;
	}

	float range = SKILLEXECUTER->GetChargeSkillRange();
	NiPoint3 heroPos = GetPos();

	cRangeCheck rangecheck( range );
	if( rangecheck.IsRange( heroPos, fieldPos ) )
	{
		/// 
		if( IsReadyUseSkill() )
		{
			UseFieldSkill( skillIdx, fieldPos );
			return;
		}
	}
/*
	else
	{
//		if( IsReadyUseSkill() )
//		{
			/// ó Ѵ.
			mAfterAction.mActionType = eAfterAction_UseFieldSkill;
			mAfterAction.mTarget.index = 0;
			mAfterAction.mTarget.type = eOBJECTTYPE_NONE;
			mAfterAction.mDestPos = fieldPos;
			mAfterAction.mRange = range;
			mAfterAction.mExData1 = skillIdx;

			/// Ÿ ġ ̵  ( ġüũ    processAfterAction ±. )
			if( ResetActionMovePath( fieldPos.x, fieldPos.y, range ) == false )
				mAfterAction.mActionType = eAfterAction_None;
//		}
	}
*/
	SKILLEXECUTER->ChargeOff( skillIdx );
}

void cHero::AfterItemPick( unsigned long idx, float destX, float destY )
{
#ifdef _GMTOOL
	if( CHEATMAN->GetHideMode() )
		return;
#endif

	if( GatheringCancel() == false )
		return;

	/// float range = 20;	20...?
	float range = ITEM_VALID_DISTANCE;

	NiPoint3 targetPos = NiPoint3(destX, destY, 0.0f);

	NiPoint3 heroPos = GetPos();
	heroPos.z = 0.0f;

	cRangeCheck rangecheck( range );
	if( rangecheck.IsRange( heroPos, targetPos ) )
	{
		///  ݱ 
		GAMEUI->HideLootingWindow();

		if( ITEMMAN->IsLocked() == true )
			return;

		///    ð üũ
		if( ITEMMAN->CheckOpenTime() == false )
			return;

		MSG_REQ_ITEM_GET_OPEN msg;
		msg.Category = NM_ITEM;
		msg.Protocol = NM_ITEM_GET_OPEN_REQ;
		msg.idx = idx;

		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		///  ɱ
		ITEMMAN->LockItemTry( ITEM_TRY_PICK );

		/// ٶ  
		NiPoint3 charDir = mDesiredDir;
		NiPoint3 viewDir = targetPos - heroPos;
		viewDir.z = 0.0f;
		if( viewDir != NiPoint3::ZERO )
		{
			if( viewDir.SqrLength() >= 0.001f )	
			{
				viewDir.Unitize();

				/// ȸ Matrix 
				NiMatrix3 matA, matB, matRot;
				matA.SetCol( 0, charDir );
				matA.SetCol( 1, -NiPoint3::UNIT_Z );
				matA.SetCol( 2, charDir.UnitCross( -NiPoint3::UNIT_Z ) );

				matB.SetCol( 0, viewDir );
				matB.SetCol( 1, -NiPoint3::UNIT_Z );
				matB.SetCol( 2, viewDir.UnitCross( -NiPoint3::UNIT_Z ) );

				matRot = matB * matA.Transpose();
				mpObjectSceneNode->SetRotate( mpObjectSceneNode->GetRotate()*matRot );
				mDesiredDir = viewDir;
			}
		}

		SetState( ePLAYER_STATE_ITEMPICK );
		return;
	}

	mAfterAction.mActionType = eAfterAction_ItemPick;
	mAfterAction.mExData1 = idx;
	mAfterAction.mDestPos = NiPoint3( destX, destY, 0.0f );
	mAfterAction.mRange = ITEM_VALID_DISTANCE;
	mAfterAction.mTarget.index = 0;
	mAfterAction.mTarget.type = eOBJECTTYPE_NONE;

	if( ResetActionMovePath( destX, destY, mAfterAction.mRange ) == false )
		mAfterAction.mActionType = eAfterAction_None;
}

void cHero::AfterGatheringPick( unsigned long idx, unsigned long classIdx, float destX, float destY )
{
#ifdef _GMTOOL
	if( CHEATMAN->GetHideMode() )
		return;
#endif

	float range = ITEM_VALID_DISTANCE;
	NiPoint3 targetPos = NiPoint3(destX, destY, 0.0f);
	NiPoint3 heroPos = GetPos();
	heroPos.z = 0.0f;

	cRangeCheck rangecheck( range );
	if( rangecheck.IsRange( heroPos, targetPos ) )
	{
		GatheringStart( idx, classIdx, targetPos );
		return;
	}

	mAfterAction.mActionType = eAfterAction_GatheringPick;
	mAfterAction.mExData1 = idx;
	mAfterAction.mExData2 = classIdx;
	mAfterAction.mDestPos = NiPoint3( destX, destY, 0.0f );
	mAfterAction.mRange = range;
	mAfterAction.mTarget.index = 0;
	mAfterAction.mTarget.type = eOBJECTTYPE_NONE;

	if( ResetActionMovePath( destX, destY, mAfterAction.mRange ) == false )
		mAfterAction.mActionType = eAfterAction_None;
}

void cHero::AfterNpcTalk( unsigned long npcIdx )
{
	AfterNpcTalk( OBJECTMAN->GetNpc(npcIdx) );
}

void cHero::AfterNpcTalk( cNpc* pNpc )
{
	if( GatheringCancel() == false )
		return;

	if( pNpc == 0 )
		return;

	if( DUELMAN->IsDuelEnable() )
		return;
	if( GetState() == eOBJECT_STATE_DIE )
		return;

	float range = NPC_VALID_DISTANCE;
	NiPoint3 targetPos = pNpc->GetPos();
	targetPos.z = 0.0f;

	NiPoint3 heroPos = GetPos();
	heroPos.z = 0.0f;

	float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pNpc, range );

	cRangeCheck rangecheck( tempRange );
	if( rangecheck.IsRange( heroPos, targetPos ) )
	{
		MSG_REQ_NPC_OPEN Msg;
		Msg.Category = NM_NPC;
		Msg.Protocol = NM_NPC_OPEN_REQ;
		Msg.mNpcIdx = pNpc->GetObjectID();
		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

		SetState( eOBJECT_STATE_IDLE );

		return;
	}

	mAfterAction.mActionType = eAfterAction_NpcTalk;
	mAfterAction.mTarget.type = eOBJECTTYPE_NPC;
	mAfterAction.mTarget.index = pNpc->GetObjectID();
	mAfterAction.mDestPos = pNpc->GetPos();
	mAfterAction.mRange = NPC_VALID_DISTANCE;

	/// npcġ ̵  ( ġüũ    processAfterAction ±. )
	if( ResetActionMovePath( pNpc->GetXPos(), pNpc->GetYPos(), mAfterAction.mRange ) == false )
		mAfterAction.mActionType = eAfterAction_None;
}

///
void cHero::AfterUseTarotStore( cPlayer* pPlayer )
{
	if( GatheringCancel() == false )
		return;

	if( pPlayer == 0 )
		return;

	mAfterAction.mActionType = eAfterAction_UseTarotStore;
	mAfterAction.mTarget.type = eOBJECTTYPE_PLAYER;
	mAfterAction.mTarget.index = pPlayer->GetObjectID();
	mAfterAction.mDestPos = pPlayer->GetPos();
	mAfterAction.mRange = 100.0f;

	if( ResetActionMovePath( pPlayer->GetXPos(), pPlayer->GetYPos(), mAfterAction.mRange ) == false )
		mAfterAction.mActionType = eAfterAction_None;
}

void cHero::AfterUseStall( cPlayer* pPlayer )
{
	if( GatheringCancel() == false )
		return;

	if( pPlayer == 0 )
		return;

	mAfterAction.mActionType = eAfterAction_UseStall;
	mAfterAction.mTarget.type = eOBJECTTYPE_PLAYER;
	mAfterAction.mTarget.index = pPlayer->GetObjectID();
	mAfterAction.mDestPos = pPlayer->GetPos();
	mAfterAction.mRange = 100.0f;

	if( ResetActionMovePath( pPlayer->GetXPos(), pPlayer->GetYPos(), mAfterAction.mRange ) == false )
		mAfterAction.mActionType = eAfterAction_None;
}

void cHero::AfterMapChange( unsigned long scriptIdx )
{
	if( GatheringCancel() == false )
		return;

	sStageChangePos* pInfo = STAGESCRIPT->GetPosScriptInfo( scriptIdx );
	if( pInfo == 0 )
	{
		/// ̵  ޼ 
		return;
	}

	NiPoint3 portalPos;
	portalPos.x = pInfo->mPosX;
	portalPos.y = pInfo->mPosY; 
	portalPos.z = 0.0f; 

	float range = pInfo->mRange;

	NiPoint3 heroPos = GetPos();
	heroPos.z = 0.0f;

	cRangeCheck rangecheck( range );
	if( rangecheck.IsRange( heroPos, portalPos ) )
	{
		sStageChangePos* pInfo = STAGESCRIPT->GetPosScriptInfo( (unsigned long)scriptIdx );
		assert(pInfo);
		if( pInfo && pInfo->mTargetInfo )
		{
			TCHAR str[256] = {0,};
			_stprintf(str,GAMERESOURCEMAN->GetGameText( 60 ), GAMERESOURCEMAN->GetMapName(pInfo->mTargetInfo->mMapNumber) );

			GAMEUI->ShowGameUI();

			///
			UIMAN->CreateModal( eStage_Game, eMBEVENT_MAPCHANGE, str, GAMERESOURCEMAN->GetGameText( 59 ), eSKIN_YESNO, (void*)scriptIdx );
		}
		return;
	}

	mAfterAction.mActionType = eAfterAction_MapChange;
	mAfterAction.mExData1 = scriptIdx;
	mAfterAction.mDestPos = portalPos;
	mAfterAction.mRange = range;
	mAfterAction.mTarget.index = 0;
	mAfterAction.mTarget.type = eOBJECTTYPE_NONE;

	if( ResetActionMovePath( portalPos.x, portalPos.y, mAfterAction.mRange ) == false )
		mAfterAction.mActionType = eAfterAction_None;
}

void cHero::SetStatus1( ePLAYER_STATUS statusBase, float value )
{
	if( statusBase >= ePLAYER_STATUS_LEVEL )
	{
		assert(NULL);
		return;
	}

	switch( statusBase )
	{
	case ePLAYER_STATUS_STR:
		mStatus1.mStr = value; break;
	case ePLAYER_STATUS_DEX:
		mStatus1.mDex = value; break;
	case ePLAYER_STATUS_CON:
		mStatus1.mCon = value; break;
	case ePLAYER_STATUS_INT:
		mStatus1.mInt = value; break;
	case ePLAYER_STATUS_WIS:
		mStatus1.mWis = value; break;
	}
}

/// 070116 PKH ⺻  ߰ ġ 
void cHero::SetStatus1Plus( ePLAYER_STATUS statusBasePlus, float value )
{
	if( statusBasePlus >= ePLAYER_STATUS_LEVEL )
	{
		assert(NULL);
		return;
	}

	switch( statusBasePlus )
	{
	case ePLAYER_STATUS_STR:
		mStatus1Plus.mStr = value; break;
	case ePLAYER_STATUS_DEX:
		mStatus1Plus.mDex = value; break;
	case ePLAYER_STATUS_CON:
		mStatus1Plus.mCon = value; break;
	case ePLAYER_STATUS_INT:
		mStatus1Plus.mInt = value; break;
	case ePLAYER_STATUS_WIS:
		mStatus1Plus.mWis = value; break;
	}
}

void cHero::SetStatus2( ePLAYER_STATUS_EXT extStatus, float value )
{
	if( extStatus >= ePLAYER_STATUS_EXT2_MAX )
	{
		assert(NULL);
		return;
	}

	switch( extStatus )
	{
	case ePLAYER_STATUS_EXT_ATK:
		break;	/// ּ ִ  
	case ePLAYER_STATUS_EXT_RATK:
		break;	/// ּ ִ  
	case ePLAYER_STATUS_EXT_DEF:
		mStatus2.mPhysicDefense = value; break;
	case ePLAYER_STATUS_EXT_MATK:
		break;	/// ּ ִ  
	case ePLAYER_STATUS_EXT_MDEF:
		mStatus2.mMagicDefense = value; break;
	case ePLAYER_STATUS_EXT_CRI:
		mStatus2.mPhysicCritical = value; break;
	case ePLAYER_STATUS_EXT_MCRI:
		mStatus2.mMagicCritical = value; break;
	case ePLAYER_STATUS_EXT_MAXHP:
		{
			mStatus2.mMaxHP = value;

			if( mPlayerExrInfo.RestHP > (unsigned long)mStatus2.mMaxHP )
				mPlayerExrInfo.RestHP = (unsigned long)mStatus2.mMaxHP;
		}
		break;
	case ePLAYER_STATUS_EXT_MAXMP:
		{
			mStatus2.mMaxMP = value;

			if( mPlayerExrInfo.RestMP > (unsigned long)mStatus2.mMaxMP )
				mPlayerExrInfo.RestMP = (unsigned long)mStatus2.mMaxMP;
		}
		break;
	case ePLAYER_STATUS_EXT_RECOVHP:
		mStatus2.mRecovHP = value; break;
	case ePLAYER_STATUS_EXT_RECOVMP:
		mStatus2.mRecovMP = value; break;
	case ePLAYER_STATUS_EXT_HIT:
		mStatus2.mPhysicAttackRate = value; break;
	case ePLAYER_STATUS_EXT_MHIT:
		mStatus2.mMagicAttackRate = value; break;
	case ePLAYER_STATUS_EXT_AVOID:
		mStatus2.mAvoid = value; break;
	case ePLAYER_STATUS_EXT_WEIGHT:
		mStatus2.mMaxWeight = value; break;
	case ePLAYER_STATUS_EXT_ASPD:
		mStatus2.mAttackSpeed = (float)value; break;
	case ePLAYER_STATUS_EXT_COOLTIME:
		mStatus2.mCooltime = (float)value; break;
	case ePLAYER_STATUS_EXT_RANGE:
		mStatus2.mInRange = value; break;
	case ePLAYER_STATUS_EXT_RRANGE:
		mStatus2.mOutRange = value; break;
	case ePLAYER_STATUS_EXT_SPD:
		mStatus2.mMoveSpeed = value; break;

	case ePLAYER_STATUS_EXT_ATKMin:
		mStatus2.mPhysicMinAttack = value; break;
	case ePLAYER_STATUS_EXT_ATKMax:
		mStatus2.mPhysicMaxAttack = value; break;
	case ePLAYER_STATUS_EXT_RATKMin:
		mStatus2.mPhysicMinRangeAttack = value; break;
	case ePLAYER_STATUS_EXT_RATKMax:
		mStatus2.mPhysicMaxRangeAttack = value; break;
	case ePLAYER_STATUS_EXT_MATKMin:
		mStatus2.mMagicMinAttack = value; break;
	case ePLAYER_STATUS_EXT_MATKMax:
		mStatus2.mMagicMaxAttack = value; break;
	case ePLAYER_STATUS_EXT_HEALMin:
		mStatus2.mMinHeal = value; break;
	case ePLAYER_STATUS_EXT_HEALMax:
		mStatus2.mMaxHeal = value; break;
	}
}


void cHero::SetStatusEtc( ePLAYER_STATUS_EXT_ADD statusAdd, float value  )
{
	if( statusAdd >= ePLAYER_STATUS_EXT_ADD_MAX )
	{
		assert(NULL);
		return;
	}

	switch( statusAdd )
	{
	case ePLAYER_STATUS_EXT_ADD_EXPADDPER:
		mStatusEtc.mExpAddPer = value; break;
	case ePLAYER_STATUS_EXT_ADD_EXPADDPLUS:
		mStatusEtc.mExpAddPlus = value; break;
	case ePLAYER_STATUS_EXT_ADD_SXPADDPER:
		mStatusEtc.mSxpAddPer = value; break;
	case ePLAYER_STATUS_EXT_ADD_SXPADDPLUS:
		mStatusEtc.mSxpAddPlus = value; break;
	}
}


float cHero::CalcStatusSkillRange( float skillRange, eRANGETYPE mRangeType, bool itemPlus )
{

	if( mRangeType == 0 )
		return skillRange;

	/// ų Ÿ
	float range = skillRange;

	/// ȿ Ÿ
	float statusRangePlus = 0;
	float statusRangePer = 0;

	if( mRangeType == eRANGETYPE_CLOSE )
	{
		statusRangePlus = STATUSCALC->GetStatus2Plus( ePLAYER_STATUS_EXT_RANGE );
		statusRangePer = STATUSCALC->GetStatus2Per( ePLAYER_STATUS_EXT_RANGE );
	}
	else if( mRangeType == eRANGETYPE_LONG )
	{
		statusRangePlus = STATUSCALC->GetStatus2Plus( ePLAYER_STATUS_EXT_RRANGE );
		statusRangePer = STATUSCALC->GetStatus2Per( ePLAYER_STATUS_EXT_RRANGE );
	}
	else
		assert(NULL);

	sEquipAbility* pBasicAbility = ITEMMAN->GetBasicAbil();

	/// Ÿ 
	if( itemPlus == true )
	{
		range = ( range + pBasicAbility->mAttackRange ) * ( ( 100 + statusRangePer ) / 100 ) + statusRangePlus;
	}
	else
		range = range * ( ( 100 + statusRangePer ) / 100 ) + statusRangePlus;

	return range;
}


void cHero::InitStatusInfoType() 
{
	for( int i = ePLAYER_STATUS_STR ; ePLAYER_STATUS_LEVEL > i ; ++i )
	{
		mStatusBaseInfoType[i] = 0; 
	}
	for( int i = ePLAYER_STATUS_EXT_ATK ; ePLAYER_STATUS_EXT_MAX > i ; ++i )
	{
		mStatusExtInfoType[i] = 0; 
	}
}

void cHero::IdleUpdate( unsigned long deltaTime )
{
	mIdleTime += deltaTime;
	if( mIdleTime >= 18000 )
	{
		mIdleTime = 0;

		if( mPlayerExrInfo.mChgMonsterIdx == 0 )
		{
			/// idle2 animation
			if( mPlayerExrInfo.mStateIdle == eIDLE_PEACE )
				ChangeAnimation( ANITYPE_PEACE_IDLE2 );
			else
			{
				ChangeAnimation( ANITYPE_IDLE2 );
			}
		}
		else
		{
			ChangeAnimation_TransMon( M_ANITYPE_IDLE2 );
		}
	}
}

void cHero::MoveUpdate( unsigned long deltaTime )
{
	if( mPathCount == 0 )
		return;

	///  ǥ ȹ
	NiPoint3 pos = mpObjectSceneNode->GetWorldTranslate();

	/// ̰ ĳͺ  Ǵ ̴.
	long speed = GetMoveSpeed();

	///  ؼ   Ÿ Ѵ.
	NiPoint2 dir1, dir2;
	dir1.x = mGotoX - pos.x;
	dir1.y = mGotoY - pos.y;
	dir1.Unitize();

	/// ӵ * ð ŭ Ÿ 
	pos.x += dir1.x * speed * (deltaTime * 0.001f);
	pos.y += dir1.y * speed * (deltaTime * 0.001f);
	pos.z = 0.0f;

	///  ؼ  ġ Ÿ Ѵ.
	dir2.x = mGotoX - pos.x;
	dir2.y = mGotoY - pos.y;
	dir2.Unitize();

	bool nextPath = false;
	if( dir2.Dot(dir1) <= 0.0f )
	{
		/// ̵ deltaTime Ŭ()  Ѿ  
		///  if    ġ ϸ ÷̽ ߻
		if( deltaTime > 500 )
		{
			pos.x = mGotoX;
			pos.y = mGotoY;
		}

		if( mPathIndex < mPathCount-1 )
		{
			nextPath = true;
		}
		else
		{
			mPathCount = 0;
			SetState( eOBJECT_STATE_IDLE );
		}
	}

	if( WORLDMAN->CalcHeight( &pos.z, pos.x, pos.y ) )
	{
		SetPos( pos );
	}
	else
	{
		assert(0);
		return;
	}

	if( nextPath == true )
	{
		NiPoint2& nextPos = mPathArray[++mPathIndex];
		Move( nextPos.x, nextPos.y );
/*
		NiPoint2& nextPos = mPathArray[++mPathIndex];
		if( mPathFinder->IsPossible( NiPoint2(GetXPos(), GetYPos()), nextPos ) == false )
		{
			NiPoint2 start = NiPoint2( GetXPos(), GetYPos() );
			NiPoint2 goal = NiPoint2(mTargetPos.x, mTargetPos.y);

			mPathIndex = 0;
			if( mPathFinder->FindPath( mPathArray, &mPathCount, MAX_PATH_COUNT, start, goal ) == false )
			{
				assert(0);
				return;
			}

			Move( mPathArray[0].x, mPathArray[0].y );
		}
		else
		{
			Move( nextPos.x, nextPos.y );
		}
*/
	}

	/// ̵ ó  Ǿٸ óѴ.
	/// ο Ÿ񱳿  ǥ  Ѵ.
	ProcessAfterAction( pos );
}

void cHero::AttackUpdate( unsigned long deltaTime, unsigned long /*accumTime*/ )
{
	/// ų  Ϸ...
	if( IsReadyUseSkill() == false )
		return;

	///  ü  - ü
	if( mWaitWeaponSwitch )
	{
		if( mSwitchWeaponFlag == false )
		{
			if( ITEMMAN->TryToSwitchWeapon() )
				HERO->SetWeaponChangeFlag( true );
		}
		mWaitWeaponSwitch = false;

		if( mWaitMove == false )
			return;
	}

	/// ̵  
	if( mWaitMove )
	{
		if( mAfterAction.mActionType == eAfterAction_None )
			ResetMovePath( mWaitMovePos.x, mWaitMovePos.y );
		else
		{
			if( ResetActionMovePath( mWaitMovePos.x, mWaitMovePos.y, mAfterAction.mRange ) == false )
				mAfterAction.mActionType = eAfterAction_None;
		}

		mWaitMove = false;
		return;
	}


	/// test
	if( SKILLEXECUTER->IsSkillCharge() == true )
	{
		if( IsTransformMonster() == true )
			ChangeAnimation_TransMon( M_ANITYPE_IDLE1 );
		else
			ChangeAnimation( ANITYPE_IDLE );
		return;
	}

	/// ų  
	/// ⺻  ( or ... ڵ ڵ )
	if( IsTransformMonster() == true )
	{
		if( mWaitSkillIdx < eMONSTERATTACK_SKILL1 )
		{
			/// ڵݿ  ʵ ּ ̸ ִ° ..
			if( SKILLEXECUTER->AutoAttack( GetTargetObject() ) == false ) 
				SetState( eOBJECT_STATE_IDLE );
		}
		else
		{
			/// ų   cool time check
			if( SKILLMAN->IsUsedMonsterSkill( mWaitSkillIdx ) == false )
			{
				mWaitSkillIdx = 0;
				return;
			}

			SKILLEXECUTER->ExecuteSkill( mWaitSkillIdx );
			mWaitSkillIdx = 0;
		}
	}
	else
	{
		if( mWaitSkillIdx < NORMAL_ATTACK_SKILL_MAX )
		{
			/// ų   cool time check
			if( SKILLMAN->IsUsedKeepSkill( NORMAL_ATTACK_SKILL ) == false )
				return;

			/// ڵݿ  ʵ ּ ̸ ִ° ..
			if( SKILLEXECUTER->AutoAttack( GetTargetObject() ) == false ) 
				SetState( eOBJECT_STATE_IDLE );
		}
		else
		{
			/// ų   cool time check
			if( SKILLMAN->IsUsedKeepSkill( mWaitSkillIdx ) == false )
			{
				mWaitSkillIdx = 0;
				return;
			}

			SKILLEXECUTER->ExecuteSkill( mWaitSkillIdx );
			mWaitSkillIdx = 0;
		}
	}
}


void cHero::Update( unsigned long deltaTime, unsigned long accumTime )
{
	if( mpObjectSceneNode  == NULL ) 
		return;

	if( mPlayerExrInfo.mChgMonsterIdx != 0 )
	{
		if( IsReadyUseSkill() )
		{
			if( mReadyRestoreMonster )
			{
				RestoreMonster();
				ChangeAnimation( ANITYPE_IDLE );
//				return;
			}
			else
				return Update_TransMon( deltaTime, accumTime );
		}
		else
			return Update_TransMon( deltaTime, accumTime );
	}

	ProcessDelayFlag( deltaTime );

	DesiredDirProcess( deltaTime );

	FaceProcess( deltaTime );

	///  Ʈ ɶ 
	if( mIsCalcStatus )
	{
		NowCalcStatus();
	}
	/// ųġ ġ Ʈɶ 
	else if( mIsUdateHeroInfo )
	{
		GAMEUI->UpdateExpSxp();

		mIsUdateHeroInfo = false;
	}


	/// ¿ ´ ó Ѵ.
	switch( mPlayerExrInfo.mState )
	{
	case eOBJECT_STATE_IDLE:
		{
			IdleUpdate( deltaTime );
		}
		break;
	case eOBJECT_STATE_MOVE:
		{
			MoveUpdate( deltaTime );
		}
		break;
	case eOBJECT_STATE_ATTACK:
		{
			AttackUpdate( deltaTime, accumTime );
		}
		break;
	case eOBJECT_STATE_DIE:
		{
			DieUpdate();
		}
		break;
	case ePLAYER_STATE_SITDOWN:
		{
			SitDownUpdate();
		}
		break;
	}


	/// ִϸ̼ ῡ  ó
	Interpret( accumTime );

	/// ī޶ ó
	cLookAtCamera* pCamera = (cLookAtCamera*)CAMERAMAN->GetCurrent();
	if( pCamera )
	{
		const NiPoint3& pos = mpObjectSceneNode->GetTranslate();
		pCamera->SetLookAt( pos.x, pos.y, pos.z + mCameraOffset );
	}

	///
	WORLDMAN->MoveSkyDome( pCamera->GetWorldTranslate() );
}

void cHero::ProcessAfterAction( NiPoint3& heroPos )
{
	if( mAfterAction.mActionType == eAfterAction_None )
		return;

	cBaseObject* pTarget = OBJECTMAN->GetObject( &mAfterAction.mTarget );
	NiPoint3 targetPos = mTargetPos;
	if( pTarget )
		targetPos = pTarget->GetPos();
	else
	{
		if( WORLDMAN->CalcHeight( &targetPos.z, targetPos.x, targetPos.y ) == false )
			assert(NULL);
	}

	NiPoint3 heroNotZPos = heroPos;
	heroNotZPos.z = 0.0f;
	NiPoint3 targetNotZPos = targetPos;
	targetNotZPos.z = 0.0f;

	///  ˻ ⺻..
	switch( mAfterAction.mActionType )
	{
	case eAfterAction_Attack:
		{	
			bool bAttack = false;
			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, mAfterAction.mRange );

			cRangeCheck rangecheck( tempRange );
			///     츦 ã´.
			NiPoint3 curPos = HERO->GetPos();
			if( rangecheck.IsRange( curPos, targetPos ) )
			{
				/// ̹     .
				heroPos.x = curPos.x;
				heroPos.y = curPos.y;

				bAttack = true;
			}
			else
			{
				/// ̵ ǥ  ˻縦 Ѵ.
				if( rangecheck.IsRange( heroPos, targetPos ) )
				{
					NiPoint3 dir = heroPos - targetPos;
					if( dir.Unitize() != 0 )
					{
						/// heroPos 
						heroPos.x = targetPos.x + ((tempRange-1.0f)*dir.x);
						heroPos.y = targetPos.y + ((tempRange-1.0f)*dir.y);
					}

					bAttack = true;
				}
			}

			if( bAttack == true )
			{
				///  ó
				if( IsReadyUseSkill() )
				{
					/// ó 
					StopAfterAction();
					if( StartAttack( mAfterAction.mExData1, OBJECTMAN->GetObject( &mAfterAction.mTarget ) ) == false )
					{
						///   
						SetState( eOBJECT_STATE_ATTACK );
						SetReadyUseSkill( true );
					}
				}
				else
				{
					/// ó  ,   
					mAfterAction.mActionType = eAfterAction_None;
					SetState( eOBJECT_STATE_ATTACK );
					SetReadyUseSkill( true );
				}
				return;
			}
		}
		break;
	case eAfterAction_UseTargetSkill:
		{
			bool bAttack = false;
			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, mAfterAction.mRange );

			cRangeCheck rangecheck( tempRange );

			///     츦 ã´.
			NiPoint3 curPos = HERO->GetPos();
			if( rangecheck.IsRange( curPos, targetPos ) )
			{
				/// ̹     .
				heroPos.x = curPos.x;
				heroPos.y = curPos.y;

				bAttack = true;
			}
			else
			{
				/// ̵ ǥ  ˻縦 Ѵ.
				if( rangecheck.IsRange( heroPos, targetPos ) )
				{
					NiPoint3 dir = heroPos - targetPos;
					if( dir.Unitize() != 0 )
					{
						/// heroPos 
						heroPos.x = targetPos.x + ((tempRange-1.0f)*dir.x);
						heroPos.y = targetPos.y + ((tempRange-1.0f)*dir.y);
					}

					bAttack = true;
				}
			}

			if( bAttack == true )
			{
				/// ó 
				StopAfterAction();

				///  
				if( IsReadyUseSkill() )
				{
					UseTargetSkill( mAfterAction.mExData1, OBJECTMAN->GetObject(&mAfterAction.mTarget) );
				}

				mWaitSkillIdx = 0;
				return;
			}
		}
		break;
	case eAfterAction_UseFieldSkill:
		{
			bool bAttack = false;
			cRangeCheck rangecheck( mAfterAction.mRange );

			///     츦 ã´.
			NiPoint3 curPos = HERO->GetPos();
			if( rangecheck.IsRange( curPos, mAfterAction.mDestPos ) )
			{
				/// ̹     .
				heroPos.x = curPos.x;
				heroPos.y = curPos.y;

				bAttack = true;
			}
			else
			{
				/// ̵ ǥ  ˻縦 Ѵ.
				if( rangecheck.IsRange( heroPos, mAfterAction.mDestPos ) )
				{
					NiPoint3 dir = heroPos - mAfterAction.mDestPos;
					if( dir.Unitize() != 0 )
					{
						/// heroPos 
						heroPos.x = mAfterAction.mDestPos.x + ((mAfterAction.mRange-1.0f)*dir.x);
						heroPos.y = mAfterAction.mDestPos.y + ((mAfterAction.mRange-1.0f)*dir.y);
					}

					bAttack = true;
				}
			}

			if( bAttack == true )
			{
				/// ó 
				StopAfterAction();

				///  
				UseFieldSkill( mAfterAction.mExData1, mAfterAction.mDestPos );

				mWaitSkillIdx = 0;
				return;
			}
		}
		break;
	case eAfterAction_ItemPick:
		{
#ifdef _GMTOOL
			if( CHEATMAN->GetHideMode() )
				return;
#endif

			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, 0, mAfterAction.mRange );

			cRangeCheck rangecheck( tempRange );

			if( rangecheck.IsRange( heroNotZPos, mAfterAction.mDestPos ) )
			{
				StopAfterAction();

				if( IsRideVehicle() == true )
				{
					MSGROOT msg;
					::memset( &msg, 0, sizeof(msg) );
					msg.Category = NM_PLAYER;
					msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

					AlightVehicle();
				}

				///  ݱ 
				GAMEUI->HideLootingWindow();

				if( ITEMMAN->IsLocked() == true )
					return;

				///    ð üũ
				if( ITEMMAN->CheckOpenTime() == false )
					return;

				MSG_REQ_ITEM_GET_OPEN msg;
				msg.Category = NM_ITEM;
				msg.Protocol = NM_ITEM_GET_OPEN_REQ;
				msg.idx = mAfterAction.mExData1;

				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				SetState( ePLAYER_STATE_ITEMPICK );

				///  ɱ
				ITEMMAN->LockItemTry( ITEM_TRY_PICK );
			}

			return;
		}
		break;
	case eAfterAction_GatheringPick:
		{
#ifdef _GMTOOL
			if( CHEATMAN->GetHideMode() )
				return;
#endif
			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, 0, mAfterAction.mRange );

			cRangeCheck rangecheck( tempRange );
			if( rangecheck.IsRange( heroNotZPos, mAfterAction.mDestPos ) )
			{
				StopAfterAction();
				GatheringStart( mAfterAction.mExData1, mAfterAction.mExData2, mAfterAction.mDestPos );
			}
			return;
		}
		break;
	case eAfterAction_NpcTalk:
		{
			assert(mAfterAction.mTarget.type == eOBJECTTYPE_NPC);

			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, mAfterAction.mRange );

			cRangeCheck rangecheck( tempRange );

			if( rangecheck.IsRange( heroNotZPos, targetNotZPos ) )
			{
				StopAfterAction();

				MSG_REQ_NPC_OPEN Msg;
				Msg.Category = NM_NPC;
				Msg.Protocol = NM_NPC_OPEN_REQ;
				Msg.mNpcIdx = pTarget->GetObjectID();
				NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
			}

			return;
		}
		break;
	case eAfterAction_UseTarotStore:
		{
			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, mAfterAction.mRange );

			cRangeCheck rangecheck( tempRange );

			if( mAfterAction.mTarget.type != eOBJECTTYPE_PLAYER )
			{
				assert(0);
				StopAfterAction();
				return;
			}

			if( pTarget == 0 || pTarget->GetObjectType() != eOBJECTTYPE_PLAYER )
			{
				assert(0);
				StopAfterAction();
				return;
			}

			if( rangecheck.IsRange( heroNotZPos, targetNotZPos ) )
			{
				StopAfterAction();

				/// ŸԻ  û
				MSG_REQ_TAROT_SEEKER_OPEN msg;				// MSG_REQ_TAROT_SEEKER_JOIN msg;
				msg.Category = NM_TAROT;
				msg.Protocol = NM_TAROT_SEEKER_OPEN_REQ;	// NM_TAROT_SEEKER_JOIN_REQ
				msg.CharacterIdx = pTarget->GetObjectID();
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
			}
			return;
		}
		break;
	case eAfterAction_UseStall:
		{
			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, mAfterAction.mRange );

			cRangeCheck ranceCheck( tempRange );

			if( mAfterAction.mTarget.type != eOBJECTTYPE_PLAYER )
			{
				assert(0);
				StopAfterAction();
				return;
			}

			if( pTarget == 0 || pTarget->GetObjectType() != eOBJECTTYPE_PLAYER )
			{
				assert(0);
				StopAfterAction();
				return;
			}

			if( ranceCheck.IsRange( heroNotZPos, targetNotZPos ) )
			{
				StopAfterAction();

				///   û
				ITEMMAN->TryToUserSellJoin( mAfterAction.mTarget );
			}
		}
		break;
	case eAfterAction_MapChange:
		{
			float tempRange = OBJECTMANAGER->ObjectSizeRange( this, pTarget, mAfterAction.mRange );

			cRangeCheck rangecheck( tempRange );

			if( rangecheck.IsRange( heroNotZPos, mAfterAction.mDestPos ) )
			{
				StopAfterAction();

				sStageChangePos* pInfo = STAGESCRIPT->GetPosScriptInfo( (unsigned long)mAfterAction.mExData1 );
				assert(pInfo);
				if( pInfo && pInfo->mTargetInfo )
				{
					TCHAR str[256] = {0,};
					_stprintf(str,GAMERESOURCEMAN->GetGameText( 60 ), GAMERESOURCEMAN->GetMapName(pInfo->mTargetInfo->mMapNumber) );

					GAMEUI->ShowGameUI();

					///
					UIMAN->CreateModal( eStage_Game, eMBEVENT_MAPCHANGE, str, GAMERESOURCEMAN->GetGameText( 59 ), eSKIN_YESNO, (void*)mAfterAction.mExData1 );
				}
			}
			return;
		}
		break;
	default:
		return;
	}

	if( mAfterAction.mActionType == eAfterAction_MapChange )
		return;

	/// Ÿ ǥ ϴ  ȭ  Ÿǥ 缳
	if( pTarget )
	{
		if( mTargetPos != targetNotZPos )
		{
			float range = (heroNotZPos - mTargetPos).Length() * 0.10f;
			if( range < 100.0f )
				range = 100.0f;

			cRangeCheck r( range );
			if( r.IsRange( targetNotZPos, mTargetPos ) == false )
			{
				///  ȭ ̻ Ÿ ٸ..
				/// ü  ̵ǥ ٲ۴.
				if( ResetActionMovePath( targetNotZPos.x, targetNotZPos.y, mAfterAction.mRange ) == false )
				{
					assert(0);
				}
			}
		}
	}
}

bool cHero::Move( float x, float y )
{
	if( x < 0 || y < 0 )
	{
		assert(0);
		return false;
	}

	/// ̵.ȸ -  
	if( !cPlayer::Move( x, y ) )
	{
		return false;
	}

	/// Ŷ
	MSG_REQ_MOVE Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_MOVE_REQ;
	Msg.startX = GetXPos();
	Msg.startY = GetYPos();
	Msg.destX = x;
	Msg.destY = y;
	NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

	return true;
}

static unsigned int checkMove = 0;
bool cHero::ActionMove( float x, float y, float range )
{
	if(x < 0 || y < 0)
	{
		assert(0);
		return false;
	}

	/// ̵.ȸ -  
	if( !cPlayer::Move( x, y ) )
	{
		return false;
	}

	/// Ŷ
	MSG_REQ_ACTIONMOVE Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_ACTIONMOVE_REQ;
	Msg.startX = GetXPos();
	Msg.startY = GetYPos();
	Msg.destX = x;
	Msg.destY = y;
	Msg.targetX = mTargetPos.x;
	Msg.targetY = mTargetPos.y;
	Msg.range = range;
	Msg.targetInfo = mAfterAction.mTarget;

	NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

//	cStringT str;
//	str.Format( _T("(%d)actionMove %d %f [%f,%f]\n"), mWaitMove, checkMove++, range, x, y );
//	OutputDebugString( str.Cstr() );

	return true;
}

/// ο path ϰ ù° path ̵..
bool cHero::ResetMovePath( float destX, float destY )
{
	if( IsReadyUseSkill() == false )
	{
		/// ų  ° ĳ̰ ̵ üũѴ.
		cSkillObject* p = SKILLEXECUTER->GetCurrentHeroSkillObject();
		if( p && p->GetDramaState() == eDRAMASTATE_CASTING )
		{
			cCastingBar* pWin = (cCastingBar*)UIMAN->GetContainer( eUIID_GAME_CASTINGBAR );
			if( pWin )
			{
				if( pWin->GetPercent() < 98.0f )
				{
					/// cast stop
					p->WaitCancel();
					pWin->Hide();
					HERO->SetState( eOBJECT_STATE_IDLE );

					/// 070712 PKH ų û ޼ ߼
					MSG_REQ_SKILL_CAST_CANCEL Msg;
					Msg.Category = NM_SKILL;
					Msg.Protocol = NM_SKILL_CAST_CANCEL_REQ;
					Msg.mAttacker.index = HERO->GetObjectID();
					Msg.mAttacker.type = HERO->GetObjectType();

					NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
				}
			}
			/// ĳ  Ŷ ..
			SKILLEXECUTER->SetCurrentHeroSkillObject( 0 );
		}
		else
		{
			mWaitMovePos.x = destX;
			mWaitMovePos.y = destY;
			mWaitMove = true;

			return false;
		}
	}

	if( GatheringCancel() == false )
		return false;

	if( ItemMixCancel() == false )
		return false;

	if( ItemEnhanceCancel() == false )
		return false;

	/// ̵ Ұ
	if( IsCantMove() == true )
		return false;

	/// Ÿ 
	NiPoint2 start( GetXPos(), GetYPos() );
	NiPoint2 goal( destX, destY );

	if( (start - goal).Length() > (float)MAX_PATH_DIST )
		return false;

	///
	mAfterAction.mActionType = eAfterAction_None;

	///  ãƺ~
	if( mPathFinder->FindPath( mPathArray, &mPathCount, MAX_PATH_COUNT, start, goal ) == false )
		return false;

	///
	mPathIndex = 0;
	mTargetPos.x = destX;
	mTargetPos.y = destY;
	mTargetPos.z = 0.0f;

	float z = 0.0f;
	if( WORLDMAN->CalcHeight( &z, mTargetPos.x, mTargetPos.y ) )
	{
		if( mMoveTargetEffectIdx != (unsigned long)-1 )
		{
			cEffectSceneNode* node = SCENEMAN->GetEffectSceneNode( mMoveTargetEffectIdx );
			if( node )
			{
				assert( node == mMoveTargetEffect );
				node->Remove();
			}
			mMoveTargetEffect = 0;
			mMoveTargetEffectIdx = (unsigned long)-1;
		}

		NiTransform trans;
		trans.MakeIdentity();
		trans.m_Translate = mTargetPos;
		trans.m_Translate.z = z;
		trans.m_fScale = 1.0f;

		mMoveTargetEffect = SCENEMAN->CreateSelfEffect( "./Data/Effect/Eff_PC_Target_03.nif", false, trans, true );
		if( mMoveTargetEffect )
			mMoveTargetEffectIdx = mMoveTargetEffect->GetIndexByManger();
	}
	else
	{
		assert(0);
	}


	/// ̵
	Move( mPathArray[0].x, mPathArray[0].y );
	return true;
}

bool cHero::ResetActionMovePath( float destX, float destY, float range )
{
	if( GatheringCancel() == false )
		return false;

	/// ̵ Ұ
	if( IsCantMove() == true )
		return false;

	if( range == 0.0f )
	{
		assert(0);
		return ResetMovePath( destX, destY );
	}

	if( IsReadyUseSkill() == false )
	{
		mWaitMovePos.x = destX;
		mWaitMovePos.y = destY;
		mWaitMove = true;

		return true;
	}

	/// Ÿ 
	NiPoint2 start( GetXPos(), GetYPos() );
	NiPoint2 goal( destX, destY );

	if( (start - goal).Length() > 30000.0f )
		return false;

	///  ãƺ~
	if( mPathFinder->FindPath( mPathArray, &mPathCount, MAX_PATH_COUNT, start, goal ) == false )
	{
		return false;
	}

	///
	mPathIndex = 0;
	mTargetPos.x = destX;
	mTargetPos.y = destY;
	mTargetPos.z = 0.0f;

	if( mMoveTargetEffectIdx != (unsigned long)-1 )
	{
		cEffectSceneNode* node = SCENEMAN->GetEffectSceneNode( mMoveTargetEffectIdx );
		if( node )
		{
			assert( node == mMoveTargetEffect );
			node->Remove();
		}
		mMoveTargetEffect = 0;
		mMoveTargetEffectIdx = (unsigned long)-1;
	}

	/// ̵
	ActionMove( mPathArray[0].x, mPathArray[0].y, range );
	return true;
	/*
	if( mPathFinder->ObstacleCheck( GetXPos(), GetYPos(), destX, destY ) )
	{
		/// ã 
		mPathNodeSet.ResetPath( GetXPos(), GetYPos(), destX, destY );

		///  ִ ˻.
		switch(mPathFinder->GetLastResult())
		{
		case PATH_OK:
			{
				NiPoint2 path = mPathNodeSet.GetNextPath();

				///   ..
				mTargetPos.x = destX; mTargetPos.y = destY;
				mTargetPos.z = 0.0f;

				/// ã  ̵ ǥ ..
				destX = path.x; destY = path.y;

				/// ̵
				ActionMove( destX, destY, range );
			}
			break;
			///   ִ 
		case PATH_BLOCK: 
			{
				return false;
			}
			///     
		case PATH_ZERO:
			{
				float onetilesize = mPathFinder->GetOneTileSize();
				if( mPathFinder->IsObstacleIndex((unsigned int)(destX/onetilesize),(unsigned int)(destY/onetilesize)) )
				{
					return false;
				}
			}
			break;
		default: 
			{
				assert(0);
				return false;
			}
		}
	}
	else
	{
		///   ..
		mTargetPos.x = destX; mTargetPos.y = destY;
		mTargetPos.z = 0.0f;

		/// ̵
		ActionMove( destX, destY, range );
	}
	return true;
	*/
}

void cHero::StopAfterAction()
{
	mAfterAction.mActionType = eAfterAction_None;
	SetState( eOBJECT_STATE_IDLE );

	mWaitSkillIdx = 0;
}

bool cHero::StartAttack( unsigned long attackIdx, cBaseObject* pTarget )
{
#ifdef _GMTOOL
	if( CHEATMAN->GetHideMode() )
		return false;
#endif

	if( IsRideVehicle() == true )
	{
		MSGROOT msg;
		::memset( &msg, 0, sizeof(msg) );
		msg.Category = NM_PLAYER;
		msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		AlightVehicle();
	}

	///  ۵Ǵ ( ڵ   )
	AutoActionClear();

	if( GetState() == eOBJECT_STATE_DIE )
		return false;

	if( IsWeaponChanging() == true )
		return false;

	if( IsReadyUseSkill() == false )
		return false;

	if( pTarget == 0 )
	{
		assert(0);
		return false;
	}

	/// ٶ  
	NiPoint3 charDir = mDesiredDir;
	NiPoint3 viewDir = pTarget->GetPos() - GetPos();
	viewDir.z = 0.0f;
	if( viewDir != NiPoint3::ZERO )
	{
		if( viewDir.SqrLength() >= 0.001f )	
		{
			viewDir.Unitize();

			/// ȸ Matrix 
			NiMatrix3 matA, matB, matRot;
			matA.SetCol( 0, charDir );
			matA.SetCol( 1, -NiPoint3::UNIT_Z );
			matA.SetCol( 2, charDir.UnitCross( -NiPoint3::UNIT_Z ) );

			matB.SetCol( 0, viewDir );
			matB.SetCol( 1, -NiPoint3::UNIT_Z );
			matB.SetCol( 2, viewDir.UnitCross( -NiPoint3::UNIT_Z ) );

			matRot = matB * matA.Transpose();
			mpObjectSceneNode->SetRotate( mpObjectSceneNode->GetRotate()*matRot );
			mDesiredDir = viewDir;
		}
	}

	if( IsTransformMonster() )
		return StartAttack_Mon( attackIdx, pTarget );

	/// Ÿ üũ
	if( SKILLMAN->IsUsedKeepSkill( NORMAL_ATTACK_SKILL ) == false )
	{
		return false;
	}

	/// ⺻ ų ..
	unsigned long key = SKILLMAN->CreateHeroSkillObject( attackIdx, this, pTarget, mPlayerExrInfo.mAttackSpeed );
	if( key )
	{
		///  
		SetState( eOBJECT_STATE_ATTACK );
		SetReadyUseSkill( false );

		/// 070712 PKH ų û ޼ ߼
		MSG_REQ_SKILL_USED Msg;
		Msg.Category = NM_SKILL;
		Msg.Protocol = NM_SKILL_USED_REQ;
		Msg.mTarget.index = pTarget->GetObjectID();
		Msg.mTarget.type = pTarget->GetObjectType();

		Msg.mSkillClassIndex = attackIdx;

		Msg.mManagedKey = key;
		Msg.mClientPosX = HERO->GetXPos();
		Msg.mClientPosY = HERO->GetYPos();

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}

	return true;
}

void cHero::UseTargetSkill( unsigned long skillIdx, cBaseObject* pTarget )
{
#ifdef _GMTOOL
	if( CHEATMAN->GetHideMode() )
		return;
#endif

	if( IsTransformMonster() )
	{
		UseTargetSkill_TransMon( skillIdx, pTarget );
		return;
	}
	else
	{
		if( IsRideVehicle() == true )
		{
			MSGROOT msg;
			::memset( &msg, 0, sizeof(msg) );
			msg.Category = NM_PLAYER;
			msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			AlightVehicle();
		}
	}

	AutoActionClear();
	SKILLEXECUTER->ChargeOff( skillIdx );

	if( IsWeaponChanging() == true )
		return;

	///  Ÿ 
	if( SKILLEXECUTER->IsPossibleUseSkillTarget( skillIdx, pTarget ) == false )
		return;

	/// ߵ 
	if( SKILLEXECUTER->IsPossibleUseSkill( skillIdx ) == false )
		return;

	if( pTarget )
	{
		/// ٶ  
		NiPoint3 charDir = mDesiredDir;
		NiPoint3 viewDir = pTarget->GetPos() - GetPos();
		viewDir.z = 0.0f;
		if( viewDir != NiPoint3::ZERO )
		{
			if( viewDir.SqrLength() >= 0.001f )	
			{
				viewDir.Unitize();

				/// ȸ Matrix 
				NiMatrix3 matA, matB, matRot;
				matA.SetCol( 0, charDir );
				matA.SetCol( 1, -NiPoint3::UNIT_Z );
				matA.SetCol( 2, charDir.UnitCross( -NiPoint3::UNIT_Z ) );

				matB.SetCol( 0, viewDir );
				matB.SetCol( 1, -NiPoint3::UNIT_Z );
				matB.SetCol( 2, viewDir.UnitCross( -NiPoint3::UNIT_Z ) );

				matRot = matB * matA.Transpose();
				mpObjectSceneNode->SetRotate( mpObjectSceneNode->GetRotate()*matRot );
				mDesiredDir = viewDir;
			}
		}
	}

	unsigned long key = SKILLMAN->CreateHeroSkillObject( skillIdx, this, pTarget );
	if( key )
	{
		sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
		if( pInfo )
		{
			if( mMageJobType == true )
				SetState( eOBJECT_STATE_IDLE, false );
			else
				SetState( eOBJECT_STATE_ATTACK );
		}
		else
		{
			SetState( eOBJECT_STATE_ATTACK );
		}

		///  
		SetReadyUseSkill( false );

		/// 070712 PKH ų û ޼ ߼
		MSG_REQ_SKILL_USED Msg;
		Msg.Category = NM_SKILL;

		/// casting ִ 
		if( SKILLSCRIPT->IsCastSkill( skillIdx, 0 ) == true )
			Msg.Protocol = NM_SKILL_CAST_USED_REQ;
		else
			Msg.Protocol = NM_SKILL_USED_REQ;

		Msg.mSkillClassIndex = skillIdx;
		Msg.mManagedKey = key;
		Msg.mClientPosX = HERO->GetXPos();
		Msg.mClientPosY = HERO->GetYPos();


		if( pTarget )
		{
			Msg.mTarget.index = pTarget->GetObjectID();
			Msg.mTarget.type = pTarget->GetObjectType();
		}
		else
		{
			Msg.mTarget.index = 0;
			Msg.mTarget.type = eOBJECTTYPE_NONE;
		}

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
}

void cHero::UseFieldSkill( unsigned long skillIdx, NiPoint3 fieldPos )
{
#ifdef _GMTOOL
	if( CHEATMAN->GetHideMode() )
		return;
#endif

	if( IsTransformMonster() )
	{
		UseFieldSkill_TransMon( skillIdx, fieldPos );
		return;
	}
	else
	{
		if( IsRideVehicle() == true )
		{
			MSGROOT msg;
			::memset( &msg, 0, sizeof(msg) );
			msg.Category = NM_PLAYER;
			msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			AlightVehicle();
		}
	}

	AutoActionClear();
	SKILLEXECUTER->ChargeOff( skillIdx );

	if( IsWeaponChanging() == true )
		return;

	/// ߵ 
	if( SKILLEXECUTER->IsPossibleUseSkill( skillIdx ) == false )
		return;

	/// ٶ  
	NiPoint3 charDir = mDesiredDir;
	NiPoint3 viewDir = fieldPos - GetPos();
	viewDir.z = 0.0f;
	if( viewDir != NiPoint3::ZERO )
	{
		if( viewDir.SqrLength() >= 0.001f )	
		{
			viewDir.Unitize();

			/// ȸ Matrix 
			NiMatrix3 matA, matB, matRot;
			matA.SetCol( 0, charDir );
			matA.SetCol( 1, -NiPoint3::UNIT_Z );
			matA.SetCol( 2, charDir.UnitCross( -NiPoint3::UNIT_Z ) );

			matB.SetCol( 0, viewDir );
			matB.SetCol( 1, -NiPoint3::UNIT_Z );
			matB.SetCol( 2, viewDir.UnitCross( -NiPoint3::UNIT_Z ) );

			matRot = matB * matA.Transpose();
			mpObjectSceneNode->SetRotate( mpObjectSceneNode->GetRotate()*matRot );
			mDesiredDir = viewDir;
		}
	}

	unsigned long key = SKILLMAN->CreateHeroSkillObject( skillIdx, this, fieldPos );
	if( key )
	{
		sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
		if( pInfo )
		{
			if( mMageJobType == true )
				SetState( eOBJECT_STATE_IDLE, false );
			else
				SetState( eOBJECT_STATE_ATTACK );
		}
		else
		{
			SetState( eOBJECT_STATE_ATTACK );
		}

		///  
		SetReadyUseSkill( false );

		/// 070712 PKH ų û ޼ ߼

		MSG_REQ_POS_USED Msg;
		Msg.Category = NM_SKILL;

		/// casting ִ 
		if( SKILLSCRIPT->IsCastSkill( skillIdx, 0 ) == true )
			Msg.Protocol = NM_SKILL_POS_CAST_USED_REQ;
		else
			Msg.Protocol = NM_SKILL_POS_USED_REQ;

		Msg.mSkillClassIndex = skillIdx;
		Msg.mManagedKey = key;
		Msg.mClientPosX = HERO->GetXPos();
		Msg.mClientPosY = HERO->GetYPos();

		Msg.mTargetPosX = fieldPos.x;
		Msg.mTargetPosY = fieldPos.y;

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
}

void cHero::UseMapChangeSkill( unsigned long skillIdx, unsigned int slotIdx )
{
	if( PVPMAN->IsEnableBattle() == true )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText(842) );
		return;
	}

	if( IsTransformMonster() == false )
	{
		if( IsRideVehicle() == true )
		{
			MSGROOT msg;
			::memset( &msg, 0, sizeof(msg) );
			msg.Category = NM_PLAYER;
			msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			AlightVehicle();
		}
	}

	AutoActionClear();
	if( IsReadyUseSkill() == false )
		return;

	SetWaitMoveFlag( false );

	SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
	if( skillIdx < NORMAL_ATTACK_SKILL_MAX )
	{
		assert(0);
		return;
	}

	///  ˻
	if( !(GetState() == eOBJECT_STATE_IDLE || GetState() == eOBJECT_STATE_MOVE) )
		return;

	if( IsWeaponChanging() == true )
		return;

	/// ų  ȹѴ.
	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return;
	}
	sPlayerSkillStepInfo* pStepInfo = &pInfo->mpSetpInfoArray[0];

	///    üũ
	if( pInfo->mUseItem )
	{
		unsigned int count = ITEMMAN->GetItemCount( pInfo->mUseItem );
		if( count < pStepInfo->mUseItemCount )
			return;
	}

	if( GetLevel() < pStepInfo->mPlayerLevel )
		return;

	/// ų ߵ
	unsigned long key = SKILLMAN->CreateHeroMapChangeSkillObject( skillIdx, this );
	if( key )
	{
		SetState( eOBJECT_STATE_ATTACK );

		///  
		SetReadyUseSkill( false );

		/// 070712 PKH ų û ޼ ߼
		MSG_REQ_SKILL_ITEMMAPCHANGE Msg;
		Msg.Category = NM_SKILL;

		/// casting ִ 
		Msg.Protocol = NM_SKILL_ITEMMAPCHANGE_REQ;
		Msg.mSkillClassIndex = skillIdx;
		Msg.mManagedKey = key;
		Msg.mClientPosX = HERO->GetXPos();
		Msg.mClientPosY = HERO->GetYPos();

		Msg.mTarget.index = HERO->GetObjectID();
		Msg.mTarget.type = eOBJECTTYPE_HERO;
		Msg.mSlotNumber = slotIdx;
		Msg.mUseItemIndex = pInfo->mUseItem;

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
}

void cHero::UseVehicleSkill( unsigned long skillIdx, unsigned int slotIdx )
{
	AutoActionClear();

	if( IsTransformMonster() == true )
		return;
	if( IsReadyUseSkill() == false )
		return;

	SetWaitMoveFlag( false );

	SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
	if( skillIdx < NORMAL_ATTACK_SKILL_MAX )
	{
		assert(0);
		return;
	}

	///  ˻
	if( !(GetState() == eOBJECT_STATE_IDLE || GetState() == eOBJECT_STATE_MOVE) )
		return;

//	if( IsWeaponChanging() == true )
//		return;

	/// ų  ȹѴ.
	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return;
	}
	sPlayerSkillStepInfo* pStepInfo = &pInfo->mpSetpInfoArray[0];

	if( IsRideVehicle() == true )
	{
		MSGROOT msg;
		::memset( &msg, 0, sizeof(msg) );
		msg.Category = NM_PLAYER;
		msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		AlightVehicle();

		///
		cInfluenceMap::cIterator i = mBuffMap.Begin();
		cInfluenceMap::cIterator end = mBuffMap.End();
		for( ; i != end; ++i )
		{
			cInfluenceObject* p = (cInfluenceObject*)(*i).mSecond;
			if( p )
			{
				if( p->GetInfluenceIdx() == pStepInfo->mInfulenceIdx )
					return;
			}
		}
	}

	///    üũ
	if( pInfo->mUseItem )
	{
		unsigned int count = ITEMMAN->GetItemCount( pInfo->mUseItem );
		if( count < pStepInfo->mUseItemCount )
			return;
	}

	if( GetLevel() < pStepInfo->mPlayerLevel )
		return;

	/// ų ߵ
	unsigned long key = SKILLMAN->CreateHeroVehicleSkillObject( skillIdx, this );
	if( key )
	{
		SetState( eOBJECT_STATE_ATTACK );

		///  
		SetReadyUseSkill( false );

		/// 070712 PKH ų û ޼ ߼
		MSG_REQ_SKILL_VEHICLE Msg;
		Msg.Category = NM_SKILL;

		/// casting ִ 
		Msg.Protocol = NM_SKILL_ITEMVEHICLE_REQ;
		Msg.mSkillClassIndex = skillIdx;
		Msg.mManagedKey = key;
		Msg.mClientPosX = HERO->GetXPos();
		Msg.mClientPosY = HERO->GetYPos();

		Msg.mTarget.index = HERO->GetObjectID();
		Msg.mTarget.type = eOBJECTTYPE_HERO;
		Msg.mSlotNumber = slotIdx;
		Msg.mUseItemIndex = pInfo->mUseItem;

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
}


void cHero::AutoActionClear()
{
	mWaitMove = false;
	mWaitSkillIdx = 0;

	mAfterAction.mActionType = eAfterAction_None;
}

void cHero::StartNpcTalk( unsigned long npcIdx )
{ 
	assert(!mNpcIdx);
	mNpcIdx = npcIdx; 

	SetStopFlag( eSTOP_NPCSPEECH );
}

void cHero::EndNpcTalk()
{
	mNpcIdx = 0;
}

void cHero::SendEndNpcTalk()
{
	///  쿡 ޼  ʴ´.
	if( HERO->GetState() != eOBJECT_STATE_DIE )
	{
		SetStopFlag( eSTOP_NONE );
		SetState( eOBJECT_STATE_IDLE );

		MSGROOT reqMsg;
		reqMsg.Category = NM_NPC;
		reqMsg.Protocol = NM_NPC_CLOSE_REQ;
		NETWORK->SendNetworkMsg( (char*)&reqMsg, sizeof(reqMsg) );
	}
}

/// ִϸ̼  ó
void cHero::Interpret( unsigned long time )
{
	if( mpObjectSceneNode->GetType() == cSceneNode::eVEHICLE )
	{
		return InterpretVehicle( time );
	}

	cActorManagerForPartition*	pActor = mpObjectSceneNode->GetActorManager();
	if( !pActor ) return;

	unsigned int id = mpObjectSceneNode->GetTargetAnimation();
	float checkTime = (float)mpObjectSceneNode->GetScaleAccumTime() * 0.001f;

	float endTime = pActor->GetNextEventTime( cActorManagerForPartition::TEXT_KEY_EVENT, id, "end" );
	if( endTime == NI_INFINITY )
		return;

	if( endTime == cActorManagerForPartition::INVALID_TIME )
	{
		endTime = mpObjectSceneNode->GetTargetAnimationScaleEndTime() * 0.001f;
	}

	InterpretEvent( id, checkTime, pActor );

	if( endTime > 0 && endTime <= checkTime )
	{
		if( id >= ANITYPE_IDLE && id < ANITYPE_IDLE2 )
		{
			return;
		}
		else if( id >= ANITYPE_IDLE2 && id < ANITYPE_RUN )
		{
			ChangeAnimation( ANITYPE_IDLE );
		}
		else if( id >= ANITYPE_VEHICLE_IDLE2 && id < ANITYPE_VEHICLE_RUN )
		{
			ChangeAnimation( ANITYPE_IDLE );
		}
		else if( id>= ANITYPE_RUN && id < ANITYPE_ATTACK1 )
		{
			return;
		}
		else if( id >= ANITYPE_ATTACK1 && id < ANITYPE_CASTING1 )
		{
			SetReadyUseSkill( true );
			ChangeAnimation( ANITYPE_IDLE );
		}
		else if( id >= ANITYPE_SKILL_BEGIN && id < ANITYPE_SKILL_END )
		{
			if( mMageJobType )
			{
				/// switch weapon check
				if( mWaitWeaponSwitch )
				{
					if( HERO->IsWeaponChanging() == false )
					{
						if( ITEMMAN->TryToSwitchWeapon() )
							HERO->SetWeaponChangeFlag( true );
					}
					mWaitWeaponSwitch = false;
				}

				SetReadyUseSkill( true );
				SetState( eOBJECT_STATE_IDLE );

				cStringT str;
				str.Format( _T("\nTime Check : %f"), endTime );
				OutputDebugString( str.Cstr() );
			}
			else
			{
				SetReadyUseSkill( true );
				ChangeAnimation( ANITYPE_IDLE );
			}
		}
		else if( mPlayerExrInfo.mState == ePLAYER_STATE_ITEMPICK )
		{
			SetRemoveDropItem( UINT_MAX );
			SetState( eOBJECT_STATE_IDLE );
			ShowWeapon( true );
		}
		else if( id == ANITYPE_PEACE_IDLE2 )
		{
			ChangeAnimation( ANITYPE_PEACE_IDLE );
		}
		else if( id >= ANITYPE_DAMAGE1 && id < ANITYPE_DIE1 )
		{
			if( !(ANITYPE_CASTING1 <= mDamageAfterAnim && mDamageAfterAnim < ANITYPE_DAMAGE1) )
			{
				SetReadyUseSkill( true );
				ChangeAnimation( ANITYPE_IDLE );
			}
			else
			{
				ChangeAnimation( (ePLAYER_ANIMATIONTYPE)mDamageAfterAnim );
			}
		}
		else if( id == ANITYPE_STANDUP )
		{
			SetState( eOBJECT_STATE_IDLE );
		}
		else if( id == ANITYPE_SITDOWN )
		{
			ChangeAnimation( ANITYPE_SITDOWN_IDLE );
			mSitDownFlag = false;
		}
		else if( id >= ANITYPE_EMOTE_START && id < ANITYPE_VEHICLE_IDLE )
		{
			SetState( eOBJECT_STATE_IDLE );
			ShowWeapon( true );
		}
		else if( id >= ANITYPE_ENHANCEDSUCCESS && id <= ANITYPE_ENHANCEDFAIL )
		{
			ChangeAnimation( ANITYPE_IDLE );
			ShowWeapon( true );
		}
	}
	else if( endTime == cActorManagerForPartition::INVALID_TIME )
	{
		return;
	}
}

/*
void cHero::ViewPlayerStatus()
{
	/// ĳ ġ
	sExpTable*	pExp = LEVELSCRIPT->GetExpTable( GetLevel() );
	unsigned int exp = GetPlayerExrInfo()->Exp;
	sSxpTable*	pSxp = LEVELSCRIPT->GetSxpTable( GetSkillLevel() );
	unsigned int sxp = GetPlayerExrInfo()->SkillExp;

	//////////////////////////////////////////////////////////////
	/// 070216 kkr ĳ Ʈâ  ( ȭ   )
	cHeroStateWindow* pStateWindow = (cHeroStateWindow*)UIMAN->GetContainer( eUIID_GAME_HERO_STATEWINDOW );

	///  
	pStateWindow->SetLevel( GetLevel() );

	unsigned char percent = static_cast<unsigned char>(exp * 100 / pExp->mExp );
	pStateWindow->SetEXPLabel( percent );

	pStateWindow->SetMAXEXP1( 10 );
	pStateWindow->SetMAXEXP2( 100 );
	pStateWindow->SetEXP1( (float)(percent % 10) );
	pStateWindow->SetEXP2( (float)(percent / 10 * 10) );	

	/// ĳ ų ġ
	pStateWindow->SetMAXSXP( (float)pSxp->mSxp );
	pStateWindow->SetSXP( static_cast<float>(sxp) );
}



void cHero::ViewPlayerInfo()
{
	/// ĳ ġ
	sExpTable*	pExp = LEVELSCRIPT->GetExpTable( GetLevel() );
	unsigned int exp = GetPlayerExrInfo()->Exp;
	sSxpTable*	pSxp = LEVELSCRIPT->GetSxpTable( GetSkillLevel() );
	unsigned int sxp = GetPlayerExrInfo()->SkillExp;

	//////////////////////////////////////////////////////////////
	/// 070122 PKH ĳ â 
	cHeroInfoWindow* pInfoWindow = (cHeroInfoWindow*)UIMAN->GetContainer( eUIID_GAME_HERO_INFOWINDOW );

	/// ĳ 
	pInfoWindow->SetLevel( GetLevel() );

	SetExp( pExp->mExp, exp );
	pInfoWindow->SetMAXEXP( (float)pExp->mExp );
	pInfoWindow->SetEXP( (float)exp );

	/// ĳ ų 
	pInfoWindow->SetSkillLevel( mPlayerExrInfo.SkillLevel );
	/// ĳ ų Ʈ
	pInfoWindow->SetSkillPoint( GetSkillPointRemain() );
	/// ĳ ų ġ
	pInfoWindow->SetMAXSXP( (float)pSxp->mSxp );
	pInfoWindow->SetSXP( static_cast<float>(sxp) );

	/// ĳ Weight , MAX Weight  
	pInfoWindow->SetMAXWeight( (float)GetMaxWeight(), eCOLOR_BLACK );
	pInfoWindow->SetWeightNoAni( 55 );

	/// Ŭ
	pInfoWindow->SetClass( GetJob() );


	/// 
	//pInfoWindow->SetFame( 123456 );
	/// 
	//pInfoWindow->SetGuild( "ӽñ" );
	/// 
	//pInfoWindow->SetRank( "ӽ" );

	/// 
	pInfoWindow->SetStr( static_cast<int>(GetBaseStatus( ePLAYER_STATUS_BASE_STR )), eCOLOR_WHITE );	
	/// ø
	pInfoWindow->SetDex( static_cast<int>(GetBaseStatus( ePLAYER_STATUS_BASE_DEX )), eCOLOR_WHITE );	
	/// ü
	pInfoWindow->SetCon( static_cast<int>(GetBaseStatus( ePLAYER_STATUS_BASE_CON )), eCOLOR_WHITE );	
	/// 
	pInfoWindow->SetInt( static_cast<int>(GetBaseStatus( ePLAYER_STATUS_BASE_INT )), eCOLOR_WHITE );	
	/// 
	pInfoWindow->SetWis( static_cast<int>(GetBaseStatus( ePLAYER_STATUS_BASE_WIS )), eCOLOR_WHITE );	

	/// ͽ ߰ ( 븻 ´  )
	pInfoWindow->SetPlusStr( static_cast<int>(GetBaseStatusPlus( ePLAYER_STATUS_BASE_STR )), GetStatusColor( eSTATUSCOLORPOS_STRENGTH ) );
	pInfoWindow->SetPlusAgi( static_cast<int>(GetBaseStatusPlus( ePLAYER_STATUS_BASE_DEX )), GetStatusColor( eSTATUSCOLORPOS_DEXTERITY ) );
	pInfoWindow->SetPlusCon( static_cast<int>(GetBaseStatusPlus( ePLAYER_STATUS_BASE_CON )), GetStatusColor( eSTATUSCOLORPOS_CONSTITUTION ) );
	pInfoWindow->SetPlusInt( static_cast<int>(GetBaseStatusPlus( ePLAYER_STATUS_BASE_INT )), GetStatusColor( eSTATUSCOLORPOS_INTELLIGENCE ) );
	pInfoWindow->SetPlusWis( static_cast<int>(GetBaseStatusPlus( ePLAYER_STATUS_BASE_WIS )), GetStatusColor( eSTATUSCOLORPOS_WISDOM ) );

	/// ݷ
	pInfoWindow->SetAtt( static_cast<int>(GetStatusAtk()), GetStatusColor( eSTATUSCOLORPOS_EXTATK ) );	
	/// 
	pInfoWindow->SetDef( static_cast<int>(GetStatusDef()), GetStatusColor( eSTATUSCOLORPOS_EXTDEF ) );	
	/// 
	pInfoWindow->SetMag( static_cast<int>(GetStatusMAtk()), GetStatusColor( eSTATUSCOLORPOS_EXTMATK ) );	
	/// ׷
	pInfoWindow->SetRes( static_cast<int>(GetStatusMDef()), GetStatusColor( eSTATUSCOLORPOS_EXTMDEF ) );	
	/// 
	pInfoWindow->SetHit( static_cast<int>(GetStatusHit()), GetStatusColor( eSTATUSCOLORPOS_EXTHIT ) );	
	/// ȸ
	pInfoWindow->SetAvoid( static_cast<int>(GetStatusAvoid()), GetStatusColor( eSTATUSCOLORPOS_EXTAVOID ) );	
}
*/

NiPoint3 cHero::GetDirection() const
{
	return mDesiredDir;//mpObjectSceneNode->GetWorldRotate() * -NiPoint3::UNIT_Y;
}

const NiMatrix3& cHero::GetRotate() const
{
	return mpObjectSceneNode->GetWorldRotate();
}

void cHero::AttachListener()
{
	//	((NiNode*)mpObjectSceneNode->GetNiObject())->AttachChild( SOUNDSYS->GetListener() );
}

cDynamicSceneNode* cHero::CreateSceneNode( cPlayerSceneNodeParam* param )
{
	return SCENEMAN->CreateHero( *param );
}

void cHero::AddBuff( unsigned long uniqueIdx, cInfluenceObject* p )
{
	if( p == 0 )
		return;

	cPlayer::AddBuff( uniqueIdx, p );

	/// buff 쿡 
	cBuffWindow* pWin = GAMEUI->GetBuffWindow();
	if( pWin )
	{
		pWin->AddIcon( uniqueIdx, p->GetInfluenceIdx() );
	}

	if( DUELMAN->IsDuelEnable() )
	{
		cDuelWindow* win = GAMEUI->GetDuelWindow();
		if( win )
			win->AddBuff( false, uniqueIdx, p->GetInfluenceIdx() );
	}

}

void cHero::DelBuff( unsigned long uniqueIdx )
{
	cInfluenceObject* p = (cInfluenceObject*)mBuffMap.GetAt( uniqueIdx );
	if( p )
	{
		cBuffWindow* pWin = GAMEUI->GetBuffWindow();
		if( pWin )
		{
			pWin->DelIcon( uniqueIdx );
		}

		if( DUELMAN->IsDuelEnable() )
		{
			cDuelWindow* win = GAMEUI->GetDuelWindow();
			if( win )
				win->DelBuff( false, uniqueIdx );
		}
	}
	cPlayer::DelBuff( uniqueIdx );
}

void cHero::AddDeBuff( unsigned long uniqueIdx, cInfluenceObject* p )
{
	if( p == 0 )
		return;

	cPlayer::AddDeBuff( uniqueIdx, p );

	/// debuff 쿡 
	cBuffWindow* pWin = GAMEUI->GetDeBuffWindow();
	if( pWin )
	{
		pWin->AddIcon( uniqueIdx, p->GetInfluenceIdx() );
	}

	if( DUELMAN->IsDuelEnable() )
	{
		cDuelWindow* win = GAMEUI->GetDuelWindow();
		if( win )
			win->AddDeBuff( false, uniqueIdx, p->GetInfluenceIdx() );
	}
}

void cHero::DelDeBuff( unsigned long uniqueIdx )
{
	cInfluenceObject* p = (cInfluenceObject*)mDeBuffMap.GetAt( uniqueIdx );
	if( p )
	{
		cBuffWindow* pWin = GAMEUI->GetDeBuffWindow();
		if( pWin )
		{
			pWin->DelIcon( uniqueIdx );
		}

		if( DUELMAN->IsDuelEnable() )
		{
			cDuelWindow* win = GAMEUI->GetDuelWindow();
			if( win )
				win->DelDeBuff( false, uniqueIdx );
		}
	}

	cPlayer::DelDeBuff( uniqueIdx );
}

void cHero::ClearAllBuff()
{
	cInfluenceMap::cIterator i = mBuffMap.Begin();
	cInfluenceMap::cIterator end = mBuffMap.End();

	cBuffWindow* pWin = GAMEUI->GetBuffWindow();

	for( ; i != end; ++i )
	{
		cInfluenceObject* p = (cInfluenceObject*)(*i).mSecond;
		if( p )
		{
			if( pWin )
				pWin->DelIcon( p->GetManagedKey() );

			SKILLMAN->DeleteInfluenceObject( p );
		}
	}
	mBuffMap.Clear();
}

void cHero::ClearAllDeBuff()
{
	cInfluenceMap::cIterator i = mDeBuffMap.Begin();
	cInfluenceMap::cIterator end = mDeBuffMap.End();

	cBuffWindow* pWin = GAMEUI->GetDeBuffWindow();

	for( ; i != end; ++i )
	{
		cInfluenceObject* p = (cInfluenceObject*)(*i).mSecond;
		if( p )
		{
			if( pWin )
				pWin->DelIcon( p->GetManagedKey() );

			SKILLMAN->DeleteInfluenceObject( p );
		}
	}
	mDeBuffMap.Clear();
}

void cHero::ClearDieBuff()
{
	cInfluenceMap::cIterator i = mBuffMap.Begin();
	cInfluenceMap::cIterator end = mBuffMap.End();

	cBuffWindow* pWin = GAMEUI->GetBuffWindow();

	while( i != end )
	{
		cInfluenceObject* p = (cInfluenceObject*)(*i++).mSecond;
		if( p && p->DieDelete() )
		{
			if( pWin )
				pWin->DelIcon( p->GetManagedKey() );

			SKILLMAN->DeleteInfluenceObject( p );

			mBuffMap.Erase( p->GetManagedKey() );
		}
	}


	cInfluenceMap::cIterator i2 = mDeBuffMap.Begin();
	cInfluenceMap::cIterator end2 = mDeBuffMap.End();

	cBuffWindow* pWin2 = GAMEUI->GetDeBuffWindow();

	while( i2 != end2 )
	{
		cInfluenceObject* p = (cInfluenceObject*)(*i2++).mSecond;
		if( p && p->DieDelete() )
		{
			if( pWin2 )
				pWin2->DelIcon( p->GetManagedKey() );

			SKILLMAN->DeleteInfluenceObject( p );

			mDeBuffMap.Erase( p->GetManagedKey() );
		}
	}
}

void cHero::DuelRequest( unsigned long playerIdx )
{
	cBaseObject* pTarget = NULL;

	try
	{
		if( playerIdx == 0 )
			pTarget = HERO->GetTargetObject();
		else
			pTarget = OBJECTMAN->GetPlayer( playerIdx );

		if( pTarget == NULL )
			throw 1;

		/// Ÿ ÷̾
		if( pTarget->GetObjectType() != eOBJECTTYPE_PLAYER )
			throw 1;
	}
	catch ( ... )
	{
		cStringT Message;
		Message.Format( GAMERESOURCEMAN->GetGameText( 808 ) );
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );

		return;
	}

	MSG_REQ_DUEL_ADD msg;
	msg.Category = NM_DUEL;
	msg.Protocol = NM_DUEL_ADD_REQ;
	msg.mTargetIdx = pTarget->GetObjectID();

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// û
	cStringT Message;
	Message.Format( GAMERESOURCEMAN->GetGameText( 800 ), pTarget->GetName() );
	CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
}

void cHero::DuelGiveUp()
{
	///   ޼ ߼
	MSGROOT msg;
	msg.Category = NM_DUEL;
	msg.Protocol = NM_DUEL_GIVEUP_RES;

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

void cHero::ViewMsgDuelReq( unsigned long duelReqPlayerIdx )
{ 
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( duelReqPlayerIdx );
	if( pPlayer == NULL )
		return;

	cDuelMsgWindow* pDuelMsgWin = GAMEUI->GetDuelMsgWindow();
	if( pDuelMsgWin == NULL )
		return;

	///  û 
	pDuelMsgWin->SetTargetIdx( duelReqPlayerIdx );

	///  ûâ 
	pDuelMsgWin->ShowModal();
}

void cHero::DuelNoStartMsg( int errorCode )
{
	cStringT Message;

	switch( errorCode )
	{
	case ERR_DUEL_ACCEPT_REQ_ERROR:		/// û  Ұ
		Message.Format( GAMERESOURCEMAN->GetGameText( 803 ) );
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
		break;
	case ERR_DUEL_ACCEPT_RES_REJECTION:	///  
		Message.Format( GAMERESOURCEMAN->GetGameText( 804 ) );
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
		break;
	case ERR_DUEL_ACCEPT_RES_ERROR:		///   Ұ
		Message.Format( GAMERESOURCEMAN->GetGameText( 806 ) );
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
		break;
	}					

	/////  ûâ 
	cDuelMsgWindow* pWin = GAMEUI->GetDuelMsgWindow();
	if( pWin != NULL )
		pWin->Hide();
}

void cHero::BlinkBuffIcon( unsigned long uniqueIdx, unsigned long influenceIdx )
{
	cBuffWindow* pWin = GAMEUI->GetBuffWindow();
	if( pWin )
		pWin->BlinkIcon( uniqueIdx, influenceIdx );
}

void cHero::BlinkDeBuffIcon( unsigned long uniqueIdx, unsigned long influenceIdx )
{
	cBuffWindow* pWin = GAMEUI->GetDeBuffWindow();
	if( pWin )
		pWin->BlinkIcon( uniqueIdx, influenceIdx );
}

void cHero::ToggleIdleFlag()
{
	if( mPeaceToggleFlag == false )
		return;
	if( GetState() == eOBJECT_STATE_DIE ||
		GetState() == eOBJECT_STATE_ATTACK ||
		GetState() == eOBJECT_STATE_STOP ||
		GetState() == eOBJECT_STATE_MOVE )
		return;

	eIDLEFLAG flag = (mPlayerExrInfo.mStateIdle == eIDLE_NORMAL)? eIDLE_PEACE:eIDLE_NORMAL;
	cPlayer::SetIdleFlag( flag );

	/// Network Msg;
	MSG_REQ_PLAYER_STATE_IDLE Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_STATE_IDLE_REQ;

	Msg.mPlayerStateIdle = (unsigned char)flag;
	NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

	mPeaceToggleFlag = false;
}

void cHero::ToggleSitDown()
{
	if( IsPossibleSitDown() == false )
		return;

	if( GatheringCancel() == false )
		return;

	/// ɱ/ ȯ
	if( GetState() == ePLAYER_STATE_SITDOWN )
	{
		StandUp();

		/// Network Msg
		MSG_REQ_PLAYER_STATE_SITDWON Msg;
		Msg.Category = NM_PLAYER;
		Msg.Protocol = NM_PLAYER_STATE_SITDOWN_REQ;
		Msg.mSitDown = false;

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
	else
	{
		if( IsRideVehicle() == true )
		{
			MSGROOT msg;
			::memset( &msg, 0, sizeof(msg) );
			msg.Category = NM_PLAYER;
			msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			AlightVehicle();
		}

		SitDown();

		/// 081209 PKH ɱ ۽ð  - 10 ĺ ڿȸ 2ǥ
		mSitDownStartTime = THEAPP->GetWorldAccumTime();
		mSitDownStatusCalc = true;

		/// Network Msg
		MSG_REQ_PLAYER_STATE_SITDWON Msg;
		Msg.Category = NM_PLAYER;
		Msg.Protocol = NM_PLAYER_STATE_SITDOWN_REQ;
		Msg.mSitDown = true;

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
}


void cHero::SitDownUpdate()
{
	/// 081209 PKH ȸ 2  
	if( mSitDownStartTime != 0 && mSitDownStatusCalc == true && mPlayerExrInfo.mState == ePLAYER_STATE_SITDOWN &&
		mSitDownStartTime + NATURE_RECOVERY_TIME < THEAPP->GetWorldAccumTime() )
	{
		mSitDownStatusCalc = false;
		CalcStatus();
	}
}


bool cHero::IsSitDownCalc()
{
	/// 081209 PKH ȸ ι  Ȯ
	if( mSitDownStartTime != 0 && mPlayerExrInfo.mState == ePLAYER_STATE_SITDOWN && 
		mSitDownStartTime + NATURE_RECOVERY_TIME < THEAPP->GetWorldAccumTime() )
		return true;

	return false;
}

void cHero::SetWeaponChangeFlag( bool val ) 
{
	if( mSwitchWeaponFlag == true && val == false )
	{
		/// ⺻  ̵ üũѴ.
		if( mAfterAction.mActionType == eAfterAction_Attack )
		{
			/// ⺻  ̵߿ ü Ѵ.
			SKILLEXECUTER->ReCharge();

			mAfterAction.mExData1 = SKILLEXECUTER->GetChargeSkill();
			mAfterAction.mRange = SKILLEXECUTER->GetChargeSkillRange();

			SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
		}
	}

	mSwitchWeaponFlag = val;

	if( val == true )
		mSwitchWeaponTime = 600;
}

bool cHero::EquipWeaponItem( sPlayerWeaponInfo* info )
{
	SetWeaponChangeFlag( false );

	return cPlayer::EquipWeaponItem( info );
}

void cHero::ChangeWeaponState( eWEAPON_STATE state )
{
	cPlayer::ChangeWeaponState( state );

	/// ⺻  ̵ üũѴ.
	if( mAfterAction.mActionType == eAfterAction_Attack )
	{
		/// ⺻  ̵߿ ü Ѵ.
		SKILLEXECUTER->ReCharge();

		mAfterAction.mExData1 = SKILLEXECUTER->GetChargeSkill();
		mAfterAction.mRange = SKILLEXECUTER->GetChargeSkillRange();

		SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
	}
}

// ResetArmorSets Method.
void cHero::ResetArmorSets()
{
	// CLEAR - ARMOR SETS
	mArmorSets = ARMOR_SETS_NONE;

	//// ARMOR SETS - HAT
	const cItem& hat = ITEMMAN->GetItem( INVENTORY_WEAR_HAT );
	cItemAbility* hatAbil = ITEMMAN->GetItemAbility( hat.GetIndex() );
	if( hatAbil )
	{
		switch( hatAbil->GetDefenseType() )
		{
		case ITEM_MATERIAL_CLOTH:		/// õ
			mArmorSets = mArmorSets | ROBES_HAT;
			break;
		case ITEM_MATERIAL_LEATHER:		/// 
			mArmorSets = mArmorSets | LIGHT_ARMOR_HAT;
			break;
		case ITEM_MATERIAL_METAL:		/// ݼ
			mArmorSets = mArmorSets | HEAVY_ARMOR_HAT;
			break;
		}
	}

	//// ARMOR SETS - UPPER(BODY1)
	const cItem& uppper = ITEMMAN->GetItem( INVENTORY_WEAR_BODY1 );
	cItemDefine* upperDefine = ITEMMAN->GetItemDefine( uppper.GetIndex() );
	cItemAbility* uppperAbil = ITEMMAN->GetItemAbility( uppper.GetIndex() );

	if( uppperAbil != NULL )
	{
		if( uppperAbil )
		{
			if( upperDefine->GetSubType() == ITEM_WEAR_ONEPIECE )
			{
				switch ( uppperAbil->GetDefenseType() )
				{
				case 1:
					mArmorSets = mArmorSets | ROBES_ONEPIECE;
					break; // õ
				case 2:
					mArmorSets = mArmorSets | LIGHT_ARMOR_ONEPIECE;
					break; // 
				case 3:
					mArmorSets = mArmorSets | HEAVY_ARMOR_ONEPIECE;
					break; // ݼ
				}
			}
			else
			{
				switch ( uppperAbil->GetDefenseType() )
				{
				case 1:
					mArmorSets = mArmorSets | ROBES_UPPER;
					break; // õ
				case 2:
					mArmorSets = mArmorSets | LIGHT_ARMOR_UPPER;
					break; // 
				case 3:
					mArmorSets = mArmorSets | HEAVY_ARMOR_UPPER;
					break; // ݼ
				}
			}
		}
	}

	//// ARMOR SETS - LOWER(BODY2)
	const cItem& lower = ITEMMAN->GetItem( INVENTORY_WEAR_BODY2 );
	cItemDefine* lowerDefine = ITEMMAN->GetItemDefine( lower.GetIndex() );
	cItemAbility* lowerAbil = ITEMMAN->GetItemAbility( lower.GetIndex() );

	if( lowerAbil != NULL )
	{
		if( lowerAbil )
		{
			if( lowerDefine->GetSubType() == ITEM_WEAR_ONEPIECE )
			{
				switch ( lowerAbil->GetDefenseType() )
				{
				case 1:
					mArmorSets = mArmorSets | ROBES_ONEPIECE;
					break; // õ
				case 2:
					mArmorSets = mArmorSets | LIGHT_ARMOR_ONEPIECE;
					break; // 
				case 3:
					mArmorSets = mArmorSets | HEAVY_ARMOR_ONEPIECE;
					break; // ݼ
				}
			}
			else
			{
				switch ( lowerAbil->GetDefenseType() )
				{
				case 1:
					mArmorSets = mArmorSets | ROBES_LOWER;
					break; // õ
				case 2:
					mArmorSets = mArmorSets | LIGHT_ARMOR_LOWER;
					break; // 
				case 3:
					mArmorSets = mArmorSets | HEAVY_ARMOR_LOWER;
					break; // ݼ
				}
			}
		}
	}

	//// ARMOR SETS - HANDS(HAND)
	const cItem& hand = ITEMMAN->GetItem( INVENTORY_WEAR_HAND );
	cItemAbility* handAbil = ITEMMAN->GetItemAbility( hand.GetIndex() );
	if( handAbil )
	{
		switch( handAbil->GetDefenseType() )
		{
		case ITEM_MATERIAL_CLOTH:		/// õ
			mArmorSets = mArmorSets | ROBES_HANDS;
			break;
		case ITEM_MATERIAL_LEATHER:		/// 
			mArmorSets = mArmorSets | LIGHT_ARMOR_HANDS;
			break;
		case ITEM_MATERIAL_METAL:		/// ݼ
			mArmorSets = mArmorSets | HEAVY_ARMOR_HANDS;
			break;
		}
	}

	//// ARMOR SETS - FEET(HAND)
	const cItem& feet = ITEMMAN->GetItem( INVENTORY_WEAR_FOOT );
	cItemAbility* feetAbil = ITEMMAN->GetItemAbility( feet.GetIndex() );
	if( feetAbil )
	{
		switch( feetAbil->GetDefenseType() )
		{
		case ITEM_MATERIAL_CLOTH:		/// õ
			mArmorSets = mArmorSets | ROBES_FEET;
			break;
		case ITEM_MATERIAL_LEATHER:		/// 
			mArmorSets = mArmorSets | LIGHT_ARMOR_FEET;
			break;
		case ITEM_MATERIAL_METAL:		/// ݼ
			mArmorSets = mArmorSets | HEAVY_ARMOR_FEET;
			break;
		}
	}
}

void cHero::SetAreaNameIdx( unsigned long idx )
{
	mAreaNameIdx = idx;

	cMiniMapWindow* win = (cMiniMapWindow*)UIMAN->GetContainer( eUIID_MINIMAP_WINDOW );
	if( win )
		win->SetZoneName( GAMERESOURCEMAN->GetMapName( mAreaNameIdx ) );
}

void cHero::ApplyDamageDrama( unsigned int damage, unsigned int damageType, cBaseObject* pAttacker )
{
	if( mPlayerExrInfo.mChgMonsterIdx != 0 )
	{
		return ApplyDamageDrama_TransMon( damage, damageType, pAttacker );
	}

	cBaseObject::ApplyDamageDrama( damage, damageType, pAttacker );

	if( GetState() == eOBJECT_STATE_DIE )
		return;

	if( damageType < eDAMAGEPRINT_HEAL_OUR )
		CAMERAMAN->Shake();

	mDamageAfterAnim = UINT_MAX;
//	mDamageAfterAnim = ANITYPE_IDLE;

	if( mpObjectSceneNode->GetTargetAnimation() >= ANITYPE_SKILL_BEGIN && 
		mpObjectSceneNode->GetTargetAnimation() <= ANITYPE_SKILL_END )
	{
		return;
	}

	switch( mAnimationType )
	{
	case ANITYPE_SITDOWN:
	case ANITYPE_SITDOWN_IDLE:
	case ANITYPE_STANDUP:
	case ANITYPE_RUN:
	case ANITYPE_ITEMPICK:
	case ANITYPE_DAMAGE1:
	case ANITYPE_DAMAGE2:
		return;
	}

	if( mpObjectSceneNode->GetTargetAnimation() >= ANITYPE_CASTING1 && 
		mpObjectSceneNode->GetTargetAnimation() < ANITYPE_DAMAGE1 )
	{
		mDamageAfterAnim = (mpObjectSceneNode->GetTargetAnimation()/10)*10;
	}

	if( mpObjectSceneNode->GetTargetAnimation() >= ANITYPE_ATTACK1 && 
		mpObjectSceneNode->GetTargetAnimation() < ANITYPE_CASTING1 )
	{
		if( GetTargetObject() != pAttacker )
			return;

		unsigned long time = mpObjectSceneNode->GetTargetAnimationEndTime() - 200;
		if( THEAPP->GetWorldAccumTime() < time )
			return;
	}

	/// damage 
	if( damageType < eDAMAGEPRINT_HEAL_OUR )
	{
		mIdleTime = 0;

		if( damageType == eDAMAGEPRINT_CRITICAL_ENEMY || damageType == eDAMAGEPRINT_CRITICAL_OUR )
			ChangeAnimation( ANITYPE_DAMAGE2 );
		else
			ChangeAnimation( ANITYPE_DAMAGE1 );

		/// change dir
		if( mpObjectSceneNode->GetTargetAnimation() >= ANITYPE_IDLE && 
			mpObjectSceneNode->GetTargetAnimation() <= ANITYPE_IDLE2 )
		{
			if( pAttacker )
				SetDesiredDir( GetPos(), pAttacker->GetPos() ); //, 200 );
		}
		if( mAnimationType == ANITYPE_PEACE_IDLE || mAnimationType == ANITYPE_PEACE_IDLE2 )
		{
			if( pAttacker )
				SetDesiredDir( GetPos(), pAttacker->GetPos() ); //, 200 );
		}
	}
}

const cSphere& cHero::GetBoundSphere() const
{
	assert( mpObjectSceneNode );
	return mpObjectSceneNode->GetBoundSphere();
}

const NiPoint3& cHero::GetCenter() const
{
	assert( mpObjectSceneNode );
	return mpObjectSceneNode->GetCenter();
}

void cHero::SetFixedObjectSizeScale( unsigned short size )
{
	cPlayer::SetFixedObjectSizeScale( size );
	mCameraOffset = mDefaultCameraOffset * (float)size * 0.01f;
}

void cHero::ActiveQuestText( LPCTSTR msg, unsigned long color )
{
	if( mPlayerExrInfo.mChgMonsterIdx == 0 )
	{
		if( mpObjectSceneNode->GetType() == cSceneNode::eVEHICLE )
			((cVehicleSceneNode*)mpObjectSceneNode)->ActiveQuestText( msg, color );
		else
			((cHeroSceneNode*)mpObjectSceneNode)->ActiveQuestText( msg, color );
	}
	else
		((cTransMonSceneNode*)mpObjectSceneNode)->ActiveQuestText( msg, color );
}

void cHero::ActiveNoticeText( LPCTSTR msg, unsigned long color )
{
	if( mPlayerExrInfo.mChgMonsterIdx == 0 )
	{
		if( mpObjectSceneNode->GetType() == cSceneNode::eVEHICLE )
			((cVehicleSceneNode*)mpObjectSceneNode)->ActiveQuestText( msg, color );
		else
			((cHeroSceneNode*)mpObjectSceneNode)->ActiveNoticeText( msg, color );
	}
	else
		((cTransMonSceneNode*)mpObjectSceneNode)->ActiveNoticeText( msg, color );
}

void cHero::SetStaticFaceReq( unsigned long faceIdx )
{
	MSG_REQ_PLAYER_STATICFACE msg;
	msg.Category = NM_PLAYER;
	msg.Protocol = NM_PLAYER_STATICFACE_REQ;
	msg.mStaticFaceIdx = faceIdx;

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

void cHero::ProcessDelayFlag( unsigned long deltaTime )
{
	/// ȭ(Z) ư delay
	if( mPeaceToggleFlag == false )
	{
		if( mPeaceToggleTime > 1000 )
		{
			mPeaceToggleFlag = true;
			mPeaceToggleTime = 0;
		}
		else
		{
			mPeaceToggleTime += deltaTime;
		}
	}

	if( mSwitchWeaponTime )
	{
		if( mSwitchWeaponTime <= deltaTime )
			mSwitchWeaponTime = 0;
		else
			mSwitchWeaponTime -= deltaTime;
	}
}

bool cHero::IsPossibleSitDown()
{
	if( IsWeaponChanging() )
		return false;
	if( IsReadyUseSkill() == false )
		return false;
	if( GetState() == eOBJECT_STATE_DIE ||
		GetState() == eOBJECT_STATE_STOP )
		return false;

	if( mSitDownFlag == false )
		return true;

	return false;
}

void cHero::SetPartyIndex( unsigned long partyIndex )
{
	cPlayer::SetPartyIndex( partyIndex );

	if( partyIndex > 0 )
		PartyIn_Init();
	else
		PartyOut_Init();
}

void cHero::SetGuild( unsigned long guildIndex, LPCTSTR guildName, unsigned char guildPosition, unsigned long markIndex )
{
	cPlayer::SetGuild( guildIndex, guildName, guildPosition, markIndex );

	cHeroInfoWindow* win = GAMEUI->GetHeroInfoWindow();
	if( win )
		win->SetGuild( guildName );
}

void cHero::CheckTabPartyObject()
{
	if( GetPartyIndex() == 0 )
		return;

	cBaseObject* curTarget = GetTargetObject();
	if( curTarget )
	{
		if( curTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
		{
			if( PARTYMAN->IsHeroParty( curTarget->GetObjectID() ) == true )
			{
				/// next party user -> SetTarget
				PARTYMAN->ChangeTabTarget( curTarget->GetObjectID() );
				return;
			}
		}
	}

	/// first party user -> SetTarget
	PARTYMAN->ChangeTabTarget( 0 );
}

void cHero::CheckTabTargetObject()
{
	tArray<void*>& vArr = SCENEMAN->GetVisibleDynamicSceneArray();
	if( vArr.IsEmpty() )
		return;

	NiCamera* cam = CAMERAMAN->GetCurrentNi();
	NiPoint3 camDir = cam->GetWorldDirection();
	NiPoint3 heroPos = GetPos();

	///  Ÿ 5 , ο ִ üũѴ.
	if( mTabTargetList.GetSize() >= 5 )
	{
		NiTListIterator kIter = mTabTargetList.GetHeadPos();
		while( kIter )
		{
			NiTListIterator kOldIter = kIter;
			sObject* data = mTabTargetList.GetNext(kIter);
			cBaseObject* o = OBJECTMAN->GetObject( data->type, data->index );
			if( o == 0 )
			{
				sObject* rp = mTabTargetList.RemovePos(kOldIter);
				SAFE_NIDELETE(rp);
				continue;
			}

			/// Ÿ üũ
			NiPoint3 targetPos = o->GetPos();
			NiPoint3 calcPos = (heroPos - targetPos);
			calcPos.z = 0.0f;
			float len  = calcPos.Length();
			if( len > 1500 )
			{
				sObject* rp = mTabTargetList.RemovePos(kOldIter);
				SAFE_NIDELETE(rp);
				continue;
			}

			///  üũ
			NiPoint3 dir = targetPos - heroPos;
			dir.Unitize();
			float checkPos = camDir.Dot(dir);
			if( checkPos < 0.0f )
			{
				sObject* rp = mTabTargetList.RemovePos(kOldIter);
				SAFE_NIDELETE(rp);
				continue;
			}
			else
			{
				if( len > 500 && checkPos < 0.7f )
				{
					sObject* rp = mTabTargetList.RemovePos(kOldIter);
					SAFE_NIDELETE(rp);
					continue;
				}
			}

			if( o->GetObjectType() == eOBJECTTYPE_PLAYER )
			{
				if( DUELMAN->IsDuelEnemy( (cPlayer*)o ) == false &&
					PVPMAN->IsEnableAttack( (cPlayer*)o ) == false )
				{
					sObject* rp = mTabTargetList.RemovePos(kOldIter);
					SAFE_NIDELETE(rp);
					continue;
				}
			}
			else if( o->GetObjectType() != eOBJECTTYPE_MONSTER )
			{
				sObject* rp = mTabTargetList.RemovePos(kOldIter);
				SAFE_NIDELETE(rp);
				continue;
			}
		}
	}

	/// ű Ÿ ִ üũѴ.
	if( mTabTargetList.GetSize() < 5 )
	{
		for( int i=vArr.GetSize()-1; i>=0; --i )
		{
			cDynamicSceneNode* n = (cDynamicSceneNode*)vArr[i];
			cBaseObject* obj = n->GetGameObject();
			if( obj == 0 )
				continue;
			if( obj == GetTargetObject() )
				continue;
			if( obj == this )
				continue;
			if( obj->GetObjectType() == eOBJECTTYPE_NPC )
				continue;

			/// Ÿ üũ
			NiPoint3 targetPos = obj->GetPos();
			NiPoint3 calcPos = (heroPos - targetPos);
			calcPos.z = 0.0f;
			float len = calcPos.Length();
			if( len > 1500 )
				break;

			///  üũ
			NiPoint3 dir = targetPos - heroPos;
			dir.Unitize();
			float checkPos = camDir.Dot(dir);
			if( checkPos > 0.0f )
			{
				if( len > 500 && checkPos < 0.7f )
					continue;
			}
			else
				continue;

			/// ü ˻
			switch( obj->GetObjectType() )
			{
			case eOBJECTTYPE_PLAYER:
				{
					if( DUELMAN->IsDuelEnemy( (cPlayer*)obj ) == false &&
						PVPMAN->IsEnableAttack( (cPlayer*)obj ) == false )
					{
						/// ÷̾   ƴϸ Ʈ ˻  Ų.
						NiTListIterator kIter = mTabTargetList.GetHeadPos();
						while (kIter)
						{
							NiTListIterator kOldIter = kIter;
							sObject* data = mTabTargetList.GetNext(kIter);
							if( obj->GetObjectID() == data->index && data->type == obj->GetObjectType() )
							{
								sObject* rp = mTabTargetList.RemovePos(kOldIter);
								SAFE_NIDELETE(rp);
								break;
							}
						}
						continue;
					}
				}
				break;
			case eOBJECTTYPE_MONSTER:
				break;
			case eOBJECTTYPE_NPC:
			default:
				continue;
			}

			/// ü ˻簡 ٸ  5  Ͽ ִ ˻
			bool addTarget = true;
			NiTListIterator kIter = mTabTargetList.GetHeadPos();
			while (kIter)
			{
				sObject* data = mTabTargetList.Get(kIter);
				if( obj->GetObjectID() == data->index && obj->GetObjectType() == data->type )
				{
					addTarget = false;
					break;
				}
				kIter = mTabTargetList.GetNextPos(kIter);
			}

			///  ˻縦  - ο Ÿ 
			if( addTarget == true )
			{
				sObject* target = new sObject;
				target->index = obj->GetObjectID();
				target->type = obj->GetObjectType();
				mTabTargetList.AddTail( target );

				if( mTabTargetList.GetSize() > 5 )
				{
					sObject* rp = mTabTargetList.RemoveHead();
					SAFE_NIDELETE(rp);
				}

				/// set target
				HERO->SetTargetObject( target->type, target->index );
				return;
			}
		}
	}

	///  5߿ ˻ؼ óѴ.
 	NiTListIterator kIter = mTabTargetList.GetHeadPos();
	while (kIter)
	{
		NiTListIterator kOldIter = kIter;
		sObject* data = mTabTargetList.GetNext(kIter);
		cBaseObject* o = OBJECTMAN->GetObject( data->type, data->index );
		if( o == 0 )
		{
			sObject* rp = mTabTargetList.RemovePos(kOldIter);
			SAFE_NIDELETE(rp);
			continue;
		}

		/// Ÿ üũ
		NiPoint3 targetPos = o->GetPos();
		NiPoint3 calcPos = (heroPos - targetPos);
		calcPos.z = 0.0f;
		float len = calcPos.Length();
		if( len > 1500 )
		{
			sObject* rp = mTabTargetList.RemovePos(kOldIter);
			SAFE_NIDELETE(rp);
			continue;
		}

		///  üũ
		NiPoint3 dir = targetPos - heroPos;
		dir.Unitize();
		float checkPos = camDir.Dot(dir);
		if( checkPos < 0.0f )
		{
			sObject* rp = mTabTargetList.RemovePos(kOldIter);
			SAFE_NIDELETE(rp);
			continue;
		}
		else
		{
			if( len > 500 && checkPos < 0.7f )
			{
				sObject* rp = mTabTargetList.RemovePos(kOldIter);
				SAFE_NIDELETE(rp);
				continue;
			}
		}

		switch( o->GetObjectType() )
		{
		case eOBJECTTYPE_PLAYER:
			{
				if( DUELMAN->IsDuelEnemy( (cPlayer*)o ) == false &&
					PVPMAN->IsEnableAttack( (cPlayer*)o ) == false )
				{
					sObject* rp = mTabTargetList.RemovePos(kOldIter);
					SAFE_NIDELETE(rp);
					continue;
				}
			}
			break;
		case eOBJECTTYPE_MONSTER:
			break;
		case eOBJECTTYPE_NPC:
		default:
			continue;
		}

		mTabTargetList.RemovePos(kOldIter);
		mTabTargetList.AddTail(data);

		/// set target
		HERO->SetTargetObject( o->GetObjectType(), o->GetObjectID() );
		return;
	}
}

void cHero::ClearTabTargetList()
{
	NiTListIterator kIter = mTabTargetList.GetHeadPos();
	while (kIter)
	{
		sObject* data = mTabTargetList.Get(kIter);
		SAFE_NIDELETE(data);

		kIter = mTabTargetList.GetNextPos(kIter);
	}
	mTabTargetList.RemoveAll();
}

void cHero::SetAlphaBlended( float alpha )
{
	cDynamicSceneNode* n = GetSceneNode();
	if( n == 0 )
		return;

#ifdef _GMTOOL
	if( CHEATMAN->GetHideMode() )
	{
		n->SetAlphaBlended( 0.25f );
		return;
	}
#endif
	{
		n->SetAlphaBlended( alpha );
	}
}

bool cHero::TransformMonster( unsigned long monsterClassIdx )
{
	/// Ͼ or ɴ  
	if( mAnimationType == ANITYPE_STANDUP )
		SetState(eOBJECT_STATE_IDLE);
	else if( mAnimationType == ANITYPE_SITDOWN )
		mSitDownFlag = false;

	if( SKILLEXECUTER->IsSkillCharge() == true )
		SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );

	if( cPlayer::TransformMonster( monsterClassIdx ) == false )
		return false;

	ShowNameGauge( true );
	
	///  ų 
	QUICKMAN->ChangeMonster( monsterClassIdx );
	QUICKMAN->CheckSkillIcon();

	/// 
	cLookAtCamera* pCamera = (cLookAtCamera*)CAMERAMAN->GetCurrent();

	NiPoint3 sFoot = mpObjectSceneNode->GetObjectFoot();
	NiPoint3 sCenter = mpObjectSceneNode->GetObjectCenter();
	mDefaultCameraOffset = sCenter.z - sFoot.z + 22.0f;
	mCameraOffset = mDefaultCameraOffset;

	pCamera->SetLookAt( NiPoint3( sFoot.x, sFoot.y, sFoot.z + mCameraOffset ) );

	if( GetTargetObject() == this )
		SetTargetObject( eOBJECTTYPE_NONE,0 );

	SKILLEXECUTER->SetMonsterSkillInfo( monsterClassIdx );
	return true;
}

void cHero::RestoreMonster()
{
	if( SKILLEXECUTER->IsSkillCharge() == true )
		SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );

	cPlayer::RestoreMonster();

	ShowNameGauge( true );
	
	///  ų 
	QUICKMAN->ChangeMonster( 0 );
	QUICKMAN->CheckSkillIcon();

	/// 
	cLookAtCamera* pCamera = (cLookAtCamera*)CAMERAMAN->GetCurrent();

	NiPoint3 sFoot = mpObjectSceneNode->GetObjectFoot();
	NiPoint3 sCenter = mpObjectSceneNode->GetObjectCenter();
	mDefaultCameraOffset = sCenter.z - sFoot.z + 22.0f;
	mCameraOffset = mDefaultCameraOffset;

	pCamera->SetLookAt( NiPoint3( sFoot.x, sFoot.y, sFoot.z + mCameraOffset ) );

	if( GetTargetObject() == this )
		SetTargetObject( eOBJECTTYPE_NONE,0 );
}


///
void cHero::Update_TransMon( unsigned long deltaTime, unsigned long accumTime )
{
	if( mpObjectSceneNode  == NULL ) return;

	ProcessDelayFlag( deltaTime );
	DesiredDirProcess( deltaTime );

	///  Ʈ ɶ 
	if( mIsCalcStatus )
	{
		STATUSCALC->CalcPlayerExtensionGlobal();

		mpObjectSceneNode->UpdateNameCardGaugeValue();
		GAMEUI->UpdateHeroInfo();

		mIsCalcStatus  = false;
	}
	/// ųġ ġ Ʈɶ 
	else if( mIsUdateHeroInfo )
	{
		GAMEUI->UpdateExpSxp();

		mIsUdateHeroInfo = false;
	}

	/// ¿ ´ ó Ѵ.
	switch( mPlayerExrInfo.mState )
	{
	case eOBJECT_STATE_IDLE:
		{
			IdleUpdate( deltaTime );
		}
		break;
	case eOBJECT_STATE_MOVE:
		{
			MoveUpdate( deltaTime );
		}
		break;
	case eOBJECT_STATE_ATTACK:
		{
			AttackUpdate( deltaTime, accumTime );
		}
		break;
	case eOBJECT_STATE_DIE:
		{
			DieUpdate();
		}
		break;
	case ePLAYER_STATE_SITDOWN:
		{
			SitDownUpdate();
		}
		break;
	}

	/// ִϸ̼ ῡ  ó
	Interpret_TransMon( accumTime );

	/// ī޶ ó
	cLookAtCamera* pCamera = (cLookAtCamera*)CAMERAMAN->GetCurrent();
	if( pCamera )
	{
		const NiPoint3& pos = mpObjectSceneNode->GetTranslate();
		pCamera->SetLookAt( pos.x, pos.y, pos.z + mCameraOffset );
	}

	///
	WORLDMAN->MoveSkyDome( pCamera->GetWorldTranslate() );
}

void cHero::Interpret_TransMon( unsigned long time )
{
	cActorManagerForPartition*	pActor = mpObjectSceneNode->GetActorManager();
	if( !pActor ) return;

	unsigned int id = mpObjectSceneNode->GetTargetAnimation();

	float endTime = pActor->GetNextEventTime( cActorManagerForPartition::TEXT_KEY_EVENT, id, "end" );
	if( endTime == NI_INFINITY )
		return;

	if( endTime == cActorManagerForPartition::INVALID_TIME )
	{
		endTime = mpObjectSceneNode->GetTargetAnimationScaleEndTime() * 0.001f;
	}

	///  ִϸ̼   ȹ
	float checkTime = (float)mpObjectSceneNode->GetScaleAccumTime() * 0.001f;
	if( endTime > 0 && endTime <= checkTime )
	{
		if( M_ANITYPE_IDLE2 == id )
		{
			ChangeAnimation_TransMon( M_ANITYPE_IDLE1 );
		}
		else if( M_ANITYPE_ATTACK1 <= id && id <= M_ANITYPE_ATTACK3 )
		{
			SetReadyUseSkill( true );
			ChangeAnimation_TransMon( M_ANITYPE_IDLE1 );
		}
		else if( M_ANITYPE_SKILL1 <= id && id <= M_ANITYPE_SKILL2 )
		{
			SetReadyUseSkill( true );
			ChangeAnimation_TransMon( M_ANITYPE_IDLE1 );
		}
		else if( id == M_ANITYPE_DAMAGE1 || id == M_ANITYPE_DAMAGE2 )
		{
			/// ݹ޴ ִϸ̼  ⺻ ִϸ̼ ٲ۴.
			if( mDamageAfterAnim == M_ANITYPE_CASTING )
				UpdateSkillAnimation( M_ANITYPE_CASTING );
			else
			{
				ChangeAnimation_TransMon( mDamageAfterAnim );
			}
				
//				SetState( eOBJECT_STATE_IDLE );

			SetReadyUseSkill( true );
		}
	}
	else if( endTime == cActorManagerForPartition::INVALID_TIME )
	{
		return;
	}
}

void cHero::ApplyDamageDrama_TransMon( unsigned int damage, unsigned int damageType, cBaseObject* pAttacker )
{
	cBaseObject::ApplyDamageDrama( damage, damageType, pAttacker );

	if( GetState() == eOBJECT_STATE_DIE )
		return;

	if( GetState() == eOBJECT_STATE_STOP )
	{
		switch( mPlayerExrInfo.mStateStop )
		{
		case eSTOP_READYTAROT:
		case eSTOP_OPENTAROT:
		case eSTOP_OPENSTALL:
			return;
		}
	}

	if( damageType < eDAMAGEPRINT_HEAL_OUR )
		CAMERAMAN->Shake();

	unsigned int ani = mpObjectSceneNode->GetTargetAnimation();

	mDamageAfterAnim = UINT_MAX;
//	mDamageAfterAnim = M_ANITYPE_IDLE1;

	switch( ani )
	{
	case M_ANITYPE_WORK:
	case M_ANITYPE_RUN:
	case M_ANITYPE_SKILL1:
	case M_ANITYPE_SKILL2:
	case M_ANITYPE_DAMAGE1:
	case M_ANITYPE_DAMAGE2:
	case M_ANITYPE_DIE1:
	case M_ANITYPE_DIE2:
		return;
	}

	if( ani >= M_ANITYPE_MODEANI )
		return;

	if( M_ANITYPE_ATTACK1 <= ani && ani <= M_ANITYPE_ATTACK3 )
	{
		if( GetTargetObject() != pAttacker )
			return;

		unsigned long time = mpObjectSceneNode->GetTargetAnimationEndTime() - 200;
		if( THEAPP->GetWorldAccumTime() < time )
			return;
	}

	if( ani == M_ANITYPE_CASTING )
		mDamageAfterAnim = M_ANITYPE_CASTING;

	/// damage 
	if( damageType < eDAMAGEPRINT_HEAL_OUR )
	{
		mIdleTime = 0;

		if( damageType == eDAMAGEPRINT_CRITICAL_ENEMY || damageType == eDAMAGEPRINT_CRITICAL_OUR )
			mpObjectSceneNode->SetTargetAnimation( M_ANITYPE_DAMAGE2 );
		else
			mpObjectSceneNode->SetTargetAnimation( M_ANITYPE_DAMAGE1 );

		if( mpObjectSceneNode->GetTargetAnimation() == M_ANITYPE_IDLE1 || 
			mpObjectSceneNode->GetTargetAnimation() == M_ANITYPE_IDLE2 )
		{
			if( pAttacker )
				SetDesiredDir( GetPos(), pAttacker->GetPos() ); //, 10 );
		}
	}
}

bool cHero::StartAttack_Mon( unsigned long attackIdx, cBaseObject* pTarget )
{
	/// ⺻ ų ..
	unsigned long key =  SKILLMAN->CreateHeroSkillObject( attackIdx, this, pTarget, mPlayerExrInfo.mAttackSpeed );
	if( key )
	{
		///  
		SetState( eOBJECT_STATE_ATTACK );
		SetReadyUseSkill( false );

		/// 070712 PKH ų û ޼ ߼
		MSG_REQ_SKILL_USED Msg;
		Msg.Category = NM_SKILL;
		Msg.Protocol = NM_SKILL_USED_MON_REQ;//NM_SKILL_USED_REQ;
		Msg.mTarget.index = pTarget->GetObjectID();
		Msg.mTarget.type = pTarget->GetObjectType();

		Msg.mSkillClassIndex = attackIdx;

		Msg.mManagedKey = key;
		Msg.mClientPosX = HERO->GetXPos();
		Msg.mClientPosY = HERO->GetYPos();

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}

	return true;
}

void cHero::UseTargetSkill_TransMon( unsigned long skillIdx, cBaseObject* pTarget )
{
	AutoActionClear();
	SKILLEXECUTER->ChargeOff( skillIdx );

	if( IsReadyUseSkill() == false )
	{
		SetState( eOBJECT_STATE_ATTACK );
		return;
	}

	if( IsWeaponChanging() == true )
		return;


	///  Ÿ 
	if( SKILLEXECUTER->IsPossibleUseSkillTarget( skillIdx, pTarget ) == false )
		return;

	/// ߵ 
	if( SKILLEXECUTER->IsPossibleUseSkill( skillIdx ) == false )
		return;

	if( pTarget )
	{
		/// ٶ  
		NiPoint3 charDir = mDesiredDir;
		NiPoint3 viewDir = pTarget->GetPos() - GetPos();
		viewDir.z = 0.0f;
		if( viewDir != NiPoint3::ZERO )
		{
			if( viewDir.SqrLength() >= 0.001f )	
			{
				viewDir.Unitize();

				/// ȸ Matrix 
				NiMatrix3 matA, matB, matRot;
				matA.SetCol( 0, charDir );
				matA.SetCol( 1, -NiPoint3::UNIT_Z );
				matA.SetCol( 2, charDir.UnitCross( -NiPoint3::UNIT_Z ) );

				matB.SetCol( 0, viewDir );
				matB.SetCol( 1, -NiPoint3::UNIT_Z );
				matB.SetCol( 2, viewDir.UnitCross( -NiPoint3::UNIT_Z ) );

				matRot = matB * matA.Transpose();
				mpObjectSceneNode->SetRotate( mpObjectSceneNode->GetRotate()*matRot );
				mDesiredDir = viewDir;
			}
		}
	}

	unsigned long key = SKILLMAN->CreateHeroSkillObject( skillIdx, this, pTarget );
	if( key )
	{
		unsigned long monsterClassIdx = GetTransMonsterClassIdx();
		if( monsterClassIdx == 0 )
			return ;
		sMonsterSkillScript* pInfo = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)skillIdx );
		if( pInfo == 0 )
			return;

		SetState( eOBJECT_STATE_ATTACK );

		///  
		SetReadyUseSkill( false );

		/// 070712 PKH ų û ޼ ߼
		MSG_REQ_SKILL_USED Msg;
		Msg.Category = NM_SKILL;

		/// casting ִ 
		if( pInfo->mShotType == eMONSTERSHOTTYPE_CASTING )		/// 090213 PKH 
			Msg.Protocol = NM_SKILL_CAST_USED_MON_REQ;
		else
			Msg.Protocol = NM_SKILL_USED_MON_REQ;

		Msg.mSkillClassIndex = skillIdx;
		Msg.mManagedKey = key;
		Msg.mClientPosX = HERO->GetXPos();
		Msg.mClientPosY = HERO->GetYPos();

		if( pTarget )
		{
			Msg.mTarget.index = pTarget->GetObjectID();
			Msg.mTarget.type = pTarget->GetObjectType();
		}
		else
		{
			Msg.mTarget.index = 0;
			Msg.mTarget.type = eOBJECTTYPE_NONE;
		}

		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
}

void cHero::UseFieldSkill_TransMon( unsigned long skillIdx, NiPoint3 fieldPos )
{

}

void cHero::SetForceType( unsigned char forceType )
{
	cPlayer::SetForceType( forceType );

	///  UI 
	cHeroInfoWindow* info = GAMEUI->GetHeroInfoWindow();
	if( info )
		info->SetForceType( forceType );
}

void cHero::SetWindPoint( unsigned long windPoint )
{ 
	mHeroInfo.mWindPoint = windPoint; 
}

void cHero::SetWindFriendly( unsigned long windFriendly )
{ 
	mHeroInfo.mWindFriendly = windFriendly; 
}

void cHero::SetEarthPoint( unsigned long earthPoint )
{ 
	mHeroInfo.mEarthPoint = earthPoint; 
}

void cHero::SetEarthFriendly( unsigned long earthFriendly )
{ 
	mHeroInfo.mEarthFriendly = earthFriendly; 
}

void cHero::SetWaterPoint( unsigned long waterPoint )
{ 
	mHeroInfo.mWaterPoint = waterPoint; 
}

void cHero::SetWaterFriendly( unsigned long waterFriendly )
{ 
	mHeroInfo.mWaterFriendly = waterFriendly; 
}

void cHero::SetFirePoint( unsigned long firePoint )
{ 
	mHeroInfo.mFirePoint = firePoint; 
}

void cHero::SetFireFriendly( unsigned long fireFriendly )
{ 
	mHeroInfo.mFireFriendly = fireFriendly; 
}

void cHero::SetFieldEffRadius( float r )
{
	if( mpObjectSceneNode == 0 )
		return;

	if( IsTransformMonster() == true )
		((cTransMonSceneNode*)mpObjectSceneNode)->SetFieldEffRadius( r );
	else
		((cHeroSceneNode*)mpObjectSceneNode)->SetFieldEffRadius( r );
}

void cHero::UpdateFieldTargetEffect( NiPoint3 center )
{
	if( mpObjectSceneNode == 0 )
		return;

	if( IsTransformMonster() == true )
		((cTransMonSceneNode*)mpObjectSceneNode)->UpdateFieldTargetEffect( center );
	else
		((cHeroSceneNode*)mpObjectSceneNode)->UpdateFieldTargetEffect( center );
}

void cHero::SetLevel( unsigned char level )
{
	cPlayer::SetLevel( level);

	STATUSCALC->CalcPlayerBaseGlobal(); 

	mpObjectSceneNode->UpdateNameCardGaugeValue();
	
	GAMEUI->UpdateHeroInfo();
	GAMEUI->UpdateExpSxp();
}

void cHero::NowCalcStatus()
{
	STATUSCALC->CalcPlayerExtensionGlobal();

	mpObjectSceneNode->UpdateNameCardGaugeValue();
	GAMEUI->UpdateHeroInfo();

	mIsCalcStatus  = false;
}

/// 
void cHero::SetJob( ePLAYER_JOB job )
{
	/// 
	cPlayer::SetJob( job );

	/// UI Ʈ
	GAMEUI->UpdateHeroInfo();

	/// ųâ 
	cSkillWindow* skillWindow = GAMEUI->GetSkillWindow();
	if( skillWindow )
	{
		skillWindow->AddJobTab( mPlayerInfo.Job );
		skillWindow->SetCurrent( 0 );
	}

	/// ų  
	SKILLMAN->UpdateAllSkill();
}

void cHero::SetJobUsedSkillPoint( unsigned int count, unsigned short* values )
{
	if( count == 0 || values == 0 )
		return;

	if( count > mJobUsedSkillPoint.GetSize() )
	{
		assert(0);
		return;
	}

	for( unsigned int i=0; i<count; i++ )
		mJobUsedSkillPoint[i] = values[i];
}

unsigned short	cHero::GetJobUsedSkillPoint( unsigned int jobLevel )
{
	if( jobLevel > mJobUsedSkillPoint.GetSize() )
	{
		assert(0);
		return 0;
	}
	return mJobUsedSkillPoint[jobLevel];
}

bool cHero::GatheringStart( unsigned long gaderIdx, unsigned long gatherClassIdx, NiPoint3 targetPos )
{
	if( IsRideVehicle() == true )
	{
		MSGROOT msg;
		::memset( &msg, 0, sizeof(msg) );
		msg.Category = NM_PLAYER;
		msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		AlightVehicle();
	}

	sGatheringList* info = GATHERINGSCRIPT->GetGatheringInfo( gatherClassIdx );
	if( info == 0 )
	{
		assert(0);
		return false;
	}

	/// check
	if( GetLevel() < info->mNeedLevel )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 602 ) );
		return false;
	}

	if( info->mNeedItemIdx )
	{
		if( ITEMMAN->FindSlotIndex( info->mNeedItemIdx ) == 0 )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 603 ) );
			return false;
		}
	}

	if( info->mNeedQuestIdx )
	{
		if( QUESTMAN->IsCompleteGathering( info->mNeedQuestIdx ) == true )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 606 ) );
			return false;
		}
		/*if( QUESTMAN->GetQuestArrIdx( info->mNeedQuestIdx ) == -1 )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 604 ) );
			return false;
		}*/
	}

	if( info->mNeedMakeIdx )
	{
		if( CheckHeroMakeSkill( info->mNeedMakeIdx ) == false )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 604 ) );
			return false;
		}
	}

	/// casting start
	cCastingBar* pWin = (cCastingBar*)UIMAN->GetContainer( eUIID_GAME_CASTINGBAR );
	if( pWin )
		pWin->SetTime( gatherClassIdx, eCasting_Gather, GATHER_CASTING_TIME );

	///  msg
	MSG_REQ_GATHERING_START msg;
	msg.Category = NM_GATHERING;
	msg.Protocol = NM_GATHERING_START_REQ;
	msg.mObjectIdx = gaderIdx;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// type  ִ   ߰ ũ
	if( IsTransformMonster() == false )
	{
		if( info->mType == eGATHERINGTYPE_COMMON )
			ChangeAnimation( ANITYPE_GATHERING1 );
		else if( info->mType == eGATHERINGTYPE_MINING )
		{
			ChangeAnimation( ANITYPE_GATHERING2 );

			if( mGatheringToolObj != UINT_MAX )
			{
				mpObjectSceneNode->UnLinkObject( mGatheringToolObj );
				mGatheringToolObj = UINT_MAX;
			}

			/// 
			mGatheringToolObj = mpObjectSceneNode->LinkObject( eLINK_RHAND, "g_fool_001.nif" );
		}
		else
			ChangeAnimation( ANITYPE_GATHERING1 );
	}

	SetState( ePLAYER_STATE_GATHERING );

	SetDesiredDir( GetPos(), targetPos );

	return true;
}

void cHero::GatheringEnd()
{
	cCastingBar* pWin = (cCastingBar*)UIMAN->GetContainer( eUIID_GAME_CASTINGBAR );
	if( pWin )
		pWin->Hide();

	SetState( eOBJECT_STATE_IDLE );

	if( mGatheringToolObj != UINT_MAX )
	{
		mpObjectSceneNode->UnLinkObject( mGatheringToolObj );
		mGatheringToolObj = UINT_MAX;
	}
}

bool cHero::ItemMixCancel()
{
	if( GetStopFlag() == eSTOP_ITEMMIX )
	{
		ITEMMIXMAN->ItemMixCancel( false );
	}
	return true;
}

bool cHero::ItemEnhanceCancel()
{
	if( GetStopFlag() == eSTOP_ENHANCED )
	{
		ITEMMAN->TryToEnhancedCancel( false );
	}
	return true;
}

bool cHero::GatheringCancel()
{
	if( GetState() == ePLAYER_STATE_GATHERING )
	{
		cCastingBar* pWin = (cCastingBar*)UIMAN->GetContainer( eUIID_GAME_CASTINGBAR );
		if( pWin )
		{
			if( pWin->GetPercent() < 98.0f )
			{
				pWin->Hide();
				HERO->SetState( eOBJECT_STATE_IDLE );

				MSGROOT Msg;
				Msg.Category = NM_GATHERING;
				Msg.Protocol = NM_GATHERING_CANCEL_REQ;

				NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
			}
			else
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 605 ) );
				return false;
			}
		}
		else 
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 605 ) );
			return false;
		}

		if( mGatheringToolObj != UINT_MAX )
		{
			mpObjectSceneNode->UnLinkObject( mGatheringToolObj );
			mGatheringToolObj = UINT_MAX;
		}
	}

	return true;
}

bool cHero::IsCantSkill( unsigned long skillIdx )
{
	if( mIsSleep == true || mIsStun == true )
		return true;

	if( mCantSkill == true )
	{
		if( IsTransformMonster() )
		{
			if( skillIdx >= eMONSTERATTACK_SKILL1 )
				return true;
		}
		else
		{
			if( skillIdx > NORMAL_ATTACK_SKILL_MAX )
				return true;
		}
	}

	return false;
}

void cHero::RideVehicle( unsigned long vehicleIdx )
{
	cPlayer::RideVehicle( vehicleIdx );

	ShowNameGauge( true );
}

void cHero::AlightVehicle()
{
	cPlayer::AlightVehicle();

	ShowNameGauge( true );
}

void cHero::PreviewTodayWord( LPCTSTR word, unsigned long color )
{
	if( mpObjectSceneNode )
	{
		cPlayerNameCard* nameCard = (cPlayerNameCard*)mpObjectSceneNode->GetNameCard();
		if( nameCard )
			nameCard->SetTodayWord( (LPTSTR)word, color );
	}
}

void cHero::PreviewGuildMark( NiTexture* tex )
{
	if( mpObjectSceneNode )
	{
		cPlayerNameCard* nameCard = (cPlayerNameCard*)mpObjectSceneNode->GetNameCard();
		if( nameCard )
			nameCard->PreviewGuildMark( tex );
	}
}

void cHero::UpdateGuildMark()
{
	if( mpObjectSceneNode )
	{
		cPlayerNameCard* nameCard = (cPlayerNameCard*)mpObjectSceneNode->GetNameCard();
		if( nameCard )
			nameCard->ChangeGuildMark();
	}
}

bool cHero::CheckHeroMakeSkill( unsigned long makeSkillIdx )
{
	if( makeSkillIdx == 0 )
		return true;

	if( makeSkillIdx == mHeroInfo.mMakeSkill1 )
		return true;

	if( makeSkillIdx == mHeroInfo.mMakeSkill2 )
		return true;

	return false;
}

void cHero::SetMixSkillFirst( unsigned char skill1 )
{
	mHeroInfo.mMakeSkill1 = skill1;
}

void cHero::SetMixSkillSecond( unsigned char skill2 )
{
	mHeroInfo.mMakeSkill2 = skill2;
}

bool cHero::CheckGatheringEnable( unsigned long gaderClassIdx )
{
	sGatheringList* info = GATHERINGSCRIPT->GetGatheringInfo( gaderClassIdx );
	if( info == 0 )
		return false;

	if( GetLevel() < info->mNeedLevel )
	{
		return false;
	}

	if( info->mNeedItemIdx )
	{
		if( ITEMMAN->FindSlotIndex( info->mNeedItemIdx ) == 0 )
		{
			return false;
		}
	}

	if( info->mNeedQuestIdx )
	{
		//if( QUESTMAN->GetQuestArrIdx( info->mNeedQuestIdx ) == -1 )
		if( QUESTMAN->IsCompleteGathering( info->mNeedQuestIdx ) == true )
			return false;
	}

	if( info->mNeedMakeIdx )
	{
		if( HERO->CheckHeroMakeSkill( info->mNeedMakeIdx ) == false )
		{
			return false;
		}
	}

	return true;
}
