#include "StdAfx.h"
#include "HeroInfoWindow.h"

#include "Gauge.h"
#include "Label.h"
#include "GameUIManager.h"
#include "GameResourceManager.h"

#include "ObjectManager.h"

#include "LevelScript.h"
#include "ItemManager.h"
#include "UIImage.h"
#include "Player_Common.h"

cHeroInfoWindow::cHeroInfoWindow()
: mpHPGauge(0), mpMPGauge(0)
, mpEXPGauge(0), mpSXPGauge(0)
, mpWeightGuage(0)
{
	mpName = 0;
	mpRace = 0;
	mpGender = 0;
	mpClass = 0;
	mpFame = 0;	/// 
	mpGuild = 0;
	mpRank = 0;	/// 

	///  ġ
	mpLevel = 0;		/// 
	mpSkillLevel = 0;	/// ų 
	mpSkillPoint = 0;	/// ų Ʈ

	/// ͽ 
	mpStr = 0;	/// 
	mpDex = 0;	/// ø
	mpCon = 0;	/// ü
	mpInt = 0;	/// 
	mpWis = 0;	/// 

	/// ͽ ߰ 
	mpPlusStr = 0;	///  
	mpPlusDex = 0;	/// ø 
	mpPlusCon = 0;	/// ü 
	mpPlusInt = 0;	///  
	mpPlusWis = 0;	///  

	/// ġ
	mpAtt = 0;	/// ݷ
	mpDef = 0;	/// 
	mpHit = 0;	/// 
	mpAvoid = 0;	/// ȸ
	/// ġ 
	mpMag = 0;	/// 
	mpRes = 0;	/// ׷

	mpAttackCri = 0;
	mpMagicCri = 0;
	mpHPRecover = 0;
	mpMPRecover = 0;

	mpForceType = 0;
}

cHeroInfoWindow::~cHeroInfoWindow()
{
}

void cHeroInfoWindow::UIStageIn()
{
	if( HERO == 0 )
	{
		assert(0);
		return;
	}

	/// ̸
	if( mpName )
		mpName->SetText( HERO->GetName() );

	///  
	if( mpRace )
		mpRace->SetText( GAMERESOURCEMAN->GetRaceName( HERO->GetRace() ) );

	///  
	if( mpGender )
	{
		if( HERO->GetGender() == 0 || HERO->GetGender() == 2 )
			mpGender->SetText( GAMERESOURCEMAN->GetGameText( 1005 ) );		// 
		else 
			mpGender->SetText( GAMERESOURCEMAN->GetGameText( 1006 ) );		// 
	}

	UpdateHeroInfo();
	UpdateExpSxp();
}

void cHeroInfoWindow::UpdateExpSxp()
{
	if( HERO == 0 )
	{
		assert(0);
		return;
	}

	/// ĳ ġ
	sExpTable*	pExp = LEVELSCRIPT->GetExpTable( HERO->GetLevel() );
	if( pExp )
	{
		unsigned int exp = HERO->GetHeroInfo()->Exp;
		SetMAXEXP( (float)pExp->mExp );
		SetEXP( (float)exp );
	}
	else
	{
		assert(0);
		return;
	}

	/// ĳ ų ġ
	sSxpTable*	pSxp = LEVELSCRIPT->GetSxpTable( HERO->GetSkillLevel() );
	if( pSxp )
	{
		unsigned int sxp = HERO->GetHeroInfo()->SkillExp;
		SetMAXSXP( (float)pSxp->mSxp );
		SetSXP( static_cast<float>(sxp) );
	}
	else
	{
		assert(0);
		return;
	}
}

void cHeroInfoWindow::UpdateHeroInfo()
{
	assert( HERO );

	/// ĳ 
	SetLevel( HERO->GetLevel() );

	/// ĳ ų 
	SetSkillLevel( HERO->GetSkillLevel() );
	/// ĳ ų Ʈ
	SetSkillPoint( HERO->GetSkillPointRemain() );

	/// ĳ Weight , MAX Weight  
	SetMAXWeight( (float)HERO->GetMaxWeight(), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_WEIGHT ) );

	/// κ丮 
	ITEMMAN->SetMaxWeightGauge( (float)HERO->GetMaxWeight() );

	/// Ŭ
	SetClass( HERO->GetJob() );

	///  
	SetForceType( HERO->GetForceType() );

	/// 
	//SetFame( 123456 );
	
	/// 
	SetGuild( HERO->GetGuildName() );

	/// 
	//SetRank( "ӽ" );

	/// 
	SetStr( FloatToInt( HERO->GetStatus1()->mStr ), eCOLOR_WHITE );	
	/// ø
	SetDex( FloatToInt( HERO->GetStatus1()->mDex ), eCOLOR_WHITE );	
	/// ü
	SetCon( FloatToInt( HERO->GetStatus1()->mCon ), eCOLOR_WHITE );	
	/// 
	SetInt( FloatToInt( HERO->GetStatus1()->mInt ), eCOLOR_WHITE );	
	/// 
	SetWis( FloatToInt( HERO->GetStatus1()->mWis ), eCOLOR_WHITE );	


	/// ͽ ߰ 
	SetPlusStr( FloatToInt( HERO->GetStatus1Plus()->mStr ), HERO->GetBaseStatusInfoType( ePLAYER_STATUS_STR ) );
	SetPlusAgi( FloatToInt( HERO->GetStatus1Plus()->mDex ), HERO->GetBaseStatusInfoType( ePLAYER_STATUS_DEX ) );
	SetPlusCon( FloatToInt( HERO->GetStatus1Plus()->mCon ), HERO->GetBaseStatusInfoType( ePLAYER_STATUS_CON ) );
	SetPlusInt( FloatToInt( HERO->GetStatus1Plus()->mInt ), HERO->GetBaseStatusInfoType( ePLAYER_STATUS_INT ) );
	SetPlusWis( FloatToInt( HERO->GetStatus1Plus()->mWis ), HERO->GetBaseStatusInfoType( ePLAYER_STATUS_WIS ) );

	int attack = 0;
	/// ⿡  ݷ 
	if( HERO->GetWeaponState() == eWEAPON_STATE_GUN ) 
	{
		/// Ÿ 
		SetAtt( FloatToInt(HERO->GetStatus2()->mPhysicMinRangeAttack), 
				FloatToInt(HERO->GetStatus2()->mPhysicMaxRangeAttack), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_ATK ) );	
	}
	else
	{
		/// ٰŸ 
		SetAtt( FloatToInt(HERO->GetStatus2()->mPhysicMinAttack), 
				FloatToInt(HERO->GetStatus2()->mPhysicMaxAttack), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_ATK ) );	
	}

	/// 
	SetDef( FloatToInt( HERO->GetStatus2()->mPhysicDefense ), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_DEF ) );	
	
	/// 
	SetMag( FloatToInt( HERO->GetStatus2()->mMagicMinAttack ), 
			FloatToInt( HERO->GetStatus2()->mMagicMaxAttack ), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_MATK ) );	

	/// ׷
	SetRes( FloatToInt( HERO->GetStatus2()->mMagicDefense ), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_MDEF ) );	
	/// 
	SetHit( FloatToInt( HERO->GetStatus2()->mPhysicAttackRate ), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_HIT ) );	
	/// ȸ
	SetAvoid( FloatToInt( HERO->GetStatus2()->mAvoid ), HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_AVOID ) );	

	///  ũƼ
	SetAttackCritical( HERO->GetStatus2()->mPhysicCritical, HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_CRI ));
	///  ũƼ
	SetMagicCritical( HERO->GetStatus2()->mMagicCritical, HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_MCRI ));
	/// HP ȸ
	SetHPrecovery( HERO->GetStatus2()->mRecovHP, HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_RECOVHP ));
	/// MP ȸ
	SetMPrecovery( HERO->GetStatus2()->mRecovMP, HERO->GetExtStatusInfoType( ePLAYER_STATUS_EXT_RECOVMP ));

	/// HP,MP
	UpdateHeroHPMP();
}

void cHeroInfoWindow::UpdateHeroHPMP()
{
	unsigned long maxHP = HERO->GetMaxHP();
	if( mpHPGauge )
	{
		if( mpHPGauge->GetMaxValue() != maxHP )
			mpHPGauge->SetMaxValue( (float)maxHP );
	}

	unsigned long curHP = HERO->GetHP();
	if( mpHPGauge )
	{
		if( mpHPGauge->GetValue() != curHP )
			mpHPGauge->SetGaugeNoAni( (float)curHP );
	}

	unsigned long maxMP = HERO->GetMaxMP();
	if( mpMPGauge )
	{
		if( mpMPGauge->GetMaxValue() != maxMP )
			mpMPGauge->SetMaxValue( (float)maxMP );
	}

	unsigned long curMP = HERO->GetMP();
	if( mpMPGauge )
	{
		if( mpMPGauge->GetValue() != curMP )
			mpMPGauge->SetGaugeNoAni( (float)curMP );
	}
}

// ǻ : 
bool cHeroInfoWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpHPGauge = (cDoubleGauge*)GetChild( eUIID_HERO_HP_GAUGE_BAR );
	mpMPGauge = (cDoubleGauge*)GetChild( eUIID_HERO_MP_GAUGE_BAR );
	mpEXPGauge = (cGauge*)GetChild( eUIID_HERO_EXP_GAUGE_BAR );
	mpSXPGauge = (cGauge*)GetChild( eUIID_HERO_SXP_GAUGE_BAR );
	mpWeightGuage = (cGauge*)GetChild( eUIID_HERO_WEIGHT_GAUGE_BAR );

	mpLevel = (cLabel*)GetChild( eUIID_HERO_LEVEL_LABEL );	
	mpSkillLevel = (cLabel*)GetChild( eUIID_HERO_SKILLLEVEL_LABEL );	 
	mpSkillPoint = (cLabel*)GetChild( eUIID_HERO_SKILLPOINT_LABEL );	

	mpName = (cLabel*)GetChild( eUIID_HERO_NAME );	
	mpRace  = (cLabel*)GetChild( eUIID_HERO_RACE );	
	mpGender  = (cLabel*)GetChild( eUIID_HERO_GENDER );	
	mpClass  = (cLabel*)GetChild( eUIID_HERO_CLASS );	
	mpFame  = (cLabel*)GetChild( eUIID_HERO_FAME );	
	mpGuild  = (cLabel*)GetChild( eUIID_HERO_GUILD );	
	mpRank  = (cLabel*)GetChild( eUIID_HERO_RANK );	

	mpStr = (cLabel*)GetChild( eUIID_HERO_STR );	
	mpDex = (cLabel*)GetChild( eUIID_HERO_DEX );	
	mpCon = (cLabel*)GetChild( eUIID_HERO_CON );	
	mpInt = (cLabel*)GetChild( eUIID_HERO_INT );	
	mpWis = (cLabel*)GetChild( eUIID_HERO_WIS );	

	mpPlusStr = (cLabel*)GetChild( eUIID_HERO_PLUSSTR );	
	mpPlusDex = (cLabel*)GetChild( eUIID_HERO_PLUSDEX );	
	mpPlusCon = (cLabel*)GetChild( eUIID_HERO_PLUSCON );	
	mpPlusInt = (cLabel*)GetChild( eUIID_HERO_PLUSINT );	
	mpPlusWis = (cLabel*)GetChild( eUIID_HERO_PLUSWIS );	

	mpAtt = (cLabel*)GetChild( eUIID_HERO_ATT );	
	mpDef = (cLabel*)GetChild( eUIID_HERO_DEF );	
	mpHit = (cLabel*)GetChild( eUIID_HERO_HIT );	
	mpAvoid = (cLabel*)GetChild( eUIID_HERO_AVOID );	

	mpMag = (cLabel*)GetChild( eUIID_HERO_MAG );	
	mpRes = (cLabel*)GetChild( eUIID_HERO_RES );	

	mpAttackCri = (cLabel*)GetChild( eUIID_HERO_ATTACKCRI );	
	mpMagicCri = (cLabel*)GetChild( eUIID_HERO_MAGICCRI );	
	mpHPRecover = (cLabel*)GetChild( eUIID_HERO_HPRECOVER );	
	mpMPRecover = (cLabel*)GetChild( eUIID_HERO_MPRECOVER );	

	mpForceType = (cLabel*)GetChild( eUIID_HERO_FORCETYPE );
	return true;
}

/// ǻ : 
void cHeroInfoWindow::OnCommand( cUINode*, unsigned int id )
{
	if( id == eUIID_HERO_CLOSE_BUTTON )
		Hide();
}

/// ǻ : Weight 
void cHeroInfoWindow::SetWeight( float value )
{
	if( mpWeightGuage )
		mpWeightGuage->SetGaugeNoAni( value );
}

/// ǻ : max Weight   
void cHeroInfoWindow::SetMAXWeight( float value, eStateInfo_Type type )
{
	if( mpWeightGuage )
		mpWeightGuage->SetMaxValue( value );
}


/// ǻ : EXP  EXP   
void cHeroInfoWindow::SetEXP( float exp )
{
	/// EXP 
	if( mpEXPGauge )
	{
		mpEXPGauge->SetGaugeNoAni( exp );

		cStringT str;
		str.Format( _T("%.2f%"), mpEXPGauge->GetPercent() );
	}
}

/// ǻ : EXP  EXP   
void cHeroInfoWindow::SetMAXEXP( float exp )
{
	if( mpEXPGauge )
		mpEXPGauge->SetMaxValue( exp );
}

/// ǻ : ų ġ  
void cHeroInfoWindow::SetSXP( float sexp )
{
	/// sxp 
	if( mpSXPGauge )
	{
		mpSXPGauge->SetGaugeNoAni( sexp );

		cStringT str;
		str.Format( _T("%.2f%"), mpSXPGauge->GetPercent() );
	}
}

/// ǻ : ų ġ  
void cHeroInfoWindow::SetMAXSXP( float sexp )
{
	if( mpSXPGauge )
		mpSXPGauge->SetMaxValue( sexp );
}

/// ǻ :  
void cHeroInfoWindow::SetLevel( int level )
{
	if( mpLevel )
		mpLevel->SetValue( level );
}

/// ǻ : ų  
void cHeroInfoWindow::SetSkillLevel( int slevel )
{
	if( mpSkillLevel )
		mpSkillLevel->SetValue( slevel );
}

/// ǻ : ų Ʈ 
void cHeroInfoWindow::SetSkillPoint( int sp )
{
	if( mpSkillPoint )
		mpSkillPoint->SetValue( sp );
}

/// Ŭ
void cHeroInfoWindow::SetClass( unsigned long job )
{
	if( mpClass )
		mpClass->SetText( GAMERESOURCEMAN->GetJobName( job ) );
}

/// 
void cHeroInfoWindow::SetFame( int famevalue )
{
	if( mpFame )
		mpFame->SetValue( famevalue );
}
/// 
void cHeroInfoWindow::SetGuild( LPCTSTR text )
{
	int len = ::_tcslen( text );
	if( mpGuild )
	{
		if( len > 0 )
			mpGuild->SetText( text );
		else
			mpGuild->Clear();
	}
}
/// 
void cHeroInfoWindow::SetRank( LPCTSTR text )
{
	int len = ::_tcslen( text );
	if( mpRank )
	{
		if( len > 0 )
			mpRank->SetText( text );
		else
			mpRank->Clear();
	}
}
/// 
void cHeroInfoWindow::SetStr( int value, eText_Color color )	
{
	if( mpStr )
		mpStr->SetValue( value, color );
}
/// ø
void cHeroInfoWindow::SetDex( int value, eText_Color color )	
{
	if( mpDex )
		mpDex->SetValue( value, color );
}	
/// ü
void cHeroInfoWindow::SetCon( int value, eText_Color color )		
{
	if( mpCon )
		mpCon->SetValue( value, color );
}
/// 
void cHeroInfoWindow::SetInt( int value, eText_Color color )		
{
	if( mpInt )
		mpInt->SetValue( value, color );
}
/// 
void cHeroInfoWindow::SetWis( int value, eText_Color color )		
{
	if( mpWis )
		mpWis->SetValue( value, color );
}

//// ߰ 
/// 
void cHeroInfoWindow::SetPlusStr( int value, eStateInfo_Type type )	
{
	if( mpPlusStr )
	{
		cStringT str;
		if( value > 0 )
			str.Format( _T("+%d"), value );
		else
			str.Format( _T("%d"), value );

		eText_Color color = GetColorForStateType(type);
		mpPlusStr->SetTextColor( color );
		mpPlusStr->SetText( (LPCTSTR)str.Cstr() );

		if( str.IsEmpty() == false && color == eCOLOR_WHITE )
		{
			assert(0);
		}

		if( value == 0 )	
			mpPlusStr->Hide();
		else
			mpPlusStr->Show();
	}
}
/// ø
void cHeroInfoWindow::SetPlusAgi( int value, eStateInfo_Type type )	
{
	if( mpPlusDex )
	{
		cStringT str;
		if( value > 0 )
			str.Format( _T("+%d"), value );
		else
			str.Format( _T("%d"), value );

		eText_Color color = GetColorForStateType(type);
		mpPlusDex->SetTextColor( color );
		mpPlusDex->SetText( (LPCTSTR)str.Cstr() );

		if( str.IsEmpty() == false && color == eCOLOR_WHITE )
		{
			assert(0);
		}

		if( value == 0 )
			mpPlusDex->Hide();
		else
			mpPlusDex->Show();
	}
}	
/// ü
void cHeroInfoWindow::SetPlusCon( int value, eStateInfo_Type type )		
{
	if( mpPlusCon )
	{
		cStringT str;
		if( value > 0 )
			str.Format( _T("+%d"), value );
		else
			str.Format( _T("%d"), value );

		eText_Color color = GetColorForStateType(type);
		mpPlusCon->SetTextColor( GetColorForStateType(type) );
		mpPlusCon->SetText( (LPCTSTR)str.Cstr() );

		if( str.IsEmpty() == false && color == eCOLOR_WHITE )
		{
			assert(0);
		}

		if( value == 0 )	
			mpPlusCon->Hide();
		else
			mpPlusCon->Show();
	}
}
/// 
void cHeroInfoWindow::SetPlusInt( int value, eStateInfo_Type type )		
{
	if( mpPlusInt )
	{
		cStringT str;
		if( value > 0 )
			str.Format( _T("+%d"), value );
		else
			str.Format( _T("%d"), value );

		eText_Color color = GetColorForStateType(type);
		mpPlusInt->SetTextColor( GetColorForStateType(type) );
		mpPlusInt->SetText( (LPCTSTR)str.Cstr() );

		if( str.IsEmpty() == false && color == eCOLOR_WHITE )
		{
			assert(0);
		}

		if( value == 0 )	
			mpPlusInt->Hide();
		else
			mpPlusInt->Show();
	}
}
/// 
void cHeroInfoWindow::SetPlusWis( int value, eStateInfo_Type type )		
{
	if( mpPlusWis )
	{
		cStringT str;
		if( value > 0 )
			str.Format( _T("+%d"), value );
		else
			str.Format( _T("%d"), value );

		mpPlusWis->SetTextColor( GetColorForStateType(type) );
		mpPlusWis->SetText( (LPCTSTR)str.Cstr() );

		if( value == 0 )
			mpPlusWis->Hide();
		else
			mpPlusWis->Show();
	}
}

/// ġ
/// ݷ
void cHeroInfoWindow::SetAtt( int min, int max, eStateInfo_Type type )		
{
	if( mpAtt )
	{
		cStringT str;
		str.Format( _T("%d~%d"), min, max );

		/// 
		mpAtt->SetTextColor( GetColorForStateType(type) );
		mpAtt->SetText( (LPCTSTR)str.Cstr() );
	}
}
/// 
void cHeroInfoWindow::SetDef( int value, eStateInfo_Type type )		
{
	if( mpDef )
		mpDef->SetValue( value, GetColorForStateType(type) );
}
/// 
void cHeroInfoWindow::SetHit( int value, eStateInfo_Type type )		
{
	if( mpHit )
		mpHit->SetValue( value, GetColorForStateType(type) );
}
/// ȸ
void cHeroInfoWindow::SetAvoid( int value, eStateInfo_Type type )		
{
	if( mpAvoid )
		mpAvoid->SetValue( value, GetColorForStateType(type) );
}

/// 
void cHeroInfoWindow::SetMag( int min, int max, eStateInfo_Type type )		
{
	if( mpMag )
	{
		cStringT str;
		str.Format( _T("%d~%d"), min, max );

		/// 
		mpMag->SetTextColor( GetColorForStateType(type) );
		mpMag->SetText( (LPCTSTR)str.Cstr() );
	}
}
/// ׷
void cHeroInfoWindow::SetRes( int value, eStateInfo_Type type )		
{
	if( mpRes )
		mpRes->SetValue( value, GetColorForStateType(type) );
}

///  ũƼ
void cHeroInfoWindow::SetAttackCritical( float value, eStateInfo_Type type )
{
	if( mpAttackCri )
	{
		cStringT str;
		str.Format( _T("%.2f%"), value );

		mpAttackCri->SetTextColor( GetColorForStateType(type) );
		mpAttackCri->SetText( (LPCTSTR)str.Cstr() );
	}
}

///  ũƼ
void cHeroInfoWindow::SetMagicCritical( float value, eStateInfo_Type type )
{
	if( mpMagicCri )
	{
		cStringT str;
		str.Format( _T("%.2f%"), value );

		mpMagicCri->SetTextColor( GetColorForStateType(type) );
		mpMagicCri->SetText( (LPCTSTR)str.Cstr() );
	}
}

/// HP ȸ
void cHeroInfoWindow::SetHPrecovery( float value, eStateInfo_Type type )
{
	if( mpHPRecover )
	{
		cStringT str;
		str.Format( _T("%.2f%"), value );

		/// 
		mpHPRecover->SetTextColor( GetColorForStateType(type) );
		mpHPRecover->SetText( (LPCTSTR)str.Cstr() );
	}
}

/// MP ȸ
void cHeroInfoWindow::SetMPrecovery( float value, eStateInfo_Type type )
{
	if( mpMPRecover )
	{
		cStringT str;
		str.Format( _T("%.2f%"), value );

		/// 
		mpMPRecover->SetTextColor( GetColorForStateType(type) );
		mpMPRecover->SetText( (LPCTSTR)str.Cstr() );
	}
}

///  Ÿ
void cHeroInfoWindow::SetForceType( unsigned char type )
{
	int textIdx = 0;
	switch( type )
	{
	case eFORCETYPE_NONE:	textIdx = 119;	break;
	case eFORCETYPE_FIRE:	textIdx = 120;	break;
	case eFORCETYPE_WATER:  textIdx = 121;	break;
	case eFORCETYPE_WIND:	textIdx = 122;	break;
	case eFORCETYPE_EARTH:	textIdx = 123;	break;
	default: assert(0); return;
	}

	if( mpForceType )
		mpForceType->SetText( UIMAN->GetUIText( textIdx ) );
}

///
eText_Color cHeroInfoWindow::GetColorForStateType( eStateInfo_Type type )
{
	eText_Color color = mDefaultColor;

	switch( type )
	{
	case eSTATE_NORMAL:		color = mDefaultColor;		break;
	case eSTATE_PLUS:		color = eCOLOR_GREEN;		break;
	case eSTATE_MINUS:		color = eCOLOR_RED;			break;
	case eSTATE_OVERLAPPLUS:
	case eSTATE_OVERLAPMINUS:
		color = eCOLOR_YELLOW;
		break;
	}

	return color;
}
