#include "StdAfx.h"
#include "HeroStateWindow.h"

#include "FontAgent.h"

#include "Label.h"
#include "Gauge.h"
#include "UIImage.h"
#include "ArcGauge.h"

#include "ObjectManager.h"
#include "Hero.h"

#include "LevelScript.h"

cHeroStateWindow::cHeroStateWindow()
: mpName(0)
, mpHPGauge(0)
, mpMPGauge(0)
, mpSXPGauge(0)
, mpEXPGauge(0)
, mpFace(0)
, mpLevelImage(0)
, mpLevelSkin(0)
{
}

cHeroStateWindow::~cHeroStateWindow()
{
	SAFE_DELETE( mpLevelImage );
}

void cHeroStateWindow::UIStageIn()
{
	if( !mpName || !HERO )
	{
		assert(0);
		return;
	}

	/// ̸
	LPTSTR str = HERO->GetName();
	if( mpName )
		mpName->SetText(str);
	
	///  ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	cString skinName;
	unsigned int imgIndex = GetImageIndex( HERO->GetRace(), HERO->GetGender() );
	switch( imgIndex )
	{
	case 0:		skinName = "Face_Human_M";		break;
	case 1:		skinName = "Face_Beast_M";		break;
	case 2:		skinName = "Face_Elf_M";		break;
	case 3:		skinName = "Face_Human_W";		break;
	case 4:		skinName = "Face_Beast_W";		break;
	case 5:		skinName = "Face_Elf_W";		break;
	}

	/// 
	mpFaceSkin = pSkin->GetNodeSkin( skinName.Cstr() );
	if( mpFaceSkin && mpFace )
	{
		unsigned int tx = mpFaceSkin->mSkinInfo->mTexX;
		unsigned int ty = mpFaceSkin->mSkinInfo->mTexY;
		unsigned int w = mpFaceSkin->mSkinInfo->mWidth;
		unsigned int h = mpFaceSkin->mSkinInfo->mHeight;
		mpFace->ChangeImage( tx, ty );
	}

	///  ʱȭ
	UpdateHeroInfo();
	UpdateExpSxp();
}

void cHeroStateWindow::UpdateExpSxp()
{
	if( HERO == 0 )
	{
		assert(0);
		return;
	}

	/// ĳ ġ
	sExpTable*	pExp = LEVELSCRIPT->GetExpTable( HERO->GetLevel() );
	if( pExp )
	{
		unsigned int exp = HERO->GetHeroInfo()->Exp;

		SetMaxEXPGauge( (float)pExp->mExp );
		SetEXPGauge( static_cast<float>(exp) );
	}
	else
	{
		assert(0);
		return;
	}

	///
	sSxpTable*	pSxp = LEVELSCRIPT->GetSxpTable( HERO->GetSkillLevel() );
	if( pSxp )
	{
		unsigned int sxp = HERO->GetHeroInfo()->SkillExp;

		SetMAXSXP( (float)pSxp->mSxp );
		SetSXP( static_cast<float>(sxp) );
	}
	else
	{
		assert(0);
		return;
	}

}

void cHeroStateWindow::UpdateHeroInfo()
{
	if( HERO == 0 )
	{
		assert(0);
		return;
	}

	///  
	SetLevel( HERO->GetLevel() );

	/// hp, mp
	UpdateHeroHPMP();
}

void cHeroStateWindow::UpdateHeroHPMP()
{
	if( HERO == 0 )
	{
		assert(0);
		return;
	}

	/// hp, mp
	unsigned long maxHP = HERO->GetMaxHP();
	unsigned long curHP = HERO->GetHP();
	if( mpHPGauge && mpHPGauge->GetMaxValue() != maxHP )
		mpHPGauge->SetMaxValue( (float)maxHP );

	if( mpHPGauge && mpHPGauge->GetValue() != curHP )
		mpHPGauge->SetGaugeNoAni( (float)curHP );

	unsigned long maxMP = HERO->GetMaxMP();
	unsigned long curMP = HERO->GetMP();
	if( mpMPGauge && mpMPGauge->GetMaxValue() != maxMP )
		mpMPGauge->SetMaxValue( (float)maxMP );

	if( mpMPGauge && mpMPGauge->GetValue() != curMP )
		mpMPGauge->SetGaugeNoAni( (float)curMP );
}

char cHeroStateWindow::GetImageIndex( char race, char gender )
{
	/// ڸ ״ 
	///  ڸ,
	char result = race;
	if( gender == eGENDER_FEMALE )
	{
		if( race == eRACE_HUMAN ) result = 3;
		if( race == eRACE_BEAST ) result = 4;
		if( race == eRACE_ELF ) result = 5;
	}

	return result;
}

void cHeroStateWindow::CreateFace()
{
	///  ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	/// Ʈ 
	mpFaceSkin = pSkin->GetNodeSkin( "Face_Human_M" );
	if( mpFace )
	{
		unsigned int tx = mpFaceSkin->mSkinInfo->mTexX;
		unsigned int ty = mpFaceSkin->mSkinInfo->mTexY;
		mpFace->ChangeImage( tx, ty );
	}
}


void cHeroStateWindow::CreateLevelImage()
{
	///   ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	/// Ʈ 
	mpLevelSkin = pSkin->GetNodeSkin( "HeroState_LevelImg" );
	mpLevelImage = new cUIImage( mpLevelSkin->mpTexture );
	if( mpLevelImage )
	{
		unsigned int tx = mpLevelSkin->mSkinInfo->mTexX;
		unsigned int ty = mpLevelSkin->mSkinInfo->mTexY;
		unsigned int x = mpLevelSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpLevelSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		unsigned int w = mpLevelSkin->mSkinInfo->mWidth;
		unsigned int h = mpLevelSkin->mSkinInfo->mHeight;
		mpLevelImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpLevelImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}
}

/// ǻ : 
bool cHeroStateWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpFace = (cLabel*)GetChild( eUIID_GAME_HERO_FACE );
	if( mpFace )
		mpFace->SetExceptEvent( true );

	mpName = (cLabel*)GetChild( eUIID_GAME_HERO_NAME_LABEL );
	mpHPGauge = (cDoubleGauge*)GetChild( eUIID_GAME_HERO_HP_GAUGE_BAR );
	mpMPGauge = (cDoubleGauge*)GetChild( eUIID_GAME_HERO_MP_GAUGE_BAR );
	mpSXPGauge = (cGauge*)GetChild( eUIID_GAME_HERO_SXP_GAUGE_BAR );
	mpEXPGauge = (cGauge*)GetChild( eUIID_GAME_HERO_EXP_GAUGE_BAR );

	/// ĳ ̹ 
	CreateFace();

	///   ̹
	CreateLevelImage();
	return true;
}

/// ǻ : 
bool cHeroStateWindow::HandleEvent( const cUIEvent& event )
{
	if( mEnabled == false )
		return mpParent->HandleEvent( event );

	switch( event.mType )
	{
	case eUIEVENT_LBUTTON_DOWN:
		{
			if( mpFace->ContainPoint( event.mPos ) )
			{
				HERO->SetTargetObject( eOBJECTTYPE_HERO, HERO->GetObjectID() );
				return true;
			}
		}
		break;
	}

	return cUIWindow::HandleEvent( event );
}

void cHeroStateWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpLevelImage && mpLevelSkin )
	{
		short x = (short)(mpLevelSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft);
		short y = (short)(mpLevelSkin->mSkinInfo->mY + GetAbsoluteRect().mTop);
		mpLevelImage->SetPos( x, y );
	}
}

void cHeroStateWindow::OnRender(cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	if( mpLevelSkin )
	{
		cUIRect rc;
		rc.mLeft = mpLevelSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		rc.mTop = mpLevelSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		rc.mRight = rc.mLeft + mpLevelSkin->mSkinInfo->mWidth;
		rc.mBottom = rc.mTop + mpLevelSkin->mSkinInfo->mHeight;

		unsigned int px = rc.mLeft + (int)((rc.GetWidth() - FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, mLevel.Cstr(), mLevel.GetLength())) * 0.5f);
		unsigned int py = rc.mTop + (int)((rc.GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_UI)) * 0.5f);
		pKeeper->AddFontItem( cFontAgent::eFont_System, (LPCTSTR)mLevel.Cstr(), px, py, mDefaultColor );
	}

	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		if( ((cUINode*)(*i))->IsVisible() == true )
		{
			((cUINode*)(*i))->OnRender(pKeeper);
		}
	}

	///  ̹
	if( mpLevelImage )
		mpLevelImage->Draw();

	pKeeper->DrawAll();
}

/// ǻ : 
void cHeroStateWindow::SetLevel( int level )
{
	mLevel.Format( _T("%d"), level );
}

/// ǻ :  SXP  
void cHeroStateWindow::SetSXP( float value )
{
	if( mpSXPGauge )
		mpSXPGauge->SetGaugeNoAni( value );
}
/// ǻ : ִ SXP  
void cHeroStateWindow::SetMAXSXP( float value )
{
	if( mpSXPGauge )
		mpSXPGauge->SetMaxValue( value );
}

void cHeroStateWindow::SetMaxEXPGauge( float value )
{
	if( mpEXPGauge )
		mpEXPGauge->SetMaxValue( value );
}

void cHeroStateWindow::SetEXPGauge( float value )
{
	if( mpEXPGauge )
		mpEXPGauge->SetGaugeNoAni( value );
}
