/*-- Include
*/
#include "StdAfx.h"

#include "iocpclient.h"
#include "criticalsectionlock.h"

#include "StageManager.h"
#include "UIMsgboxEvent.h"

/*-- Local definitions
*/
#pragma warning( disable: 4127 )
#pragma warning( disable: 4702 )

#define SafeCloseHandle(P)  if (P!=NULL) { CloseHandle(P); (P)=NULL; } // ڵ鸦 ϰ 
#define SafeDelete(P)       if (P!=NULL) { delete(P);      (P)=NULL; } // "


#pragma pack(1) // 1Byte  

struct Login2Game : Packet
{
	unsigned long  ipv4;
	unsigned short port;
};
struct Game2Game : Packet
{
	unsigned long  ipv4;
	unsigned short port;
};

#pragma pack( ) // 1Byte  


/*-- Global data
*/
cIOCPClient* cIOCPClient::mIOCPClient = NULL;

#define MAX_RC5_KEY				16

RC5_32_KEY RC5_32_KEY_TABLE[ MAX_RC5_KEY ];

BYTE SY_KEY_TABLE[16][4]=
{
	{ 0x17,0xb3,0x67,0xaa },	//0
	{ 0x53,0xf2,0x74,0xb1 },	//1
	{ 0x8c,0x72,0x59,0x32 },	//2
	{ 0x98,0xea,0x55,0x29 },	//3
	{ 0x4B,0x1C,0x15,0x11 },	//4
	{ 0xE8,0x9B,0x3A,0x8A },	//5
	{ 0x0F,0xAD,0x37,0x6C },	//6
	{ 0xD9,0x64,0x28,0x5C },	//7
	{ 0xB3,0xB7,0xEC,0x7B },	//8
	{ 0x9C,0x13,0xFE,0xF5 },	//9
	{ 0x5C,0x55,0x6A,0xD8 },	//10
	{ 0x6C,0xA9,0xDB,0x64 },	//11
	{ 0x5A,0xBE,0xF2,0xF6 },	//12
	{ 0xA6,0x4D,0x8F,0xB9 },	//13
	{ 0x67,0x9F,0x7D,0xF6 },	//14
	{ 0xCA,0x6A,0xA9,0xEF },	//15
};

BYTE SY_RKEY_TABLE[16][4]=
{
	{ 0xC0,0x3C,0x06,0xEA },	//0
	{ 0xB9,0x78,0xB3,0x45 },	//1
	{ 0x88,0x48,0xC0,0x71 },	//2
	{ 0x85,0x4C,0xB6,0xE7 },	//3
	{ 0x98,0xAE,0xD9,0xBF },	//4
	{ 0x2D,0x83,0x06,0x55 },	//5
	{ 0x44,0x95,0xAF,0x99 },	//6
	{ 0x43,0xC8,0x53,0x63 },	//7
	{ 0x3B,0xB1,0x60,0x0B },	//8
	{ 0x19,0x2D,0x57,0xC6 },	//9
	{ 0x68,0xCC,0x56,0x3A },	//10
	{ 0x5C,0xF8,0x90,0x4A },	//11
	{ 0xA1,0x8A,0x0B,0x70 },	//12
	{ 0x28,0x45,0x80,0xB1 },	//13
	{ 0x71,0x9D,0x4A,0x80 },	//14
	{ 0x54,0x1B,0x0F,0x9C },	//15
};

// ErrorLog prototype
void ErrorLog( char* format, ... )
{
	LPVOID  msgBuf = NULL;
	DWORD   bufferLength;

	va_list args;

	va_start( args, format );

	bufferLength = _vscprintf( format, args ) + 1;
	msgBuf       = malloc( bufferLength );

	vsprintf( (char*)msgBuf, format, args );

	va_end( args );

	if ( msgBuf != NULL )
	{
		FILE*      stream = NULL;
		char       filename[ MAX_PATH ];
		SYSTEMTIME systemtime;
		char       buffer[ 1024 ];

		GetLocalTime( &systemtime );

		sprintf( filename,
				 "Network_%04d_%02d_%02d.log",
				 systemtime.wYear,
				 systemtime.wMonth,
				 systemtime.wDay );

		stream = fopen( filename, "at" );
		if ( stream != NULL )
		{
			sprintf( buffer,
					 "%04d %02d %02d::%02d %02d %02d : %s\n",
					 systemtime.wYear,
					 systemtime.wMonth,
					 systemtime.wDay,
					 systemtime.wHour,
					 systemtime.wMinute,
					 systemtime.wSecond,
					 (char*)msgBuf );

			fputs( buffer, stream );
			fclose( stream );
		}

		free( msgBuf );
	}
}
/*-- cIOCPClient Constructor
*/
cIOCPClient::cIOCPClient(HWND wnd, DWORD messageID) : mWnd( wnd ), mMessageID( messageID )
{
	//  .
	mIOCPClient = this;

	// ws2_32.dll غ
	mVersionRequested = MAKEWORD(2,2);
	::WSAStartup( mVersionRequested, &mWsaData );

	// Critical Section ʱȭ.
	InitializeCriticalSection( &mCs );

	// κ ʱȭ.
	mIocp                   = NULL;
	mSocket                 = INVALID_SOCKET;
	mIocpWorkerThreadNumber = 0;

	mIoContextPool          = NULL;

	mConnectThread          = NULL;
	mConnected              = false;
	mConnectionResult       = true;

	mRC5Enable              = true;

	mLastTos                = 0;
	mLastCategory           = 0;
	mLastProtocol           = 0;

	/*-- ...
	*/
	RC5_32_KEY*   rc532Key  = RC5_32_KEY_TABLE;		// ...
	unsigned char tiv1[ 4 ] = {'I','R','I','S'};	// ...
	unsigned char tiv2[ 4 ] = {'S','I','R','I'};	// ...
	DWORD         skey[ 2 ];						// ...

	memset( RC5_32_KEY_TABLE, 0, sizeof(RC5_32_KEY_TABLE) );

	for ( int i = 0; i < MAX_RC5_KEY; i++, rc532Key++ )
	{
		skey[ 0 ] = (*(DWORD*)(SY_RKEY_TABLE + i)) ^ (*(DWORD*)tiv1);
		skey[ 1 ] = (*(DWORD*)(SY_RKEY_TABLE + i)) ^ (*(DWORD*)tiv2);

		RC5_32_set_key( rc532Key, sizeof(skey), (unsigned char*)&skey, RC5_8_ROUNDS );
	}
}

/*-- ~cIOCPClient Destructor
*/
cIOCPClient::~cIOCPClient(void)
{
	// 
	Shutdown( );

	// Critical Section .
	DeleteCriticalSection( &mCs );

	// ws2_32.dll 
	::WSACleanup( );

	//  ڵ & ޽ ʱ.
	mWnd        = NULL;
	mMessageID  = 0;

	//   .
	mIOCPClient = NULL;
}

/*-- Initialize Method
*/
bool cIOCPClient::Initialize(unsigned short numWorkerThreads)
{
	/*-- CreateIoCompletionPort ̿Ͽ completion port Ʈ   Ϲ Ű  
		 ʹ NumberOfConcurrentThreads ̴. ó 3 Ķʹ   ʴ´.

		 NumberOfConcurrentThreads  completion port Ͽ  带  ΰ 
		 .  ̻   context switching ϱ Ͽ 񽺿 Ͽ ϳ 
		  ϳ 常 ϵ ϴ ̴. NumberOfConcurrentThreads  0 ϸ 
		  μ    ҴϿ Ѵ.
		 (ϳ CPU Ͽ IOCP ϳ ϳ 带 )
	*/
	mIocp = CreateIoCompletionPort( INVALID_HANDLE_VALUE, NULL, 0, 0 );
	if ( mIocp == NULL )
		return false;

	/*-- CreateIoCompletionPort Ʈ  ڿ ۾带 ϰ ڵ   ִµ,
	     ̶ ϴ ۾, 尡 ϵ ɼ ִٸ, NumberOfConcurrentThreads  
		   ϴ  . NumberOfConcurrentThreadsŭ 尡 ׻ ǰ   ֱ 
		 , ϵ 尡 ִٸ ٸ 尡   ̱ ̴.
	*/
	SYSTEM_INFO si;
	DWORD       threadId;

	// ýۿ   μ ִ ȮѴ.
	GetSystemInfo( &si );

	mIocpWorkerThreadNumber = min( si.dwNumberOfProcessors * numWorkerThreads, IOCP_MAX_WORKER_THREAD );
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		mIocpWorkerThread[i] = CreateThread( NULL, 0, WorkerThreadStartingPoint, (LPVOID)this, 0, &threadId );
		if ( mIocpWorkerThread[i] == NULL )
			return false;
	}

	/*-- I/O Context Pool Ѵ.
	*/
	mIoContextPool = new cIoContextPool( );
	if ( mIoContextPool == NULL )
		return false;

	// ȯ溯 .
	mConnected        = false;
	mConnectionResult = true;
	return true;
}

/*-- Shutdown Method
*/
void cIOCPClient::Shutdown(DWORD maxWait)
{
	/*-- Connect Thread ɶ .
	*/
	WaitForSingleObjectEx( mConnectThread, maxWait, TRUE );
	SafeCloseHandle( mConnectThread );

	/*--  .
	*/
	SOCKET sockTemp = mSocket;

	/*--  ϰ Ѵ.
	*/
	mSocket           = INVALID_SOCKET;
	mConnected        = false;
	mConnectionResult = false;

	if ( sockTemp != INVALID_SOCKET )
	{
		closesocket( sockTemp );
	}

	/*-- Worket Thread û.
	*/
	if ( mIocp != NULL )
	{
		for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
		{
			PostQueuedCompletionStatus( mIocp, 0, 0, IOCP_SHUTDOWN );
		}
	}

	/*-- Worket Thread Ȯ  .
	*/
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		if ( WaitForSingleObject( mIocpWorkerThread[ i ], 60000 ) != WAIT_OBJECT_0 )
		{
			DWORD exitCode;
			GetExitCodeThread( mIocpWorkerThread[ i ], &exitCode);
			if ( exitCode == STILL_ACTIVE )
			{
				TerminateThread( mIocpWorkerThread[ i ], 0 );
			}
		}
		SafeCloseHandle( mIocpWorkerThread[ i ] );
	}

	/*-- Overlapped I/O Model Pool Socket Context Pool Ѵ.
	*/
	SafeDelete( mIoContextPool );

	/*-- completion port Ѵ.
	*/
	SafeCloseHandle( mIocp );
}

/// PostConnect Method
bool cIOCPClient::PostConnect(char* addr, unsigned short port)
{
	cCSLock lock( &mCs );

	if ( mConnectThread != NULL )
		return false;

	// ּҺȯ.
	ZeroMemory( (void*)&mAddr, sizeof(mAddr) );
	mAddr.sin_family = AF_INET;
	mAddr.sin_port   = htons( port );
	mAddr.sin_addr.s_addr = inet_addr( addr );

	if ( mAddr.sin_addr.s_addr == INADDR_NONE )
	{
		PHOSTENT phe = gethostbyname( addr );
		// the host name for the server is not in dot format, therefore try it just as a string
		if ( phe != NULL )
			CopyMemory( &mAddr.sin_addr, phe->h_addr_list[0], phe->h_length );
		else
			return false;
	}

	return PostConnect( );
}
bool cIOCPClient::PostConnect(unsigned long ipv4, unsigned short port)
{
	cCSLock lock( &mCs );

	if ( mConnectThread != NULL )
		return false;

	// ּҺȯ.
	ZeroMemory( (void*)&mAddr, sizeof(mAddr) );
	mAddr.sin_family = AF_INET;
	mAddr.sin_port   = htons( port );
	mAddr.sin_addr.s_addr = ipv4;

	if ( mAddr.sin_addr.s_addr == INADDR_NONE )
		return false;

	return PostConnect( );
}
bool cIOCPClient::PostConnect( )
{
	// ϰ˻.
	if ( mSocket != INVALID_SOCKET )
	{
		closesocket( mSocket );
		mSocket = INVALID_SOCKET;
	}

	// connect Ŭ̾Ʈ  Ѵ.
	mSocket = WSASocket( AF_INET, SOCK_STREAM, IPPROTO_IP, NULL, 0, WSA_FLAG_OVERLAPPED );
	if ( mSocket == INVALID_SOCKET )
		return false;

	//   ʱȭ.
	mConnected        = false;
	mConnectionResult = false;

	DWORD threadId;
	mConnectThread = CreateThread( NULL, 0, ConnectThreadStartingPoint, (LPVOID)this, 0, &threadId );
	return (mConnectThread != NULL) ? true : false;
}

/*-- GetConnectionResult Method;
*/
bool cIOCPClient::GetConnectionResult( )
{
	cCSLock lock( &mCs );

	/*-- Connect Thread ɶ .
	*/
	WaitForSingleObjectEx( mConnectThread, INFINITE, TRUE );
	SafeCloseHandle( mConnectThread );

	if ( mConnected == true )
	{
		/*-- The purpose of this algorithm is to reduce the number of very small segments sent, especially on
		high-delay (remote) links.

		Windows Sockets applications can disable the Nagle algorithm for their connections by setting the
		TCP_NODELAY socket option. However, this practice should be used wisely and only when needed because
		this practice increases network traffic. Usually, applications that need to disable the Nagle algorithm
		are applications that need to send small packets and require that the peer application receive them
		immediately. Some network applications may not perform well if their design does not take into account
		the effects of transmitting large numbers of small packets and the Nagle algorithm.

		Nagel ˰  Ư () ũ ũⰡ  ׸Ʈ ۵Ǵ Ƚ ̴
		̴.

		Windows   α׷ ڽ ῡ  Nagle ˰    TCP_NODELAY
		 ɼ   ֽϴ. ׷ ̷ ۾ Ʈũ ̿ ø  ݵ ʿ
		찡 ƴϸ   ʾƾ մϴ. ټ  Ŷ   ߻ϴ  Nagle
		˰   ·  Ʈũ  α׷     ֽϴ.
		Nagle ˰ ɻ   TCP  ϴ   ʽϴ. Windows 2000
		Netbt  ȣƮ / Ӹ ƴ϶ TCP  NetBIOS ῡ ؼ ̱۸
		   ϴ.  ټ     ϴ  α׷  
		  ֽϴ. ׷  α׷δ  /    ϴ  
		׷   ֽϴ. 

		BOOL nodelay = TRUE;
		if ( setsockopt( mSocket, IPPROTO_TCP, TCP_NODELAY, (BOOL*)&nodelay, sizeof(BOOL) ) == SOCKET_ERROR )
		return false;
		*/

		int zero;
		/*-- Disable receive buffering on the socket. Setting SO_RCVBUF to 0 causes winsock to stop bufferring
			receive and perform receives directly from our buffers, thereby reducing CPU usage.

			SO_RCVBUF 0Ͽ Ź۸  ʴ´. Ź۰ 0 ƴϸ ʿϰ  Ź۸
			ļ overlapped I/O ȣ   ۷ 簡 ̷.
			Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
			.
		*/
		zero = 0;
		if ( setsockopt( mSocket, SOL_SOCKET, SO_RCVBUF, (char*)&zero, sizeof(zero)) == SOCKET_ERROR )
		{
			closesocket( mSocket );
			mSocket = INVALID_SOCKET;
			return (mConnectionResult = false);
		}

		/*-- Disable send buffering on the socket. Setting SO_SNDBUF to 0 causes winsock to stop bufferring
			sends and perform sends directly from our buffers, thereby reducing CPU usage.

			SO_SNDBUF 0Ͽ ۽Ź۸  ʴ´. ۽Ź۰ 0 ƴϸ ʿϰ  ۽Ź۸
			ļ overlapped I/O ȣ   ۷ 簡 ̷.
			۽Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
			.
		*/
		zero = 0;
		if ( setsockopt( mSocket, SOL_SOCKET, SO_SNDBUF, (char*)&zero, sizeof(zero) ) == SOCKET_ERROR )
		{
			closesocket( mSocket );
			mSocket = INVALID_SOCKET;
			return (mConnectionResult = false);
		}

		LINGER linger;
		/*-- closesocket Լ ȣ Ŀ  Ϳ  ó ϱ  ɼ̴.
			linger::u_short l_onoff  : option on/off
			linger::u_short l_linger : linger time

			SO_LINGER ɼ ŸӾƿ 0 ϸ (linger ü l_onoff ʵ带 0 ƴѰ, l_linger
			 0 ),  ۵  Ͱ ִ closesocket Լ ȣ ϵ ʰ 
			. ̷ ȣ   (virtual circuit)  (reset)ǰ ۵  
			ʹ սǵȴ.  ϴ   Լ WSAECONNRESET Ѵ.
		*/
		linger.l_onoff  = 1;
		linger.l_linger = 0;
		if ( setsockopt( mSocket, SOL_SOCKET, SO_LINGER, (char*)&linger, sizeof(linger) ) == SOCKET_ERROR )
		{
			closesocket( mSocket );
			mSocket = INVALID_SOCKET;
			return (mConnectionResult = false);
		}

		/*-- connect Ͽ ϵ  ڵ completion port ҴѴ.
		*/
		if ( CreateIoCompletionPort( (HANDLE)mSocket, mIocp, (ULONG_PTR)NULL, 0 ) == NULL )
		{
			closesocket( mSocket );
			mSocket = INVALID_SOCKET;
			return (mConnectionResult = false);
		}

		/*--   I/O Context غѴ.
		*/
		PerIoContext* perIoContext = mIoContextPool->GetIoContext( mSocket, IOCP_REQUEST_READ );
		if ( perIoContext == NULL )
		{
			closesocket( mSocket );
			mSocket = INVALID_SOCKET;
			return (mConnectionResult = false);
		}
		if ( RecvPost( perIoContext ) == false )
		{
			closesocket( mSocket );
			mSocket = INVALID_SOCKET;
			return (mConnectionResult = false);
		}
		else
			return (mConnectionResult = true);
	}
	else
	{
		closesocket( mSocket );
		mSocket = INVALID_SOCKET;
		return (mConnectionResult = false);
	}
}

/*-- Disconnect Method
*/
bool cIOCPClient::Disconnect(void)
{
	if ( mConnected == true && mConnectionResult == true )
	{
		cCSLock lock( &mCs );
		SOCKET  sockTemp = mSocket;

		/*--  ϰ Ѵ.
		*/
		mSocket           = INVALID_SOCKET;
		mConnected        = false;
		mConnectionResult = false;

		if ( sockTemp != INVALID_SOCKET )
		{
			closesocket( sockTemp );
		}

		PostMessage( mWnd, mMessageID, (WPARAM)ICT_DISCONNECT, (LPARAM)0L );
		return true;
	}
	return false;
}

/*-- SendNetworkMsg Method;
*/
bool cIOCPClient::SendNetworkMsg(char* buf, u_short len)
{
	if ( IsConnected( ) == true )
	{
		cCSLock       lock( &mCs );
		try {
			PerIoContext* perIoConect = mIoContextPool->GetIoContext( mSocket, IOCP_REQUEST_WRITE );
			Packet*       packet      = (Packet*)perIoConect->buffer;
			char*         buffer      = NULL;

			packet->ver  = PHVer;
			packet->hlen = PHLen;
			packet->tos  = TOS_CLIENT;
			packet->tlen = packet->hlen + len;

			buffer = perIoConect->buffer + packet->hlen;
			memcpy( buffer, buf, len );

			perIoConect->offset = packet->tlen;
			return SendPost( perIoConect );
		} catch ( ... ) {
			ErrorLog( "Throwing 'cIOCPClient::SendNetworkMsg' exception" );
			throw;
		}
	}
	return false;
}

/*-- ReleaseNetworkMsg Method;
*/
bool cIOCPClient::ReleaseNetworkMsg(LPARAM lParam)
{
	PerIoContext* perIoContect = (PerIoContext*)lParam;
	DWORD         error        = 0;
	if ( perIoContect->socket == mSocket )
	{
		mIoContextPool->ReleaseIoContext( perIoContect );
		if ( error != 0 )
			assert( "WARNING - cIOCPClient::ReleaseNetworkMsg." );
		return true;
	}
	return false;
}

// SendHeartbeat Method
bool cIOCPClient::SendHeartbeat( )
{
	if ( IsConnected( ) == true )
	{
		cCSLock       lock( &mCs );
		PerIoContext* perIoConect = mIoContextPool->GetIoContext( mSocket, IOCP_REQUEST_WRITE );
		Packet*       packet      = (Packet*)perIoConect->buffer;

		packet->ver  = PHVer;
		packet->hlen = PHLen;
		packet->tos  = TOS_TTL;
		packet->tlen = packet->hlen;

		perIoConect->offset = packet->tlen;
		return SendPost( perIoConect );
	}
	return false;
}

// Decrypt Method
void cIOCPClient::Decrypt(BYTE* ptr, RC5_32_KEY key)
{
	unsigned char tiv[8] = {'I','R','I','S','I','R','I','S'};
	int           num    = 0;

	LONG  decryptlen = ((Packet*)ptr)->tlen;
	BYTE* decryptptr = ptr;

	decryptlen -= PHLen;
	decryptptr += PHLen;

	if ( decryptlen > 0 )
	{
		RC5_32_cfb64_encrypt( decryptptr, decryptptr, decryptlen, &key, tiv, &num, RC5_DECRYPT );
	}
}

// Encrypt Method
void cIOCPClient::Encrypt(BYTE* ptr, RC5_32_KEY key)
{
	unsigned char tiv[8] = {'I','R','I','S','I','R','I','S'};
	int           num    = 0;

	LONG  encryptlen = ((Packet*)ptr)->tlen;
	BYTE* encryptptr = ptr;

	encryptlen -= PHLen;
	encryptptr += PHLen;

	if ( encryptlen > 0 )
	{
		RC5_32_cfb64_encrypt( encryptptr, encryptptr, encryptlen, &key, tiv, &num, RC5_ENCRYPT );
	}
}

// Decrypt Method
void cIOCPClient::Decrypt(BYTE key, long len, char* ptr)
{
	len -= PHLen;
	ptr += PHLen;

	if ( len > 0 )
	{
		for ( long i = 0; i < len; i++, ptr++ )
		{
			(*ptr) = (*ptr) ^ SY_KEY_TABLE[key][i%3];
		}
	}
}

/*-- Encrypt Method
*/
void cIOCPClient::Encrypt(BYTE key, long len, char* ptr)
{
	len -= PHLen;
	ptr += PHLen;

	if ( len > 0 )
	{
		for ( LONG i = 0; i < len; i++, ptr++ )
		{
			(*ptr) = (*ptr) ^ SY_KEY_TABLE[key][i%3];
		}
	}
}

/*-- SendPost Method
*/
bool cIOCPClient::SendPost(PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  sendBytes = 0;
	DWORD  flags     = 0;
	int    retcode;

	wsaBuf.len = perIoContext->offset;
	wsaBuf.buf = perIoContext->buffer;

	if ( mRC5Enable )
	{
		BYTE  key = (BYTE)(rand( ) & 0x0f);
		(*wsaBuf.buf) = ((*wsaBuf.buf) & 0xf0) | key;

		Encrypt( (BYTE*)wsaBuf.buf, RC5_32_KEY_TABLE[ ((*wsaBuf.buf) & 0x0f) ] );
	}
	else
	{
		BYTE  key = (BYTE)(rand( ) & 0x0f);

		Encrypt( key, wsaBuf.len, wsaBuf.buf );
		(*wsaBuf.buf) = ((*wsaBuf.buf) & 0xf0) | key;
	}

	retcode = WSASend( perIoContext->socket,
					   &wsaBuf,
					   1,
					   &sendBytes,
					   flags,
					   &(perIoContext->wsaOverlapped),
					   NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		PostQueuedCompletionStatus( mIocp, 0, NULL, (LPOVERLAPPED)perIoContext );
		return false;
	}
	return true;
}

/*-- RecvPost Method
*/
bool cIOCPClient::RecvPost(PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  recvBytes = 0;
	DWORD  flags     = 0;
	int    retcode;

	wsaBuf.len = (perIoContext->length - perIoContext->offset);
	wsaBuf.buf = (perIoContext->buffer + perIoContext->offset);

	retcode = WSARecv( perIoContext->socket,
					   &wsaBuf,
					   1,
					   &recvBytes,
					   &flags,
					   &(perIoContext->wsaOverlapped),
					   NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		PostQueuedCompletionStatus( mIocp, 0, NULL, (LPOVERLAPPED)perIoContext );
		return false;
	}
	return true;
}

/*-- Close Method - CompletionKey Overlapped  CompletionKey Ѵ.
*/
void cIOCPClient::Close(ULONG_PTR /*completionKey*/, PerIoContext* perIoContext)
{
	cCSLock lock( &mCs );
	DWORD   error = 0;

	//   ˻.
	if ( (mConnected == true) && (mConnectionResult == true) )
	{
		SOCKET  sockTemp = mSocket;

		/*--  ϰ Ѵ.
		*/
		mSocket           = INVALID_SOCKET;
		mConnected        = false;
		mConnectionResult = false;

		if ( sockTemp != INVALID_SOCKET )
		{
			closesocket( sockTemp );
		}

		PostMessage( mWnd, mMessageID, ICT_CONNECTION_DEAD, (LPARAM)GetLastError( ) );
	}

	//  Ϸ I/O Context ȸ.
	mIoContextPool->ReleaseIoContext( perIoContext );
	if ( error != 0 )
		assert( "WARNING - cIOCPClient::Close." );
}

/*-- SendComplete Method
*/
bool cIOCPClient::SendComplete(ULONG_PTR, PerIoContext* perIoContext, DWORD)
{
	//  Ϸ I/O Context ȸѴ.
	DWORD error = 0;
	mIoContextPool->ReleaseIoContext( perIoContext );
	if ( error != 0 )
		assert( "WARNING - cIOCPClient::SendComplete." );
	return true;
}

/*-- RecvComplete Method (Default Echo Server)
*/
bool cIOCPClient::RecvComplete(ULONG_PTR, PerIoContext* perIoContext, DWORD bytesTransferred)
{
	cCSLock lock( &mCs );

	//  ũ⸦ Ѵ.
	perIoContext->offset += bytesTransferred;

	DWORD length = perIoContext->offset; // ŵ  ũ
	DWORD offset = 0;                    // ŵ  

	while ( length >= PHLen )
	{
		Packet* packet    = (Packet*)(perIoContext->buffer + offset);
		DWORD   packetLen = packet->tlen;
		BOOL    retvalue;

		//  ̰ ּ     óؾ Ѵ.
		if ( packetLen < PHLen )
			return false;

		//  ̰ Ҷ ̾ ޱ⸦ ؾ Ѵ.
		if ( packetLen > length )
			break;

		// ⼭  ó  ڵ带 Ѵ.
		PerIoContext* ioContext = mIoContextPool->GetIoContext( mSocket, IOCP_REQUEST_READ );

			memcpy( ioContext->buffer, packet, packet->tlen );
			ioContext->offset = packet->tlen;

			if ( mRC5Enable )
			{
				Decrypt( (BYTE*)ioContext->buffer, RC5_32_KEY_TABLE[ packet->ver ] );
			}
			else
			{
				Decrypt( packet->ver, packet->tlen, ioContext->buffer );
			}

		retvalue = PostMessage( mWnd, mMessageID, (WPARAM)ICT_RECV, (LPARAM)ioContext );
		if ( retvalue == FALSE )
			return false;

		// ó Offset  Length ٽ Ѵ.
		length -= packetLen;
		offset += packetLen;
	}

	// ̾ ޱ⸦  ͸ Ѵ.
	if ( offset > 0 )
	{
		PerIoContext* recvIoContext = mIoContextPool->GetIoContext( mSocket, IOCP_REQUEST_READ );
		DWORD         error         = 0;

		if ( length > 0 )
		{
			memcpy( recvIoContext->buffer, (perIoContext->buffer + offset), length );
			recvIoContext->offset = length;
		}

		mIoContextPool->ReleaseIoContext( perIoContext );
		if ( error != 0 )
			assert( "WARNING - cIOCPClient::RecvComplete." );

		perIoContext = recvIoContext;
	}

	return RecvPost( perIoContext );
}

/*-- Process Method;
*/
DWORD cIOCPClient::ConnectThread(void)
{
	cCSLock lock( &mCs );
	mConnected = (connect( mSocket, (LPSOCKADDR)&mAddr, sizeof(mAddr) ) != SOCKET_ERROR ) ? true : false;
	PostMessage( mWnd, mMessageID, (WPARAM)ICT_CONNECT, (LPARAM)0L );
	return 0L;
}

/*-- Process Method;
*/
bool cIOCPClient::Process(WPARAM wParam, LPARAM lParam)
{
	IOCP_CLIENT_TYPE type = (IOCP_CLIENT_TYPE)wParam;
	switch ( type )
	{
	case ICT_CONNECT:
		// ŬƮ Ḧ û ...
		if ( GetConnectionResult( ) )
		{
			/// Ἲ.
		}
		else
		{
			/// .
			UIMAN->ModalEventFromGameSystem( false );

			UIMAN->CreateModal(	eStage_Login, eMBEVENT_CONNECT_LOGINFAILE, 
				GAMERESOURCEMAN->GetGameText( 3 ),
				GAMERESOURCEMAN->GetGameText( 301 ),
				eSKIN_OK );
		}
		break;

	case ICT_DISCONNECT:
		// ŬƮ   û 츸...
		break;

	case ICT_CONNECTION_DEAD:
		{
			// κ   Ǿ ...
			UIMAN->CreateModal(	eStage_Login, eMBEVENT_CONNECT_DEAD, 
								GAMERESOURCEMAN->GetGameText( 61 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK );
		}
		break;

	case ICT_RECV:
		{
			PerIoContext* perIoContext = (PerIoContext*)lParam;
			Packet*       packet       = (Packet*)perIoContext->buffer;

			char*         buffer       = perIoContext->buffer + packet->hlen;
			u_long        length       = packet->tlen - packet->hlen;

			mLastTos = packet->tos;
			switch ( packet->tos )
			{
			case TOS_LOGIN:
				try {
					MSGROOT* msgRoot = (MSGROOT*)buffer;
					mLastCategory = msgRoot->Category;
					mLastProtocol = msgRoot->Protocol;

					STAGEMAN->NetworkMsgParser( 0, buffer, length );
					ReleaseNetworkMsg( lParam );
				} catch ( ... ) {
					ErrorLog( "In TOS_LOGIN:NetworkMsgParser(%d,%d) Method. Throwing 'cIOCPClient::Process' exception", mLastCategory, mLastProtocol );
					throw;
				}
				break;

			case TOS_LOGIN_ACCEPT:
				mRC5Enable = true;

				/// α   
				UIMAN->ModalEventFromGameSystem( true );
				ReleaseNetworkMsg( lParam );
				break;

			case TOS_LOGIN_2_GAME:
				{
					/// Ӽ .
					Login2Game*    login2Game = (Login2Game*)packet;
					unsigned long  ipv4       = login2Game->ipv4;
					unsigned short port       = login2Game->port;

					ReleaseNetworkMsg( lParam );

					return PostConnect( ipv4, port );
				}
				break;

			case TOS_GAME:
				try {
					MSGROOT* msgRoot = (MSGROOT*)buffer;
					mLastCategory = msgRoot->Category;
					mLastProtocol = msgRoot->Protocol;

					STAGEMAN->NetworkMsgParser( 0, buffer, length );
					ReleaseNetworkMsg( lParam );
				} catch ( ... ) {
					ErrorLog( "In TOS_GAME:NetworkMsgParser(%d,%d) Method. Throwing 'cIOCPClient::Process' exception", mLastCategory, mLastProtocol );
					throw;
				}
				break;

			case TOS_GAME_ACCEPT:
				{
					mRC5Enable = false;

					/// Ӽ õ.
					MSG_REQ_GAMESRV gamein;
					::memset( &gamein, 0, sizeof(gamein) );

					gamein.Category  = NM_USER;
					gamein.Protocol  = NM_USER_GAMESRV_REQ;
					gamein.LoginIdx  = STAGEMAN->GetLoginIdx( );
					gamein.MemberIdx = STAGEMAN->GetUserIdx( );

					SendNetworkMsg( (char*)&gamein, sizeof(gamein) );

					/// ޼ 
					UIMAN->ChangeModalMessage( GAMERESOURCEMAN->GetGameText( 12 ) );
					ReleaseNetworkMsg( lParam );
				}
				break;

			case TOS_GAME_2_GAME:
				{
					/// ӳ äκ.
					Game2Game*     game2Game = (Game2Game*)packet;
					unsigned long  ipv4       = game2Game->ipv4;
					unsigned short port       = game2Game->port;

					ReleaseNetworkMsg( lParam );

					return PostConnect( ipv4, port );
				}
				break;

			default:
				assert( 0 && "UNKNOWN - TYPE OF SERVICE." );
				ReleaseNetworkMsg( lParam );
				break;
			}
		}
		break;
	}
	return true;
}

/*-- WorkerThread Method
*/
DWORD cIOCPClient::WorkerThread(void)
{
	DWORD             bytesTransferred;
	ULONG_PTR         completionKey;
	OVERLAPPED*       overlapped;
	BOOL              retValue;

	PerIoContext*     perIoContext;

	try {
		while ( true )
		{
			/*-- completion port Ҵ   I/O ϷḦ ٸ.
			*/
			retValue = GetQueuedCompletionStatus( mIocp, &bytesTransferred, &completionKey, &overlapped, INFINITE );

			/*-- Shutdown
			*/
			if ( overlapped == IOCP_SHUTDOWN )
				return 0;

			perIoContext = (PerIoContext*)overlapped;

			/*-- client connection dropped, continue to service remaining (and possibly new) client connections
			*/
			if ( retValue == FALSE || bytesTransferred == 0 ) 
			{
				perIoContext->offset = max( perIoContext->offset, bytesTransferred );
				Close( completionKey, perIoContext );
				continue;
			}

			switch ( perIoContext->requestType )
			{
			case IOCP_REQUEST_READ:
				if ( RecvComplete( completionKey, perIoContext, bytesTransferred ) == false )
				{
					Close( completionKey, perIoContext );
				}
				break; // Receive Ϸ ڵ鷯 Լ.

			case IOCP_REQUEST_WRITE:
				if ( SendComplete( completionKey, perIoContext, bytesTransferred ) == false )
				{
					Close( completionKey, perIoContext );
				}
				break; // Send Ϸ ڵ鷯 Լ.
			}
		}
	} catch ( ... ) {
		ErrorLog( "Throwing 'cIOCPClient::WorkerThread' exception" );
		throw;
	}
	return 0;
}

/*-- ConnectThreadStartingPoint Method ( Connect Thread  Ʈ )
*/
DWORD cIOCPClient::ConnectThreadStartingPoint(void* ptr)
{
	cIOCPClient* client = (cIOCPClient*)ptr;
	return client->ConnectThread( );
}

/*-- WorkerThreadStartingPoint Method ( Worker Thread  Ʈ )
*/
DWORD cIOCPClient::WorkerThreadStartingPoint(void* ptr)
{
	cIOCPClient* client = (cIOCPClient*)ptr;
	return client->WorkerThread( );
}
