/* ==========================================================================
*    : ̼
*    : 2007.06.14
*      : 
* ǻ : 
*===========================================================================*/
#pragma once
#include "UINode.h"
#include "UINodeData.h"
#include "UIImage.h"
#include "UIImageFont.h"
#include "UITransformImage.h"
#include "UIRoundGauge.h"

class cPlaneObject;
enum eTooltipType;
enum eAniType
{
	eANI_AURA,		/// ų ׵θ
	eANI_FLASH,		/// Ÿ  ¦
	eANI_COUNT,		/// Ÿ īƮ 
		
	eANI_MAX,
};

enum eIconType
{
	eICON_NORMAL = 0,	/// ϹŸ
	eICON_ITEM,
	eICON_SKILL,
	eICON_COMMUNITY,

	eICON_MAX,
	eICON_NULL,
};

/// ִϸ̼ 
struct sAniParam
{
	short			mFrame;				/// Ӽ
	unsigned int	mTexX, mTexY;		/// ؽ ǥ
	unsigned int	mWidth, mHeight;	/// ̹ 
	short			mCurFrame;			///  
	bool			mAniOn;				/// ִϻ뿩
	bool			mReturn;			/// ִϸ̼ ѹ 

	/// Ÿ̸
	unsigned long	mTimeOut;			/// ִϸ̼  ð
	unsigned long	mAccumTime;
	unsigned long	mLastAccumTime;

	sAniParam()
	{
		::memset( this, 0, sizeof(sAniParam) );
	}
	~sAniParam(){}
};

///  
class cIconParam
{
public:
	/// ؽó
	NiTexture* mpTexture;

	/// ؽó ġ ǥ
	cUIPos mTexPos;
};

/// 
class cIcon : public cUINode
{
public:
	cIcon( eUINodeType type = eUINODE_ICON );
	virtual ~cIcon();

	///  Ȱȭ (̺Ʈ ޵, Ȱȭ )
	void SetUsedFlag( bool enable, bool colorchange = true );
	bool IsEnableUse();

	/// 巡̸  Ⱥ
	void ShowGauge( bool show );
	void ChangeGauge( cUIRoundGauge& gauge );
	cUIRoundGauge& GetGauge() { return mGauge; }

	///
	bool IsActive();
	void StartDelay( unsigned long delayTime );
	void StopDelay();
	void SetElapsedTime( unsigned long delta );

	/// ̹
	void ShowImage( bool show );
	void ChangeImage( cIconParam* param, unsigned int texW = 0, unsigned int texH = 0 );

	/// 
	void SetColor( const NiColorA& color );
	void SetColor( float r, float g, float b, float a );
	const NiColorA& GetColor() const;

	///  
	cIconParam* GetIconParam() const;

	/// ȣ
	unsigned int GetNumber() { return mNumber; }
	void SetNumber( unsigned int num );

	///    
	void ShowNumber( bool show );
	bool IsShowNumber() const;

	void SetTipType( unsigned int type );
	unsigned int GetTipType() { return mTipType; }
	
	/// ܿ ִϸ̼   
	void SetAniEnable( bool enable );

	/// ִϸ̼ 
	void SetAuraOn( bool set );
	bool IsAuraOn();

	void SetAniParam( sAniParam* param );
	sAniParam* GetAniParam() { return mAniParam; }

	void SetIconType( eIconType type );
	unsigned int GetIconType();

protected:
	virtual bool IsValid() const;
	virtual bool SetSkin( const cUINodeSkin* skin );
	virtual void UpdateRect();

	/// ̺Ʈ
	virtual bool HandleEvent( const cUIEvent& event );
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void OnMouseHovered(const cUIPos& pos );
	virtual void OnMouseMove( const cUIPos& pos );
	virtual void OnMouseLeft(const cUIPos& pos );
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	virtual void OnLButtonUp( const cUIPos& pos );
	virtual void OnLButtonDoubleClick( const cUIPos& pos );
	virtual void OnRButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	
	///  Ÿ̸
	void OnTimer( unsigned int type );
	void SetAniOn( eAniType type, short frame = 0 );

protected:
	///  Ÿ 
	int mIconType;

	/// ̹
	bool mShowImage;
	
	///  
	cUIRoundGauge mGauge;

	///  
	cIconParam* mParam;

	/// ̹ Ʈ
	cUIImageFont* mImageFont;

	/// ȣ ( )
	unsigned int mNumber;
	cString mNumText;

	/// Ʈ 
	bool mShiftDown;

	/// 巡 ο    
	bool mShowGauge;

	/// 
	bool mShowNumber;

	/// Ȱȭ  (̵)
	bool mEnableUse;

	NiColorA mColor;

protected:
	/// ִϸ̼ ϴ  
	bool		mAniEnable;

	/// īƮ ̹ ( ִϸ̼ )
	cPlaneObject*	mpCountImage;

	/// ¦̴ ̹ ( ִϸ̼ )
	cPlaneObject*	mpFlashImage;

	/// ų ׵θ ̹( ִϸ̼ )
	cPlaneObject*	mpEdgeImage;

	/// ִϸ̼  
	sAniParam	mAniParam[ eANI_MAX ];

	///   ̹   ( )
	cUIImage*		mpTipImage;
	eTooltipType	mTipType;		///  ÷ Ÿ
};


inline
void cIcon::SetIconType( eIconType type )
{
	mIconType = type;
}

inline
unsigned int cIcon::GetIconType()
{
	return mIconType;
}

inline
bool cIcon::IsEnableUse()
{
	return mEnableUse;
}

inline
void cIcon::ShowImage( bool show )
{
	mShowImage = show;
}

inline
void cIcon::SetColor( const NiColorA& color )
{
	mColor = color;

	if( mpImage )
		mpImage->SetColor( color );
}

inline
void cIcon::SetColor( float r, float g, float b, float a )
{
	mColor = NiColorA(r,g,b,a);

	if( mpImage )
		mpImage->SetColor( NiColorA(r,g,b,a) );
}

inline
const NiColorA& cIcon::GetColor() const
{
	if( mpImage )
		return mpImage->GetColor();

	return NiColorA::WHITE;
}

inline
cIconParam* cIcon::GetIconParam() const
{
	return mParam;
}

inline
void cIcon::SetNumber( unsigned int num )
{
	mNumber = num;
	mNumText.Format( "%d", num );
}

inline
void cIcon::ShowNumber( bool show )
{
	mShowNumber = show;
}

inline
bool cIcon::IsShowNumber() const
{
	return mShowNumber;
}

inline
void cIcon::SetAniEnable( bool enable )
{
	mAniEnable = enable;
}

////////////////////////////////////////////////////////////////////////////////
///  Ų
class cIconSkin : public cUINodeSkin
{
public:
	cIconSkin( eUINodeType type = eUINODE_ICON );
	virtual ~cIconSkin();

	/// ε
	virtual bool Load( cParser& parser );
};
