#include "StdAfx.h"
#include "inputsystem.h"

#include "Application.h"
#include "RenderSystem.h"
#include "StageManager.h"

#include "ObjectManager.h"
#include "UIManager.h"

#include "CameraManager.h"
#include "UICursor.h"
#include "UINode.h"

#include "XPerformanceGuard.h"

cInputSystem* cInputSystem::mpSingleton = 0;

cInputSystem::cInputSystem()
{
	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;

	mEnabled = false;
}

cInputSystem::~cInputSystem()
{
	Exit();

	mpSingleton = 0;
}

bool cInputSystem::Init( NiInstanceRef hi, NiWindowRef hwnd )
{
	HRESULT hr;

	/// ġ 
	hr = DirectInput8Create( hi, DIRECTINPUT_VERSION, IID_IDirectInput8, (VOID**)&mpDI, NULL );
	if( FAILED( hr ) )
	{
		return false;
	}

	/// Ű 
	hr |= mKeyboard.Create( hwnd, mpDI );
	if( FAILED( hr ) )
	{
		return false;
	}

	/// 콺 
	if( !mMouse.Create( hwnd ) )
	{
		return false;
	}

	mEnabled = true;

	return true;
}

void cInputSystem::Exit()
{
	mMouse.Release();
	mKeyboard.Release();

	SAFE_RELEASE( mpDI );
}


/// ǻ : Ű 콺 ó   !!
void cInputSystem::Process( unsigned long deltaTime )
{
	/// 
	OBJECTMAN->ClearPickObject();

	/// Keyboard ó
	mKeyboard.UpdateKeyboardState();
	if( THEAPP->IsActive() == false || mEnabled == false )
	{
		mKeyboard.ClearKeyState();
	}
	else
	{
		/// Ŀ 尡 ְų,  ̾αװ  ó .
		if( UIMAN->GetFocusedNode() || UIMAN->GetModalBox() )
		{
			mKeyboard.ClearKeyState();
		}
		else
		{
			/// ֻ ̳ʿ ̺Ʈ Ѵ..

			/// ̰    !!

			/// ӻ ŰԷ ó...
			STAGEMAN->ProcessKeyPressed( &mKeyboard );

			mKeyboard.StartGetKeyState();
			while( mKeyboard.GetNextKeyState() )
			{
				/// ӻ ŰԷ ó...
				STAGEMAN->ProcessKeyUpDown( deltaTime, &mKeyboard );
			}
		}
	}

	/// Mouse ó
	do
	{
		mMouse.GetNextMouseEvent();

		if( mEnabled )
		{
			/// UI ǲ ó
			if( UseMouseEventByUIMgr() )
			{
				/// UI ޼ óߴٸ...
				continue;
			}

			/// ī޶  ǲ ó ( WM_MOUSEMOVE )
			if( STAGEMAN->GetCurrentStage() == eStage_Game )
			{
				CAMERAMAN->ProcessMouse( deltaTime );

				if( UIMAN->IsVisibleDrag() )
				{
					CURSOR->SetCursor( eCURSOR_DEFAULT );
					continue;
				}

				cUINode* node = UIMAN->GetHoverNode();
				if( node )
				{
					if( (mMouse.LButtonDown() && node->IsLClickNotifyStage()) == false )
					{
						CURSOR->SetCursor( eCURSOR_DEFAULT );
						continue;
					}
				}
			}

			/// ӻ 콺 ̺Ʈ ó...
			STAGEMAN->ProcessMouseEvent( deltaTime, &mMouse );
		}
	}
	while( !mMouse.IsEmptyMouseEvent() );
}

bool cInputSystem::UseMouseEventByUIMgr()
{
	cUIEvent event;
	event.mControl = mMouse.ControlPressed();
	event.mShift = mMouse.ShiftPressed();
	event.mAlt = mMouse.AltPressed();

	if( THEAPP->IsActive() )
	{
		if( mMouse.LButtonDown() )
		{
			event.mType = eUIEVENT_LBUTTON_DOWN;
			event.mPos.mX = mMouse.GetMouseEventX();//mMouse.GetMouseX();
			event.mPos.mY = mMouse.GetMouseEventY();//mMouse.GetMouseY();

			return UIMAN->PostEventFromUser( event );
		}
		else if( mMouse.LButtonUp() )
		{
			event.mType = eUIEVENT_LBUTTON_UP;
			event.mPos.mX = mMouse.GetMouseEventX();//mMouse.GetMouseX();
			event.mPos.mY = mMouse.GetMouseEventY();//mMouse.GetMouseY();

			return UIMAN->PostEventFromUser( event );
		}
		else if( mMouse.RButtonDown() )
		{
			event.mType = eUIEVENT_RBUTTON_DOWN;
			event.mPos.mX = mMouse.GetMouseEventX();//mMouse.GetMouseX();
			event.mPos.mY = mMouse.GetMouseEventY();//mMouse.GetMouseY();

			return UIMAN->PostEventFromUser( event );
		}
		else if( mMouse.RButtonUp() )
		{
			event.mType = eUIEVENT_RBUTTON_UP;
			event.mPos.mX = mMouse.GetMouseEventX();//mMouse.GetMouseX();
			event.mPos.mY = mMouse.GetMouseEventY();//mMouse.GetMouseY();

			return UIMAN->PostEventFromUser( event );
		}
		else if( mMouse.LButtonDoubleClick() )
		{
			event.mType = eUIEVENT_LBUTTON_DBLCLK;
			event.mPos.mX = mMouse.GetMouseEventX();//mMouse.GetMouseX();
			event.mPos.mY = mMouse.GetMouseEventY();//mMouse.GetMouseY();

			return UIMAN->PostEventFromUser( event );
		}
	}

	if( mMouse.GetWheel() )
	{
		event.mType = eUIEVENT_MOUSE_WHEEL;
		event.mPos.mX = mMouse.GetMouseX();
		event.mPos.mY = mMouse.GetMouseY();
		event.mWheel = mMouse.GetWheel();

		return UIMAN->PostEventFromUser( event );

	}

	/// WM_MOUSE_MOVE  ó  Ȱ/Ȱ Ѵ.
	if( mMouse.IsDrag() )
	{
		event.mType = eUIEVENT_MOUSE_MOVE;
		//event.mPos.mX = (float)mMouse.GetMouseX() / (float)RENDERSYS->GetScreenWidth();
		//event.mPos.mY = (float)mMouse.GetMouseY() / (float)RENDERSYS->GetScreenHeight();
		event.mPos.mX = mMouse.GetMouseX();
		event.mPos.mY = mMouse.GetMouseY();
		return UIMAN->PostEventFromUser( event );
	}
	return false;
}

bool cInputSystem::WindowMessageParser( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam )
{
	if( !mEnabled ) 
		return false;

	/// 콺 óǴ ̺Ʈ!!
	if( mMouse.GetWindowMessage( wnd, msg, wparam, lparam ) )
		return false;

	/// UI ̺Ʈ
	cUIEvent event;

	/// UI Ʈ 迭 Ŀ ִ  ó
	if( UIMAN == 0 )
		return false;

	if( UIMAN->GetModalBox() == 0 )
	{
		if( !UIMAN->GetFocusedNode() )
			return false;
	}
	
	/// Ű ̺Ʈ  ó!!
	switch( msg )
	{
		/*
		BYTE keys[256];
		WORD asc = 0;
		GetKeyboardState( keys );
		ToAscii( wparam, lparam, keys, &asc, 0 );

		event.mShift = (keys[VK_SHIFT] & 0x80) != 0;
		event.mControl = (keys[VK_CONTROL] & 0x80) != 0;
		event.mAscii = asc >= 0 ? asc : 0;
		*/
			/// 1. KEY DOWN/UP ó
	case WM_KEYDOWN:
		{
			event.mType = eUIEVENT_KEY_DOWN;
			event.mCode = (eKeyCode)wparam;

			UIMAN->PostEventFromUser( event );
		}
		return true;
	case WM_KEYUP:
		{
			event.mType = eUIEVENT_KEY_UP;
			event.mCode = (eKeyCode)wparam;

			UIMAN->PostEventFromUser( event );
		}
		return true;

		/// 2. WM_CHAR Message ó
	case WM_CHAR:
		{
			event.mType = eUIEVENT_CHAR;
			event.mWparam = (TCHAR)wparam;

			UIMAN->PostEventFromUser( event );
		}
		return true;
	
		/// 3. IME Message ó
	case WM_IME_NOTIFY:
		{
			event.mType = eUIEVENT_IME_NOTIFY;
			
			if( wparam == IMN_SETCONVERSIONMODE )
			{
				event.mWparam = wparam;
				UIMAN->PostEventFromUser( event );
			}
		}
		return true;
	case WM_IME_STARTCOMPOSITION:
		{
			event.mType = eUIEVENT_IME_STARTCOMPOSITION;
			event.mCode = (eKeyCode)wparam;

			UIMAN->PostEventFromUser( event );
		}
		return true;
	case WM_IME_COMPOSITION:
		{
			/// ѱ  
			event.mType = eUIEVENT_IME_COMPOSITION;
			event.mWparam = (BYTE)wparam;
			event.mLparam = lparam;

			UIMAN->PostEventFromUser( event );
		}
		return true;
	case WM_IME_ENDCOMPOSITION:
		{
			event.mType = eUIEVENT_IME_ENDCOMPOSITION;

			UIMAN->PostEventFromUser( event );
		}
		return true;
	}

	return false;
}

void cInputSystem::InputInfoClearAll()
{
	mKeyboard.UpdateKeyboardState();
	mKeyboard.ClearKeyState();
	mMouse.ClearAllInfo();
}

void cInputSystem::KeyInfoClear()
{
	mKeyboard.UpdateKeyboardState();
	mKeyboard.ClearKeyState();
}
