/* ====================================================================
*      :	InputSystem.h
*      :	I/O(콺, Ű)  
*    :	̹ 
*    :	2006.01
* ǻ :	
* =================================================================== */
#pragma once

#include "MouseAgent.h"
#include "KeyboardAgent.h"

class cInputSystem
{
	static cInputSystem* mpSingleton;

public:
	cInputSystem();
	virtual ~cInputSystem();

	/// ʱȭ  
	bool Init( NiInstanceRef hi, NiWindowRef hwnd );
	void Exit();

	/// ó
	void Process( unsigned long deltaTime );

	///      ǲ   Ѵ.
	void InputInfoClearAll();

	void KeyInfoClear();

	/// Window Message Parser( ϰ false  DefaultWndProcó  ʰ Ѿ )
	bool WindowMessageParser( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );

	/// Էó 뿩
	inline bool IsEnable() { return mEnabled; }
	void SetEnable(bool isEnable) { mEnabled = isEnable; }

	/// 콺  ȹ
	inline cMouseAgent* GetMouse() { return &mMouse; }

	/// Ű  ȹ
	inline cKeyboardAgent* GetKeyboard() { return &mKeyboard; }

protected:
	bool UseMouseEventByUIMgr();

public:
	/// ü 
	static cInputSystem* GetSingleton();

protected:

	/// DX Input 
	LPDIRECTINPUT8		mpDI;

	/// 콺 
	cMouseAgent			mMouse;

	/// Ű 
	cKeyboardAgent		mKeyboard;

	/// Ƿ Է¿  ó  Ѵ.
	bool				mEnabled;		
};

inline cInputSystem* cInputSystem::GetSingleton()
{
	return mpSingleton;
}

#define INPUTSYS	cInputSystem::GetSingleton()
#define MOUSE		INPUTSYS->GetMouse()
#define KEYBOARD	INPUTSYS->GetKeyboard()
