#include "stdafx.h"
#include "IntroStage.h"
#include "IntroUIManager.h"
#include "StageManager.h"

#include "Application.h"
#include "GameResourceManager.h"

#include "UIRootNode.h"
#include "UIBackWindow.h"

cIntroStage::cIntroStage()
: mpIntroUIManager(0)
{	
}

cIntroStage::~cIntroStage()
{
}

/// ǻ : 
void cIntroStage::Init( cStageManager* pStageManager )
{	
	mpStageManager = pStageManager;
}
 
/// ǻ : 
void cIntroStage::InitStage()
{
	if( mInit )	return;

	/// UI
	mpIntroUIManager = new cIntroUIManager;
	mpIntroUIManager->Init();

	mInit = true;
}

/// ǻ : 
void cIntroStage::Exit()
{
	GAMERESOURCEMAN->LoadEnd();

	if( mpIntroUIManager )
	{
		mpIntroUIManager->Exit();
		delete mpIntroUIManager;
		mpIntroUIManager = 0;
	}

	mpStageManager = NULL;
}

/// ǻ : 
void cIntroStage::Open()
{
	/// ui
	mpIntroUIManager->Open();
//	mpStageManager->ChangeStage( eStage_Login );

	if( GAMERESOURCEMAN->LoadInitData1() == false )
	{
		assert(0);
	}

	::ShowWindow( THEAPP->GetHWND(), SW_SHOW );
}

/// ǻ : 
void cIntroStage::Close()
{
	/// UI
	if( mpIntroUIManager )
		mpIntroUIManager->Close();
}

/// ǻ : 
void cIntroStage::Process( unsigned long deltaTime, unsigned long /*accumTime*/ )
{
	if( mpIntroUIManager->IsFadeOn() == false  )
	{
		unsigned int flag = GAMERESOURCEMAN->CheckInitData();
		if( flag == eData_Error )
		{
			assert(0);
			NiMessageBox( "Failed load gameData. Please reinstall client or patch.", "GameData Error" );
			::SendMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
			::PostQuitMessage(0);
			return;
		}
		else if( flag == eData_End )
		{
			GAMERESOURCEMAN->LoadEnd();
			mpIntroUIManager->SetFadeOn( true );
			mpStageManager->ChangeStage( eStage_Login );

			UIMAN->GotoFrontNode( (cUINode*)mpIntroUIManager->GetBackWindow() );
			return;
		}
	}

	/// UI
	mpIntroUIManager->Process( deltaTime );
}

void cIntroStage::ClearBackImage()
{
	cUIBackWindow* back = mpIntroUIManager->GetBackWindow();
	if( back )
		back->SetBackTexture( 0 );
}

bool cIntroStage::IsProcessEnd()
{
	if( mpIntroUIManager == 0 )
		return true;

	return mpIntroUIManager->IsProcessEnd();
}


/// ǻ : 
void cIntroStage::NetworkMsgParser( unsigned long /*connectionIdx*/, char* /*pMsg*/, unsigned long /*length*/ )
{
}