#include "stdafx.h"
#include "IntroUIManager.h"
#include "UIBackWindow.h"

#include "ResourceManager.h"

///
cIntroUIManager::cIntroUIManager()
: mpBackWindow(0)
{
	mFadeOn = false;
	mAlpha = 1000;

	mOneState = false;
}

///
cIntroUIManager::~cIntroUIManager()
{
}

///
void cIntroUIManager::Init()
{
	UIMAN->SetCurrentStage( eStage_Login );

	mpBackWindow = new cUIBackWindow;
	mpBackWindow->CreateByPropertyName( "P_LoadingBack", 0 );

	mpBackWindow->SetOnlyBackground( true );
}

///
void cIntroUIManager::InitStage()
{
}

///
void cIntroUIManager::Exit()
{
	if( mpBackWindow )
		mpBackWindow->SetBackTexture( 0 );

	mpBackWindow = 0;
}

///
void cIntroUIManager::Open()
{
	UIMAN->SetCurrentStage( eStage_Login );

	NiTexture* tex = RESOURCEMAN->LoadMapTexture( "./Data/2DData/LoadingMap_Image00.dds", false );
	if( tex )
		mpBackWindow->SetBackTexture( tex );

	mpBackWindow->SetEnabled( false );
	mpBackWindow->SetExceptEvent( true );
	mpBackWindow->Show();
}

///
void cIntroUIManager::Close()
{
	UIMAN->SetCurrentStage( eStage_Login );

	mpBackWindow->SetEnabled( false );
}

///
void cIntroUIManager::Process( unsigned long delta )
{
	if( mOneState )
		return;

	if( mFadeOn )
	{
		unsigned long val = delta/100;
		if( val == 0 )
			val = 5;

		if( mAlpha <= val )
			mAlpha = 0;
		else
			mAlpha -= val;

		if( mpBackWindow )
			mpBackWindow->SetAlpha( (float)mAlpha * 0.001f );
	}

	if( mAlpha == 0 )
	{
		mOneState = true;
		mpBackWindow->Hide();
		mpBackWindow->SetBackTexture(0);
	}
}
