#include "stdafx.h"
#include "InvenEquipWindow.h"

#include "../Common/Item_Common.h"
#include "GameUIManager.h"
#include "DragWindow.h"
#include "ItemIcon.h"

cInvenEquipWindow::cInvenEquipWindow()
{
	for( int i = 0; i < EQUIP_SLOT_COUNT; ++i )
		mIcon[i] = 0;
}

cInvenEquipWindow::~cInvenEquipWindow()
{
}

bool cInvenEquipWindow::UIStageIn()
{
	///   ˻
	ITEMMAN->CheckItemSlot( INVENTORY_HAND_RIGHT1 );
	ITEMMAN->CheckItemSlot( INVENTORY_HAND_RIGHT2 );
	return true;
}

bool cInvenEquipWindow::OnCreate( cUINodeProperty* /*property*/ )
{
	///  x
	cString str;
	for( unsigned int i = 0, slotIndex = INVENTORY_WEAR_BEGIN; i < EQUIP_SLOT_COUNT; ++i, ++slotIndex )
	{
		str.Format( "InvenEquip_Icon%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, 1 ) == false )
			return false;

		mIcon[i] = icon;
		ITEMMAN->BindIcon( slotIndex, icon );

		///  ǥ ( ⽺Ī )
		ITEMMAN->SetWeaponIconPos( slotIndex, icon->GetRelativeRect() );
	}
	return true;
}

void cInvenEquipWindow::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( (cUIWindow*)mpParent, DRAG_FROM_INVENTORY, icon, pos, shift );
}

void cInvenEquipWindow::OnIconDoubleClicked( cUINode* caller, unsigned int /*id*/ )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
		ITEMMAN->TryToUnEquipItem( icon->GetSlotIndex() );
}

void cInvenEquipWindow::OnIconClicked( cUINode* caller, unsigned int id )
{
	/// κ丮 쿡   ̺Ʈ
	if( caller )
		SendEvent( mpParent, eUIEVENT_ICON_CLICKED, caller, id );
}