#include "stdafx.h"
#include "InvenSheetWindow.h"

#include "../Common/Item_Common.h"
#include "GameUIManager.h"
#include "TradeWindow.h"
#include "InventoryWindow.h"
#include "DragWindow.h"
#include "UINpcTelling.h"
#include "Npc_Common.h"
#include "ItemIcon.h"

cInvenSheetWindow::cInvenSheetWindow( eUINodeType type )
: cUIWindow( type )
, mTabIndex( 0 )
{
	for( int i = 0; i < INVENSHEET_SLOT_COUNT; ++i )
		mIcon[i] = 0;
}

cInvenSheetWindow::~cInvenSheetWindow()
{
}

bool cInvenSheetWindow::BindSlot( unsigned int tabIndex )
{
	mTabIndex = tabIndex;

	///  
	cString str;
	unsigned int slotIndex = 0;

	switch( mTabIndex )
	{
	case 0:
		slotIndex = INVENTORY_BAG0_BEGIN;
		break;
	case 1:
		slotIndex = INVENTORY_QUEST_BEGIN;
		break;
	case 2:
		slotIndex = INVENTORY_MALL_BEGIN;
		break;
	default:
		assert( 0 && "index out of range" );
		return false;
	}

	for( unsigned int i = 0; i < INVENSHEET_SLOT_COUNT; ++i, ++slotIndex )
	{
		str.Format( "InvenSheet_Icon%02d", i );

		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, 1 ) == false )
			return false;

		mIcon[i] = icon;
		ITEMMAN->BindIcon( slotIndex, icon );
	}
	return true;
}

void cInvenSheetWindow::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( (cUIWindow*)mpParent, DRAG_FROM_INVENTORY, icon, pos, shift );
}

void cInvenSheetWindow::OnIconDoubleClicked( cUINode* caller, unsigned int /*id*/ )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
	{
		if( UIMAN->GetNpcFunc() == NPC_FUNC_NULL )
			ITEMMAN->TryToEquipItem( icon->GetSlotIndex() );
	}
}

void cInvenSheetWindow::OnIconClicked( cUINode* caller, unsigned int id )
{
	SendEvent( mpParent, eUIEVENT_ICON_CLICKED, caller, id );
}

void cInvenSheetWindow::OnIconRightClicked( cUINode* caller, unsigned int id, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( !icon )
	{
		assert(0);
		return;
	}

	/// ΰ
	if( UIMAN->GetNpcFunc() == NPC_FUNC_STORE )
	{
		unsigned int slotIndex = icon->GetSlotIndex();
		const cItem& item = ITEMMAN->GetItem( slotIndex );
		unsigned short count = item.GetCount();

		if( count )
			GAMEUI->ShowItemSellAskWindow( slotIndex, count );
	}
	else
	{
		SendEvent( mpParent, eUIEVENT_ICON_RIGHTCLICKED, caller, id, shift );
	}
}
