#include "stdafx.h"
#include "Item.h"
#include "ItemIcon.h"
#include "CoolTimeManager.h"
#include "Application.h"

void cItem::BindIcon( cItemIcon* icon )
{
	assert( icon && "null icon" );

	mIcon = icon;

	if( mCount )
	{
		mIcon->SetItemIndex( mIndex );
		mIcon->SetDBIndex( mDBIndex );
		mIcon->SetNumber( mCount );
		mIcon->SetUsedFlag( true );

		if( mDefine )
		{
			mIcon->ChangeImage( mDefine->GetIconParam() );
			mIcon->SetTipType( mDefine->GetTipType() );
			mIcon->ShowImage( true );
			
			/// ġ ۸   
			if( mDefine->GetCapacity() > 1 )
			{
				mIcon->ShowNumber( true );
			}
			else
			{
				mIcon->ShowNumber( false );
			}
		}
	}
	else
	{
		mIcon->SetItemIndex( 0 );
		mIcon->SetDBIndex( 0 );
		mIcon->SetUsedFlag( false );
		mIcon->ShowNumber( false );
	}
}

/// ٸ ۰ ȭ ġ Ѵ
bool cItem::SwicthPosition( cUIRect& rect )
{
	if( !mIcon )
		return false;

	/// 
	mIcon->SetRelativeRect( rect );
	return true;
}

void cItem::ClearColor()
{
	if( mIcon )
		mIcon->SetColor( NiColorA::WHITE );
	mColor = NiColorA::WHITE;
}

void cItem::SetTwoHanded( bool twoHanded, cIconParam* iconParam, cItemDefine* define )
{
	if( twoHanded )
	{
		mIconParam = iconParam;

		if( mIcon )
		{
			mIcon->ChangeImage( iconParam );
			if( define )
				mIcon->SetTipType( define->GetTipType() );
			mIcon->SetColor( 0.5f, 0.5f, 0.5f, 1.0f );
			mIcon->SetUsedFlag( false );
			mEnableUse = false;
		}
	}
	else
	{
		if( mIcon )
		{
			if( mCount == 0 )
			{
				mIcon->ChangeImage( 0 );
				mIcon->SetUsedFlag( false );
				mEnableUse = false;
			}
			else
			{
				mIcon->SetUsedFlag( true );
				mEnableUse = true;
			}	
			mIcon->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
		}
	}
}

void cItem::SetCount( unsigned short count )
{
	mCount = count;

	if( mCount == 0 )
		operator=( 0 );
	else if( mIcon )
		mIcon->SetNumber( mCount );
}

void cItem::SetUsedFlag( bool enabled, bool colorchange )
{
	mEnableUse = enabled;

	if( mIcon )
	{
		mIcon->SetUsedFlag( enabled, colorchange );
	}
}

void cItem::SetLock( bool lock )
{
	mLock = lock;

	if( mIcon )
	{
		mIcon->SetUsedFlag( !lock );
	}
}

bool cItem::StartCoolTime( unsigned long cool )
{
	if( mIcon == 0 )
		return false;

	///  0 ̻̾Ѵ.
	if( mCount <= 0 )
		return false;

	if( mIcon->IsActive() )
		return false;

	mIcon->StartDelay( cool );
	return true;
}

void cItem::EndCoolTime()
{
	if( mIcon == 0 )
		return;

	if( IsCoolTime() == true )
	{
		/// Ÿ
		mIcon->StopDelay();
	}
}

bool cItem::IsCoolTime() const
{
	if( mIcon == 0 )
		return false;

	return mIcon->IsActive();
}

void cItem::CopyCoolTime( unsigned long startTime, unsigned long restTime, unsigned long totalTime )
{
	if( mIcon == 0 )
		return;

	cUIRoundGauge& gauge = mIcon->mGauge;
	gauge.mGaugeState = 0;
	gauge.mStartTime = startTime;
	gauge.mElapsedTime = totalTime - restTime;
	gauge.mMaintainTime = totalTime;
	gauge.mActivate = true;
}

///    Ͱ, ͸    ؾѴ!!
cItem& cItem::operator=( cItem& other )
{
	mIndex = other.mIndex;
	mDBIndex = other.mDBIndex;
	mCardIndex1 = other.mCardIndex1;
	mCardIndex2 = other.mCardIndex2;
	mCardIndex3 = other.mCardIndex3;
	mCardIndex4 = other.mCardIndex4;
	mCardIndex5 = other.mCardIndex5;
	mEnhanced = other.mEnhanced;
	mCount = other.mCount;
	mSeal = other.mSeal;
	mDefine = other.mDefine;
	mEquipType = other.mEquipType;
	mFlag = other.mFlag;
	mEnableUse = other.mEnableUse;
	mShowNumber = other.mShowNumber;
	mTipType = other.mTipType;

	/// 
	cItemIcon* otherIcon = other.mIcon;

	if( mIcon )
	{
		if( otherIcon )
		{
			/// 
			*mIcon = *otherIcon;
		}
		else
		{
			mIcon->mParam = other.mIconParam;
			mIcon->mImageFont = other.mImageFont;
			mIcon->mItemIndex = other.mIndex;
			mIcon->mDBIndex = other.mDBIndex;
			mIcon->mNumber = other.mNumber;
			mIcon->mNumText = other.mNumText;
			mIcon->mGauge = other.mGauge;
			mIcon->ShowNumber( other.mShowNumber );
			mIcon->SetUsedFlag( other.mEnableUse );
			mIcon->SetAniParam( other.mAniParam );
			mIcon->SetTipType( other.mTipType );
		}

		mIcon->ChangeImage( mIcon->mParam ); 
	}
	else
	{
		if( otherIcon )
		{
			mIconParam = otherIcon->mParam;
			SetAniParam( otherIcon->mAniParam );
			mGauge = otherIcon->mGauge;
			mImageFont = otherIcon->mImageFont;
			mNumber = otherIcon->mNumber;
			mNumText = otherIcon->mNumText;
			mShowNumber = otherIcon->mShowNumber;
			mTipType = otherIcon->mTipType;
		}
		else
		{
			mIconParam = other.mIconParam;
			SetAniParam( other.mAniParam );
			mImageFont = other.mImageFont;
			mNumber = other.mNumber;
			mShowNumber = other.mShowNumber;
			mNumText = other.mNumText;
			mTipType = other.mTipType;
		}
	}
	return *this;
}

cItem& cItem::operator=( unsigned int i )
{
	if( i )
	{
		SetCount( (unsigned short)i );
	}
	else
	{
		mIndex = 0;
		mDBIndex = 0;
		mCardIndex1 = 0;
		mCardIndex2 = 0;
		mCardIndex3 = 0;
		mCardIndex4 = 0;
		mCardIndex5 = 0;
		mEnhanced = 0;
		mCount = 0;
		mSeal = false;
		mDefine = 0;
		mEquipType = ITEM_EQUIP_NORMAL;
		mFlag = ITEM_FLAG_NULL;
		mIconParam = 0;
		mImageFont = 0;
		mNumber = 0;
		mShowNumber = false;
		mColor = NiColorA::WHITE;
		mEnableUse = true;
		mLock = false;
		::memset( mAniParam, 0, sizeof(mAniParam) );

		mTipType = eTOOLTIP_NONE;

		/// 
		if( mIcon )
		{
			mIcon->mParam = 0;
			mIcon->mItemIndex = 0;
			mIcon->mDBIndex = 0;
 			mIcon->mNumber = 0;
			mIcon->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
			mIcon->SetUsedFlag( false );
			mIcon->ShowNumber( false );
			mIcon->StopDelay();
			mIcon->SetAniParam( 0 );
		}
	}
	return *this;
}

void cItem::SetAniParam( sAniParam* param )
{
	if( param == 0 )
	{
		for( unsigned int i = 0; i < eANI_MAX; ++i )
		{
			mAniParam[i].mAniOn = false;
		}
	}
	else
	{
		for( unsigned int i = 0; i < eANI_MAX; ++i, ++param )
		{
			mAniParam[i].mFrame = (*param).mFrame;
			mAniParam[i].mTexX = (*param).mTexX;
			mAniParam[i].mTexY = (*param).mTexY;
			mAniParam[i].mWidth = (*param).mWidth;
			mAniParam[i].mHeight = (*param).mHeight;
			mAniParam[i].mCurFrame = (*param).mCurFrame;
			mAniParam[i].mAniOn = (*param).mAniOn;
			mAniParam[i].mTimeOut = (*param).mTimeOut;
			mAniParam[i].mAccumTime = (*param).mAccumTime;
			mAniParam[i].mLastAccumTime = (*param).mLastAccumTime;
			mAniParam[i].mReturn = (*param).mReturn;
		}
	}
}