/* ==========================================================================
*    : ̼
*    : 2007.07.06
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

#include "ItemDefine.h"
#include "UIRoundGauge.h"
#include "UIRect.h"
#include "Icon.h"
typedef tUIRect<int> cUIRect;

class cItemIcon;
class cIconParam;
class cUIImageFont;
class cCoolData;

/// 
/// κ丮     Ѵ.
class cItem
{
	friend class cItemManager;
	friend class cCoolTimeManager;

public:
	cItem();
	cItem( cItem& other );
	~cItem();

	///   
	void BindIcon( cItemIcon* icon );
	cItemIcon* GetIcon() { return mIcon; }

	///    Ȱȭ 
	void SetUsedFlag( bool enabled, bool colorchange = true );

	///   :  ̺Ʈ Ұ (  )
	/// ŷâ, â, â UI ҽÿ Ѵ 
	void SetLock( bool lock );
	bool IsLock() { return mLock; }
	
	unsigned long GetIndex() const;
	unsigned short GetCount() const;
	unsigned char GetEnhanceStep() const;
	cItemDefine* GetDefine();
	cItemTarot* GetTarotDefine();

	unsigned long GetCardIndex1() { return mCardIndex1; }
	unsigned long GetCardIndex2() { return mCardIndex2; }
	unsigned long GetCardIndex3() { return mCardIndex3; }
	unsigned long GetCardIndex4() { return mCardIndex4; }
	unsigned long GetCardIndex5() { return mCardIndex5; }

	/// Ÿ 
	void CopyCoolTime( unsigned long startTime, unsigned long restTime, unsigned long totalTime );
	bool StartCoolTime( unsigned long cool );
	void EndCoolTime();
	bool IsCoolTime() const;

	/// ÷ Ŭ
	void ClearColor();

	/// ٸ ۰ ġ ü  (  ״  )
	bool SwicthPosition( cUIRect& rect );

private:
	void SetTwoHanded( bool twoHanded, cIconParam* iconParam = 0, cItemDefine* define = 0 );
	void SetCount( unsigned short count );
	
	cItem& operator=( cItem& other );
	cItem& operator=( unsigned int i );
	void SetAniParam( sAniParam* param );

private:
	///  ε
	unsigned long mIndex;

	///   ε ( DB ε )
	unsigned long mDBIndex;

	/// ȭܰ
	unsigned char mEnhanced;

	///  
	unsigned short mCount;

	///   
	bool mSeal;

	///   ī
	unsigned long  mCardIndex1;
	unsigned long  mCardIndex2;		
	unsigned long  mCardIndex3;		
	unsigned long  mCardIndex4;		
	unsigned long  mCardIndex5;		

	///  
	cItemDefine* mDefine;

	///  Ÿ
	eItemEquip mEquipType;

	/// ÷
	eItemFlag mFlag;

	/// ε  
	cItemIcon* mIcon;

	///  Ȱȭ
	bool mEnableUse;

	///  :  ۰ ̺Ʈ Ұ
	bool mLock; 

	/// temp  (  ü temp ̿ϹǷ ʿ )
	cUIRoundGauge mGauge;
	cString mNumText;
	NiColorA mColor;
	unsigned int mNumber;
	eTooltipType mTipType;		///  
	bool mShowNumber;
	sAniParam mAniParam[eANI_MAX];
	cIconParam* mIconParam;
	cUIImageFont* mImageFont;
};

inline
cItem::cItem()
: mIndex( 0 )
, mDBIndex( 0 )
, mEnhanced( 0 )
, mCount( 0 )
, mSeal( false )
, mCardIndex1( 0 )
, mCardIndex2( 0 )
, mCardIndex3( 0 )
, mCardIndex4( 0 )
, mCardIndex5( 0 )
, mDefine( 0 )
, mEquipType( ITEM_EQUIP_NORMAL )
, mFlag( ITEM_FLAG_NULL )
, mIcon( 0 )
, mIconParam( 0 )
, mImageFont( 0 )
, mNumber( 0 )
, mEnableUse( true )
, mLock( false )
, mShowNumber( false )
, mColor( NiColorA::WHITE )
, mTipType( eTOOLTIP_NONE )
{
	::memset( mAniParam, 0, sizeof(mAniParam) );
}

inline
cItem::cItem( cItem& other )
: mIcon( 0 )
{
	operator=( other );
}

inline
cItem::~cItem()
{
}

inline
unsigned long cItem::GetIndex() const
{
	return mIndex;
}

inline
unsigned short cItem::GetCount() const
{
	return mCount;
}

inline
unsigned char cItem::GetEnhanceStep() const
{
	return mEnhanced;
}

inline
cItemDefine* cItem::GetDefine()
{
	return mDefine;
}

inline
cItemTarot* cItem::GetTarotDefine()
{
	return mDefine->GetTarotDefine();
}
