#include "stdafx.h"
#include "ItemCountWindow.h"

#include "GameUIManager.h"
#include "ItemManager.h"
#include "ItemDefine.h"
#include "NumberEditBox.h"
#include "ObjectManager.h"
#include "Hero.h"

#include "BaseStage.h"
#include "StageManager.h"
#include "UIMsgboxEvent.h"

cItemCountWindow::cItemCountWindow()
: mMaxValue( 1 )
, mSlotIndex0( 0 )
, mSlotIndex1( 0 )
, mItemIndex( 0 )
, mNumEdit(0)
{
}

cItemCountWindow::~cItemCountWindow()
{
}

void cItemCountWindow::OnShow()
{
	cUIWindow::OnShow();

	if( mNumEdit )
	{
		mNumEdit->Clear();
		mNumEdit->SetMaxValue( mMaxValue );
	//	mNumEdit->SetValue( 1 );
		mNumEdit->SetFocus();
	//	mNumEdit->SetAllSelect();
	}
}


bool cItemCountWindow::HandleEvent(const cUIEvent& event )
{	
	if( mEnabled == false || mVisible == false )
		return mpParent->HandleEvent( event );

	switch( event.mType )
	{
	case eUIEVENT_LBUTTON_DOWN:
	case eUIEVENT_LBUTTON_UP:
	case eUIEVENT_MOUSE_MOVE:
		{
			cUINode* pNode = this->GetNode( event.mPos );
			if( pNode && (pNode->GetType() == eUINODE_BUTTON || pNode->GetType() == eUINODE_EDITBOX ))
				pNode->HandleEvent( event );
			else
				cUIWindow::HandleEvent( event );
		}
		break;
	case eUIEVENT_COMMAND:
	case eUIEVENT_GAME_COMMAND:
		if( event.mID == eMESSAGE_BUTTON_NO )
		{
			Hide();
		}
		else
			cUIWindow::HandleEvent( event );
		break;
	case eUIEVENT_EDITBOX_ENTER:
		{
			if( event.mCode == eKEY_RETURN )
			{
				/// Ȯ ư Է¿ 
				OnCommand( 0, eUIID_ITEMCOUNT_OK );
			}
			else if( event.mCode == eKEY_ESCAPE )
			{
				OnCommand( 0, eUIID_ITEMCOUNT_CANCEL );
			}
		}
		break;
	default:
		cUIWindow::HandleEvent( event );
		break;
	}
	return true;
}

///   ̺Ʈ 
void cItemCountWindow::ShowModal( eMSGBox_Event eventtype, unsigned int slotIndex0, unsigned int slotIndex1 )
{
	const cItem& item0 = ITEMMAN->GetItem( slotIndex0 );
	if( item0.GetCount() <= 1 )
		return;
	
	const cItem& item1 = ITEMMAN->GetItem( slotIndex1 );
	if( item1.GetCount() && item0.GetIndex() != item1.GetIndex() )
		return;

	mSlotIndex0 = slotIndex0;
	mSlotIndex1 = slotIndex1;

	mMaxValue = item0.GetCount();

	mMsgHandler = STAGEMAN->GetStage( STAGEMAN->GetCurrentStage() );
	mEventType = eventtype;

	cUIWindow::ShowModal( eventtype );
}

void cItemCountWindow::ShowModal( eMSGBox_Event eventtype, unsigned int slotIndex, unsigned int itemIndex, unsigned int maxValue )
{
	mSlotIndex0 = slotIndex;
	mItemIndex = itemIndex;
	mMaxValue = maxValue;

	mMsgHandler = STAGEMAN->GetStage( STAGEMAN->GetCurrentStage() );
	mEventType = eventtype;

	cUIWindow::ShowModal( eventtype );
}


///  ε õ ̺Ʈ
void cItemCountWindow::ShowModal( eMSGBox_Event eventtype, unsigned int index )
{
	switch( eventtype )
	{
	case eMBEVENT_ITEMCOUNT_BUY:
		{
			mItemIndex = index;

			/// ѹ Ҽ ִ ִ .
			cItemDefine* itemDefine = ITEMMAN->GetItemDefine( mItemIndex );
			assert(itemDefine);

			if( itemDefine )
			{
				mMaxValue = itemDefine->GetCapacity();

				switch( itemDefine->GetBuyType() )
				{
				case ItemBuyNone:
					{
						assert(0);
						return;
					}
				case ItemBuyMoney:
				case ItemBuyPvp:
				case ItemBuyTarot:
					{
						int money = 0;
						if( itemDefine->GetBuyType() == ItemBuyMoney )
						{
							money = HERO->GetMoney();
						}
						else if( itemDefine->GetBuyType() == ItemBuyPvp )
						{
							money = HERO->GetPVPPoint();
						}
						else if( itemDefine->GetBuyType() == ItemBuyTarot )
						{
							money = HERO->GetTarotPoint();
						}
						else
						{
							assert(0);
							return;
						}

						/// 
						int count = money / itemDefine->GetBuyPrice();

						/// 
						int remainWei = HERO->GetMaxWeight() - (int)ITEMMAN->GetWeight();
						int weiCount = ( itemDefine->GetWeight() > 0 ) ? remainWei / itemDefine->GetWeight() : remainWei;

						int mincount = ( count > weiCount ) ? weiCount : count;

						///  
						int invenCount = ITEMMAN->GetRemainCount( mItemIndex, mincount );

						mMaxValue = ( invenCount > mincount ) ? mincount : invenCount;
					}
					break;
				default:
					{
						/// η - ϶ GetBuyType()   ε.
						unsigned long haveCount = ITEMMAN->GetItemCount( itemDefine->GetBuyType() );
						cItemDefine* coinDefine = ITEMMAN->GetItemDefine( itemDefine->GetBuyType() );
						assert(coinDefine);
						if( coinDefine )
						{
							/// 
							int count = haveCount / itemDefine->GetBuyPrice();

							/// 
							int remainWei = HERO->GetMaxWeight() - (int)ITEMMAN->GetWeight();
							int weiCount = ( itemDefine->GetWeight() > 0 ) ? remainWei / itemDefine->GetWeight() : remainWei;

							int maxCount = ( count > weiCount ) ? weiCount : count;

							///  ÿ Ա ջ
							if( itemDefine->GetWeight() > 0 )
							{
								weiCount = (remainWei + (maxCount * coinDefine->GetWeight())) / itemDefine->GetWeight();
							}
							else
							{
								weiCount = remainWei + (maxCount * coinDefine->GetWeight());
							}

							int mincount = ( count > weiCount ) ? weiCount : count;

							///  
							int invenCount = ITEMMAN->GetRemainCount( mItemIndex, mincount );

							mMaxValue = ( invenCount > mincount ) ? mincount : invenCount;
						}
					}
					break;
				}
			}
		}
		break;
	case eMBEVENT_ITEMCOUNT_SELL:
		{
			mSlotIndex0 = index;

			const cItem& item = ITEMMAN->GetItem( mSlotIndex0 );
			mMaxValue = item.GetCount();
		}
		break;
	default:
		assert( 0 && "invalid item try" );
		return;
	}

	mMsgHandler = STAGEMAN->GetStage( STAGEMAN->GetCurrentStage() );
	mEventType = eventtype;

	cUIWindow::ShowModal( eventtype );
}

bool cItemCountWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	mNumEdit = (cNumberEditBox*)GetChild( eUIID_ITEMCOUNT_NUMBER );
	if( mNumEdit )
		mNumEdit->SetUseZero( false );
	return true;
}

void cItemCountWindow::OnCommand( cUINode*, unsigned int id )
{
	if( !mNumEdit )
	{
		assert(0);
		return;
	}

	switch( id )
	{
	case eUIID_ITEMCOUNT_UP:
		{
			int value = mNumEdit->GetValue();

			value++;
			if( value > mMaxValue )
				value = mMaxValue;

			mNumEdit->SetValue( value );
		}
		break;
	case eUIID_ITEMCOUNT_DOWN:
		{
			int value = mNumEdit->GetValue();

			value--;
			if( value < 1 )
				value = 1;

			mNumEdit->SetValue( value );
		}
		break;
	case eUIID_ITEMCOUNT_MAX:
		{
			mNumEdit->SetValue( mMaxValue );
		}
		break;
	case eUIID_ITEMCOUNT_OK:
		{
			int value = mNumEdit->GetValue();
			if( value > 0 )
			{
				if( value >= mMaxValue )
					value = mMaxValue;

				mNumEdit->SetValue( value );

				if( mMsgHandler )
					mMsgHandler->MsgBoxEventParser( mEventType, id, 0 );

				Hide();
			}
		}
		break;
	case eUIID_ITEMCOUNT_CLOSE:
	case eUIID_ITEMCOUNT_CANCEL:
		Hide();
		break;
	default:
		assert(0);
		break;
	}
}

void cItemCountWindow::OnButtonDowned( cUINode* , unsigned int id )
{
	if( !mNumEdit )
	{
		assert(0);
		return;
	}

	switch( id )
	{
	case eUIID_ITEMCOUNT_UP:
		{
			int value = mNumEdit->GetValue();

			value++;
			if( value > mMaxValue )
				value = mMaxValue;

			mNumEdit->SetValue( value );
		}
		break;
	case eUIID_ITEMCOUNT_DOWN:
		{
			int value = mNumEdit->GetValue();

			value--;
			if( value < 1 )
				value = 1;

			mNumEdit->SetValue( value );
		}
		break;
	}
}

unsigned int cItemCountWindow::GetCount()
{
	return ( mNumEdit )? mNumEdit->GetValue() : 0;
}