/* ==========================================================================
*    : ̼
*    : 2007.07.02
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Item_Common.h"
#include "Player_Common.h"

class cIconParam;

///   
const int MAX_DISJOINT = 6;
struct sDisjointData
{
	unsigned long itemIndex;
	unsigned int count;
};

///  
struct sItemDisjoint
{
	/// 
	unsigned long mPrice;

	///  
	sDisjointData mDisjoint[MAX_DISJOINT];
};

enum eEnhancedType
{
	eENHANCE_PHYSICATTACK = 1,		/// 
	eENHANCE_MAGICATTACK,			/// 
	eENHANCE_PHYSICDEFENSE,			/// 
	eENHANCE_MAGICDEFENSE,			/// 
};

///  ȭ
struct sItemEnhanced
{
	/// ȭǴ Ӽ1
	short mEnhanced1;

	/// ȭǴ Ӽ2
	short mEnhanced2;

	/// 
	unsigned int mValue[MAX_ITEM_ENHANCED];
};

/// Ƽ ȿ 
struct sAblityOption
{
	short mOptType;		/// ɼ ε Ÿ
	short mOptValue;	/// ɼ 

	sAblityOption()
	{
		mOptType = 0;
		mOptValue = 0;
	}
};

/// ī 
struct sItemPutCardSlot
{
	short mSlotType[MAX_CARD_SLOT];
};

///   Ÿ
enum eItemEquip
{
	ITEM_EQUIP_NORMAL = 0,
	ITEM_EQUIP_ONE_HAND,
	ITEM_EQUIP_TWO_HANDS,
	ITEM_EQUIP_SHIELD
};

///  ÷
/// ۰   Ÿ ˻ ( ƴѰ   )
enum eItemFlag
{
	ITEM_FLAG_NULL		= 0,
	ITEM_FLAG_WEAPON	= (1 <<  0),
	ITEM_FLAG_WEAR		= (1 <<  1),
	ITEM_FLAG_ACCESSORY	= (1 <<  2),

	ITEM_FLAG_SWORD		= (1 <<  3) | ITEM_FLAG_WEAPON,		/// Ѽհ
	ITEM_FLAG_BLADE		= (1 <<  4) | ITEM_FLAG_WEAPON,		/// հ
	ITEM_FLAG_DUAL		= (1 <<  5) | ITEM_FLAG_WEAPON,		/// ̵
	ITEM_FLAG_CUTTER	= (1 <<  6) | ITEM_FLAG_WEAPON,		/// ܰ
	ITEM_FLAG_GUN		= (1 <<  7) | ITEM_FLAG_WEAPON,		/// 
	ITEM_FLAG_STAFF		= (1 <<  8) | ITEM_FLAG_WEAPON,		/// 
	ITEM_FLAG_SHIELD	= (1 <<  9) | ITEM_FLAG_WEAPON,		/// 

	ITEM_FLAG_HEAD		= (1 << 10) | ITEM_FLAG_WEAR,		/// Ӹ
	ITEM_FLAG_UPPER		= (1 << 11) | ITEM_FLAG_WEAR,		/// 
	ITEM_FLAG_LOWER		= (1 << 12) | ITEM_FLAG_WEAR,		/// 
	ITEM_FLAG_HANDS		= (1 << 13) | ITEM_FLAG_WEAR,		/// 
	ITEM_FLAG_FEET		= (1 << 14) | ITEM_FLAG_WEAR,		/// 
	ITEM_FLAG_ONEPIECE	= (1 << 15) | ITEM_FLAG_WEAR,		/// ǽ

	ITEM_FLAG_EARRING	= (1 << 16) | ITEM_FLAG_ACCESSORY,	/// Ͱ
	ITEM_FLAG_NECKLACE	= (1 << 17) | ITEM_FLAG_ACCESSORY,	/// 
	ITEM_FLAG_BROOCH	= (1 << 18) | ITEM_FLAG_ACCESSORY,	/// ġ
	ITEM_FLAG_BRACELET	= (1 << 19) | ITEM_FLAG_ACCESSORY,	/// 
	ITEM_FLAG_RING		= (1 << 20) | ITEM_FLAG_ACCESSORY,	/// 

	ITEM_FLAG_EQUIPCARD	= (1 << 21),						///  ī
	ITEM_FLAG_UNKNOWN	= (1 << 22),

	ITEM_FLAG_ALL		= 0x7FFFFFFF
};

///  ɷ
class cItemAbility
{
	friend class cItemManager;

public:
	inline long  GetDescription() { return mDescription; }
	inline short GetTargetType() { return mTargetType; }
	inline short GetDefenseType() { return mDefenseType; }
	inline short GetUseRange() { return mUseRange; }
	inline short GetPhysicMaxAttack() { return mPhysicMaxAttack; }
	inline short GetPhysicMinAttack() { return mPhysicMinAttack; }
	inline short GetMagicMaxAttack() { return mMagicMaxAttack; }
	inline short GetMagicMinAttack() { return mMagicMinAttack; }
	inline short GetPhysicDefense() { return mPhysicDefense; }
	inline short GetMagicDefense() { return mMagicDefense; }
	inline short GetAttackRange() { return mAttackRange; }
	inline short GetAttackSpeed() { return mAttackSpeed; }
	inline long  GetCoolTime() { return mCoolTime; }
	inline unsigned int GetGroupNum() { return mGroupNum; }

	inline sAblityOption* GetOption() { return mOption; }
	inline long GetInfluenceIndex() { return mInfluenceIndex; }

private:
	/// ȿ  
	long mDescription; 

	/// 
	short mDefenseType;

	/// 
	short mRangeType;

	/// ȿŸ
	short mTargetType;

	/// Ÿ
	short mUseRange;

	///  
	short mPhysicDefense;
	///  
	short mMagicDefense;

	/// Ÿ
	short mAttackRange;

	///  ӵ
	short mAttackSpeed;

	/// ð
	long mCoolTime;

	/// ׷Ÿ ȣ
	unsigned int mGroupNum;

	///  ݷ()
	short mPhysicMinAttack;
	///  ݷ()
	short mPhysicMaxAttack;
	///  ݷ()
	short mMagicMinAttack;
	///  ݷ()
	short mMagicMaxAttack;

	/// ɼ 
	sAblityOption mOption[10];

	/// Ҹȿ
	long mInfluenceIndex;
};

///  
class cItemLimit
{
	friend class cItemManager;

public:
	cItemLimit();

	inline char GetRace() { return mCharRace; }
	inline char GetGender() { return mCharGender; }
	inline long GetJob() { return mCharJob; }
	inline char GetLevel() { return mCharLevel; }
	inline char GetPVPOnly() { return mUsePVPOnly; }

private:
	/// ĳ:
	char mCharRace;

	/// ĳ:
	char mCharGender;

	/// ĳ:
	long mCharJob;

	/// ĳ:
	char mCharLevel;

	///    ( 0 : Ұ, 1 : 밡 )
	char mUsePVPOnly;
};

inline cItemLimit::cItemLimit()
: mCharRace( 0 )
, mCharGender( 0 )
, mCharJob( 0 )
, mCharLevel( 0 )
{
}

///  
class cSpreadParam
{
public:
	/// ̹ ε
	int mImageIndex;

	/// ǥ
	unsigned int mX;

	/// ǥ
	unsigned int mY;

	/// 
	int mDir;

	///  ( 0 : 븻, 1 : *, 2 : /, 3 : + )
	int mCalc;

	/// ġ
	int mValue;
};

///  
class cItemSpread
{
	friend class cItemManager;

public:
	cItemSpread();

public:
	///   迭
	cSpreadParam mParam[10];
};

inline cItemSpread::cItemSpread()
{	
	memset( mParam, 0, sizeof(mParam) );
}

///  ī
class cItemCard
{
	friend class cItemManager;

public:
	cItemCard();

private:
	/// 
	char mEpisode;

	/// īѹ
	unsigned int mCardNumber;

	/// ͵
	char mRareLevel;

	/// īз
	char mCardType;

	/// ġ
	char mWearPos;

	/// ̹ε
	unsigned int mImageIndex;
};

inline
cItemCard::cItemCard()
: mEpisode(0)
, mCardNumber(0)
, mRareLevel(0)
, mCardType(0)
, mWearPos(0)
, mImageIndex(0)
{

}

///  Ÿī
class cItemTarot
{
	friend class cItemManager;

public:
	cItemTarot();

	///
	inline unsigned int GetImageIndex() { return mImageIndex; }
	inline unsigned char GetUniqueNumber() { return mNumber; }

	///
	inline short GetStraightValue() { return mStraightValue; }
	inline short GetInverseValue() { return mInverseValue; }

	/// ؼȣ 
	inline unsigned long GetStraightDesc() { return mStraightIdx; }
	inline unsigned long GetInverseDesc() { return mInverseIdx; }

private:
	/// ī ̹ ε
	unsigned int mImageIndex;

	///  ȣ
	char mNumber;

	/// ī巹
	char mLevel;

	/// ġ
	short mStraightValue;

	/// ġ
	short mInverseValue;

	/// Ӽ
	char mProperty;

	/// Ǽҵ()
	char mEpisode;

	/// ؼ ε 
	unsigned long mStraightIdx;

	/// ؼ ε
	unsigned long mInverseIdx;
};

inline cItemTarot::cItemTarot()
: mImageIndex(0)
, mNumber(0)
, mLevel(0)
, mStraightValue(0)
, mInverseValue(0)
, mProperty(0)
, mEpisode(0)
, mStraightIdx(0)
, mInverseIdx(0) 
{

}

///  
class cItemDefine
{
	friend class cItemManager;

public:
	cItemDefine();

	inline LPCTSTR GetName() { return mName; }
	inline LPCTSTR GetDescription() { return mDescription; }
	inline unsigned char GetType() { return mType; }
	unsigned char GetSubType() { return mSubType; }
	inline unsigned short GetTipType() { return mTooltipColor; }
	inline short GetWeight() { return mWeight; }
	inline unsigned short GetCapacity() { return mCapacity; }
	inline cIconParam* GetIconParam() { return mIconParam; }
	inline const char* GetFileName0( unsigned int race, unsigned int gender );
	inline const char* GetFileName1( unsigned int race, unsigned int gender );
	inline eItemEquip GetEquipType() { return mEquipType; }
	inline cItemCard* GetCardDefine() { return mCard; }
	inline cItemTarot*	GetTarotDefine() { return mTarot; }
	inline cItemSpread* GetSpreadDefine() { return mSpread; }
	inline sItemDisjoint* GetDisjoint() { return mDisjoint; }
	inline sItemPutCardSlot* GetPutCard() { return mPutCardSlot; } 
	inline cItemAbility* GetAbililty() { return mAbility; }
	inline cItemLimit* GetLimit() { return mLimit; }
	inline sItemEnhanced* GetEnhanced() { return mEnhance; }
	inline unsigned long GetBuyPrice() { return mBuyPrice; }
	inline unsigned long GetSellPrice() { return mSellPrice; }
	inline unsigned long GetBuyType() { return mBuyType; }
	inline unsigned long GetSellType() { return mSellType; }
	inline unsigned short GetPutSlotCount() { return mPutSlotCount; }
	inline char GetExchange() { return mExchange; }
	inline unsigned long GetTitleIndex() { return mTitleIndex; }
	inline char GetShowHead() { return mShowHead; }		/// 0 : Ӹǥ on, 1 : Ӹǥ off

private:
	/// ̸
	LPCTSTR mName;

	/// 
	LPCTSTR mDescription;

	/// 
	unsigned char mType;

	///  
	unsigned char mSubType;

	/// 
	short mWeight;

	///  
	unsigned short mCapacity;

	/// Ǹ 
	unsigned long mSellType;

	/// ǸŰ
	unsigned long mSellPrice;

	///  
	unsigned long mBuyType;

	/// ԰
	unsigned long mBuyPrice;

	/// ִ 
	unsigned long mPresentNum;

	///   
	unsigned long mMaxHaveInven;

	///  ÷ (  )
	unsigned short mTooltipColor;

	/// ȣĪ ε
	unsigned long mTitleIndex;

	/// ŷ  (0ŷ/1ŷҰ)
	char mExchange;

	/// ɷ
	cItemAbility* mAbility;

	/// 
	cItemLimit* mLimit;

	/// ī ε
	cItemCard* mCard;

	/// Ÿ ε 
	cItemTarot* mTarot;

	///  ε 
	cItemSpread* mSpread;

	///  
	sItemDisjoint* mDisjoint;

	/// ȭ 
	sItemEnhanced* mEnhance;

	/// ī  
	sItemPutCardSlot* mPutCardSlot;
	unsigned short mPutSlotCount;			/// ī   

	///  ̹
	cIconParam* mIconParam;

	/// ϸ 迭
	cString* mFileNames0;
	cString* mFileNames1;

	///  Ÿ
	eItemEquip mEquipType;

	///  
	char mShowHead;

	/// ÷
	eItemFlag mFlag;
};

inline
cItemDefine::cItemDefine()
: mName( 0 )
, mDescription( 0 )
, mType( 0 )
, mSubType( 0 )
, mWeight( 0 )
, mBuyPrice( 0 )
, mSellPrice( 0 )
, mAbility( 0 )
, mLimit( 0 )
, mCard( 0 )
, mTarot(0)
, mSpread( 0 )
, mDisjoint( 0 )
, mEnhance( 0 )
, mPutCardSlot( 0 )
, mIconParam( 0 )
, mFileNames0( 0 )
, mFileNames1( 0 )
, mEquipType( ITEM_EQUIP_NORMAL )
, mFlag( ITEM_FLAG_NULL )
, mTooltipColor( 0 )
, mPutSlotCount( 0 )
, mTitleIndex( 0 )
, mExchange( false )
, mShowHead( 0 )
{
}

inline
const char* cItemDefine::GetFileName0( unsigned int race, unsigned int gender )
{
	assert( race < eRACE_MAX );
	assert( gender < eGENDER_MAX );

	if( mFileNames0 == 0 )
		return 0;
	else
	{
		if( mType == ITEM_WEAPON )
		{
			/// None  ΰ/ 
			if( mFileNames0[race * eGENDER_MAX + gender] == "None" )
				return mFileNames0[0].Cstr();
			else
				return mFileNames0[race * eGENDER_MAX + gender].Cstr();
		}
		else
		{
			return mFileNames0[race * eGENDER_MAX + gender].Cstr();
		}
	}
}

inline
const char* cItemDefine::GetFileName1( unsigned int race, unsigned int gender )
{
	assert( race < eRACE_MAX );
	assert( gender < eGENDER_MAX );

	if( mFileNames1 == 0 )
		return 0;
	else
	{
		if( mType == ITEM_WEAPON )
		{
			/// None  ΰ/ 
			if( mFileNames1[race * eGENDER_MAX + gender] == "None" )
				return mFileNames1[0].Cstr();
			else
				return mFileNames1[race * eGENDER_MAX + gender].Cstr();
		}
		else
		{
			return mFileNames1[race * eGENDER_MAX + gender].Cstr();
		}
	}
}
