/* ==========================================================================
*    : ̼
*    : 2007.07.02
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Item_Common.h"
#include "Item.h"
#include "BaseStage.h"
#include "UIRect.h"
typedef tUIRect<int> cUIRect;

struct MSG_RES_NPC_ITEM_MOV2_INVENTORY;
struct MSG_RES_NPC_ITEM_BUY;
struct MSG_RES_NPC_ITEM_SELL;

/// â ¿
const int MAX_ITEMNAME_LEN = 10;
const int ITENNAME_LEN = 128;
const int MAX_NAME_WIDTH = 102;
const unsigned long OPEN_TIME = 1000;

const unsigned long TRADE_WAIT_TIME = 10000;

class cParser;
class cUIText;
class cItemDefine;
class cItemAbility;
class cItemLimit;
class cItemCard;
class cGauge;
class cPlayer;
class cUIWindow;

/// drop item ׷ 
class cSceneNode;

/// npc    
const int NPCSTORE_TAB_COUNT = 5;
const int NPCSTORE_SLOT_COUNT = 10;

/// κ丮  Ե
///   ϱ ,  þ
enum eNotInvenSlotIndex
{
	///  Npc  
	NPCSTORE_SLOT_BEGIN = MAX_INVENTORY + 1,
	NPCSTORE_SLOT_END = NPCSTORE_SLOT_BEGIN + NPCSTORE_SLOT_COUNT - 1,

	///  
	DISJOINT_SLOT,

	/// ȭ 
	ENHANCED_ITEM_SLOT,

	/// ȭī 
	ENHANCED_CARD_SLOT,

	/// ī  
	PUTCARD_ITEM_SLOT,
	PUTCARD_CARD_SLOT_BEGIN,
	PUTCARD_CARD_SLOT_END = PUTCARD_CARD_SLOT_BEGIN + MAX_CARD_SLOT - 1,

	NOTINVENSLOT_MAX,
};

/// κ丮  
const int EQUIP_SLOT_COUNT = INVENTORY_HAND_END - INVENTORY_WEAR_BEGIN + 1;

/// κ丮 Ʈ 
const int INVENSHEET_SLOT_COUNT = INVENTORY_BAG0_END - INVENTORY_BAG0_BEGIN + 1;

/// κ丮  
const int BAG_SLOT_COUNT = INVENTORY_BAG1_END - INVENTORY_BAG1_BEGIN + 1;

///  â 
const int WAREHOUSE_SLOT_COUNT = INVENTORY_WAREHOUSE0_END - INVENTORY_WAREHOUSE0_BEGIN + 1;

///  
const int ITEM_SLOT_COUNT = MAX_INVENTORY + NOTINVENSLOT_MAX + 1;

///   Ҽ
///   â ϴ ˼ .
enum eItemIn
{
	ITEM_IN_NULL = 0,
	ITEM_IN_EQUIP,
	ITEM_IN_INVEN_PRIVATE,
	ITEM_IN_INVEN_QUEST,
	ITEM_IN_INVEN_MALL,
	ITEM_IN_WAREHOUSE_PRIVATE,
	ITEM_IN_WAREHOUSE_MALL,
	ITEM_IN_NPCSTORE,
	ITEM_IN_USERSELL,	
	ITEM_IN_DISJOINT,
	ITEM_IN_ENHANCED_ITEM,
	ITEM_IN_ENHANCED_CARD,
	ITEM_IN_PUTCARD_ITEMSLOT,
	ITEM_IN_PUTCARD_CARDSLOT,
	ITEM_IN_CARDBOOK_TAROT,
	ITEM_IN_CARDBOOK_SPREAD,
};

///  õ
enum eItemTry
{
	ITEM_TRY_NULL = 0,
	ITEM_TRY_MOVE,
    ITEM_TRY_USE,
	ITEM_TRY_EQUIP,
	ITEM_TRY_UNEQUIP,
	ITEM_TRY_DUMP,
	ITEM_TRY_SPLIT,
	ITEM_TRY_MERGE,
	ITEM_TRY_SWITCH,
	ITEM_TRY_BUY,
	ITEM_TRY_SELL,
	ITEM_TRY_GET,				/// ڷκ  ȹ
	ITEM_TRY_DISJOINT,
	ITEM_TRY_ENHANCEDSTART,
	ITEM_TRY_ENHANCEDCANCEL,
	ITEM_TRY_ENHANCEDEND,
	ITEM_TRY_TRADEADD,
	ITEM_TRY_TRADEDELETE,
	ITEM_TRY_SELLITEMADD,
	ITEM_TRY_SELLITEMDELETE,
	ITEM_TRY_SELLGET,			///  
	ITEM_TRY_QUEST_REWARDTAKE,	///   & ݳ ó
	ITEM_TRY_QUEST_ADDBYITEM,	///   & Ƿھ  ó
	ITEM_TRY_QUEST_TAKE,		///  ݳ
	ITEM_TRY_PUTCARD,			/// ī 
	ITEM_TRY_CARDBOOKADD,		/// ÷Ǻ 
	ITEM_TRY_PICK,				/// ̽ٷ  ݱ
	ITEM_TRY_CHANGE,			/// ü 
	ITEM_TRY_MIXSKILL,			/// ձ 
};

struct sNpcItemData
{
	unsigned long			mTextIndex;
	tArray<unsigned long>	mItemArr;

	sNpcItemData()
	{
		mTextIndex = 0;
	}
};

///  Npc 
class cItemNpcStore
{
public:
	cItemNpcStore();
	~cItemNpcStore();

	void Clear();
	bool Load( cParser& parser );
	bool LoadTab( cParser& parser );

	unsigned int GetTabCount() { return mDataCount; }
	unsigned int GetItemCount( unsigned int tab );
	unsigned long GetItemIndex( unsigned int tabIndex, unsigned int cellIndex );
	unsigned long GetTextIndex( unsigned int tabIndex );

private:
	///  īƮ
	unsigned int mDataCount;
	sNpcItemData mItemData[NPCSTORE_TAB_COUNT];
};

inline
cItemNpcStore::cItemNpcStore()
: mDataCount(0)
{
}

inline
cItemNpcStore::~cItemNpcStore()
{
	Clear();
}

inline
unsigned long cItemNpcStore::GetItemIndex( unsigned int tabIndex, unsigned int cellIndex )
{
	return mItemData[tabIndex].mItemArr[cellIndex];
}

inline
unsigned long cItemNpcStore::GetTextIndex( unsigned int tabIndex )
{
	return mItemData[tabIndex].mTextIndex;
}

inline
unsigned int cItemNpcStore::GetItemCount( unsigned int tab )
{
	return mItemData[tab].mItemArr.GetSize();
}

///  
class cItemManager
{
	friend class cCheatManager;

public:
	static cItemManager* mSingleton;

	///  ( text index, з Ʈ )
	typedef tPair<unsigned int, void*> cDataPair;

public:
	cItemManager();
	~cItemManager();

	/// ʱȭ
	bool Init();
	void Open();

	///  
	void Close();

	/// 
	void BindIcon( unsigned int slotIndex, cItemIcon* icon );
	void LinkIcon( cItemIcon* icon );
	void UnLinkIcon( bool setcolor = false );
	void ClearColor( unsigned int slotIndex );
	void CheckItemSlot( unsigned int slotIndex );

	/// Ÿ 
	void StartCoolTime( unsigned long itemIndex, unsigned long coolTime );
	void EndCoolTime( unsigned long itemIndex );
	void CopyCoolTime( unsigned long itemIndex, unsigned long startTime, unsigned long restTime, unsigned long totalTime );

	/// ӽ, ü Ÿ    
	void SetAllItemCool();

	/// 
	void SetWeightGauge( cGauge* gauge );
	void SetMaxWeightGauge( float max );
	void SetCurWeightGauge();

	///  ȭ  üũ ( , , 뿩ε )
	void UpdateItem();
	float GetWeight();

	///  Ƽ üũ
	void ClearAbility();
	void CheckEquipAbility();

	sEquipAbility* GetBasicAbil();

	/// hero   
	cItem& GetHeroRightWeapon();
	cItem& GetHeroLeftWeapon();

	/// ⸦ ϰ ִ 
	bool IsEquipWeapon();
	void SetActiveWeapon( int active ) { mActiveWeapon = (eItemActiveWeapon)active; }
	int GetActiveWeapon() { return (int)mActiveWeapon; }

	/// κ丮 õ  Ѱ ϵ 
	void SetInvenSelect( cUIWindow* win );

	///   ÷  
	void GetTooltipColor( unsigned short tiptype, unsigned long& color );

	///    ȹ
	unsigned long GetPriceUinit( unsigned long type );

	/// ۸ ̱
	bool ModifyItemName( LPCTSTR name, TCHAR* out );

	/// 
	bool CheckLimit( unsigned int slotIndex );	
	bool CheckMoveItem( unsigned int itemIndex, unsigned short count );
	bool CheckDisjoint( unsigned int slotIndex );
	bool TryToMoveItem( unsigned int slotIndex0, unsigned int slotIndex1, cItemIcon* icon );
	bool TryToEquipItem( unsigned int slotIndex );
	bool TryToUnEquipItem( unsigned int slotIndex );
	bool TryToDumpItem( unsigned int slotIndex );
	bool TryToSplitItem( unsigned int slotIndex0, unsigned int slotIndex1, unsigned short value );
	bool TryToUseMapChange( unsigned int slotIndex );
	
	/// 
	bool TryToSwitchWeapon();

	/// ش    ִ 
    bool CheckEmptySlot( unsigned int itemIndex, unsigned short count );

	/// Կ   ִ  ϱ
	int GetRemainCount( unsigned int itemIndex, unsigned short mincount );

	/// 
	bool CheckBuyItem( unsigned int itemIndex, unsigned short count );
	bool TryToBuyItem( unsigned int itemIndex, unsigned short count );
	bool TryToSellItem( unsigned int slotIndex, unsigned short count );

	///  ݱ
	bool TryToGetItem( unsigned long itemIndex, unsigned short count );

	///  , ȭ (,ī)
	bool TryToDisjoint( unsigned int slotIndex );

	bool TryToEnhancedStart();
	void TryToEnhancedCancel( bool close = true );
	bool TryToEnhanced( unsigned int slotIndex0, unsigned int slotIndex1 );

	/// 080402 PKH Npc
	void NpcNetTryItem( unsigned int protocol, void* msg = 0 );

	/// ŷ
	bool TryToTradeAsk( cPlayer* player );	/// ŷû
	void TryToTradeAccept();								/// ŷ 
	void TryToTradeReject();								/// ŷ 
	void TryToTradeCancel();								/// ݱ û
	bool TryToTradeItemAdd( unsigned int slotIndex );		///  
	bool TryToTradeMoneyAdd( unsigned long money );			/// ŷݾ 
	bool TryToTradeItemDelete( unsigned int slotIndex, unsigned int arrIndex );	///  
	void TryToTradeOk();									/// ŷǰ Ȯ Ϸ
	void TryToTradeReTry();									///  û
	void TryToTradeEnd();									/// ŷ  

	/// 
	unsigned long GetUserSellTarget() { return mUserSellTarget; }
	void ClearUserSellTarget();
	bool TryToUserSellOpen();
	bool TryToUserSellReName( LPCTSTR title );
	void TryToUserSellClose();
	bool TryToUserSellAdd( unsigned short slot, unsigned long price );
	bool TryToUserSellDelete( unsigned short slot );
	bool TryToUserSellModify( unsigned short slot );
	void TryToUserSellJoin( sObject& obj );
	void TryToUserSellJoinClose();										///   ݱ
	bool TryToUserSellGet( unsigned short slot, unsigned short count );	///  Կû
	void TryToUserSellSearch( unsigned long itemIndex, unsigned char enhanced );

	/// ī  ( , ī,   )
	bool TryToPutCard( unsigned int itemSlot, unsigned int cardSlot, unsigned int putSlot );

	/// ÷Ǻ ī  
	bool TryToCardBookAdd( unsigned int slot0, unsigned int slot1 );

	///
	cItem& GetItem( unsigned int slotIndex );
	cItemDefine* GetItemDefine( long itemIndex );
	cItemAbility* GetItemAbility( long itemIndex );
	eItemIn GetItemIn( unsigned int slotIndex );
	cItemNpcStore* GetItemNpcStore( unsigned int npcIndex );
	unsigned int GetItemCount( long itemIndex );
	unsigned int FindSlotIndex( long itemIndex );
	LPCTSTR GetItemName( unsigned int textIndex );

	/// 
	void LockItemTry( eItemTry itemTry, unsigned long slotIndex0 = 0 );	/// ܺ 

	///  Ǯ 
	eItemTry GetItemTry() { return mTry; }
	void UnlockItemTry( eItemTry itemTry );
	bool IsLocked();

	/// Ʈũ ޽
	void NetworkMsgParser( char* msg );
	void NetSetItem( sInventory* inv, bool setCool = true );

	/// DropItem ̽..
	bool CreateDropItem( MSG_ITEM_INFO* dropMsg );
	void DeleteDropItem( unsigned long idx );

	/// Ʈ   
	void DeleteQuestInsertItem();

	///  ,  
	void DeleteMixInsertItem();

	/// DropItem   üũ
	//bool ProcessLButtonClick( int mouseX, int mouseY );
	//bool ProcessLButtonDClick( int mouseX, int mouseY );
	//bool ProcessMouseOver( int mouseX, int mouseY );

	bool CheckNearestDropItem();
	bool CheckOpenTime();

	///  Ī ǥ 
	void SetWeaponIconPos( unsigned int slotIndex, cUIRect rect );

	///  з ȹ
	tArray<unsigned long>* GetHighClassArr() { return &mHighClassArr; }
	tArray<unsigned long>* GetMiddleClassArr( unsigned long key ) { return (tArray<unsigned long>*)mMiddleClassMap.GetAt( key ); }
	tArray<unsigned long>* GetLowClassArr( unsigned long key ) { return (tArray<unsigned long>*)mLowClassMap.GetAt( key ); }
	tArray<unsigned long>* GetItemCategoryArr( unsigned long key ) { return (tArray<unsigned long>*)mItemMap.GetAt( key ); }

#ifdef _GMTOOL
	tArray<unsigned long>* GetGMItemCategoryArr( unsigned long key ) { return (tArray<unsigned long>*)mGMItemMap.GetAt( key ); }
#endif

	///  Ǹ ȹ
	tHashMap<long, void*>& GetDefineMap() { return mDefineMap; }
	
protected:
	/// ε
	bool LoadText( const cString& pathName );
	bool LoadDefine( const cString& pathName );
	bool LoadAbility( const cString& pathName );
	bool LoadLimit( const cString& pathName );
	bool LoadCard( const cString& pathName );
	bool LoadTarot( const cString& pathName );
	bool LoadSpread( const cString& pathName );
	bool LoadFileName( const cString& pathName );
	bool LoadNpcStore( const cString& pathName );
	bool LoadDisjoint( const cString& pathName );
	bool LoadEnhanced( const cString& pathName );
	bool LoadCardSlot( const cString& pathName );
	bool LoadCategoryTable( const cString& pathName );

	/// Ÿ   ε
	void LoadCoolData();
	
	///
	void LockAndBackup( eItemTry itemTry, unsigned int slotIndex0, unsigned int slotIndex1 = 0, unsigned long tempIndex = 0, unsigned short value = 0, unsigned long price = 0, cItemIcon* icon = 0 );

	/// 
	bool TestMoveItemDown( unsigned int slotIndex0, unsigned int slotIndex1 );
	bool TestMoveItemUp( unsigned int slotIndex0, unsigned int slotIndex1 );

	bool MoveItemDown( unsigned int slotIndex0, unsigned int slotIndex1 );
	bool MoveItemUp( unsigned int slotIndex0, unsigned int slotIndex1 );

	bool TestEquipWeapon( unsigned int& slotIndex1, eItemEquip equipType );
	bool TestEquipWeapon_OneHand( unsigned int& slotIndex1 );
	bool TestEquipWeapon_TwoHands( unsigned int& slotIndex1 );
	bool TestEquipWeapon_Shield( unsigned int& slotIndex1 );
	bool TestEquipWear( unsigned int& slotIndex1, unsigned char subType );
	bool TestEquipAccessory( unsigned int& slotIndex1, unsigned char subType );
	bool TestEquipCard( unsigned int& slotIndex1 );

	bool TestUseItem( unsigned int slotIndex0 );
	bool TestUseEtcItem( unsigned int slotIndex0 );	// Ʈ Ƿھ

	bool EquipWeapon( unsigned int& slotIndex1, unsigned int slotIndex, eItemEquip equipType );
	bool EquipWeapon_OneHand( unsigned int& slotIndex1, unsigned int slotIndex );
	bool EquipWeapon_TwoHands( unsigned int& slotIndex1, unsigned int slotIndex );
	bool EquipWeapon_Shield( unsigned int& slotIndex1, unsigned int slotIndex );
	bool EquipWear( unsigned int& slotIndex1, unsigned int slotIndex, unsigned char subType );
	bool EquipAccessory( unsigned int& slotIndex1, unsigned int slotIndex, unsigned char subType );
	bool EquipCard( unsigned int& slotIndex1, unsigned int slotIndex );

	bool FindEmptySlot( unsigned int* slotIndex, unsigned int begin, unsigned int end );

	/// Ʈũ
	void NetTryItem( unsigned int protocol, void* msg = 0 );
	void NetMoveItem( unsigned int slotIndex0, unsigned int slotIndex1 );
	void NetEquipItem( unsigned int slotIndex );
	void NetUseItem( unsigned int slotIndex );
	void NetUnEquipItem( unsigned int slotIndex );
	void NetDumpItem( unsigned int slotIndex );
	void NetSplitItem( MSG_RES_ITEM_DIVIDE_INVENTORY* msgData );
	void NetSplitItem( MSG_RES_NPC_ITEM_MOV2_INVENTORY* msgData, unsigned int slotIndex0, unsigned int slotIndex1 );

	void SetSwitchWeapon( eItemActiveWeapon activeWeapon );
	void NetSwitchWeapon( eItemActiveWeapon activeWeapon );
	void NetBuyItem( MSG_RES_NPC_ITEM_BUY* msgData );
	void NetGetItem( MSG_RES_ITEM_GET* msgData );
	void NetSellItem( MSG_RES_NPC_ITEM_SELL* msgData );
	void NetRewardItem( MSG_RES_ITEM_REWARD* msgData );
	void NetTakeItem( MSG_RES_ITEM_TAKE* msgData );
	void NetDisjointItem( MSG_RES_ITEM_DISJOINT_INVENTORY* msgData );
	void NetEnhancedItem( MSG_RES_ITEM_ENHANCED_END* msgData );
	void NetTradeItem( MSG_RES_ITEM_EXCHANGE_END* msgData );
	void NetChangeItem( MSG_RES_ITEM_CHANGE_INVENTORY* msgData );
	void NetMixSkillItem( MSG_RES_MAKESKILL_ITEM* msgData );
	void NetMixItem( MSG_RES_ITEM_MIXED* msgData );

	///
	cItemLimit* GetItemLimit( long itemIndex );
	cString* GetItemFileNames( long itemIndex );
	cItemSpread* GetItemSpread( long itemIndex );
	cItemCard* GetItemCard( long itemIndex );
	cItemTarot* GetItemTarot( long itemIndex );
	sItemDisjoint* GetItemDisjoint( long index );
	sItemEnhanced* GetItemEnhanced( long index );
	sItemPutCardSlot* GetItemPutCardSlot( long index );
	
	///  Ƽ üũ
	void AddAbility( cItem& item );
	void AddSpecialAbility( short type, short value );

	void AddEnhance( cItem& item );
	void AddPutCard( unsigned long cardIndex );

	///  ü  ˻ &&  Ѱ 
	void CheckWeight();
	void CheckItemCount();

	/// õ  
	void ChangeSelectSlot( unsigned int slot );
	
	/// ġƮ
	bool CheatMakeItem( sInventory* inv );

public:
	/// ü 
	static cItemManager* GetSingleton();

protected:
	/// ؽƮ
	cUIText* mItemText;

	///  
	typedef tHashMap<long, void*> cDefineMap;
	cDefineMap mDefineMap;

	///  ɷ
	typedef tHashMap<long, void*> cAbilityMap;
	cAbilityMap mAbilityMap;

	///  
	typedef tHashMap<long, void*> cLimitMap;
	cLimitMap mLimitMap;

	///  ī
	typedef tHashMap<long, void*> cCardMap;
	cCardMap mCardMap;

	///  Ÿ
	typedef tHashMap<long, void*> cTarotMap;
	cTarotMap mTarotMap;

	///  
	typedef tHashMap<long, void*> cSpreadMap;
	cSpreadMap mSpreadMap;

	///  ϸ 迭
	typedef tHashMap<long, void*> cFileNamesMap;
	cFileNamesMap mFileNamesMap;

	///    
	typedef tHashMap<long, void*> cDisjointMap;
	cDisjointMap mDisjointMap;

	///  ȭ  
	typedef tHashMap<long, void*> cEnhancedMap;
	cEnhancedMap mEnhancedMap;

	/// ī  
	typedef tHashMap<long, void*> cPutCardSlotMap;
	cPutCardSlotMap	mPutCardSlotMap;

	///  з  ڷᱸ
	///   ε

	typedef tArray<unsigned long> cNameIdxArr;
	typedef tPointerHashMap<unsigned long, void*> cNameIdxArrMap;

	cNameIdxArr mHighClassArr;
	cNameIdxArrMap mMiddleClassMap;
	cNameIdxArrMap mLowClassMap;
	cNameIdxArrMap mItemMap;

#ifdef _GMTOOL
	cNameIdxArrMap mGMItemMap;
#endif

protected:

	///  迭
	cItem mItemArray[MAX_INVENTORY];

	///  ÷ 迭
	int mFlagArray[MAX_INVENTORY];

	///  
	bool mLocked;

	/// Ȱȭ  
	eItemActiveWeapon mActiveWeapon;

	/// front / back ǥ
	cUIRect mFrontLeft;
	cUIRect mFrontRight;
	cUIRect mBackLeft;
	cUIRect mBackRight;

	/// 
	eItemTry mTry;
	unsigned int mSlotIndex0;
	unsigned int mSlotIndex1;
	unsigned long mTempIndex;	///  Ȳ  ε
	unsigned short mValue;
	unsigned long mPrice;
	cItemIcon* mLinkedIcon;

	/// 
	cGauge* mWeightGauge;
	float mMaxWeight;
	float mCurWeight;

	///  Ƽ ( ⺻, ߰ )
	sEquipAbility mBasicAbil;

	/// Npc 
	typedef tHashMap<unsigned int, void*> cNpcStoreMap;
	cNpcStoreMap mNpcStoreMap;

	///      (ε,  Ѱ)
	typedef tHashMap<long, unsigned int> cItemCountMap;
	cItemCountMap mItemCountMap;

	/// Drop Item    ϱ  ڷᱸ
	/// server  index / ׷ Node 
	typedef tPointerHashMap<unsigned long, unsigned long> cDropItemMap;
	cDropItemMap mDropItemMap;

	/// ŷ  
	unsigned long mTradeTarget;
	cStringT mTradeName;
	unsigned long mTradeMoney;

	///  
	cStringT mUserSellName;	
	unsigned long mUserSellTarget;	/// ִ  Ÿε

	///   ½ð üũ
	unsigned long mLastAccutime;
};

inline
void cItemManager::SetWeightGauge( cGauge* gauge )
{
	mWeightGauge = gauge;
}

inline
float cItemManager::GetWeight()
{
	return mCurWeight;
}

inline
cItem& cItemManager::GetItem( unsigned int slotIndex )
{
	assert( slotIndex <= MAX_INVENTORY && "index out of range" );

	return mItemArray[ slotIndex ];
}

inline
sEquipAbility*	cItemManager::GetBasicAbil()
{
	return &mBasicAbil;
}

inline
void cItemManager::ClearUserSellTarget()
{
	mUserSellTarget = 0;
}

inline
cItemManager* cItemManager::GetSingleton()
{
	return mSingleton;
}

#define ITEMMAN cItemManager::GetSingleton()
