#include "stdafx.h"
#include "Item_Common.h"
#include "ItemManager.h"

#include "BaseObject.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "QuickManager.h"
#include "RangeCheck.h"
#include "MonsterScript.h"
#include "ChatManager.h"
#include "Monster_Common.h"
#include "GameResourceManager.h"
#include "PartyManager.h"
#include "TitleManager.h"
#include "SkillScript.h"

bool cItemManager::TestMoveItemDown( unsigned int i0, unsigned int i1 )
{
	cItem& item0 = mItemArray[i0];
	cItem& item1 = mItemArray[i1];

	if( item0.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
		///  Ѿ
	}
	else
	{
		if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
		{
			unsigned int i2 = 0;

			switch( i0 )
			{
			case INVENTORY_HAND_LEFT1:
				i2 = INVENTORY_HAND_RIGHT1;
				break;
			case INVENTORY_HAND_RIGHT1:
				i2 = INVENTORY_HAND_LEFT1;
				break;
			case INVENTORY_HAND_LEFT2:
				i2 = INVENTORY_HAND_RIGHT2;
				break;
			case INVENTORY_HAND_RIGHT2:
				i2 = INVENTORY_HAND_LEFT2;
				break;
			}

			cItem& item2 = mItemArray[i2];

			if( item2.mCount )
			{
				unsigned int i3 = 0;
				if( FindEmptySlot( &i3, INVENTORY_BAG0_BEGIN, INVENTORY_BAG3_END ) == false )
					return false;
			}
		}
	}
	return true;
}

bool cItemManager::MoveItemDown( unsigned int i0, unsigned int i1 )
{
	cItem& item0 = mItemArray[i0];
	cItem& item1 = mItemArray[i1];

	if( item0.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
		if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
		{
			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
		}
		else if( item1.mCount )
		{
			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
		}
		else
		{
			item1 = item0;
			item0 = 0;
		}
	}
	else
	{
		if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
		{
			unsigned int i2 = 0;

			switch( i0 )
			{
			case INVENTORY_HAND_LEFT1:
				i2 = INVENTORY_HAND_RIGHT1;
				break;
			case INVENTORY_HAND_RIGHT1:
				i2 = INVENTORY_HAND_LEFT1;
				break;
			case INVENTORY_HAND_LEFT2:
				i2 = INVENTORY_HAND_RIGHT2;
				break;
			case INVENTORY_HAND_RIGHT2:
				i2 = INVENTORY_HAND_LEFT2;
				break;
			}

			cItem& item2 = mItemArray[i2];

			if( item2.mCount )
			{
				unsigned int i3 = 0;
				if( FindEmptySlot( &i3, INVENTORY_BAG0_BEGIN, INVENTORY_BAG3_END ) == false )
					return false;

				cItem& item3 = mItemArray[i3];

				cItem tempItem = item1;
				item1 = item0;
				item0 = tempItem;
				item3 = item2;
				item2 = 0;
			}
			else
			{
				cItem tempItem = item1;
				item1 = item0;
				item0 = tempItem;
			}
		}
		else if( item1.mCount )
		{
			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
		}
		else
		{
			item1 = item0;
			item0 = 0;
		}
	}

	/// ü ɷġ˻
	CheckEquipAbility();

	///   
	HERO->ResetArmorSets();
	return true;
}

bool cItemManager::TestMoveItemUp( unsigned int i0, unsigned int i1 )
{
	cItem& item0 = mItemArray[i0];
	cItem& item1 = mItemArray[i1];

	if( item0.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
		if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
		{
		}
		else if( item1.mCount )
		{
			unsigned int i2 = 0;

			switch( i1 )
			{
			case INVENTORY_HAND_LEFT1:
				i2 = INVENTORY_HAND_RIGHT1;
				break;
			case INVENTORY_HAND_RIGHT1:
				i2 = INVENTORY_HAND_LEFT1;
				break;
			case INVENTORY_HAND_LEFT2:
				i2 = INVENTORY_HAND_RIGHT2;
				break;
			case INVENTORY_HAND_RIGHT2:
				i2 = INVENTORY_HAND_LEFT2;
				break;
			}

			cItem& item2 = mItemArray[i2];

			if( item2.mCount )
			{
				unsigned int i3 = 0;
				if( FindEmptySlot( &i3, INVENTORY_BAG0_BEGIN, INVENTORY_BAG3_END ) == false )
					return false;
			}
		}
	}
	return true;
}

bool cItemManager::MoveItemUp( unsigned int i0, unsigned int i1 )
{
	cItem& item0 = mItemArray[i0];
	cItem& item1 = mItemArray[i1];

	unsigned int i2 = 0;

	switch( i1 )
	{
	case INVENTORY_HAND_LEFT1:
		i2 = INVENTORY_HAND_RIGHT1;
		break;
	case INVENTORY_HAND_RIGHT1:
		i2 = INVENTORY_HAND_LEFT1;
		break;
	case INVENTORY_HAND_LEFT2:
		i2 = INVENTORY_HAND_RIGHT2;
		break;
	case INVENTORY_HAND_RIGHT2:
		i2 = INVENTORY_HAND_LEFT2;
		break;
	}

	if( item0.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
		if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
		{
			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
		}
		else if( item1.mCount )
		{
			cItem& item2 = mItemArray[i2];

			if( item2.mCount )
			{
				unsigned int i3 = 0;
				if( FindEmptySlot( &i3, INVENTORY_BAG0_BEGIN, INVENTORY_BAG3_END ) == false )
					return false;

				cItem& item3 = mItemArray[i3];

				cItem tempItem = item1;
				item1 = item0;
				item0 = tempItem;
				item3 = item2;
				item2 = 0;
			}
			else
			{
				cItem tempItem = item1;
				item1 = item0;
				item0 = tempItem;
			}
		}
		else
		{
			cItem& item2 = mItemArray[i2];

			if( item2.mCount )
			{
				item1 = item0;
				item0 = item2;
				item2 = 0;
			}
			else
			{
				item1 = item0;
				item0 = 0;
			}
		}
	}
	else
	{
		cItem& item2 = mItemArray[i2];

		if( item2.mEquipType == ITEM_EQUIP_TWO_HANDS )
		{
			item1 = item0;
			item0 = item2;
			item2 = 0;
		}
		else if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
		{
			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
		}
		else if( item1.mCount )
		{
			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
		}
		else
		{
			item1 = item0;
			item0 = 0;
		}
	}

	/// ü ɷġ˻
	CheckEquipAbility();

	///   
	HERO->ResetArmorSets();
	return true;
}

bool cItemManager::TestEquipWeapon( unsigned int& i1, eItemEquip equipType )
{
	if( HERO->IsReadyUseSkill() == false )
	{
		/// ų  ü Ұ
		return false;
	}

	switch( equipType )
	{
	case ITEM_EQUIP_ONE_HAND:
		if( TestEquipWeapon_OneHand( i1 ) == false )
			return false;
		break;

	case ITEM_EQUIP_TWO_HANDS:
		if( TestEquipWeapon_TwoHands( i1 ) == false )
			return false;
		break;

	case ITEM_EQUIP_SHIELD:
		if( TestEquipWeapon_Shield( i1 ) == false )
			return false;
		break;

	default:
		assert( 0 && "invalid item equip type" );
		return false;
	}
	return true;
}

bool cItemManager::TestEquipWeapon_OneHand( unsigned int& i1 )
{
	i1 = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_RIGHT2 : INVENTORY_HAND_RIGHT1;
	return true;
}

bool cItemManager::TestEquipWeapon_TwoHands( unsigned int& i1 )
{
	unsigned int right = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_RIGHT2 : INVENTORY_HAND_RIGHT1;
	unsigned int left = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_LEFT2 : INVENTORY_HAND_LEFT1;

	i1 = right;
	cItem& item1 = mItemArray[right];

	if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
		///  Ѿ
	}
	else if( item1.mCount )
	{
		cItem& item2 = mItemArray[left];

		if( item2.mCount )
		{
			assert( item2.mEquipType == ITEM_EQUIP_SHIELD );

			unsigned int i3 = 0;
			if( FindEmptySlot( &i3, INVENTORY_BAG0_BEGIN, INVENTORY_BAG3_END ) == false )
				return false;
		}
	}
	return true;
}

bool cItemManager::TestEquipWeapon_Shield( unsigned int& i1 )
{
	unsigned int right = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_RIGHT2 : INVENTORY_HAND_RIGHT1;
	unsigned int left = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_LEFT2 : INVENTORY_HAND_LEFT1;

	i1 = left;
	cItem& item1 = mItemArray[left];
	cItem& item2 = mItemArray[right];

	if( item2.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
	}
	else if( item1.mCount )
	{
		assert( item1.mEquipType == ITEM_EQUIP_SHIELD );
	}
	return true;
}

bool cItemManager::EquipWeapon( unsigned int& i1, unsigned int i, eItemEquip equipType )
{
	switch( equipType )
	{
	case ITEM_EQUIP_ONE_HAND:
		if( EquipWeapon_OneHand( i1, i ) == false )
			return false;
		break;

	case ITEM_EQUIP_TWO_HANDS:
		if( EquipWeapon_TwoHands( i1, i ) == false )
			return false;
		break;

	case ITEM_EQUIP_SHIELD:
		if( EquipWeapon_Shield( i1, i ) == false )
			return false;
		break;

	default:
		assert( 0 && "invalid item equip type" );
		return false;
	}
	return true;
}

bool cItemManager::EquipWeapon_OneHand( unsigned int& i1, unsigned int i )
{
	unsigned int right = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_RIGHT2 : INVENTORY_HAND_RIGHT1;

	i1 = right;

	cItem& item0 = mItemArray[i];
	cItem& item1 = mItemArray[right];

	cItem tempItem = item1;
	item1 = item0;
	item0 = tempItem;
	return true;
}

bool cItemManager::EquipWeapon_TwoHands( unsigned int& i1, unsigned int i )
{
	unsigned int right = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_RIGHT2 : INVENTORY_HAND_RIGHT1;
	unsigned int left = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_LEFT2 : INVENTORY_HAND_LEFT1;

	i1 = right;

	cItem& item0 = mItemArray[i];
	cItem& item1 = mItemArray[right];

	///  ̾
	if( item1.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
		cItem tempItem = item1;
		item1 = item0;
		item0 = tempItem;
	}
	/// Ѽ  
	else if( item1.mCount )
	{
		cItem& item2 = mItemArray[left];

		if( item2.mCount )
		{
			assert( item2.mEquipType == ITEM_EQUIP_SHIELD );

			unsigned int i3 = 0;
			if( FindEmptySlot( &i3, INVENTORY_BAG0_BEGIN, INVENTORY_BAG3_END ) == false )
				return false;

			cItem& item3 = mItemArray[i3];

			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
			item3 = item2;
			item2 = 0;
		}
		else
		{
			cItem tempItem = item1;
			item1 = item0;
			item0 = tempItem;
		}
	}
	///  
	else
	{
		cItem& item2 = mItemArray[left];

		if( item2.mCount )
		{
			assert( item2.mEquipType == ITEM_EQUIP_SHIELD );

			item1 = item0;
			item0 = item2;
			item2 = 0;
		}
		else
		{
			item1 = item0;
			item0 = 0;
		}
	}
	return true;
}

bool cItemManager::EquipWeapon_Shield( unsigned int& i1, unsigned int i )
{
	unsigned int right = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_RIGHT2 : INVENTORY_HAND_RIGHT1;
	unsigned int left = ( mActiveWeapon == ItemActiveFront ) ? INVENTORY_HAND_LEFT2 : INVENTORY_HAND_LEFT1;

	i1 = left;

	cItem& item0 = mItemArray[i];
	cItem& item1 = mItemArray[left];
	cItem& item2 = mItemArray[right];

	if( item2.mEquipType == ITEM_EQUIP_TWO_HANDS )
	{
		item1 = item0;
		item0 = item2;
		item2 = 0;
	}
	else if( item1.mCount )
	{
		assert( item1.mEquipType == ITEM_EQUIP_SHIELD );

		cItem tempItem = item1;
		item1 = item0;
		item0 = tempItem;
	}
	else
	{
		item1 = item0;
		item0 = 0;
	}
	return true;
}

bool cItemManager::TestEquipWear( unsigned int& i1, unsigned char subType )
{
	switch( subType )
	{
	case ITEM_WEAR_HEAD:
		i1 = INVENTORY_WEAR_HAT;
		break;
	case ITEM_WEAR_UPPER:
		i1 = INVENTORY_WEAR_BODY1;
		break;
	case ITEM_WEAR_LOWER:
		i1 = INVENTORY_WEAR_BODY2;
		break;
	case ITEM_WEAR_HANDS:
		i1 = INVENTORY_WEAR_HAND;
		break;
	case ITEM_WEAR_FEET:
		i1 = INVENTORY_WEAR_FOOT;
		break;
	default:
		assert( 0 && "invalid wear item subtype" );
		return false;
	}
	return true;
}

bool cItemManager::EquipWear( unsigned int& i1, unsigned int i, unsigned char subType )
{
	switch( subType )
	{
	case ITEM_WEAR_HEAD:
		i1 = INVENTORY_WEAR_HAT;
		break;
	case ITEM_WEAR_UPPER:
		i1 = INVENTORY_WEAR_BODY1;
		break;
	case ITEM_WEAR_LOWER:
		i1 = INVENTORY_WEAR_BODY2;
		break;
	case ITEM_WEAR_HANDS:
		i1 = INVENTORY_WEAR_HAND;
		break;
	case ITEM_WEAR_FEET:
		i1 = INVENTORY_WEAR_FOOT;
		break;
	default:
		assert( 0 && "invalid wear item subtype" );
		return false;
	}

	cItem& item0 = mItemArray[i];
	cItem& item1 = mItemArray[i1];

	cItem tempItem = item1;
	item1 = item0;
	item0 = tempItem;
	return true;
}

bool cItemManager::TestEquipAccessory( unsigned int& i1, unsigned char subType )
{
	switch( subType )
	{
	case ITEM_ACCESSORY_EARRING:
		i1 = INVENTORY_WEAR_EARRING;
		break;
	case ITEM_ACCESSORY_NECKLACE:
		i1 = INVENTORY_WEAR_NECKLACE;
		break;
	case ITEM_ACCESSORY_BROOCH:
		i1 = INVENTORY_WEAR_BROOCH;
		break;
	case ITEM_ACCESSORY_BRACELET:
		i1 = INVENTORY_WEAR_BRACELET;
		break;
	case ITEM_ACCESSORY_RING:
		i1 = INVENTORY_WEAR_RING;
		break;
	default:
		assert( 0 && "invalid accessory item subtype" );
		return false;
	}
	return true;
}

bool cItemManager::TestEquipCard( unsigned int& slotIndex1 )
{
	cItem& item1 = mItemArray[INVENTORY_WEAR_CARD1];
	cItem& item2 = mItemArray[INVENTORY_WEAR_CARD2];
	cItem& item3 = mItemArray[INVENTORY_WEAR_CARD3];

	if( item1.mCount == 0 )
	{
		slotIndex1 = INVENTORY_WEAR_CARD1;
	}
	else if( item2.mCount == 0 )
	{
		slotIndex1 = INVENTORY_WEAR_CARD2;
	}
	else if( item3.mCount == 0 )
	{
		slotIndex1 = INVENTORY_WEAR_CARD3;
	}
	else /// ڸ ù  
	{
		slotIndex1 = INVENTORY_WEAR_CARD1;
	}
	return true;
}

/// κ丮 ΰ ƴϸ  ü .
bool cItemManager::TestUseItem( unsigned int slotIndex0 )
{
	cItem& item = mItemArray[slotIndex0];
	cItemDefine* itemDefine = item.mDefine;
	if( itemDefine == 0 )
	{
		assert(0);
		return false;
	}

	cItemAbility* itemAbil = itemDefine->GetAbililty();
	if( itemAbil == 0 )
	{
		cTitleDefine* titleDefine = TITLEMAN->GetTitleDefine( itemDefine->GetTitleIndex() );
		if( titleDefine == 0 )
		{
			assert(0);
			return false;
		}

		/// ŸƲ ˻
		if( TITLEMAN->IsHaveTitle( itemDefine->GetTitleIndex() ) == true )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 68 ) );
			return false;
		}
		else
			return true;
	}

	/// ̹ Ÿ  ˻
	if( item.IsCoolTime() == true )
		return false;

	/// Ÿ Ÿ 
	const sObject* target = HERO->GetTargetInfo();
	if( !target )
	{
		assert(0);
		return false;
	}


	/// Ÿ ڱڽ̸ 
	if( itemAbil->GetTargetType() == ITEM_TARGET_MYSELF )
	{
		///// ī üũ
		//if( itemAbil->GetInfluenceIndex() > 0 )
		//{
		//	sInfluenceScript* pScript = SKILLSCRIPT->GetInfluenceInfo( itemAbil->GetInfluenceIndex() );
		//	if( pScript )
		//	{
		//		bool checkChgMon = false;
		//		if( pScript->mStatusPlusIdx1 == eSTATUSPLUS_CHANGE_MONSTER )
		//		{
		//			checkChgMon = true;
		//		}
		//		else if( pScript->mStatusPlusIdx2 == eSTATUSPLUS_CHANGE_MONSTER )
		//		{
		//			checkChgMon = true;
		//		}
		//		else if( pScript->mStatusPlusIdx3 == eSTATUSPLUS_CHANGE_MONSTER )
		//		{
		//			checkChgMon = true;
		//		}

		//		if( checkChgMon == true )
		//		{
		//			if( HERO && HERO->IsRideVehicle() == true )
		//			{
		//				MSGROOT msg;
		//				::memset( &msg, 0, sizeof(msg) );
		//				msg.Category = NM_PLAYER;
		//				msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
		//				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		//			}
		//		}
		//	}
		//}
		/////

		return true;
	}
	/// Ÿ ̸
	else if( itemAbil->GetTargetType() == ITEM_TARGET_MONSTER )
	{
		/// Ÿ 
		if( target->type == eOBJECTTYPE_MONSTER )
		{
			cBaseObject* pMonster = OBJECTMAN->GetObject( target->type, target->index );
			if( pMonster )
			{
				///  ˻
				sRegenScript* info = MONSTERSCRIPT->GetRegenMonsterInfo( target->index );
				if( !info )	
				{
					assert(0);
					return false;
				}

				NiPoint3 monPos = pMonster->GetPos();
				NiPoint3 heroPos = HERO->GetPos();

				/// Ÿ, ʰ˻
                if( HERO->GetMapNum() == info->mMapNumber && (short)(heroPos - monPos).Length() < itemAbil->GetUseRange() )
					return true;
				else /// Ÿ
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 238 ) );
			}
			else
			{
				assert(0);
			}
		}
		else /// Ÿٿ
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 237 ) );
	}
	///  Ÿ ˻  ( ڱڽ + ÷̾ = 5, ڱڽ + Ƽ = 9...)
	else
	{
		if( itemAbil->GetTargetType() & ITEM_TARGET_MYSELF )
		{
			if( target->type == eOBJECTTYPE_HERO )
				return true;
		}
		
		if( itemAbil->GetTargetType() & ITEM_TARGET_PLAYER )
		{
			if( target->type == eOBJECTTYPE_PLAYER )
			{
				/// ÷̾  Ÿ    Ƿ ʰ˻ ʿ.
				cBaseObject* pPlayer = OBJECTMAN->GetObject( target->type, target->index );
				if( pPlayer )
				{
					NiPoint3 playerPos = pPlayer->GetPos();
					NiPoint3 heroPos = HERO->GetPos();
					
					if( (short)(heroPos - playerPos).Length() < itemAbil->GetUseRange() )
						return true;
					else
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 238 ) );
				}
				else
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 238 ) );
			}
		}

		if( itemAbil->GetTargetType() & ITEM_TARGET_PARTY )
		{
			if( HERO->GetPartyIndex() > 0 )
			{
				/// hero  Ƽ϶  Ƽ ˻
				if( PARTYMAN->IsHeroParty( target->index ) == true )
				{
					/// ÷̾  Ÿ    Ƿ ʰ˻ ʿ.
					cBaseObject* pPlayer = OBJECTMAN->GetObject( target->type, target->index );
					if( pPlayer )
					{
						NiPoint3 playerPos = pPlayer->GetPos();
						NiPoint3 heroPos = HERO->GetPos();

						if( (short)(heroPos - playerPos).Length() < itemAbil->GetUseRange() )
							return true;
						else
							CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 238 ) );
					}
					else
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 238 ) );

				}
				return true;
			}
		}	
	}
	return false;
}

bool cItemManager::TestUseEtcItem( unsigned int slotIndex0 )
{
	cItem& item = mItemArray[slotIndex0];
	cItemDefine* itemDefine = item.mDefine;
	if( itemDefine == 0 )
	{
		assert(0);
		return false;
	}

	cItemAbility* itemAbil = itemDefine->GetAbililty();
	if( itemAbil == 0 )
	{
		assert(0);
		return false;
	}

	/// ̹ Ÿ  ˻
	if( item.IsCoolTime() == true )
		return false;

	unsigned long influenceIdx = itemAbil->GetInfluenceIndex();
	return ( influenceIdx > 0 ) ? true : false;
}

bool cItemManager::EquipAccessory( unsigned int& i1, unsigned int i, unsigned char subType )
{
	switch( subType )
	{
	case ITEM_ACCESSORY_EARRING:
		i1 = INVENTORY_WEAR_EARRING;
		break;
	case ITEM_ACCESSORY_NECKLACE:
		i1 = INVENTORY_WEAR_NECKLACE;
		break;
	case ITEM_ACCESSORY_BROOCH:
		i1 = INVENTORY_WEAR_BROOCH;
		break;
	case ITEM_ACCESSORY_BRACELET:
		i1 = INVENTORY_WEAR_BRACELET;
		break;
	case ITEM_ACCESSORY_RING:
		i1 = INVENTORY_WEAR_RING;
		break;
	default:
		assert( 0 && "invalid accessory item subtype" );
	}

	cItem& item0 = mItemArray[i];
	cItem& item1 = mItemArray[i1];

	cItem tempItem = item1;
	item1 = item0;
	item0 = tempItem;
	return true;
}

bool cItemManager::EquipCard( unsigned int& i1, unsigned int i )
{
	cItem& item0 = mItemArray[i];
	cItem& item1 = mItemArray[i1];

	cItem tempItem = item1;
	item1 = item0;
	item0 = tempItem;
	return true;
}