#include "stdafx.h"
#include "ItemManager.h"

#include "Tokenizer.h"
#include "UIManager.h"

#include "gameResourceManager.h"
#include "CoolTimeManager.h"

bool cItemManager::LoadAbility( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item ability" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = str.ToInt();
		assert( index > 0 );

		/// ȿ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long discription = (long)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short defenseType = (short)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short rangeType = (short)str.ToInt();

		/// ȿŸ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short targetType = (short)str.ToInt();

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short useRange = (short)str.ToInt();

		///  
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short physicDefense = (short)str.ToInt();

		///  
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short magicDefense = (short)str.ToInt();

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short attackRange = (short)str.ToInt();

		///  ӵ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short attackSpeed = (short)str.ToInt();

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long coolTime = (long)str.ToInt();

		/// ׷ Ÿ ȣ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int groupTime = (unsigned int)str.ToInt();

		/// :ּҰݷ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short physicMinAttack = (short)str.ToInt();

		/// :ִݷ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short physicMaxAttack = (short)str.ToInt();

		/// :ּҰݷ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short magicMinAttack = (short)str.ToInt();

		/// :ִݷ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short magicMaxAttack = (short)str.ToInt();

		/// ɼ 
		sAblityOption opt[10];
		for( int i = 0; i < 10; ++i )
		{
			if( tokenizer.GetNext( &str ) == false )
				return false;

			opt[i].mOptType = (short)str.ToInt();

			if( tokenizer.GetNext( &str ) == false )
				return false;

			opt[i].mOptValue = (short)str.ToInt();
		}

		/// ųȿ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long InfluenceIndex = (long)str.ToInt();

		///  ɷ 
		cItemAbility* p = new cItemAbility;
		p->mDescription = discription;
		p->mDefenseType = defenseType;
		p->mRangeType = rangeType;
		p->mTargetType = targetType;
		p->mUseRange = useRange;
		p->mPhysicDefense = physicDefense;
		p->mMagicDefense = magicDefense;
		p->mAttackRange = attackRange;
		p->mAttackSpeed = attackSpeed;
		p->mCoolTime = coolTime;
		p->mGroupNum = groupTime;
		p->mPhysicMinAttack = physicMinAttack;
		p->mPhysicMaxAttack = physicMaxAttack;
		p->mMagicMinAttack = magicMinAttack;
		p->mMagicMaxAttack = magicMaxAttack;
		p->mInfluenceIndex = InfluenceIndex;

		for( int i = 0; i < 10; ++i )
		{
			p->mOption[i] = opt[i];
		}

		if( mAbilityMap.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item ability, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cItemManager::LoadLimit( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item limit" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = str.ToInt();
		assert( index > 0 );

		/// ĳ:
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char charRace = (char)str.ToInt();

		/// ĳ:
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char charGender = (char)str.ToInt();

		/// ĳ:
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long charJob = (long)str.ToInt();

		/// ĳ:
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char charLevel = (char)str.ToInt();

		///  
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char usePVPOnly = (char)str.ToInt();

		///   
		cItemLimit* p = new cItemLimit;

		p->mCharRace = charRace;
		p->mCharGender = charGender;
		p->mCharJob = charJob;
		p->mCharLevel = charLevel;
		p->mUsePVPOnly = usePVPOnly;

		if( mLimitMap.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item limit, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cItemManager::LoadCard( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load tarot define" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();
		assert( index >= 0 );

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char episode = (char)str.ToInt();

		/// īѹ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int cardnum = (unsigned int)str.ToInt();

		/// ͵
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char rarelevel = (char)str.ToInt();

		/// īŸ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char cardtype = (char)str.ToInt();

		/// ġ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char wearPos = (char)str.ToInt();

		/// ī̹ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int imageIndex = (unsigned int)str.ToInt();

		///   
		cItemCard* p = new cItemCard;
		p->mEpisode = episode;
		p->mCardNumber = cardnum;
		p->mRareLevel = rarelevel;
		p->mCardType = cardtype;
		p->mWearPos = wearPos;
		p->mImageIndex = imageIndex;

		if( mCardMap.Insert( index, p ) == false )
		{	
			assert( 0 && "failed to insert card define, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cItemManager::LoadTarot( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load tarot define" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();
		assert( index >= 0 );

		/// ̹ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int imageIndex = (unsigned int)str.ToInt();
		assert( imageIndex >= 0 );

		///  ȣ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char number = (char)str.ToInt();

		/// ī 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char level = (char)str.ToInt();

		/// ġ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short strvalue = (short)str.ToInt();

		/// ġ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short invvalue = (short)str.ToInt();

		/// Ӽ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char prop = (char)str.ToInt();

		/// Ǽҵ()
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char episode = (char)str.ToInt();

		///  ؼ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long strdescIdx = (unsigned long)str.ToInt();
		assert( strdescIdx >= 0 );

		///  ؼ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long invdescIdx = (unsigned long)str.ToInt();
		assert( invdescIdx >= 0 );

		///   
		cItemTarot* p = new cItemTarot;

		p->mImageIndex = imageIndex;
		p->mNumber = number;
		p->mLevel = level;
		p->mStraightValue = strvalue;
		p->mInverseValue = invvalue;
		p->mProperty = prop;
		p->mEpisode = episode;
		p->mStraightIdx = strdescIdx;
		p->mInverseIdx = invdescIdx;

		if( mTarotMap.Insert( index, p ) == false )
		{	
			assert( 0 && "failed to insert tarot define, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cItemManager::LoadSpread( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load spread define" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		long index = 0;
		cItemSpread* p = new cItemSpread;

		for( int i = 0; i < 10; ++i )
		{
			///  ε
			if( tokenizer.GetNext( &str ) == false )
			{
				assert( 0 && "spread must 10 list" );;
				return false;
			}

			index = (long)str.ToInt();
			assert( index >= 0 );

			/// ̹ ε 
			if( tokenizer.GetNext( &str ) == false )
				return false;

			int imageIdx = (int)str.ToInt();

			/// ǥ ε 
			if( tokenizer.GetNext( &str ) == false )
				return false;

			long axisIndex = (long)str.ToInt();
			assert( axisIndex >= 0 );

			/// x ǥ 
			if( tokenizer.GetNext( &str ) == false )
				return false;

			unsigned int x = (unsigned int)str.ToInt();

			/// y ǥ 
			if( tokenizer.GetNext( &str ) == false )
				return false;

			unsigned int y = (unsigned int)str.ToInt();

			/// 
			if( tokenizer.GetNext( &str ) == false )
				return false;

			int dir = (int)str.ToInt();

			///  
			if( tokenizer.GetNext( &str ) == false )
				return false;

			unsigned int calc = 0;
			if( !str.CompareNoCase("*") )
			{
				calc = 1;
			}
			else if( !str.CompareNoCase("/") )
			{
				calc = 2;
			}
			else if( !str.CompareNoCase("+") )
			{
				calc = 3;
			}

			/// ġ
			if( tokenizer.GetNext( &str ) == false )
				return false;

			int value = (int)str.ToInt();

			///  
			p->mParam[i].mImageIndex = imageIdx;
			p->mParam[i].mX = x;
			p->mParam[i].mY = y;
			p->mParam[i].mDir = dir;
			p->mParam[i].mCalc = calc;
			p->mParam[i].mValue = value;

			if( axisIndex < 1 || axisIndex > 10 )
			{
				assert( 0 && "error axis index" );
				return false;
			}
		}

		if( mSpreadMap.Insert( index, p ) == false )
		{	
			assert( 0 && "failed to insert spread define, maybe already exist" );
			return false;
		}
	}

	return true;
}


///    ε
bool cItemManager::LoadDisjoint( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item disjoint" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), "\t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();
		assert( index > 0 );

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long price = (long)str.ToInt();

		/// 1
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long itemIdx1 = (long)str.ToInt();

		/// 1 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int count1 = (int)str.ToInt();

		/// 2
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long itemIdx2 = (long)str.ToInt();

		/// 2 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int count2 = (int)str.ToInt();

		/// 3
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long itemIdx3 = (long)str.ToInt();

		/// 3 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int count3 = (int)str.ToInt();

		/// 4
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long itemIdx4 = (long)str.ToInt();

		/// 4 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int count4 = (int)str.ToInt();

		/// 5
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long itemIdx5 = (long)str.ToInt();

		/// 5 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int count5 = (int)str.ToInt();

		/// 6
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long itemIdx6 = (long)str.ToInt();

		/// 6 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int count6 = (int)str.ToInt();

		/// 
		sItemDisjoint* p = new sItemDisjoint;

		p->mPrice = price;
		p->mDisjoint[0].itemIndex = itemIdx1;
		p->mDisjoint[0].count	  = count1;
		p->mDisjoint[1].itemIndex = itemIdx2;
		p->mDisjoint[1].count	  = count2;
		p->mDisjoint[2].itemIndex = itemIdx3;
		p->mDisjoint[2].count	  = count3;
		p->mDisjoint[3].itemIndex = itemIdx4;
		p->mDisjoint[3].count	  = count4;
		p->mDisjoint[4].itemIndex = itemIdx5;
		p->mDisjoint[4].count	  = count5;
		p->mDisjoint[5].itemIndex = itemIdx6;
		p->mDisjoint[5].count	  = count6;

		if( mDisjointMap.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item disjoint, maybe already exist" );
			return false;
		}
	}

	return true;
}

bool cItemManager::LoadEnhanced( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item enhanced" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), "\t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();

		sItemEnhanced* p = new sItemEnhanced;

		/// Ӽ1
		if( tokenizer.GetNext( &str ) == false )
			return false;

		p->mEnhanced1 = (short)str.ToInt();

		/// Ӽ2
		if( tokenizer.GetNext( &str ) == false )
			return false;

		p->mEnhanced2 = (short)str.ToInt();

		/// 
		for( unsigned int i = 0; i < MAX_ITEM_ENHANCED; ++i )
		{
			if( tokenizer.GetNext( &str ) == false )
				return false;

			p->mValue[i] = (unsigned int)str.ToInt();
		}

		///
		if( mEnhancedMap.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item enhanced, maybe already exist" );
			return false;
		}
	}
	return true;
}

/// ī  ε
bool cItemManager::LoadCardSlot( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load card slot" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), "\t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();

		///  Ÿ1
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short type1 = (short)str.ToInt();

		///  Ÿ2
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short type2 = (short)str.ToInt();

		///  Ÿ3
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short type3 = (short)str.ToInt();

		///  Ÿ4
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short type4 = (short)str.ToInt();

		///  Ÿ5
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short type5 = (short)str.ToInt();

		///  
		sItemPutCardSlot* p = new sItemPutCardSlot;
		p->mSlotType[0] = type1;
		p->mSlotType[1] = type2;
		p->mSlotType[2] = type3;
		p->mSlotType[3] = type4;
		p->mSlotType[4] = type5;

		///
		if( mPutCardSlotMap.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item putcard, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cItemManager::LoadDefine( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item define" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), "\t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();
		assert( index > 0 );

		/// ̸
		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ̸ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int nameIndex = (unsigned int)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int tipIndex = (unsigned int)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned char type = (unsigned char)str.ToInt();

		///  
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned char subType = (unsigned char)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short weight = (short)str.ToInt();

		/// ħ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short capacity = (short)str.ToInt();

		/// ǸŹ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long sellType = (unsigned long)str.ToInt();

		/// ǸŰ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long sellPrice = (unsigned long)str.ToInt();

		/// Թ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long buyType = (unsigned long)str.ToInt();

		/// ԰
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long buyPrice = (unsigned long)str.ToInt();

		/// ִ 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long presentNum = (unsigned long)str.ToInt();

		///  ɰ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long maxHaveInven = (unsigned long)str.ToInt();

		/// ڰŷ (0ŷ/1ŷҰ)
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char exchange = (char)str.ToInt();

		/// ɷ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long abilityIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long limitIndex = (long)str.ToInt();

		/// ī ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		//long cardIndex = (long)str.ToInt();

		/// Ÿ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long tarotIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long spreadIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long disjointIndex = (long)str.ToInt();

		/// ī彽 ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long cardSlotIndex = (long)str.ToInt();

		/// ȭȮ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long enhanceRateIndex = (long)str.ToInt();

		/// ȭ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long enhanceIndex = (long)str.ToInt();

		/// ü ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ȣĪ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long titleIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int iconIndex = (unsigned int)str.ToInt();

		///  ε0
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int fileIndex0 = (unsigned int)str.ToInt();

		///  ε1
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int fileIndex1 = (unsigned int)str.ToInt();

		///  ̱ (0:Ӹǥ, 1:Ӹǥ )
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char showHead = (char)str.ToInt();

		///  ÷ (  )
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned short tooltipColor = (unsigned short)str.ToInt();

		///  Ǹ 
		cItemDefine* p = new cItemDefine;

		p->mName = GetItemName( nameIndex );
		p->mDescription = ( tipIndex > 0 ) ? GAMERESOURCEMAN->GetItemToolTipText( tipIndex ) : 0;
		p->mType = type;
		p->mSubType = subType;
		p->mWeight = weight;
		p->mCapacity = capacity;
		p->mSellType = sellType;
		p->mSellPrice = sellPrice;
		p->mBuyType = buyType;
		p->mBuyPrice = buyPrice;
		p->mPresentNum = presentNum;
		p->mMaxHaveInven = maxHaveInven;
		p->mExchange = exchange;
		p->mTitleIndex = titleIndex;
		p->mAbility = GetItemAbility( abilityIndex );
		p->mLimit = GetItemLimit( limitIndex );
		//p->mCard = GetItemCard( cardIndex );
		p->mTarot = GetItemTarot( tarotIndex );
		p->mSpread = GetItemSpread( spreadIndex );
		p->mDisjoint = GetItemDisjoint( disjointIndex );
		p->mEnhance = GetItemEnhanced( enhanceIndex );
		p->mPutCardSlot = GetItemPutCardSlot( cardSlotIndex );
		p->mIconParam = UIMAN->GetIconParam( iconIndex );
		p->mFileNames0 = GetItemFileNames( fileIndex0 );
		p->mFileNames1 = GetItemFileNames( fileIndex1 );
		p->mShowHead = showHead;
		p->mTooltipColor = tooltipColor;

		if( p->mIconParam == 0 )
		{
			assert( 0 && "failed to find icon param" );
			return false;
		}
		if( p->mLimit == 0 )
		{
			assert( 0 && "failed to find item limit" );
			return false;
		}

		///  Ÿ 
		if( type == ITEM_WEAPON )
		{
			switch( subType )
			{
				/// Ѽհ
			case ITEM_WEAPON_SWORD:
				p->mEquipType = ITEM_EQUIP_ONE_HAND;
				break;

				/// հ, ܰ, , , ̵
			case ITEM_WEAPON_BLADE:
			case ITEM_WEAPON_DUAL:
			case ITEM_WEAPON_CUTTER:
			case ITEM_WEAPON_GUN:
			case ITEM_WEAPON_STAFF:
				p->mEquipType = ITEM_EQUIP_TWO_HANDS;
				break;

				/// 
			case ITEM_WEAPON_SHIELD:
				p->mEquipType = ITEM_EQUIP_SHIELD;
				break;
			}
		}

		/// ÷ 
		switch( type )
		{
		case ITEM_WEAPON:
			switch( subType )
			{
			case ITEM_WEAPON_SWORD:
				p->mFlag = ITEM_FLAG_SWORD;
				break;
			case ITEM_WEAPON_BLADE:
				p->mFlag = ITEM_FLAG_BLADE;
				break;
			case ITEM_WEAPON_DUAL:
				p->mFlag = ITEM_FLAG_DUAL;
				break;
			case ITEM_WEAPON_CUTTER:
				p->mFlag = ITEM_FLAG_CUTTER;
				break;
			case ITEM_WEAPON_GUN:
				p->mFlag = ITEM_FLAG_GUN;
				break;
			case ITEM_WEAPON_STAFF:
				p->mFlag = ITEM_FLAG_STAFF;
				break;
			case ITEM_WEAPON_SHIELD:
				p->mFlag = ITEM_FLAG_SHIELD;
				break;
			default:
				assert( 0 && "invalid item weapon subtype" );
			}
			break;

		case ITEM_WEAR:
			switch( subType )
			{
			case ITEM_WEAR_HEAD:
				p->mFlag = ITEM_FLAG_HEAD;
				break;
			case ITEM_WEAR_UPPER:
				p->mFlag = ITEM_FLAG_UPPER;
				break;
			case ITEM_WEAR_LOWER:
				p->mFlag = ITEM_FLAG_LOWER;
				break;
			case ITEM_WEAR_HANDS:
				p->mFlag = ITEM_FLAG_HANDS;
				break;
			case ITEM_WEAR_FEET:
				p->mFlag = ITEM_FLAG_FEET;
				break;
			case ITEM_FLAG_ONEPIECE:
				p->mFlag = ITEM_FLAG_ONEPIECE;
				break;
			default:
				assert( 0 && "invalid item wear subtype" );
			}
			break;

		case ITEM_ACCESSORY:
			switch( subType )
			{
			case ITEM_ACCESSORY_EARRING:
				p->mFlag = ITEM_FLAG_EARRING;
				break;
			case ITEM_ACCESSORY_NECKLACE:
				p->mFlag = ITEM_FLAG_NECKLACE;
				break;
			case ITEM_ACCESSORY_BROOCH:
				p->mFlag = ITEM_FLAG_BROOCH;
				break;
			case ITEM_ACCESSORY_BRACELET:
				p->mFlag = ITEM_FLAG_BRACELET;
				break;
			case ITEM_ACCESSORY_RING:
				p->mFlag = ITEM_FLAG_RING;
				break;
			default:
				assert( 0 && "invalid item accessory subtype" );
			}
			break;

		case ITEM_CARD:	/// ĳ  ī
			p->mFlag = ( subType == ITEM_CARD_EQUIP_C ) ? ITEM_FLAG_EQUIPCARD : ITEM_FLAG_UNKNOWN;
			break;
		default:
			p->mFlag = ITEM_FLAG_UNKNOWN;
			break;
		}

		/// ī   īƮ 
		sItemPutCardSlot* slot = p->mPutCardSlot;
		if( slot )
		{
			for( int i = 0; i < MAX_CARD_SLOT; ++i )
			{
				///   
				if( slot->mSlotType[i] > 0 )
					p->mPutSlotCount++;
			}
		}

		if( mDefineMap.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item define, maybe already exist" );
			return false;
		}


	}
	return true;
}

bool cItemManager::LoadFileName( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item file name" );
		return false;
	}

	unsigned int iend = eRACE_MAX * eGENDER_MAX;

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = str.ToInt();
		assert( index > 0 );

		iend = eRACE_MAX * eGENDER_MAX;

		///   ̸ 迭 
		cString* p = new cString[iend];

		for( unsigned int i = 0; i < iend; ++i )
		{
			if( tokenizer.GetNext( &(p[i]) ) == false )
			{
				delete [] p;
				return false;
			}
		}

		if( mFileNamesMap.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item file names, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cItemManager::LoadCategoryTable( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item file name" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), "\t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// з
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int	highClass = (int)str.ToInt();

		/// ߺз
		if( tokenizer.GetNext( &str ) == false )
			return false;
		
		int	midClass = (int)str.ToInt();

		/// Һз
		if( tokenizer.GetNext( &str ) == false )
			return false;

		int	lowClass = (int)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long itemIdx = (unsigned long)str.ToInt();

		/// GMTool Only Used : 0
		if( tokenizer.GetNext( &str ) == false )
			return false;

		bool gmOnly = str.ToInt()? false:true;


		cNameIdxArrMap* pItemArrMap = &mItemMap;
		if( gmOnly == true )
		{
#ifdef _GMTOOL
			pItemArrMap = &mGMItemMap;
#else
			continue;
#endif
		}

		///  +  + 
		bool newKey = false;
		unsigned int itemKey = lowClass + midClass + highClass;
		cNameIdxArr* itemArr = (cNameIdxArr*)pItemArrMap->GetAt( itemKey );
		if( itemArr == 0 )
		{
			itemArr = new cNameIdxArr;
			if( pItemArrMap->Insert( itemKey, itemArr ) == false )
			{
				assert(0);
			}

			newKey = true;
		}
		itemArr->PushBack( itemIdx );


		///  + 
		if( newKey == true )
		{
			newKey = false;
			unsigned int lowKey = midClass + highClass;
			cNameIdxArr* lowArr = (cNameIdxArr*)mLowClassMap.GetAt( lowKey );
			if( lowArr == 0 )
			{
				lowArr = new cNameIdxArr;
				if( mLowClassMap.Insert( lowKey, lowArr ) == false )
				{
					assert(0);
				}

				newKey = true;
			}
			lowArr->PushBack( lowClass );
		}


		/// 
		if( newKey == true )
		{
			unsigned int middleKey = highClass;
			cNameIdxArr* middleArr = (cNameIdxArr*)mMiddleClassMap.GetAt( middleKey );
			if( middleArr == 0 )
			{
				middleArr = new cNameIdxArr;
				if( mMiddleClassMap.Insert( middleKey, middleArr ) == false )
				{
					assert(0);
				}

				/// ο з ̸ 迭 
				mHighClassArr.PushBack( highClass );
			}
			middleArr->PushBack( midClass );
		}
	}

	return true;
}

///
void cItemManager::LoadCoolData()
{
	cAbilityMap::cIterator i = mAbilityMap.Begin();
	cAbilityMap::cIterator end = mAbilityMap.End();

	for( ; i != end; ++i )
	{
		cItemAbility* p = (cItemAbility*)(i->mSecond);
		if( !p )
		{
			assert(0);
			continue;
		}

		/// Ÿ  
		if( p->mCoolTime > 0 )
		{
			unsigned long itemIndex = (unsigned long)(i->mFirst);
			COOLMAN->LoadData( itemIndex, p->mGroupNum, p->mCoolTime );
		}
	}
}
