#include "stdafx.h"
#include "ItemManager.h"

#include "Parser.h"
#include "Lexer.h"

/// Npc  ū Ÿ
enum
{
	/// Npc 
	eTOKEN_NPCSTORE = 100,

	/// 
	eTOKEN_TAB
};

/// Npc   м
class cItemNpcStoreLexer : public cLexer
{
public:
	cItemNpcStoreLexer( const char* buffer, unsigned int size );
};

cItemNpcStoreLexer::cItemNpcStoreLexer( const char* buffer, unsigned int size )
: cLexer( buffer, size )
{
	BindKeyword( "npc_store", eTOKEN_NPCSTORE );
	BindKeyword( "tab", eTOKEN_TAB );
}

void cItemNpcStore::Clear()
{
	///  
	for( unsigned int i = 0; i < mDataCount; ++i )
		mItemData[i].mItemArr.Clear();
}

bool cItemNpcStore::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	cToken token;
	cLexer* lexer = parser.GetLexer();
	if( !lexer )
	{
		assert(0);
		return false;
	}

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
			break;

		switch( token.mType )
		{
		case eTOKEN_TAB:
			{
				///  ε
				unsigned long textIdx = parser.ParseInt();

				if( mDataCount > NPCSTORE_TAB_COUNT )
				{
					assert( 0 && "tab index out of range" );
					return false;
				}

				///  ε
				mItemData[mDataCount].mTextIndex = textIdx;
				if( LoadTab( parser ) == false )
				{
					assert( 0 );
					return false;
				}

				mDataCount++;
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

///  εε ÿ ٲ!!!!!!!!!!!! 
bool cItemNpcStore::LoadTab( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	cToken token;
	cLexer* lexer = parser.GetLexer();
	if( !lexer )
	{
		assert(0);
		return false;
	}

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
			break;

		switch( token.mType )
		{
		case eTOKEN_INT:
			{
				unsigned long itemIndex = (unsigned long)token.ToInt();
				mItemData[mDataCount].mItemArr.PushBack( itemIndex );
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

bool cItemManager::LoadNpcStore( const cString& pathName )
{
	///  
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load npc store" );
		return false;
	}

	///  ְ Ľ
	cToken token;
	cItemNpcStoreLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_NPCSTORE:
			{
				/// Npc ε
				unsigned int i = parser.ParseInt();

				/// Npc  
				cItemNpcStore* p = new cItemNpcStore;

				/// ε
				if( p->Load( parser ) == false )
				{
					delete p;
					return false;
				}

				/// Npc  ʿ ߰
				if( mNpcStoreMap.Insert( i, p ) == false )
				{
					assert( 0 && "failed to insert npc store, maybe already exist" );
					return false;
				}
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

cItemNpcStore* cItemManager::GetItemNpcStore( unsigned int npcIndex )
{
	cNpcStoreMap::cConstIterator i = mNpcStoreMap.Find( npcIndex );

	if( i == mNpcStoreMap.End() )
		return 0;
	else
		return (cItemNpcStore*)i->mSecond;
}
