/* ==========================================================================
*      : ItemMixManager.h
*      : 
*    : 谡
*    : 2009-01-15
* ǻ :
*===========================================================================*/

/// Ʈũ 
enum
{
	eLOCK_ITEMMIXNONE,
	eLOCK_ITEMMIXDELETE,
	eLOCK_ITEMMIXSTART,
	eLOCK_ITEMMIXEND,
};

///   
struct sKeepRecipe
{
	unsigned long mRestTime;
	unsigned long mStartTime;
	
	sKeepRecipe()
	{
		mRestTime = 0;
		mStartTime = 0;
	}
};

class cItemMixManager
{
public:
	cItemMixManager();
	~cItemMixManager();

	void Close();

	/// ų,   
	bool ItemMixUseMakeSkill( unsigned short slot, unsigned long makeSkillIdx );
	bool ItemMixUseRecipe( unsigned short slot, unsigned long recipeIdx );
	bool ItemMixUseRecipeGroup( unsigned short slot, unsigned long recipeGroupIdx );

	///
	void ItemMixStart( unsigned char index, unsigned long recipeIdx, int count );
	void ItemMixDelete( unsigned char index );
	void ItemMixCancel( bool hide = true );
	void ItemMixEndRequest();

	///
	void ItemMixOpen();

	///
	void NetworkMsgParserLoad( char* msg );
	void NetworkMsgParserGame( char* msg );

	/// ε
	sKeepRecipe* GetKeepMixSkill1( unsigned long recipeIdx );
	sKeepRecipe* GetKeepMixSkill2( unsigned long recipeIdx );
	unsigned long GetKeepSkillText( unsigned char index );
	unsigned long GetTypeText( int index, unsigned long type );
	bool IsMixContinue() { return (mContinueDescCount > mContinueCount); }
	bool IsNetLock() { return mNetLock; }

	tPointerHashMap<unsigned long, void*>* GetKeepSkillMap1() { return &mKeepSkillMap1; }
	tPointerHashMap<unsigned long, void*>* GetKeepSkillMap2() { return &mKeepSkillMap2; }

public:
	static cItemMixManager*	mpSingleton;
	static cItemMixManager* GetSingleton();

protected:
	bool AddKeepSkill1( unsigned long recipeIdx, unsigned long restTime );
	bool AddKeepSkill2( unsigned long recipeIdx, unsigned long restTime );
	void DeleteKeepSkill1();
	void DeleteKeepSkill2();

	void ItemMixContinue();
	
	/// ɱ
	void NetLock( int lockTry );
	void NetUnLock( int lockTry );

private:
	typedef tPointerHashMap<unsigned long, void*> cKeepRecipeMap;
	cKeepRecipeMap	mKeepSkillMap1;	//  1
	cKeepRecipeMap	mKeepSkillMap2;	//  2

	/// Ʈũ  
	bool	mNetLock;
	int		mLockTry;

	///   
	int			  mContinueDescCount;	/// ǥġ
	int			  mContinueCount;
	unsigned char mContinueSkill;
	unsigned long mContinueRecipe;
};

inline cItemMixManager* cItemMixManager::GetSingleton() 
{
	return mpSingleton;
}

#define ITEMMIXMAN cItemMixManager::GetSingleton()