#include "StdAfx.h"
#include "ItemMixWindow.h"
#include "Label.h"
#include "NumberEditBox.h"
#include "ComboBox.h"
#include "UIImage.h"
#include "ListFolderBox.h"
#include "ListBox.h"
#include "ItemIcon.h"
#include "Gauge.h"
#include "MakeSkill_Common.h"
#include "ItemMixManager.h"
#include "MakeSkillScript.h"
#include "ItemManager.h"
#include "GameResourceManager.h"
#include "GameUIManager.h"
#include "ObjectManager.h"
#include "ChatManager.h"
#include "Hero.h"
#include "Application.h"
#include "UIMsgboxEvent.h"

cItemMixWindow::cItemMixWindow()
: mpCoolTime(0)
, mpMixCount(0)
, mpCompleteCount(0)
, mpGaugeBar(0)
, mpMixSkillCombo(0)
, mpMixSkillList(0)
, mpHighImage(0)
, mpItemMixList(0)
, mpRecipeCool(0)
, mpMixStart(0)
, mpMixGiveUp(0)
, mpMixStop(0)
{
	memset( mpResultRate, 0, sizeof(mpResultRate) );
	memset( mpResultIcon, 0, sizeof(mpResultIcon) );
}

cItemMixWindow::~cItemMixWindow()
{
	SAFE_DELETE( mpHighImage );
}

void cItemMixWindow::Clear()
{
	InitCoolTime();

	if( mpMixCount )
		mpMixCount->SetValue( 1 );
	if( mpCompleteCount )
		mpCompleteCount->SetValue( 0 );

	if( mpGaugeBar )
		mpGaugeBar->ClearFront();
	if( mpMixSkillCombo )
		mpMixSkillCombo->Clear();
	if( mpMixSkillList )
		mpMixSkillList->Clear();
	if( mpItemMixList )
		mpItemMixList->Clear();

	for( int i = 0; i < 3; ++i )
	{
		mpResultRate[i]->Clear();
		mpResultIcon[i]->ChangeImage(0);
		mpResultIcon[i]->SetNumber(0);
		mpResultIcon[i]->SetItemIndex(0);
	}
}

void cItemMixWindow::OnShow()
{
	cUIWindow::OnShow();

	GAMEUI->HideItemSetWindow( this );

	sHeroInfo* info = HERO->GetHeroInfo();
	if( info )
	{
		InsertMakeSkill( info->mMakeSkill1 );
		InsertMakeSkill( info->mMakeSkill2 );
	}
	else
	{
		assert(0);
		return;
	}

	if( mpMixSkillCombo )
		mpMixSkillCombo->SetSelect( 0 );
}

void cItemMixWindow::OnHide()
{
	cUIWindow::OnHide();

	Clear();
}

void cItemMixWindow::HideESC( bool onsound )
{
	ITEMMIXMAN->ItemMixCancel();
}

bool cItemMixWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpCoolTime = (cLabel*)GetChild( eUIID_GAME_ITEMMIX_COOLTIME );
	mpMixCount = (cNumberEditBox*)GetChild( eUIID_GAME_ITEMMIX_NUMBEREDIT );
	mpCompleteCount = (cLabel*)GetChild( eUIID_GAME_ITEMMIX_COMPLETECOUNT );
	mpGaugeBar = (cGauge*)GetChild( eUIID_GAME_ITEMMIX_GAUGE );
	mpMixSkillCombo = (cComboBox*)GetChild( eUIID_GAME_ITEMMIX_MIXSKILLCOMBO );
	mpMixSkillList = (cListFolderBox*)GetChild( eUIID_GAME_ITEMMIX_MIXSKILLFOLDER );
	mpItemMixList = (cItemMixListBox*)GetChild( eUIID_GAME_ITEMMIX_MIXLIST );
	mpMixStart = GetChild( eUIID_GAME_ITEMMIX_START );
	mpMixGiveUp = GetChild( eUIID_GAME_ITEMMIX_GIVEUP );
	mpMixStop = GetChild( eUIID_GAME_ITEMMIX_CANCEL );

	mpResultRate[0] = (cLabel*)GetChild( eUIID_GAME_ITEMMIX_RESULT1 );
	mpResultRate[1] = (cLabel*)GetChild( eUIID_GAME_ITEMMIX_RESULT2 );
	mpResultRate[2] = (cLabel*)GetChild( eUIID_GAME_ITEMMIX_RESULT3 );

	/// Ȯ  
	cString str;
	for( int i = 0; i < 3; ++i )
	{
		mpResultIcon[i] = new cItemIcon;

		str.Format( "ItemMixResult_Slot%02d", i );
		if( mpResultIcon[i]->CreateBySkinName( str, this, i+100 ) == false )
			return false;

		mpResultIcon[i]->SetUsedFlag( false, false );
	}
	
	/// ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cUINodeSkin* pHighSkin = pSkin->GetNodeSkin( "ItemMix_FolderCheck" );
	cUINodeSkin* pHighNoSkin = pSkin->GetNodeSkin( "ItemMix_FolderNoCheck" );
	if( pHighSkin && pHighNoSkin )
	{
		mpHighImage = new cUIImage( pHighSkin->mpTexture );

		unsigned int tx = pHighSkin->mSkinInfo->mTexX;
		unsigned int ty = pHighSkin->mSkinInfo->mTexY;
		unsigned int w = pHighSkin->mSkinInfo->mWidth;
		unsigned int h = pHighSkin->mSkinInfo->mHeight;
		unsigned int x = pHighSkin->mSkinInfo->mX;
		unsigned int y = pHighSkin->mSkinInfo->mY;

		mpHighImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpHighImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );

		unsigned int tx2 = pHighNoSkin->mSkinInfo->mTexX;
		unsigned int ty2 = pHighNoSkin->mSkinInfo->mTexY;

		mpMixSkillList->SetHighNoCheckPos( tx, ty );
		mpMixSkillList->SetHighCheckPos( tx2, ty2 );

		///  ġ 
		mpMixSkillList->SetLowGap( w );
	}

	if( mpGaugeBar )
		mpGaugeBar->SetMaxValue( 100 );
	return true;
}

void cItemMixWindow::OnCommand( cUINode* , unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_ITEMMIX_CLOSE:
		ITEMMIXMAN->ItemMixCancel();
		break;
	case eUIID_GAME_ITEMMIX_GIVEUP:
		{
			if( ITEMMIXMAN->IsNetLock() )
				return;

			///  
			unsigned char index = (unsigned char)mpMixSkillCombo->GetSelectData();

			cStringT str;
			unsigned long textIndex = ITEMMIXMAN->GetKeepSkillText( index );
			str.Format( GAMERESOURCEMAN->GetGameText( 2820 ), UIMAN->GetUIText( textIndex ) );

			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_ITEMMIX_DELETE, 
				(LPCTSTR)str.Cstr(),	
				GAMERESOURCEMAN->GetGameText( 301 ),	 // 
				eSKIN_YESNO,
				(void*)index
				);
		}
		break;
	case eUIID_GAME_ITEMMIX_START:
		if( mpMixCount->GetValue() > 0 )
		{
			unsigned int row  = mpMixSkillList->GetSelectRow();
			unsigned int column = mpMixSkillList->GetSelectRowColumn();
			unsigned long recipeIdx = (unsigned long)mpMixSkillList->GetExtraData( row, column );

			/// õ ų 
			unsigned char index = (unsigned char)mpMixSkillCombo->GetSelectData();

			///  ִ ְġ  Ѵ
			int total = GetMaxValue( recipeIdx );
			int value = ( total < (int)mpMixCount->GetValue() ) ? total : mpMixCount->GetValue();

			if( mpMixCount )
			{
				if( value == INT_MAX )
					mpMixCount->SetValue( 1 );
				else
					mpMixCount->SetValue( value );
			}

			/// 
			ITEMMIXMAN->ItemMixStart( index, recipeIdx, value );
		}
		else
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 2809 ) );
		}	
		break;
	case eUIID_GAME_ITEMMIX_CANCEL:
		ITEMMIXMAN->ItemMixCancel( false );
		break;
	case eUIID_GAME_ITEMMIX_MAX:
		{
			/// max ư
			/// õ Ʈ  
			unsigned int row  = mpMixSkillList->GetSelectRow();
			unsigned int column = mpMixSkillList->GetSelectRowColumn();
			unsigned long recipeIdx = (unsigned long)mpMixSkillList->GetExtraData( row, column );

			///  
			int total = GetMaxValue( recipeIdx );
		
			if( mpMixCount )
			{
				if( total == INT_MAX )
					mpMixCount->SetValue( 1 );
				else
					mpMixCount->SetValue( total );
			}
		}
		break;
	}
}

unsigned long cItemMixWindow::GetMaxValue( unsigned long recipeIdx )
{
	typedef tArray<void*>* cMaterialArr;
	cMaterialArr materialArr;

	int total = INT_MAX;
	sMakeSkillScript* script = MAKESKILLSCRIPT->GetMakeSkill( recipeIdx );
	if( script )
	{
		materialArr = script->mpMaterial;
		if( materialArr )
		{
			for( unsigned int i = 0; i < materialArr->GetSize(); ++i )
			{
				sMaterialScript* data = (sMaterialScript*)(*materialArr)[i];
				if( data )
				{
					int invenCount = ITEMMAN->GetItemCount( data->mItemIdx );

					///  ִ  üũ
					int makeCount = (invenCount / data->mItemCnt);
					total = ( total < makeCount ) ? total : makeCount;
				}
				else
				{
					assert(0);
				}
			}
		}
	}
	return total;
}

void cItemMixWindow::OnComboSelected( cUINode* , unsigned int id )
{
	if( ITEMMIXMAN->IsMixContinue() )
		return;

	if( id == eUIID_GAME_ITEMMIX_MIXSKILLCOMBO )
	{
		if( mpMixSkillCombo )
		{
			unsigned char index = (unsigned char)mpMixSkillCombo->GetSelectData();
			UpdateMixList( index );
		}
	}
}

void cItemMixWindow::OnListBoxChanged( cUINode* , unsigned int id )
{
	if( ITEMMIXMAN->IsMixContinue() )
		return;

	if( id == eUIID_GAME_ITEMMIX_MIXSKILLFOLDER )
	{
		/// ʱȭ
		if( mpMixCount) 
			mpMixCount->SetValue( 1 );
		UpdateMixInfo();
	}
}

void cItemMixWindow::OnGaugeEnd( cUINode* n, unsigned int )
{
	if( mpGaugeBar && n == mpGaugeBar )
	{
		ITEMMIXMAN->ItemMixEndRequest();
	}
}

void cItemMixWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mpRecipeCool )
	{
		cStringT tm,ts;

		unsigned long elapsedTime = accumTime - mpRecipeCool->mStartTime;
		if( mpRecipeCool->mRestTime > elapsedTime )
		{
			short coolTime = (short)((mpRecipeCool->mRestTime - elapsedTime) / 1000);

			/// ð ؼ 
			unsigned int m = ((unsigned int)coolTime ) / 60;
			unsigned int s = ((unsigned int)coolTime % 60) % 60;

			if( m != 0 )
				tm.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000809 ), m );
			if( s != 0 )
				ts.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000808 ), s );

			tm += ts;

			if( mpCoolTime )
				mpCoolTime->SetText( (LPCTSTR)tm.Cstr() );
		}
		else
		{
			ts.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000808 ), 0 );

			if( mpCoolTime )
				mpCoolTime->SetText( (LPCTSTR)ts.Cstr() );
		}
	}
}

/// ޺ ų ֱ
bool cItemMixWindow::InsertMakeSkill( unsigned char index )
{
	if( mVisible && index > 0 )
	{
		if( mpMixSkillCombo )
		{
			unsigned long textIndex = ITEMMIXMAN->GetKeepSkillText( index );
			mpMixSkillCombo->AddItem( UIMAN->GetUIText( textIndex ), (void*)index );
			mpMixSkillCombo->SetSelect( 0 );
		}
		else
		{
			assert(0);
			return false;
		}
	}
	return true;
}

bool cItemMixWindow::DeleteMakeSkill( unsigned char index )
{
    ///  UI   Ѵ ( Ⱥ showϸ鼭 ڵ )
	if( mVisible && mpMixSkillCombo && mpMixSkillCombo )
	{
		mpMixSkillList->Clear();
		mpMixSkillCombo->Clear();

		/// 
		sHeroInfo* info = HERO->GetHeroInfo();
		if( info )
		{
			InsertMakeSkill( info->mMakeSkill1 );
			InsertMakeSkill( info->mMakeSkill2 );
		}
		else
		{
			assert(0);
			return false;
		}
	}
	return true;
}

/// ο  
bool cItemMixWindow::InsertRecipe( unsigned char index, unsigned long recipeIdx )
{
	///  UI   Ѵ ( Ⱥ showϸ鼭 ڵ )
	if( mVisible && mpMixSkillCombo )
	{
		///   ִ ̸,
		unsigned char idx = (unsigned char)mpMixSkillCombo->GetSelectData();
		if( idx == index )
		{
			/// 
			sMakeSkillScript* script = MAKESKILLSCRIPT->GetMakeSkill( recipeIdx );
			if( script )
			{
				unsigned long textIndex = ITEMMIXMAN->GetTypeText( index, script->mType );

				mpMixSkillList->AddHighData( script->mType, GAMERESOURCEMAN->GetItemToolTipText( textIndex ), mDefaultColor, mpHighImage );
				mpMixSkillList->AddLowData( script->mType, ITEMMAN->GetItemName( recipeIdx ), mDefaultColor, (void*)recipeIdx );
			}
		}
	}
	return true;
}

/// ոƮ 
void cItemMixWindow::UpdateMixList( int index )
{
	if( index < eMAKESKILL_COOK )
		return;

	typedef tPointerHashMap<unsigned long, void*> cKeepRecipeMap;

	cKeepRecipeMap* keepRecipeMap = 0;
	
	sHeroInfo* info = HERO->GetHeroInfo();
	if( info )
	{
		if( info->mMakeSkill1 == index )
		{
			keepRecipeMap = ITEMMIXMAN->GetKeepSkillMap1();
		}
		else if( info->mMakeSkill2 == index )
		{
			keepRecipeMap = ITEMMIXMAN->GetKeepSkillMap2();
		}
		else
		{
			assert(0);
			return;
		}
	}

	if( keepRecipeMap )
	{
		/// ʱȭ
		mpItemMixList->Clear();
		mpMixSkillList->Clear();
		mpMixCount->SetValue( 1 );
		mpCompleteCount->SetValue( 0 );
		InitCoolTime();

		/// 
		cKeepRecipeMap::cIterator i = keepRecipeMap->Begin();
		cKeepRecipeMap::cIterator end = keepRecipeMap->End();
		for( ; i != end; ++i )
		{
			unsigned long key = (unsigned long)(i->mFirst);
			sKeepRecipe* data = (sKeepRecipe*)(i->mSecond);

			sMakeSkillScript* script = MAKESKILLSCRIPT->GetMakeSkill( key );
			if( script )
			{
				unsigned long textIndex = ITEMMIXMAN->GetTypeText( index, script->mType );

				mpMixSkillList->AddHighData( script->mType, GAMERESOURCEMAN->GetItemToolTipText( textIndex ), mDefaultColor, mpHighImage );
				mpMixSkillList->AddLowData( script->mType, ITEMMAN->GetItemName( key ), mDefaultColor, (void*)key );
			}
		}

		mpMixSkillList->UpdateSelectImage();
	}
	else
	{
		assert(0);
	}
}

///    
void cItemMixWindow::UpdateMixInfo()
{
	typedef tArray<void*>* cMaterialArr;
	cMaterialArr materialArr;

	unsigned int row  = mpMixSkillList->GetSelectRow();
	unsigned int column = mpMixSkillList->GetSelectRowColumn();
	unsigned long recipeIdx = (unsigned long)mpMixSkillList->GetExtraData( row, column );

	InitCoolTime();

	///  
	sMakeSkillScript* script = MAKESKILLSCRIPT->GetMakeSkill( recipeIdx );
	if( script )
	{
		sHeroInfo* info = HERO->GetHeroInfo();
		if( info )
		{
			/// 1.  ð 
			unsigned char index = (unsigned char)mpMixSkillCombo->GetSelectData();
			if( info->mMakeSkill1 == index )
			{
				mpRecipeCool = ITEMMIXMAN->GetKeepMixSkill1( recipeIdx );
			}
			else if( info->mMakeSkill2 == index )
			{
				mpRecipeCool = ITEMMIXMAN->GetKeepMixSkill2( recipeIdx );
			}
			else
			{
				assert(0);
				return;
			}
		}

		/// 2.  
		materialArr = script->mpMaterial;
		if( materialArr )
		{
			mpItemMixList->Clear();

			for( unsigned int i = 0; i < materialArr->GetSize(); ++i )
			{
				sMaterialScript* data = (sMaterialScript*)(*materialArr)[i];
				if( data )
				{
					cItemDefine* define = ITEMMAN->GetItemDefine( data->mItemIdx );
					if( define )
					{
						//  : κ ,  : ʿ䷮
						int invenCount = ITEMMAN->GetItemCount( data->mItemIdx );

						///    ٲٱ
						unsigned long color = ( invenCount < data->mItemCnt ) ? eCOLOR_RED : mDefaultColor;

						unsigned int row = mpItemMixList->AddRow( define->GetName(), color, (void*)data->mItemIdx );
						if( row >= 0 )
						{
							cStringT countStr;
							countStr.Format( _T("%d/%d"), invenCount, data->mItemCnt );
							mpItemMixList->AddColume( row, (LPCTSTR)countStr.Cstr(), color );
						}
					}
					else
					{
						assert(0);
					}
				}
				else
				{
					assert(0);
				}
			}
		}

		unsigned int totalRate = 0;
		for( int i = 0; i < MAKESKILL_MAKE_ITEM_CNT; ++i )
		{
			unsigned long itemIndex = script->mMakeItemIdx[i];
			if( itemIndex > 0 )
				totalRate = totalRate + script->mMakeRate[i];
		}

		for( int i = 0; i < MAKESKILL_MAKE_ITEM_CNT; ++i )
		{
			///  ʱȭ
			mpResultIcon[i]->ChangeImage(0);
			mpResultIcon[i]->SetNumber(0);
			mpResultIcon[i]->SetItemIndex(0);
			mpResultRate[i]->Clear();

			unsigned long itemIndex = script->mMakeItemIdx[i];
			unsigned int count = script->mMakeCnt[i];
			unsigned short rate = script->mMakeRate[i];
			if( itemIndex > 0 )
			{
				cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
				if( define )
				{
					mpResultIcon[i]->SetItemIndex( itemIndex );
					mpResultIcon[i]->ChangeImage( define->GetIconParam() );
					mpResultIcon[i]->SetNumber( count );
				}

				float presentRate = (float)(rate * 100 / totalRate);

				cStringT str;
				str.Format( _T("%.f%%"), presentRate );
				mpResultRate[i]->SetText( (LPCTSTR)str.Cstr() );
			}
		}
	}
}

/// Ÿ 
void cItemMixWindow::UpdateMixCool()
{
	unsigned int row  = mpMixSkillList->GetSelectRow();
	unsigned int column = mpMixSkillList->GetSelectRowColumn();
	unsigned long recipeIdx = (unsigned long)mpMixSkillList->GetExtraData( row, column );

	InitCoolTime();

	sMakeSkillScript* script = MAKESKILLSCRIPT->GetMakeSkill( recipeIdx );
	if( script )
	{
		sHeroInfo* info = HERO->GetHeroInfo();
		if( info )
		{
			/// 1.  ð 
			unsigned char index = (unsigned char)mpMixSkillCombo->GetSelectData();
			if( info->mMakeSkill1 == index )
			{
				mpRecipeCool = ITEMMIXMAN->GetKeepMixSkill1( recipeIdx );
			}
			else if( info->mMakeSkill2 == index )
			{
				mpRecipeCool = ITEMMIXMAN->GetKeepMixSkill2( recipeIdx );
			}
			else
			{
				assert(0);
				return;
			}
		}
	}
}

///     
void cItemMixWindow::CheckItemCount()
{
	typedef tArray<void*>* cMaterialArr;
	cMaterialArr materialArr;

	unsigned int row  = mpMixSkillList->GetSelectRow();
	unsigned int column = mpMixSkillList->GetSelectRowColumn();
	unsigned long recipeIdx = (unsigned long)mpMixSkillList->GetExtraData( row, column );

	///  
	sMakeSkillScript* script = MAKESKILLSCRIPT->GetMakeSkill( recipeIdx );
	if( script )
	{
		materialArr = script->mpMaterial;
		if( materialArr )
		{
			mpItemMixList->Clear();

			for( unsigned int i = 0; i < materialArr->GetSize(); ++i )
			{
				sMaterialScript* data = (sMaterialScript*)(*materialArr)[i];
				if( data )
				{
					cItemDefine* define = ITEMMAN->GetItemDefine( data->mItemIdx );
					if( define )
					{
						//  : κ ,  : ʿ䷮
						int invenCount = ITEMMAN->GetItemCount( data->mItemIdx );

						///    ٲٱ
						unsigned long color = ( invenCount < data->mItemCnt ) ? eCOLOR_RED : mDefaultColor;

						unsigned int row = mpItemMixList->AddRow( define->GetName(), color, (void*)data->mItemIdx );
						if( row >= 0 )
						{
							cStringT countStr;
							countStr.Format( _T("%d/%d"), invenCount, data->mItemCnt );
							mpItemMixList->AddColume( row, (LPCTSTR)countStr.Cstr(), color );
						}
					}
					else
					{
						assert(0);
					}
				}
				else
				{
					assert(0);
				}
			}
		}
	}
}

void cItemMixWindow::InitCoolTime()
{
	mpRecipeCool = 0;

	if( mpCoolTime )
	{
		cStringT ts;
		ts.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000808 ), 0 );
		mpCoolTime->SetText( (LPCTSTR)ts.Cstr() );
	}
}

void cItemMixWindow::SetCompleteCount( int count )
{
	if( mpCompleteCount )
		mpCompleteCount->SetValue( count );
}

void cItemMixWindow::StartGauge( float speed )
{
	if( mpGaugeBar )
	{
		mpGaugeBar->SetGaugeSpeed( speed );
		mpGaugeBar->SetGaugeAni( 100 );
	}
}

void cItemMixWindow::StopGauge()
{
	if( mpGaugeBar )
		mpGaugeBar->ClearFront();
}

void cItemMixWindow::OnNetLock( int lockTry )
{
	if( mpMixStart )
		mpMixStart->NetLock( lockTry );

	if( mpMixGiveUp )
		mpMixGiveUp->NetLock( lockTry );
}

void cItemMixWindow::OnNetUnLock( int lockTry )
{
	if( mpMixStart )
		mpMixStart->NetUnLock( lockTry );

	if( mpMixGiveUp )
		mpMixGiveUp->NetUnLock( lockTry );
}

//----------------------------------------------------------
// Ÿ Ʈڽ
cItemMixListBox::cItemMixListBox( eUINodeType type )
: cNpcStoreListBox( type )
{
}

bool cItemMixListBox::OnCreate( cUINodeProperty* pproperty )
{
	if( cListBox::OnCreate( pproperty ) == false )
		return false;

	mHalfWidth = 174;
	mMaxIconCount = 6;

	///  
	cString str;
	for( int i = 0; i < mMaxIconCount; ++i )
	{
		str.Format( "ItemMix_Slot%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, i + 1 ) == false )
			return false;

		mIcon[i] = icon;
	}

	mShowImage = false;
	mEnableSelect = false;
	return true;
}
