#include "stdafx.h"
#include "ItemMsgWindow.h"

#include "ItemManager.h"
#include "GameResourceManager.h"
#include "UIMsgboxEvent.h"

#include "BaseStage.h"
#include "StageManager.h"
#include "Button.h"
#include "Label.h"
#include "NumberEditBox.h"

cItemMsgWindow::cItemMsgWindow()
: mpOk(0)
, mpYes(0)
, mpCancel(0)
, mItemIndex(0)
, mSlotIndex0(0)
, mSlotIndex1(0)
, mCount(0)
, mpCaption(0)
, mpText(0)
{
}

cItemMsgWindow::~cItemMsgWindow()
{
}

void cItemMsgWindow::OnHide()
{
	cUIWindow::OnHide();

	if( mpText )
		mpText->Clear();

	mItemIndex = 0;
	mSlotIndex0 = 0;
	mSlotIndex1 = 0;
	mCount = 0;
}

bool cItemMsgWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	mpOk = (cButton*)GetChild( eUIID_ITEMMSG_OK );
	mpYes = (cButton*)GetChild( eUIID_ITEMMSG_YES );
	mpCancel = (cButton*)GetChild( eUIID_ITEMMSG_CANCEL );
	mpCaption = (cLabel*)GetChild( eUIID_ITEMMSG_CAPTION );
	mpText = (cLabel*)GetChild( eUIID_ITEMMSG_TEXT );

	if( mpCaption )
		mpCaption->SetTextColor( eCOLOR_WHITE );

	if( mpText )
		mpText->SetTextColor( eCOLOR_WHITE );
	return true;
}

bool cItemMsgWindow::HandleEvent(const cUIEvent& event )
{	
	if( mEnabled == false || mVisible == false )
		return mpParent->HandleEvent( event );

	switch( event.mType )
	{
	case eUIEVENT_LBUTTON_DOWN:
	case eUIEVENT_LBUTTON_UP:
	case eUIEVENT_MOUSE_MOVE:
		{
			cUINode* pNode = this->GetNode( event.mPos );
			if( pNode && (pNode->GetType() == eUINODE_BUTTON || pNode->GetType() == eUINODE_EDITBOX ))
				pNode->HandleEvent( event );
			else
				cUIWindow::HandleEvent( event );
		}
		break;
	case eUIEVENT_KEY_UP:
	case eUIEVENT_KEY_DOWN:
		if( event.mCode == eKEY_RETURN || event.mCode == eKEY_ESCAPE )
		{
			cUIWindow::HandleEvent( event );
		}
		break;
	case eUIEVENT_COMMAND:
	case eUIEVENT_GAME_COMMAND:
		if( event.mID == eMESSAGE_BUTTON_NO && mMsgHandler )
		{
			if( mpOk && mpOk->IsVisible() == true )
				mMsgHandler->MsgBoxEventParser( mEventType, eUIID_ITEMMSG_OK, 0 );
			else
				mMsgHandler->MsgBoxEventParser( mEventType, eUIID_ITEMMSG_CANCEL, 0 );
		}
		else
			cUIWindow::HandleEvent( event );
		break;
	default:
		cUIWindow::HandleEvent( event );
		break;
	}
	return true;
}

void cItemMsgWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_ITEMMSG_OK:
	case eUIID_ITEMMSG_YES:
	case eUIID_ITEMMSG_CANCEL:
		if( mMsgHandler )
			mMsgHandler->MsgBoxEventParser( mEventType, id, 0 );

		Hide();
		break;
	}
}

void cItemMsgWindow::ShowModal( eMSGBox_Event eventtype, unsigned int slotIndex, unsigned long itemIndex, 
							    unsigned int count, unsigned long price )
{
	cUIWindow::ShowModal( eventtype );

	if( mpOk )
		mpOk->Hide();
	if( mpYes )
		mpYes->Show();
	if( mpCancel )
		mpCancel->Show();

	cStringT str;
	unsigned long itemPrice = 0;
	switch( eventtype )
	{
	case eMBEVENT_ITEM_SELL:
		{
			cItem& item = ITEMMAN->GetItem( slotIndex );
			cItemDefine* itemDefine = item.GetDefine();
			if( itemDefine )
			{
				/// ǸźҰ
				if( itemDefine->GetSellType() == ItemSellNone )
				{
					str.Format( GAMERESOURCEMAN->GetGameText( 204 ) );
					
					if( mpOk )
						mpOk->Show();
					if( mpYes )
						mpYes->Hide();
					if( mpCancel )
						mpCancel->Hide();
				}
				else
				{
					LPCTSTR name = itemDefine->GetName();
					unsigned long unitIndex = ITEMMAN->GetPriceUinit( itemDefine->GetSellType() );
					itemPrice = count * itemDefine->GetSellPrice();
					cStringT priceStr = cNumberEditBox::FormatNumber( itemPrice );
					cStringT countStr = cNumberEditBox::FormatNumber( count );

					str.Format( GAMERESOURCEMAN->GetGameText( 206 ), name, (LPCTSTR)countStr.Cstr(), (LPCTSTR)priceStr.Cstr(), GAMERESOURCEMAN->GetItemToolTipText( unitIndex ) );
				}
			}
		}
		break;
	case eMBEVENT_ITEM_DUMP:
		{
			cItem& item = ITEMMAN->GetItem( slotIndex );
			cItemDefine* itemDefine = item.GetDefine();
			if( itemDefine )
				str.Format( GAMERESOURCEMAN->GetGameText( 214 ), itemDefine->GetName() );
		}
		break;
	case eMBEVENT_ITEM_BUY:
		{
			///  ε ̿
			cItemDefine* itemDefine = ITEMMAN->GetItemDefine( itemIndex );
			if( itemDefine )
			{
				LPCTSTR name = itemDefine->GetName();
				unsigned long unitIndex = ITEMMAN->GetPriceUinit( itemDefine->GetBuyType() );
				itemPrice = count * itemDefine->GetBuyPrice();
				cStringT priceStr = cNumberEditBox::FormatNumber( itemPrice );
				cStringT countStr = cNumberEditBox::FormatNumber( count );

				str.Format( GAMERESOURCEMAN->GetGameText( 203 ), name, (LPCTSTR)countStr.Cstr(), (LPCTSTR)priceStr.Cstr(), GAMERESOURCEMAN->GetItemToolTipText( unitIndex ) );		
			}
		}
		break;
	case eMBEVENT_ITEM_USERSELLBUY:
		{
			cItemDefine* itemDefine = ITEMMAN->GetItemDefine( itemIndex );
			if( itemDefine )
			{
				LPCTSTR name = itemDefine->GetName();
				itemPrice = count * price;
				cStringT priceStr = cNumberEditBox::FormatNumber( itemPrice );
				cStringT countStr = cNumberEditBox::FormatNumber( count );

				str.Format( GAMERESOURCEMAN->GetGameText( 216 ), name, (LPCTSTR)countStr.Cstr(), (LPCTSTR)priceStr.Cstr() );		
			}
		}
		break;
	default:
		assert(0);
		return;
	}

	if( mpText )
		mpText->SetText( (LPCTSTR)str.Cstr() );

	mMsgHandler = STAGEMAN->GetStage( STAGEMAN->GetCurrentStage() );
	mEventType = eventtype;
	mSlotIndex0 = slotIndex;
	mSlotIndex1 = 0;
	mItemIndex = itemIndex;
	mCount = count;
}

void cItemMsgWindow::ShowModal( eMSGBox_Event eventtype, unsigned int slotIndex0, unsigned int slotIndex1, unsigned long itemIndex )
{
	cUIWindow::ShowModal( eventtype );

	if( mpOk )
		mpOk->Hide();
	if( mpYes )
		mpYes->Show();
	if( mpCancel )
		mpCancel->Show();

	cStringT str;
	switch( eventtype )
	{
	case eMBEVENT_ITEM_PUTCARD_NEW:	/// ο ī 
		{
			cItem& item = ITEMMAN->GetItem( slotIndex0 );
			cItemDefine* itemDefine = item.GetDefine();
			if( itemDefine )
				str.Format( GAMERESOURCEMAN->GetGameText( 2601 ), itemDefine->GetName() );
		}
		break;
	case eMBEVENT_ITEM_PUTCARD_UPDATE:	///  ī 
		{
			cItem& item0 = ITEMMAN->GetItem( slotIndex0 );
			cItemDefine* itemDefine0 = item0.GetDefine();

			cItemDefine* itemDefine1 = ITEMMAN->GetItemDefine( itemIndex );
			if( itemDefine0 && itemDefine1 )
				str.Format( GAMERESOURCEMAN->GetGameText( 2602 ), itemDefine0->GetName(), itemDefine1->GetName() );
		}
		break;
	case eMBEVENT_ITEM_CARDBOOK_TAROTNEW:
		{
			cItem& item = ITEMMAN->GetItem( slotIndex0 );
			cItemDefine* itemDefine = item.GetDefine();
			if( itemDefine )
				str.Format( GAMERESOURCEMAN->GetGameText( 340 ), itemDefine->GetName() );
		}
		break;
	case eMBEVENT_ITEM_CARDBOOK_TAROTUPDATE:
		{
			cItem& item0 = ITEMMAN->GetItem( slotIndex0 );
			cItemDefine* itemDefine0 = item0.GetDefine();

			cItemDefine* itemDefine1 = ITEMMAN->GetItemDefine( itemIndex );
			if( itemDefine0 && itemDefine1 )
				str.Format( GAMERESOURCEMAN->GetGameText( 341 ), itemDefine0->GetName(), itemDefine1->GetName() );
		}
		break;
	case eMBEVENT_ITEM_CARDBOOK_SPREADNEW:
		{
			cItem& item = ITEMMAN->GetItem( slotIndex0 );
			cItemDefine* itemDefine = item.GetDefine();
			if( itemDefine )
				str.Format( GAMERESOURCEMAN->GetGameText( 344 ), itemDefine->GetName() );
		}
		break;
	case eMBEVENT_ITEM_CARDBOOK_SPREADUPDATE:
		{
			cItem& item0 = ITEMMAN->GetItem( slotIndex0 );
			cItemDefine* itemDefine0 = item0.GetDefine();

			cItemDefine* itemDefine1 = ITEMMAN->GetItemDefine( itemIndex );
			if( itemDefine0 && itemDefine1 )
				str.Format( GAMERESOURCEMAN->GetGameText( 345 ), itemDefine0->GetName(), itemDefine1->GetName() );
		}
		break;
	default:
		assert(0);
		return;
	}

	if( mpText )
		mpText->SetText( (LPCTSTR)str.Cstr() );

	mMsgHandler = STAGEMAN->GetStage( STAGEMAN->GetCurrentStage() );
	mEventType = eventtype;
	mSlotIndex0 = slotIndex0;
	mSlotIndex1 = slotIndex1;
	mItemIndex = itemIndex;
}
