#include "StdAfx.h"
#include "ItemTipWindow.h"
#include "FontAgent.h"

#include "ItemManager.h"
#include "PlaneObject.h"
#include "UIWindow.h"
#include "GameResourceManager.h"
#include "FontAgent.h"
#include "UIRoundGauge.h"
#include "UIImage.h"
#include "Icon.h"

cItemTipWindow::cItemTipWindow()
: mGauge(0)
, mTimeTipIdx(0)
, mItemIndex(0)
, mCheckTime(false)
//, mSlotIndex(UINT_MAX)
, mSlotCount(0)
, mUpdateSizebyTime( false )
{
	Clear();
	::memset( mImage, 0, sizeof(mImage) );
	::memset( mSlotImage, 0, sizeof(mSlotImage) );
}

cItemTipWindow::~cItemTipWindow()
{
	for( int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		SAFE_DELETE( mImage[i] );
		SAFE_DELETE( mSlotImage[i] );
	}
}

void cItemTipWindow::Clear()
{
	cTipWindow::Clear();
	mGauge = 0;
	mTimeTipIdx = 0;
	mItemIndex = 0;
	mCheckTime = false;
//	mSlotIndex = UINT_MAX;
	mSaveCoolTime.Clear();
	mUpdateSizebyTime = true;
	mTimerEnabled = false;
	mSlotCount = 0;
	mImagePosY = 0;

	for( int i = 0; i < MAX_CARD_SLOT; ++i )
		mShowImage[i] = false;
}

bool cItemTipWindow::OnCreate( cUINodeProperty* prop )
{
	if( cTipWindow::OnCreate( prop ) == false )
		return false;

	///  Ÿ ̹ б
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cString str;
	NiTexture* texture = 0;
	for( unsigned int i = 0; i < MAX_CARD_SLOT-1; ++i )
	{
		str.Format( "PutCard_SlotType%d", i );
		cUINodeSkin* pSlotSkin = pSkin->GetNodeSkin( str );
		if( pSlotSkin )
		{
			mTexPos[i].mX = pSlotSkin->mSkinInfo->mTexX;
			mTexPos[i].mY = pSlotSkin->mSkinInfo->mTexY;

			texture = pSlotSkin->mpTexture;
		}
	}

	if( !texture )
	{
		assert(0);
		return false;
	}

	/// ̹ 
	cUINodeSkin* imgSkin = pSkin->GetNodeSkin( "PutCard_Slot0" );
	if( !imgSkin )
		return false;

	for( int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		mImage[i] = new cUIImage;
		unsigned int x = imgSkin->mSkinInfo->mX;
		unsigned int y = imgSkin->mSkinInfo->mY;
		unsigned int w = imgSkin->mSkinInfo->mWidth;
		unsigned int h = imgSkin->mSkinInfo->mHeight;
		mImage[i]->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}

	///  ̹ 
	for( int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		str.Format( "PutCard_SlotPos%d", i );
		imgSkin = pSkin->GetNodeSkin( str );
		if( imgSkin && texture )
		{
			mSlotImage[i] = new cUIImage( texture );
			unsigned int x = imgSkin->mSkinInfo->mX;
			unsigned int y = imgSkin->mSkinInfo->mY;
			mSlotSize.mWidth = imgSkin->mSkinInfo->mWidth;
			mSlotSize.mHeight = imgSkin->mSkinInfo->mHeight;
			mSlotImage[i]->SetScreenRect( cUIRect(x, y, x+mSlotSize.mWidth, y+mSlotSize.mHeight) );
		}
	}
	return true;
}

void cItemTipWindow::OnRender( cUIFontItemKeeper* fontKeeper )
{	
	if( mVisible == false )
		return;

	/// 
	mMiddleBack->Draw();

	if( mSlotCount > 0 )
	{
		for( unsigned int i = 0; i < mSlotCount; ++i )
		{
			if( mSlotImage[i] )
				mSlotImage[i]->Draw();

			if( mImage[i] && mShowImage[i] == true )
				mImage[i]->Draw();
		}
	}

	int px = mX + GAP_SIZE;
	int py = mY;

	///   
	for( unsigned int row = 0; row < mIndex; ++row )
	{
		cStringT& str = mToolTip[row].mString;
		if( str.IsEmpty() )
			continue;

		py += mToolTip[row].mGapCount * GAP_SIZE;

		///   
		unsigned int color = mToolTip[row].mColor;
		fontKeeper->AddFontItem( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), px, py, color );

		py += mLineHeight;
	}

	///
	fontKeeper->DrawAll();
}

bool cItemTipWindow::SetItemInfo( eTip_Kind tipkind, const cUIPos& pos, sInventory& inven, bool checkTime )
{
	cItemDefine* itemDefine = ITEMMAN->GetItemDefine( inven.ItemIndex );
	if( itemDefine == 0 )
		return false;

	Clear();

	mItemIndex = inven.ItemIndex;
	mCheckTime = checkTime;

	bool bStore = false;
	eItemIn itemIn = ITEMMAN->GetItemIn( inven.number );
	if( itemIn == ITEM_IN_NPCSTORE )
		bStore = true;

	//////////////////////////////////////////////////////////////////////////
	/// Tip Start
	AddGap( 1 );
	SetName( itemDefine, inven.enhanced );

	///  
	SetRare( itemDefine );
	AddGap( 1 );

	///  з  
	unsigned char type = itemDefine->GetType();
	unsigned char subType = itemDefine->GetSubType();
	short defenseType = 0;

	cItemAbility* itemAbil = itemDefine->GetAbililty();
	if( itemAbil )
		defenseType = itemAbil->GetDefenseType();

	SetType( type, subType, defenseType );
	AddGap( 1 );

	///  
	if( type == ITEM_WEAPON || type == ITEM_WEAR || type == ITEM_ACCESSORY )
	{
		///  ⺻ ġ 
		if( SetBasic( itemDefine, inven.enhanced ) == true )
			AddGap( 1 );

		///  ߰ ġ 
		if( SetSpecial( itemDefine ) == true )
			AddGap( 1 );
	}
	else if( type == ITEM_CARD && subType == ITEM_CARD_EQUIP_C )
	{
		///  ⺻ ġ 
		if( SetBasic( itemDefine, inven.enhanced ) == true )
			AddGap( 1 );

		///  ߰ ġ 
		if( SetSpecialCard( itemDefine ) == true )
			AddGap( 1 );
	}
	else
	{
		///   
		/// ȿ 
		if( SetEffect( itemDefine ) == true )
			AddGap( 1 );

		/// ð 
		if( SetUseTime( itemDefine ) == true )
			AddGap( 1 );
	}

	/// ī
	if( bStore == false )
		SetCard( inven );

	///   
	if( SetLimit( itemDefine ) == true )
		AddGap( 1 );

	///   
	LPCTSTR desc = itemDefine->GetDescription();
	if( desc )
	{
		CheckText( desc, eCOLOR_BLUE );
		AddGap( 1 );
	}

	///    
	SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000701 ), (unsigned long)itemDefine->GetWeight(), eCOLOR_WHITE );

	///  ̸,
	if( bStore == false )
	{
		/// ǸŰ 
		SetPrice( itemDefine->GetSellType(), itemDefine, 2000702, itemDefine->GetSellPrice() );
	}
	else
	{
		/// Ű 
		SetPrice( itemDefine->GetBuyType(), itemDefine, 2000704, itemDefine->GetBuyPrice() );
	}

	///   ɿ 
	if( itemDefine->GetDisjoint() )
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000705 ), eCOLOR_BLUE );

	/// ŷ   
	if( itemDefine->GetExchange() != 0 )
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000711 ), eCOLOR_BLUE );
	/// Tip End
	//////////////////////////////////////////////////////////////////////////

	///  ̹ 
	SetBackImg( pos );

	return true;
}

/*
///   
bool cItemTipWindow::SetItem( eTip_Kind tipkind, const cUIPos& pos, unsigned long itemIndex, int slotIndex, cUIRoundGauge* gauge )
{
	if( itemIndex == 0 )
		return false;

	cItemDefine* itemDefine = ITEMMAN->GetItemDefine( itemIndex );
	if( itemDefine == 0 )
		return false;

	/// Ŭ 
	Clear();

	///   
	mGauge = gauge;
	mItemIndex = itemIndex;
	mSlotIndex = slotIndex;

	if( tipkind == eTIP_ITEM )
	{
		/// ۰â ȣ
		eItemIn itemIn = ITEMMAN->GetItemIn( slotIndex );
		if( itemIn == ITEM_IN_NPCSTORE )
			SetNormalTip( itemDefine, true );
		else
			SetNormalTip( itemDefine );
	}
	else if( tipkind == eTIP_QUICK )
	{
		///  
		SetNormalTip( itemDefine );
	}

	///  ̹ 
	SetBackImg( pos );
	return true;
}

bool cItemTipWindow::SetItem( eTip_Kind tipkind, const cUIPos& pos, unsigned long itemIndex, unsigned int enhance )
{
	if( itemIndex == 0 )
		return false;

	cItemDefine* itemDefine = ITEMMAN->GetItemDefine( itemIndex );
	if( itemDefine == 0 )
		return false;

	/// Ŭ 
	Clear();

	if( tipkind != eTIP_ITEM )
		return true;

	///   
	mItemIndex = itemIndex;

	///  
	{
		/// ۸  
		AddGap( 1 );
		SetName( itemDefine, enhance );

		///  
		SetRare( itemDefine );
		AddGap( 1 );

		///  з  
		unsigned char type = itemDefine->GetType();
		unsigned char subType = itemDefine->GetSubType();
		short defenseType = 0;

		cItemAbility* itemAbil = itemDefine->GetAbililty();
		if( itemAbil )
			defenseType = itemAbil->GetDefenseType();

		SetType( type, subType, defenseType );
		AddGap( 1 );

		///   ( ī )
		if( type == ITEM_WEAPON || type == ITEM_WEAR || type == ITEM_ACCESSORY )
		{
			///  ⺻ ġ 
			if( SetBasic( itemDefine, enhance ) == true )
				AddGap( 1 );

			///  ߰ ġ 
			if( SetSpecial( itemDefine ) == true )
				AddGap( 1 );
		}
		else if( type == ITEM_CARD && subType == ITEM_CARD_EQUIP_C )
		{
			///  ⺻ ġ 
			if( SetBasic( itemDefine, enhance ) == true )
				AddGap( 1 );

			///  ߰ ġ 
			if( SetSpecialCard( itemDefine ) == true )
				AddGap( 1 );
		}
		else
		{
			///   
			/// ȿ 
			if( SetEffect( itemDefine ) == true )
				AddGap( 1 );

			/// ð 
			if( SetUseTime( itemDefine ) == true )
				AddGap( 1 );
		}

		///   
		if( SetLimit( itemDefine ) == true )
			AddGap( 1 );

		///   
		LPCTSTR desc = itemDefine->GetDescription();
		if( desc )
		{
			CheckText( desc, eCOLOR_BLUE );
			AddGap( 1 );
		}

		///    
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000701 ), (unsigned long)itemDefine->GetWeight(), eCOLOR_WHITE );

		/// ǸŰ 
		SetPrice( itemDefine->GetSellType(), itemDefine, 2000702, itemDefine->GetSellPrice() );

		///   ɿ 
		if( itemDefine->GetDisjoint() )
			SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000705 ), eCOLOR_BLUE );

		/// ŷ   
		if( itemDefine->GetExchange() != 0 )
			SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000711 ), eCOLOR_BLUE );
	}

	///  ̹ 
	SetBackImg( pos );
	return true;
}

/// ٸ    
bool cItemTipWindow::SetOtherItem( eTip_Kind tipkind, const cUIPos& pos, sInventory& inven )
{
	if( inven.ItemIndex == 0 )
		return false;

	cItemDefine* itemDefine = ITEMMAN->GetItemDefine( inven.ItemIndex );
	if( itemDefine == 0 )
		return false;

	///
	Clear();

	if( tipkind != eTIP_ITEM )
		return true;

	///  
	{
		/// ۸  
		AddGap( 1 );
		SetName( itemDefine, inven.enhanced );

		///  
		SetRare( itemDefine );
		AddGap( 1 );

		///  з  
		unsigned char type = itemDefine->GetType();
		unsigned char subType = itemDefine->GetSubType();
		short defenseType = 0;

		cItemAbility* itemAbil = itemDefine->GetAbililty();
		if( itemAbil )
			defenseType = itemAbil->GetDefenseType();

		SetType( type, subType, defenseType );
		AddGap( 1 );

		///   ( ī )
		if( type == ITEM_WEAPON || type == ITEM_WEAR || type == ITEM_ACCESSORY )
		{
			///  ⺻ ġ 
			if( SetBasic( itemDefine, inven.enhanced ) == true )
				AddGap( 1 );

			///  ߰ ġ 
			if( SetSpecial( itemDefine ) == true )
				AddGap( 1 );
		}
		else if( type == ITEM_CARD && subType == ITEM_CARD_EQUIP_C )
		{
			///  ⺻ ġ 
			if( SetBasic( itemDefine, inven.enhanced ) == true )
				AddGap( 1 );

			///  ߰ ġ 
			if( SetSpecialCard( itemDefine ) == true )
				AddGap( 1 );
		}
		else
		{
			///   
			/// ȿ 
			if( SetEffect( itemDefine ) == true )
				AddGap( 1 );

			/// ð 
			if( SetUseTime( itemDefine ) == true )
				AddGap( 1 );
		}

		/// ī̹ 
		SetCard( inven );

		///   
		if( SetLimit( itemDefine ) == true )
			AddGap( 1 );

		///   
		LPCTSTR desc = itemDefine->GetDescription();
		if( desc )
		{
			CheckText( desc, eCOLOR_BLUE );
			AddGap( 1 );
		}
		
		///    
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000701 ), (unsigned long)itemDefine->GetWeight(), eCOLOR_WHITE );

		/// ǸŰ 
		SetPrice( itemDefine->GetSellType(), itemDefine, 2000702, itemDefine->GetSellPrice() );

		///   ɿ 
		if( itemDefine->GetDisjoint() )
			SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000705 ), eCOLOR_BLUE );

		/// ŷ   
		if( itemDefine->GetExchange() != 0 )
			SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000711 ), eCOLOR_BLUE );
	}

	///  ̹ 
	SetBackImg( pos );
	return true;
}
*/
/*
///
void cItemTipWindow::SetNormalTip( cItemDefine* itemDefine, bool store )
{
	/// ۸  
	AddGap( 1 );
	SetName( itemDefine );

	///  
	SetRare( itemDefine );
	AddGap( 1 );

	///  з  
	unsigned char type = itemDefine->GetType();
	unsigned char subType = itemDefine->GetSubType();
	short defenseType = 0;
	
	cItemAbility* itemAbil = itemDefine->GetAbililty();
	if( itemAbil )
		defenseType = itemAbil->GetDefenseType();

	SetType( type, subType, defenseType );
	AddGap( 1 );

	///  
	if( type == ITEM_WEAPON || type == ITEM_WEAR || type == ITEM_ACCESSORY )
	{
		///  ⺻ ġ 
		if( SetBasic( itemDefine ) == true )
			AddGap( 1 );

		///  ߰ ġ 
		if( SetSpecial( itemDefine ) == true )
			AddGap( 1 );
	}
	else if( type == ITEM_CARD && subType == ITEM_CARD_EQUIP_C )
	{
		///  ⺻ ġ 
        if( SetBasic( itemDefine ) == true )
			AddGap( 1 );

		///  ߰ ġ 
		if( SetSpecialCard( itemDefine ) == true )
			AddGap( 1 );
	}
	else
	{
		///   
		/// ȿ 
		if( SetEffect( itemDefine ) == true )
			AddGap( 1 );

		/// ð 
		if( SetUseTime( itemDefine ) == true )
			AddGap( 1 );
	}

	/// ī
	if( store == false )
		SetCard();
	
	///   
	if( SetLimit( itemDefine ) == true )
		AddGap( 1 );

	///   
	LPCTSTR desc = itemDefine->GetDescription();
	if( desc )
	{
		CheckText( desc, eCOLOR_BLUE );
		AddGap( 1 );
	}

	///    
	SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000701 ), (unsigned long)itemDefine->GetWeight(), eCOLOR_WHITE );

	///  ̸,
	if( store == false )
	{
		/// ǸŰ 
		SetPrice( itemDefine->GetSellType(), itemDefine, 2000702, itemDefine->GetSellPrice() );
	}
	else
	{
		/// Ű 
		SetPrice( itemDefine->GetBuyType(), itemDefine, 2000704, itemDefine->GetBuyPrice() );
	}

	///   ɿ 
	if( itemDefine->GetDisjoint() )
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000705 ), eCOLOR_BLUE );

	/// ŷ   
	if( itemDefine->GetExchange() != 0 )
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000711 ), eCOLOR_BLUE );

}
*/

///  ̹ 
void cItemTipWindow::SetBackImg( const cUIPos& pos )
{
	/// ּ ʺ  
	if( mMaxWidth < mLimitMinWidth )
		mMaxWidth = mLimitMinWidth;

	/// ִ ʺ  
	if( mMaxWidth > mLimitMaxWidth )
		mMaxWidth = mLimitMaxWidth;

	/// 
	mX = pos.mX + 25;
	mY = pos.mY + 25;
	unsigned int w = mMaxWidth + GAP_SIZE * 2; 
	unsigned int h = mIndex * mLineHeight + (mGapCount*GAP_SIZE);

	/// ī尡  ī ̸ŭ  
	if( mSlotCount > 0 )
	{
		unsigned int cardWidth = mSlotCount * ( mSlotSize.mWidth + SLOT_GAP + GAP_SIZE );

		if( cardWidth > w )
			w = cardWidth;
	}

	/// ȭ ȹ 
	if( mX + w > GetScreenWidth() )
	{	
		mX -= ((mX + w) - GetScreenWidth());
	}

	if( mY + h > GetScreenHeight() )
	{
		mY -= ((mY + h) - GetScreenHeight());
	}

	mMiddleBack->SetScreenRect( (short)mX, (short)mY, (unsigned short)w, (unsigned short)h );
	mMiddleBack->SetColorA( 0.6f, 0.6f, 0.6f, 0.6f );
	SetRelativePos( cUIPos( mX, mY ) );

	/// ī ̹ ġ 
	for( unsigned int i = 0; i < mSlotCount; ++i )
	{
		if( mShowImage && mImage[i] && mSlotImage[i] )
		{
			unsigned int ygap = mSlotImage[i]->GetHeight() - mImage[i]->GetHeight();

			/// ī̹ġ  ī彽̹ 
			unsigned int x = mX + ( i * (mSlotImage[i]->GetWidth()+GAP_SIZE) ) + GAP_SIZE;
			unsigned int y = mImagePosY + mY;
			mSlotImage[i]->SetPos( x, y );

			/// ̹ ȼ ؼ ´ (߾ӿϱ)
			mImage[i]->SetPos( x + SLOT_GAP, y + ygap - SLOT_GAP );
		}
	}
}
/*
///
void cItemTipWindow::SetCard()
{
	cItemDefine* define = ITEMMAN->GetItemDefine( mItemIndex );
	if( !define )
	{
		assert(0);
		return;
	}

	/// ,  Ÿ ƴϸ 
	if( !(define->GetType() == ITEM_WEAPON || define->GetType() == ITEM_WEAR) )
		return;

	///  翩 Ǵ
	mSlotCount = define->GetPutSlotCount();
	if( mSlotCount == 0 )
		return;

	//AddGap( 1 );

	/// ̹  ġ 
	mImagePosY = mIndex * mLineHeight + (mGapCount*GAP_SIZE);

	///   
	sItemPutCardSlot* data = define->GetPutCard();
	if( data )
	{
		cUIPos texpos;
		for( unsigned int i = 0; i < mSlotCount; ++i )
		{
			switch( data->mSlotType[i] )
			{
			case ITEM_CARD_SLOT_NONE:	continue;
			case ITEM_CARD_SLOT_A:	texpos = mTexPos[0]; break;
			case ITEM_CARD_SLOT_B:	texpos = mTexPos[1]; break;
			case ITEM_CARD_SLOT_AB:	texpos = mTexPos[2]; break;
			case ITEM_CARD_SLOT_O:	texpos = mTexPos[3]; break;
			}

			if( mSlotImage[i] )
				mSlotImage[i]->SetTextureRect( cUIRect(texpos.mX, texpos.mY, texpos.mX + mSlotSize.mWidth, texpos.mY + mSlotSize.mHeight ) );
		}
	}

	AddGap( 8 );

	///   ī ̹ 
	if( !(mSlotIndex > MAX_INVENTORY) )
	{
		cItem& item = ITEMMAN->GetItem( mSlotIndex );

		SetCardData( 0, item.GetCardIndex1() );
		SetCardData( 1, item.GetCardIndex2() );
		SetCardData( 2, item.GetCardIndex3() );
		SetCardData( 3, item.GetCardIndex4() );
		SetCardData( 4, item.GetCardIndex5() );

		AddGap( 1 );
	}
}
*/
void cItemTipWindow::SetCard( sInventory& inven )
{
	cItemDefine* define = ITEMMAN->GetItemDefine( inven.ItemIndex );
	if( !define )
	{
		assert(0);
		return;
	}

	/// ,  Ÿ ƴϸ 
	if( !(define->GetType() == ITEM_WEAPON || define->GetType() == ITEM_WEAR) )
		return;

	///  翩 Ǵ
	mSlotCount = define->GetPutSlotCount();
	if( mSlotCount == 0 )
		return;

	//AddGap( 1 );

	/// ̹  ġ 
	mImagePosY = mIndex * mLineHeight + (mGapCount*GAP_SIZE);

	///   
	sItemPutCardSlot* data = define->GetPutCard();
	if( data )
	{
		cUIPos texpos;
		for( unsigned int i = 0; i < mSlotCount; ++i )
		{
			switch( data->mSlotType[i] )
			{
			case ITEM_CARD_SLOT_NONE:	continue;
			case ITEM_CARD_SLOT_A:	texpos = mTexPos[0]; break;
			case ITEM_CARD_SLOT_B:	texpos = mTexPos[1]; break;
			case ITEM_CARD_SLOT_AB:	texpos = mTexPos[2]; break;
			case ITEM_CARD_SLOT_O:	texpos = mTexPos[3]; break;
			}

			if( mSlotImage[i] )
				mSlotImage[i]->SetTextureRect( cUIRect(texpos.mX, texpos.mY, texpos.mX + mSlotSize.mWidth, texpos.mY + mSlotSize.mHeight ) );
		}
	}

	AddGap( 8 );

	///  ī ̹ 
	SetCardData( 0, inven.cardSlot1 );
	SetCardData( 1, inven.cardSlot2 );
	SetCardData( 2, inven.cardSlot3 );
	SetCardData( 3, inven.cardSlot4 );
	SetCardData( 4, inven.cardSlot5 );

	/// ϳ õǸ  ֱ
	AddGap( 1 );
}

bool cItemTipWindow::SetCardData( int i, unsigned long cardIndex )
{
	if( cardIndex == 0 )
		return false;

	cItemDefine* cardDefine = ITEMMAN->GetItemDefine( cardIndex );
	if( !cardDefine )
		return false;

	/// ī ̸ 
	/// ۾ ÷ ϱ
	unsigned long color = eCOLOR_WHITE;
	ITEMMAN->GetTooltipColor( cardDefine->GetTipType(), color );

	/// ī̹ 
	cIconParam* param = cardDefine->GetIconParam();
	if( param )
	{
		mImage[i]->SetTexture( param->mpTexture );
		mImage[i]->SetTextureRect( cUIRect( param->mTexPos.mX, param->mTexPos.mY, 
			param->mTexPos.mX + 28, param->mTexPos.mY + 28 ) );

		mShowImage[i] = true;
	}

	/// ī  
	cItemAbility* pAbil = cardDefine->GetAbililty();
	if( pAbil )
	{
		TCHAR temp[256] = {0,};
		LPCTSTR name = cardDefine->GetName();
		long index = pAbil->GetDescription();

		::_stprintf( temp, _T("%s: %s"), cardDefine->GetName(), GAMERESOURCEMAN->GetItemToolTipText( index ) );
		SetText( temp, color );
	}
	
	return true;
}


///////////
cChatTipWindow::cChatTipWindow()
: mpClose(0)
{

}

cChatTipWindow::~cChatTipWindow()
{

}

bool cChatTipWindow::OnCreate( cUINodeProperty* prop )
{
	if( cUIWindow::OnCreate( prop ) == false )
		return false;

	mpClose = GetChild( eUIID_CHATTIP_CLOSE );

	///  Ÿ ̹ б
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cString str;
	NiTexture* texture = 0;
	for( unsigned int i = 0; i < MAX_CARD_SLOT-1; ++i )
	{
		str.Format( "PutCard_SlotType%d", i );
		cUINodeSkin* pSlotSkin = pSkin->GetNodeSkin( str );
		if( pSlotSkin )
		{
			mTexPos[i].mX = pSlotSkin->mSkinInfo->mTexX;
			mTexPos[i].mY = pSlotSkin->mSkinInfo->mTexY;

			texture = pSlotSkin->mpTexture;
		}
	}

	if( !texture )
	{
		assert(0);
		return false;
	}

	/// ̹ 
	cUINodeSkin* imgSkin = pSkin->GetNodeSkin( "PutCard_Slot0" );
	if( !imgSkin )
		return false;

	for( int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		mImage[i] = new cUIImage;
		unsigned int x = imgSkin->mSkinInfo->mX;
		unsigned int y = imgSkin->mSkinInfo->mY;
		unsigned int w = imgSkin->mSkinInfo->mWidth;
		unsigned int h = imgSkin->mSkinInfo->mHeight;
		mImage[i]->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}

	///  ̹ 
	for( int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		str.Format( "PutCard_SlotPos%d", i );
		imgSkin = pSkin->GetNodeSkin( str );
		if( imgSkin && texture )
		{
			mSlotImage[i] = new cUIImage( texture );
			unsigned int x = imgSkin->mSkinInfo->mX;
			unsigned int y = imgSkin->mSkinInfo->mY;
			mSlotSize.mWidth = imgSkin->mSkinInfo->mWidth;
			mSlotSize.mHeight = imgSkin->mSkinInfo->mHeight;
			mSlotImage[i]->SetScreenRect( cUIRect(x, y, x+mSlotSize.mWidth, y+mSlotSize.mHeight) );
		}
	}
	return true;
}

void cChatTipWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mMiddleBack )
	{
		mX = GetAbsoluteRect().mLeft;
		mY = GetAbsoluteRect().mTop;
		mMiddleBack->SetScreenXY( mX, mY );

		/// ī ̹ ġ 
		for( unsigned int i = 0; i < mSlotCount; ++i )
		{
			if( mShowImage && mImage[i] && mSlotImage[i] )
			{
				unsigned int ygap = mSlotImage[i]->GetHeight() - mImage[i]->GetHeight();

				/// ī̹ġ  ī彽̹ 
				unsigned int x = mX + ( i * (mSlotImage[i]->GetWidth()+GAP_SIZE) ) + GAP_SIZE;
				unsigned int y = mImagePosY + mY;
				mSlotImage[i]->SetPos( x, y );

				/// ̹ ȼ ؼ ´ (߾ӿϱ)
				mImage[i]->SetPos( x + SLOT_GAP, y + ygap - SLOT_GAP );
			}
		}
	}
}

void cChatTipWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	unsigned int w = mMaxWidth + GAP_SIZE * 2; 
	unsigned int h = mIndex * mLineHeight + (mGapCount*GAP_SIZE);

	/// ߰ 
	if( mpClose )
	{
		int x = w - mpClose->GetRelativeRect().GetWidth() - 2;
		mpClose->SetRelativePos( cUIPos(x, 2) );
	}

	SetRelativeSize( cUISize( w, h ) );
	mCaptionRect.Set( 0, 0, w, h );
}

void cChatTipWindow::OnRender( cUIFontItemKeeper* fontKeeper )
{	
	if( mVisible == false )
		return;

	/// 
	mMiddleBack->Draw();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		if( ((cUINode*)(*i))->IsVisible() == true )
			((cUINode*)(*i))->OnRender(fontKeeper);
	}

	///
	if( mSlotCount > 0 )
	{
		for( unsigned int i = 0; i < mSlotCount; ++i )
		{
			if( mSlotImage[i] )
				mSlotImage[i]->Draw();

			if( mImage[i] && mShowImage[i] == true )
				mImage[i]->Draw();
		}
	}

	int px = mX + GAP_SIZE;
	int py = mY;

	///   
	for( unsigned int row = 0; row < mIndex; ++row )
	{
		cStringT& str = mToolTip[row].mString;
		if( str.IsEmpty() )
			continue;

		py += mToolTip[row].mGapCount * GAP_SIZE;

		///   
		unsigned int color = mToolTip[row].mColor;
		fontKeeper->AddFontItem( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), px, py, color );

		py += mLineHeight;
	}

	///
	fontKeeper->DrawAll();
}

void cChatTipWindow::OnCommand(cUINode* , unsigned int id )
{
	if( id == eUIID_CHATTIP_CLOSE )
		Hide();
}

///  ̹ 
void cChatTipWindow::SetBackImg( const cUIPos& pos )
{
	if( !mpClose )
		assert(0);

	/// ּ ʺ  
	if( mMaxWidth < mLimitMinWidth )
		mMaxWidth = mLimitMinWidth;

	/// ִ ʺ  
	if( mMaxWidth > mLimitMaxWidth )
		mMaxWidth = mLimitMaxWidth;

	/// 
	mX = GetRelativeRect().mLeft;
	mY = GetRelativeRect().mTop;
	unsigned int w = mMaxWidth + GAP_SIZE * 2;
	unsigned int h = mIndex * mLineHeight + (mGapCount*GAP_SIZE);

	if( mpClose )
		w += mpClose->GetRelativeRect().GetWidth();

	/// ī尡  ī ̸ŭ  
	if( mSlotCount > 0 )
	{
		unsigned int cardWidth = mSlotCount * ( mSlotSize.mWidth + SLOT_GAP + GAP_SIZE );

		if( cardWidth > w )
			w = cardWidth;
	}

	SetRelativeSize( cUISize( w, h ) );
	mCaptionRect.Set( 0, 0, w, h );

	mMiddleBack->SetScreenRect( (short)mX, (short)mY, (unsigned short)w, (unsigned short)h );
	mMiddleBack->SetColorA( 0.6f, 0.6f, 0.6f, 0.6f );

	/// ī ̹ ġ 
	for( unsigned int i = 0; i < mSlotCount; ++i )
	{
		if( mShowImage && mImage[i] && mSlotImage[i] )
		{
			unsigned int ygap = mSlotImage[i]->GetHeight() - mImage[i]->GetHeight();

			/// ī̹ġ  ī彽̹ 
			unsigned int x = mX + ( i * (mSlotImage[i]->GetWidth()+GAP_SIZE) ) + GAP_SIZE;
			unsigned int y = mImagePosY + mY;
			mSlotImage[i]->SetPos( x, y );

			/// ̹ ȼ ؼ ´ (߾ӿϱ)
			mImage[i]->SetPos( x + SLOT_GAP, y + ygap - SLOT_GAP );
		}
	}

	/// ߰ 
	if( mpClose )
	{
		int x = w - mpClose->GetRelativeRect().GetWidth() - 2;
		mpClose->SetRelativePos( cUIPos(x, 2) );
	}
}
