#include "StdAfx.h"
#include "ItemTipWindow.h"
#include "GameResourceManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "ItemManager.h"
#include "Item_Common.h"
#include "InputSystem.h"
#include "NumberEditBox.h"
#include "PVPManager.h"

#include "Application.h"
#include "CoolTimeManager.h"

/*
///
bool cItemTipWindow::SetName( cItemDefine* itemDefine )
{
	/// ۾ ÷ ϱ
	unsigned long itemColor = eCOLOR_WHITE;
	ITEMMAN->GetTooltipColor( itemDefine->GetTipType(), itemColor );

	/// ̸ 
	if( mSlotIndex > MAX_INVENTORY )
	{
		LPCTSTR name = itemDefine->GetName();
		SetText( name, itemColor );
	}
	else
	{	
		///   ȭ  
		cItem& item = ITEMMAN->GetItem( mSlotIndex );
		if( item.GetCount() > 0 && item.GetEnhanceStep() > 0 )
		{
			/// ȭ ܰ 
			TCHAR temp[128] = {0,};
			::_stprintf( temp, _T("+%d %s"), item.GetEnhanceStep(), itemDefine->GetName() );
			SetText( temp, itemColor );
		}
		else
		{
			/// ̸ 
			LPCTSTR name = itemDefine->GetName();
			SetText( name, itemColor );
		}
	}
	return true;
}
*/

///
bool cItemTipWindow::SetName( cItemDefine* itemDefine, unsigned int enhance )
{
	/// ۾ ÷ ϱ
	unsigned long itemColor = eCOLOR_WHITE;
	ITEMMAN->GetTooltipColor( itemDefine->GetTipType(), itemColor );
	
	///   ޾Ƽ 
	if( enhance > 0 )
	{
		/// ȭ ܰ 
		TCHAR temp[128] = {0,};
		::_stprintf( temp, _T("+%d %s"), enhance, itemDefine->GetName() );
		SetText( temp, itemColor );
	}
	else
	{
		/// ̸ 
		LPCTSTR name = itemDefine->GetName();
		SetText( name, itemColor );
	}
	return true;
}

///   
bool cItemTipWindow::SetRare( cItemDefine* itemDefine )
{
	if( !itemDefine )
		return false;

	int index = 0;
	switch( itemDefine->GetTipType() )
	{
	case eTOOLTIP_MALL:		index = 2000901;		break;
	case eTOOLTIP_ETC:		index = 2000902;		break;
	case eTOOLTIP_NORMAL:	index = 2000903;		break;
	case eTOOLTIP_MAGIC:	index = 2000904;		break;
	case eTOOLTIP_RARE:		index = 2000905;		break;
	case eTOOLTIP_UNIQUE:	index = 2000906;		break;
	case eTOOLTIP_EPIC:		index = 2000907;		break;
	case eTOOLTIP_REGEND:	index = 2000908;		break;
	}

	/// ÷ 
	unsigned long itemColor = eCOLOR_WHITE;
	ITEMMAN->GetTooltipColor( itemDefine->GetTipType(), itemColor );

	SetText( GAMERESOURCEMAN->GetItemToolTipText( index ), itemColor );
	return true;
}

///
bool cItemTipWindow::SetType( unsigned char type, unsigned char subtype, short defenseType )
{
	unsigned long index = 0;

	switch( type )
	{
	case ITEM_WEAPON:
		{
			switch( subtype )
			{
			case ITEM_WEAPON_SWORD:		index = 2000000;	break;
			case ITEM_WEAPON_BLADE:		index = 2000001;	break;
			case ITEM_WEAPON_DUAL:		index = 2000002;	break;
			case ITEM_WEAPON_CUTTER:	index = 2000003;	break;
			case ITEM_WEAPON_GUN:		index = 2000004;	break; 
			case ITEM_WEAPON_STAFF:		index = 2000005;	break; 
			case ITEM_WEAPON_SHIELD:	index = 2000006;	break;  
			}
		}
		break;
	case ITEM_WEAR:
		{
			switch( subtype )
			{
			case ITEM_WEAR_HEAD:		index = 2000007;	break;
			case ITEM_WEAR_UPPER:		index = 2000008;	break;
			case ITEM_WEAR_LOWER:		index = 2000009;	break;
			case ITEM_WEAR_HANDS:		index = 2000010;	break;
			case ITEM_WEAR_FEET:		index = 2000011;	break;
			case ITEM_WEAR_ONEPIECE:	index = 2000012;	break;
			}
		}
		break;
	case ITEM_ACCESSORY:
		{
			switch( subtype )
			{
			case ITEM_ACCESSORY_EARRING:	index = 2000013;	break;
			case ITEM_ACCESSORY_NECKLACE:	index = 2000014;	break;
			case ITEM_ACCESSORY_BROOCH:		index = 2000015;	break;
			case ITEM_ACCESSORY_BRACELET:	index = 2000016;	break;
			case ITEM_ACCESSORY_RING:		index = 2000017;	break;
			}
		}
		break;
	case ITEM_ETC1:
		{
			switch( subtype )
			{
			case ITEM_ETC1_POTION:	index = 2000018;	break;
			case ITEM_ETC1_MISC:	index = 2000019;	break;
			case ITEM_ETC1_QUEST:	index = 2000047;	break;
			case ITEM_ETC1_CHANGE:	index = 2000048;	break;
			case ITEM_ETC1_MIXSKILL:	index = 2000053;	break;
			case ITEM_ETC1_TITLE:		index = 2000055;	break;
			case ITEM_ETC1_RECIPE:		index = 2000054;	break;
			case ITEM_ETC1_RECIPEGROUP: index = 2000054;	break;
			}
		}
		break;
	case ITEM_MATERIAL:
		{
			switch( subtype )
			{
			case ITEM_MATERIAL_SKILL:		index = 2000020;	break;
			case ITEM_MATERIAL_CLOTH:		index = 2000021;	break;
			case ITEM_MATERIAL_LEATHER:		index = 2000022;	break;
			case ITEM_MATERIAL_METAL:		index = 2000023;	break;
			case ITEM_MATERIAL_JEWEL:		index = 2000024;	break;
			case ITEM_MATERIAL_MISC:		index = 2000025;	break;
			case ITEM_MATERIAL_MAP:			index = 2000049;	break;
			case ITEM_MATERIAL_VEHICLE:		index = 2000056;	break;
			}
		}
		break;
	case ITEM_QUEST:	
		index = 2000026;
		break;
	case ITEM_ETC2:
		index = 2000027;
		break;
	case ITEM_SPREAD:
		index = 2000028;
		break;
	case ITEM_CARD:
		{
			switch( subtype )
			{
			case ITEM_CARD_TAROT:			index = 2000029; break;
			case ITEM_CARD_COMMON:			index = 2000030; break;
			case ITEM_CARD_EQUIP_C:			index = 2000033; break;
			case ITEM_CARD_EQUIP_A:			index = 2000034; break;
			case ITEM_CARD_EQUIP_B:			index = 2000035; break;
			case ITEM_CARD_EQUIP_AB:		index = 2000036; break;
			case ITEM_CARD_EQUIP_O:			index = 2000037; break;
			//case ITEM_CARD_ENHANCE_WEAPON:	index = 2000031; break;
			//case ITEM_CARD_ENHANCE_WEAR:	index = 2000032; break;
			case ITEM_CARD_ENHANCE_WEAPON_LV1:	index = 2000031; break;
			case ITEM_CARD_ENHANCE_WEAPON_LV2:	index = 2000031; break;
			case ITEM_CARD_ENHANCE_WEAPON_LV3:	index = 2000031; break;
			case ITEM_CARD_ENHANCE_WEAPON_LV4:	index = 2000031; break;
			case ITEM_CARD_ENHANCE_WEAPON_LV5:	index = 2000031; break;
			case ITEM_CARD_ENHANCE_WEAR_LV1:	index = 2000032; break;
			case ITEM_CARD_ENHANCE_WEAR_LV2:	index = 2000032; break;
			case ITEM_CARD_ENHANCE_WEAR_LV3:	index = 2000032; break;
			case ITEM_CARD_ENHANCE_WEAR_LV4:	index = 2000032; break;
			case ITEM_CARD_ENHANCE_WEAR_LV5:	index = 2000032; break;
			}
		}
		break;
	case ITEM_MONSTER:
		{
			switch( subtype )
			{
			case ITEM_MONSTER_UNKNOWN:	index = 2000038; break;
			case ITEM_MONSTER_HUMAN:	index = 2000039; break;
			case ITEM_MONSTER_ANIMAL:	index = 2000040; break;
			case ITEM_MONSTER_PLANT:	index = 2000041; break;
			case ITEM_MONSTER_INSECT:	index = 2000042; break;
			case ITEM_MONSTER_ELF:		index = 2000043; break;
			case ITEM_MONSTER_UNDEAD:	index = 2000044; break;
			case ITEM_MONSTER_GIANT:	index = 2000045; break;
			case ITEM_MONSTER_DRAGON:	index = 2000046; break;
			}
		}
		break;
	case ITEM_COIN:
		{
			switch( subtype )
			{
			case ITEM_COIN_GOLD:	index = 2000050; break;
			case ITEM_COIN_SILVER:  index = 2000051; break;
			case ITEM_COIN_COPPER:  index = 2000052; break;
			}
		}
		break;
	case ITEM_UNKNOWN:	
		index = 2000060;
		break;
	}

	///   ؼ 
	if( type == ITEM_WEAR )
	{
		unsigned long defenseIdx = 0;
		switch( defenseType )
		{
		case 1:		defenseIdx = 2000101;		break;
		case 2:		defenseIdx = 2000102;		break;
		case 3:		defenseIdx = 2000103;		break;
		default:	assert(0); break;
		}

		SetText( GAMERESOURCEMAN->GetItemToolTipText( index ), GAMERESOURCEMAN->GetItemToolTipText( defenseIdx ), eCOLOR_WHITE );
	}
	else
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( index ), eCOLOR_WHITE );
	}
	return true;
}
/*
/// ⺻ġ 
bool cItemTipWindow::SetBasic( cItemDefine* itemDefine )
{
	bool usePrint = false;
	unsigned char type = itemDefine->GetType();
	unsigned char subtype = itemDefine->GetSubType();

	cItemAbility* pAbil = itemDefine->GetAbililty();
	if( pAbil == 0 )
		return false;

	short physicMinAttack = 0;
	short physicMaxAttack = 0;
	short magicMinAttack = 0;
	short magicMaxAttack = 0;
	short physicDefense = 0;
	short magicDefense = 0;
	float useRange = 0;

	/// Ϲݰݷ() - Ϲݰݷ()
	physicMinAttack = pAbil->GetPhysicMinAttack();
	physicMaxAttack = pAbil->GetPhysicMaxAttack();

	/// Ϲݸݷ() - Ϲݸݷ()
	magicMinAttack = pAbil->GetMagicMinAttack();
	magicMaxAttack = pAbil->GetMagicMaxAttack();

	/// Ϲ 
	physicDefense = pAbil->GetPhysicDefense();
	
	/// Ϲ 
	magicDefense = pAbil->GetMagicDefense();

	/// Ÿ
	useRange = (float)(pAbil->GetAttackRange() * 0.01);

	/// κ丮  ,
	//if( mSlotIndex >= 0 && mSlotIndex <= MAX_INVENTORY )
	if( !(mSlotIndex > MAX_INVENTORY) )
	{
		cItem& item = ITEMMAN->GetItem( mSlotIndex );
		unsigned char enhanceStep = item.GetEnhanceStep();
		if( enhanceStep > 0 )
		{
			/// ȭܰ迡  + ġ 
			short addPhysicAttack = 0;
			short addMagicAttack = 0;
			short addPhysicDefense = 0;
			short addMagicDefense = 0;
			
			sItemEnhanced* enhance = itemDefine->GetEnhanced();
			if( !enhance )
				return false;

			/// ݷ 
			if( physicMaxAttack > 0 )
			{
				if( enhance->mEnhanced1 == eENHANCE_PHYSICATTACK || 
					enhance->mEnhanced2 == eENHANCE_PHYSICATTACK )
				{
					addPhysicAttack = enhance->mValue[enhanceStep-1];
				}

				/// ȭ ܰ 
				TCHAR temp[128] = {0,};
				if( addPhysicAttack > 0 )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000204 ), physicMinAttack, physicMaxAttack, addPhysicAttack );
					SetText( temp, eCOLOR_GREEN );
				}
				else
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000200 ), physicMinAttack, physicMaxAttack );
					SetText( temp, eCOLOR_WHITE );
				}
			}

			/// ݷ ġ & 
			if( magicMaxAttack > 0 )
			{
				if( enhance->mEnhanced1 == eENHANCE_MAGICATTACK || 
					enhance->mEnhanced2 == eENHANCE_MAGICATTACK )
				{
					addMagicAttack = enhance->mValue[enhanceStep-1];
				}

				TCHAR temp[128] = {0,};
				if( addMagicAttack > 0 )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000205 ), magicMinAttack, magicMaxAttack, addMagicAttack );
					SetText( temp, eCOLOR_GREEN );
				}
				else
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000201 ), magicMinAttack, magicMaxAttack );
					SetText( temp, eCOLOR_WHITE );
				}
			}

			/// ,    
			if( physicDefense > 0 )
			{
				if( enhance->mEnhanced1 == eENHANCE_PHYSICDEFENSE || 
					enhance->mEnhanced2 == eENHANCE_PHYSICDEFENSE )
				{
					addPhysicDefense = enhance->mValue[enhanceStep-1];
				}

				TCHAR temp[128] = {0,};
				if( addPhysicDefense > 0 )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000206 ), physicDefense, addPhysicDefense );
					SetText( temp, eCOLOR_GREEN );
				}
				else
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000202 ), physicDefense );
					SetText( temp, eCOLOR_WHITE );
				}
			}

			if( magicDefense > 0 )
			{
				if( enhance->mEnhanced1 == eENHANCE_MAGICDEFENSE || 
					enhance->mEnhanced2 == eENHANCE_MAGICDEFENSE )
				{
					addMagicDefense = enhance->mValue[enhanceStep-1];
				}

				TCHAR temp[128] = {0,};
				if( addMagicDefense > 0 )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000207 ), magicDefense, addMagicDefense );
					SetText( temp, eCOLOR_GREEN );
				}
				else
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000203 ), magicDefense );
					SetText( temp, eCOLOR_WHITE );
				}
			}

			/// Ÿ 
			if( useRange > 0 )
				SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000208 ), (float)useRange, eCOLOR_WHITE );

			return true;
		}
	}

	/// κ丮 ܺ, Ȥ ȭ ȵ ̸ ̴  
	/// ݷ 
	if( physicMaxAttack > 0 )
	{
		TCHAR temp[128] = {0,};
		::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000200 ), physicMinAttack, physicMaxAttack );
		SetText( temp, eCOLOR_WHITE );

		usePrint = true;
	}

	/// ݷ ġ & 
	if( magicMaxAttack > 0 )
	{
		TCHAR temp[128] = {0,};
		::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000201	), magicMinAttack, magicMaxAttack );
		SetText( temp, eCOLOR_WHITE );

		usePrint = true;
	}

	/// ,    
	if( physicDefense > 0 )
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000202 ), (unsigned long)physicDefense, eCOLOR_WHITE );
		usePrint = true;
	}

	if( magicDefense > 0 )
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000203 ), (unsigned long)magicDefense, eCOLOR_WHITE );
		usePrint = true;
	}
	
	/// Ÿ 
	if( useRange > 0 )
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000208 ), (float)useRange, eCOLOR_WHITE );
		usePrint = true;
	}

	return usePrint;
}
*/
///   
bool cItemTipWindow::SetBasic( cItemDefine* itemDefine, unsigned int enhance )
{
	bool usePrint = false;
	unsigned char type = itemDefine->GetType();
	unsigned char subtype = itemDefine->GetSubType();

	cItemAbility* pAbil = itemDefine->GetAbililty();
	if( pAbil == 0 )
		return false;

	short physicMinAttack = 0;
	short physicMaxAttack = 0;
	short magicMinAttack = 0;
	short magicMaxAttack = 0;
	short physicDefense = 0;
	short magicDefense = 0;
	float useRange = 0;

	/// Ϲݰݷ() - Ϲݰݷ()
	physicMinAttack = pAbil->GetPhysicMinAttack();
	physicMaxAttack = pAbil->GetPhysicMaxAttack();

	/// Ϲݸݷ() - Ϲݸݷ()
	magicMinAttack = pAbil->GetMagicMinAttack();
	magicMaxAttack = pAbil->GetMagicMaxAttack();

	/// Ϲ 
	physicDefense = pAbil->GetPhysicDefense();

	/// Ϲ 
	magicDefense = pAbil->GetMagicDefense();

	/// Ÿ
	useRange = (float)(pAbil->GetAttackRange() * 0.01);

	/// ȭǾ  
	unsigned char enhanceStep = enhance;
	if( enhance > 0 )
	{
		/// ȭܰ迡  + ġ 
		short addPhysicAttack = 0;
		short addMagicAttack = 0;
		short addPhysicDefense = 0;
		short addMagicDefense = 0;

		sItemEnhanced* enhance = itemDefine->GetEnhanced();
		if( !enhance )
			return false;

		/// ݷ 
		if( physicMaxAttack > 0 )
		{
			if( enhance->mEnhanced1 == eENHANCE_PHYSICATTACK || 
				enhance->mEnhanced2 == eENHANCE_PHYSICATTACK )
			{
				addPhysicAttack = enhance->mValue[enhanceStep-1];
			}

			/// ȭ ܰ 
			TCHAR temp[128] = {0,};
			if( addPhysicAttack > 0 )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000204 ), physicMinAttack, physicMaxAttack, addPhysicAttack );
				SetText( temp, eCOLOR_GREEN );
			}
			else
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000200 ), physicMinAttack, physicMaxAttack );
				SetText( temp, eCOLOR_WHITE );
			}
		}

		/// ݷ ġ & 
		if( magicMaxAttack > 0 )
		{
			if( enhance->mEnhanced1 == eENHANCE_MAGICATTACK || 
				enhance->mEnhanced2 == eENHANCE_MAGICATTACK )
			{
				addMagicAttack = enhance->mValue[enhanceStep-1];
			}

			TCHAR temp[128] = {0,};
			if( addMagicAttack > 0 )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000205 ), magicMinAttack, magicMaxAttack, addMagicAttack );
				SetText( temp, eCOLOR_GREEN );
			}
			else
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000201	 ), magicMinAttack, magicMaxAttack );
				SetText( temp, eCOLOR_WHITE );
			}
		}

		/// ,    
		if( physicDefense > 0 )
		{
			if( enhance->mEnhanced1 == eENHANCE_PHYSICDEFENSE || 
				enhance->mEnhanced2 == eENHANCE_PHYSICDEFENSE )
			{
				addPhysicDefense = enhance->mValue[enhanceStep-1];
			}

			TCHAR temp[128] = {0,};
			if( addPhysicDefense > 0 )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000206 ), physicDefense, addPhysicDefense );
				SetText( temp, eCOLOR_GREEN );
			}
			else
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000202 ), physicDefense );
				SetText( temp, eCOLOR_WHITE );
			}
		}

		if( magicDefense > 0 )
		{
			if( enhance->mEnhanced1 == eENHANCE_MAGICDEFENSE || 
				enhance->mEnhanced2 == eENHANCE_MAGICDEFENSE )
			{
				addMagicDefense = enhance->mValue[enhanceStep-1];
			}

			TCHAR temp[128] = {0,};
			if( addMagicDefense > 0 )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000207 ), magicDefense, addMagicDefense );
				SetText( temp, eCOLOR_GREEN );
			}
			else
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000203 ), magicDefense );
				SetText( temp, eCOLOR_WHITE );
			}
		}

		/// Ÿ 
		if( useRange > 0 )
			SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000208 ), (float)useRange, eCOLOR_WHITE );

		return true;
	}

	/// κ丮 ܺ, Ȥ ȭ ȵ ̸ ̴  
	/// ݷ 
	if( physicMaxAttack > 0 )
	{
		TCHAR temp[128] = {0,};
		::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000200 ), physicMinAttack, physicMaxAttack );
		SetText( temp, eCOLOR_WHITE );

		usePrint = true;
	}

	/// ݷ ġ & 
	if( magicMaxAttack > 0 )
	{
		TCHAR temp[128] = {0,};
		::_stprintf( temp, GAMERESOURCEMAN->GetItemToolTipText( 2000201 ), magicMinAttack, magicMaxAttack );
		SetText( temp, eCOLOR_WHITE );

		usePrint = true;
	}

	/// ,    
	if( physicDefense > 0 )
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000202 ), (unsigned long)physicDefense, eCOLOR_WHITE );
		usePrint = true;
	}

	if( magicDefense > 0 )
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000203 ), (unsigned long)magicDefense, eCOLOR_WHITE );
		usePrint = true;
	}

	/// Ÿ 
	if( useRange > 0 )
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000208 ), (float)useRange, eCOLOR_WHITE );
		usePrint = true;
	}

	return usePrint;
}

unsigned long cItemTipWindow::GetTooltipIdxByOpt( short type )
{
	unsigned long index = 0;
	switch ( type )
	{
	case ITEM_OPT_STR:	index = 2000210;	break; // 
	case ITEM_OPT_DEX:	index = 2000211;	break; // ø
	case ITEM_OPT_CON:	index = 2000212;	break; // ü
	case ITEM_OPT_INT:	index = 2000213;	break; // 
	case ITEM_OPT_WIS:	index = 2000214;	break; // 
	case ITEM_OPT_ALL:	index = 2000215;	break; // (:ø:ü::)
		// Option - Plus
	case ITEM_OPT_PLUS_PHYSIC_ATTACK:	index = 2000301; break; // ݷ
	case ITEM_OPT_PLUS_MAGIC_ATTACK:	index = 2000302; break; // ݷ
	case ITEM_OPT_PLUS_PHYSIC_DEFENSE:	index = 2000303; break; // 
	case ITEM_OPT_PLUS_MAGIC_DEFENSE:	index = 2000304; break;	// 
	case ITEM_OPT_PLUS_PHYSIC_ATTACK_RATE:	index = 2000305; break; // ߷
	case ITEM_OPT_PLUS_MAGIC_ATTACK_RATE:	index = 2000306; break; // ߷
	case ITEM_OPT_PLUS_PHYSIC_CRITICAL:	index = 2000307; break; // ũƼ
	case ITEM_OPT_PLUS_MAGIC_CRITICAL:	index = 2000308; break; // ũƼ
	case ITEM_OPT_PLUS_DOD:				index = 2000309; break; // ȸ
	case ITEM_OPT_PLUS_WEI:				index = 2000310; break; // 
	case ITEM_OPT_PLUS_MAX_HP:			index = 2000312; break; // ִ뷮 HP
	case ITEM_OPT_PLUS_MAX_MP:			index = 2000313; break; // ִ뷮 MP
	case ITEM_OPT_PLUS_MOV:				index = 2000311; break; // ̵
	case ITEM_OPT_PLUS_HP:				index = 2000314; break; // HP ȸ
	case ITEM_OPT_PLUS_MP:				index = 2000315; break; // MP ȸ

		// Option - Percent
	case ITEM_OPT_PERCENT_PHYSIC_ATTACK:	index = 2000301; break; // ݷ
	case ITEM_OPT_PERCENT_MAGIC_ATTACK:		index = 2000302; break; // ݷ
	case ITEM_OPT_PERCENT_PHYSIC_DEFENSE:	index = 2000303; break;// 
	case ITEM_OPT_PERCENT_MAGIC_DEFENSE:	index = 2000304; break;// 
	case ITEM_OPT_PERCENT_PHYSIC_ATTACK_RATE: index = 2000305; break;// ߷
	case ITEM_OPT_PERCENT_MAGIC_ATTACK_RATE: index = 2000306; break;// ߷
	case ITEM_OPT_PERCENT_PHYSIC_CRITICAL:	 index = 2000307; break;// ũƼ
	case ITEM_OPT_PERCENT_MAGIC_CRITICAL:	 index = 2000308; break;// ũƼ
	case ITEM_OPT_PERCENT_DOD:				 index = 2000309; break;// ȸ
	case ITEM_OPT_PERCENT_WEI:				 index = 2000310; break;// 
	case ITEM_OPT_PERCENT_MAX_HP:			index = 2000312; break;// ִ뷮 HP
	case ITEM_OPT_PERCENT_MAX_MP:			index = 2000313; break;// ִ뷮 MP
	case ITEM_OPT_PERCENT_MOV:				index = 2000311; break;// ̵
	case ITEM_OPT_PERCENT_HP:				index = 2000314; break;// HP ȸ
	case ITEM_OPT_PERCENT_MP:				index = 2000315; break;// MP ȸ

		// Option - Etc
	case ITEM_OPT_PERCENT_DRAIN_HP:			index = 2000501; break;	// HP 
	case ITEM_OPT_PERCENT_DRAIN_MP:			index = 2000502; break;	// MP 
	case ITEM_OPT_PERCENT_SKILL_HEAL_INC:	index = 2000503; break;	// ų  ȸ 
	case ITEM_OPT_PERCENT_DAMAGE_DEC:		index = 2000504; break;	//  /
	case ITEM_OPT_PERCENT_DAMAGE_REF:		index = 2000505; break;	//  ݻ
	}

	return index;
}

/// ߰ġ
bool cItemTipWindow::SetSpecial( cItemDefine* itemDefine )
{
	cItemAbility* pAbil = itemDefine->GetAbililty();
	if( pAbil == 0 )
		return false;

	bool usePrint = false;
	sAblityOption* opt = pAbil->GetOption();
	for( int i = 0; i < 10; ++i, ++opt )
	{
		usePrint = AddSpecial( usePrint, GetTooltipIdxByOpt( opt->mOptType ), opt->mOptValue, (opt->mOptType >= ITEM_OPT_PERCENT_PHYSIC_ATTACK) );
	}
	return usePrint;
}

bool cItemTipWindow::AddSpecial( bool usePrint, unsigned long tooltipIdx, short value, bool usePercent )
{
	if( value == 0 )
		return usePrint;

	LPCTSTR tip = GAMERESOURCEMAN->GetItemToolTipText( tooltipIdx );
	TCHAR temp[128]={0,};
	if( value > 0 )
	{
		if( usePercent == true )
			::_stprintf( temp, _T("%s +%d%%"), tip, value );
		else
			::_stprintf( temp, _T("%s +%d"), tip, value );
	}
	else if( value < 0 )
	{
		if( usePercent == true )
			::_stprintf( temp, _T("%s %d%%"), tip, value );
		else
			::_stprintf( temp, _T("%s %d"), tip, value );
	}

	SetText( temp, eCOLOR_GREEN );
	return true;
}

bool cItemTipWindow::SetSpecialCard( cItemDefine* itemDefine )
{
	cItemAbility* pAbil = itemDefine->GetAbililty();
	if( pAbil == 0 )
		return false;

	bool usePrint = true;
	sAblityOption* opt = pAbil->GetOption();
	for( int i = 0; i < 10; ++i, ++opt )
	{
		usePrint = AddSpecialEquipCard( usePrint, GetTooltipIdxByOpt( opt->mOptType ), opt->mOptValue, (opt->mOptType >= ITEM_OPT_PERCENT_PHYSIC_ATTACK) );
	}

	/// ġ ϳ ԷµǾ
	return (!usePrint);
}

bool cItemTipWindow::AddSpecialEquipCard( bool IsFront, unsigned long tooltipIdx, short value, bool usePercent )
{
	if( value == 0 )
		return IsFront;

	cStringT str = GAMERESOURCEMAN->GetItemToolTipText( 2000706 );		/// ȿ
	cStringT empty = GAMERESOURCEMAN->GetItemToolTipText( 2000707 );	/// 

	/// ڿ 
	cStringT tip = GAMERESOURCEMAN->GetItemToolTipText( tooltipIdx );
	if( IsFront == true )
		str = ( str + tip );
	else
		str = ( empty + tip );

	TCHAR temp[128]={0,};
	if( value > 0 )
	{
		if( usePercent == true )
			::_stprintf( temp, _T("%s +%d%%"), (LPCTSTR)str.Cstr(), value );
		else
			::_stprintf( temp, _T("%s +%d"), (LPCTSTR)str.Cstr(), value );
	}
	/// 
	else
	{
		if( usePercent == true )
			::_stprintf( temp, _T("%s %d%%"), (LPCTSTR)str.Cstr(), value );
		else
			::_stprintf( temp, _T("%s %d"), (LPCTSTR)str.Cstr(), value );
	}

	SetText( temp, eCOLOR_GREEN );
	return false;
}

///
bool cItemTipWindow::SetLimit( cItemDefine* itemDefine )
{
	cItemLimit* itemLimit = itemDefine->GetLimit();
	if( itemLimit == 0 )
		return false;

	bool usePrint = false;

	/// ּҿ䱸  ( ּҿ䱸 1  ̻  )
	if( itemLimit->GetLevel() > 1 )
	{
		unsigned long color = ( itemLimit->GetLevel() <= HERO->GetLevel() ) ? eCOLOR_WHITE : eCOLOR_RED;
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000801 ), (short)itemLimit->GetLevel(), color );

		usePrint = true;
	}
	
    ///  
	/// ITEM_RACE_ALL ̸  ϹǷ ŵ
	if( itemLimit->GetRace() == ITEM_RACE_HUMAN )
	{
		/// ΰ
		unsigned long color = ( HERO->GetRace() == eRACE_HUMAN ) ? eCOLOR_WHITE : eCOLOR_RED;
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000802 ), GAMERESOURCEMAN->GetItemToolTipText( 2000810 ), color );

		usePrint = true;
	}
	else if( itemLimit->GetRace() == ITEM_RACE_BEAST )
	{
		/// 
		unsigned long color = ( HERO->GetRace() == eRACE_BEAST ) ? eCOLOR_WHITE : eCOLOR_RED;
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000802 ), GAMERESOURCEMAN->GetItemToolTipText( 2000811 ), color );

		usePrint = true;
	}
	else if( itemLimit->GetRace() == ITEM_RACE_ELF )
	{
		/// 
		unsigned long color = ( HERO->GetRace() == eRACE_ELF ) ? eCOLOR_WHITE : eCOLOR_RED;
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000802 ), GAMERESOURCEMAN->GetItemToolTipText( 2000812 ), color );

		usePrint = true;
	}
		
	///  
	if( itemLimit->GetJob() != 0 )
	{
		///   ˻
		long job = HERO->GetJob() - ( HERO->GetJob() % ITEM_JOB_FIGHTER );
		
		unsigned long color = ( itemLimit->GetJob() == job ) ? eCOLOR_WHITE : eCOLOR_RED;
		LPCTSTR jobname = GAMERESOURCEMAN->GetJobName( itemLimit->GetJob() );
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000803 ), jobname, color );

		usePrint = true;
	}

	/// 뼺  
	if( itemLimit->GetGender() == ITEM_GENDER_MALE )
	{
		unsigned long color = ( itemLimit->GetGender() == HERO->GetGender() ) ? eCOLOR_WHITE : eCOLOR_RED;
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000804 ), GAMERESOURCEMAN->GetItemToolTipText( 2000813 ), color );

		usePrint = true;
	}
	else if( itemLimit->GetGender() == ITEM_GENDER_FEMALE )
	{
		unsigned long color = ( itemLimit->GetGender() == HERO->GetGender() ) ? eCOLOR_WHITE : eCOLOR_RED;
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000804 ), GAMERESOURCEMAN->GetItemToolTipText( 2000814 ), color );

		usePrint = true;
	}

	///   
	if( itemLimit->GetPVPOnly() == 1 )
	{
		unsigned long color = ( PVPMAN->IsEnableBattle() ) ? eCOLOR_WHITE : eCOLOR_RED;
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000712 ), color );

		usePrint = true;
	}

	return usePrint;
}

///
bool cItemTipWindow::SetEffect( cItemDefine* itemDefine )
{
	if( itemDefine == 0 )
		return false;

	cItemAbility* pAbil = itemDefine->GetAbililty();
	if( pAbil == 0 )
		return false;

	long index = pAbil->GetDescription();

	if( itemDefine->GetType() == ITEM_CARD )
	{
		if( itemDefine->GetSubType() >= ITEM_CARD_EQUIP_C && itemDefine->GetSubType() <= ITEM_CARD_EQUIP_O )
		{
			AppendText( GAMERESOURCEMAN->GetItemToolTipText( 2000706 ), GAMERESOURCEMAN->GetItemToolTipText( index ), eCOLOR_GREEN );
			return true;
		}
	}

	AppendText( GAMERESOURCEMAN->GetItemToolTipText( 2000805 ), GAMERESOURCEMAN->GetItemToolTipText( index ), eCOLOR_GREEN );
	return true;
}

/// ð 
bool cItemTipWindow::SetUseTime( cItemDefine* itemDefine )
{
	cItemAbility* pAbil = itemDefine->GetAbililty();
	if( pAbil == 0 )
		return false;

	short coolTime = (short)(pAbil->GetCoolTime() / 1000);

	/// ð ؼ 
	unsigned int m = ((unsigned int)coolTime ) / 60;
	unsigned int s = ((unsigned int)coolTime % 60) % 60;

	/// ð 0 ʸ 
	if( m == 0 && s == 0 )
		return false;

	cStringT tm,ts;
	if( m != 0 )
		tm.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000809 ), m );
	if( s != 0 )
		ts.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000808 ), s );
	tm += ts;

	mSaveCoolTime.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000806 ), tm.Cstr() );

	if( mCheckTime )
	{
		mTimerEnabled = true;
		mUpdateSizebyTime = true;
		mTimeTipIdx = mIndex;
		mIndex++;
	}
	else
	{
		SetText( mSaveCoolTime.Cstr(), eCOLOR_WHITE );
	}

/*
	if( mGauge && mGauge->IsActive() == true )
	{
		mTimerEnabled = true;
		mUpdateSizebyTime = true;
		mTimeTipIdx = mIndex;
		mIndex++;
	}
	else
	{
		SetText( mSaveCoolTime.Cstr(), eCOLOR_WHITE );
	}
*/
	return true;
}

/// Ÿ ð 
void cItemTipWindow::OnTimer()
{
	cUIWindow::OnTimer();

	if( mTimeTipIdx == 0 || mCheckTime == 0 )
		return;

	cStringT str1 = mSaveCoolTime;

	sCoolTime* timeInfo = COOLMAN->GetProcessData( mItemIndex );
	if( timeInfo )
	{
		/// ð ؼ 
		long elapsedTime = THEAPP->GetWorldAccumTime() - timeInfo->startTime;

		unsigned long restTime = 0;
		if( timeInfo->restTime > elapsedTime )
		{
			restTime = timeInfo->restTime - elapsedTime;
		}
		restTime /= 1000;

		cStringT str2;
		/// ʸ ½ ݿøؼ 
		unsigned int m = restTime / 60;
		//unsigned int s = (restTime % 60) % 60 + 1;
		unsigned int s = restTime % 60 + 1;

		cStringT tm,ts;
		if( m != 0 )
			tm.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000809 ), m );
		ts.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000808 ), s );

		tm += ts;
		str2.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000807 ), tm.Cstr() );
		str1.Append( str2 );
	}
/*
	/// Ÿ 
	if( mGauge && mGauge->IsActive() == true )
	{
		/// ð ؼ 
		cStringT str2;
		unsigned int restTime = mGauge->GetRestTime()/1000;

		/// ʸ ½ ݿøؼ 
		unsigned int m = restTime / 60;
		//unsigned int s = (restTime % 60) % 60 + 1;
		unsigned int s = restTime % 60 + 1;

		cStringT tm,ts;
		if( m != 0 )
			tm.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000809 ), m );
		ts.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000808 ), s );

		tm += ts;
		str2.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000807 ), tm.Cstr() );
		str1.Append( str2 );
	}
*/
	mToolTip[mTimeTipIdx].mString = str1;
	mToolTip[mTimeTipIdx].mColor = eCOLOR_WHITE;
	CalcMaxWidth( mToolTip[mTimeTipIdx].mString );

	if( mUpdateSizebyTime == true )
	{
		SetBackImg( cUIPos(MOUSE->GetMouseX(), MOUSE->GetMouseY()) );
		mUpdateSizebyTime = false;
	}
}

///  
void cItemTipWindow::SetPrice( unsigned long type, cItemDefine* itemDefine, unsigned long priceTooltipIdx, unsigned long price )
{
	TCHAR temp[128]={0,};

	LPCTSTR tooltip = GAMERESOURCEMAN->GetItemToolTipText( priceTooltipIdx );
	LPCTSTR priceStr = cNumberEditBox::FormatNumber( price );

	if( type == ItemSellNone )
	{
		SetText( GAMERESOURCEMAN->GetItemToolTipText( 2000703 ), eCOLOR_BLUE );
	}	
	else
	{
		unsigned long unitIndex = ITEMMAN->GetPriceUinit( type );
		::_stprintf( temp, _T("%s %s %s"), tooltip, priceStr, GAMERESOURCEMAN->GetItemToolTipText( unitIndex ) );
		SetText( temp, eCOLOR_WHITE );
	}
}