#include "Stdafx.h"
#include "Label.h"
#include "UIManager.h"
#include "UISkinLexer.h"
#include "Token.h"
#include "Parser.h"

#include "UIContainer.h"
#include "FontAgent.h"
#include "UITransformImage.h"

cLabel::cLabel( eUINodeType type )
: cUINode( type )
, mTextPosX( 0 )
, mTextPosY( 0 )
, mEditPos( 0, 0 )
, mpSkin(0)
{	
	mTextAlign = eALIGN_NONE;
	mTextColor = mDefaultColor;
	mDescNode = 0;
	mBackColor = 0xFF111111;
}

cLabel::~cLabel()
{
	mTextArr.Clear();
}

void cLabel::Clear()
{
	mTextArr.Clear();
	mText.Clear();
}

/// ǻ : 
bool cLabel::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_LABEL ) == false )
	{
		assert( 0 && "not label skin type" );
		return false;
	}

	///  Ų ռ ˻
	if( pskin->IsValid() == false )
	{
		assert( 0 && "invalid skin" );
		return false;
	}

	/// ̹ 
	if( pskin->mpTexture )
	{
		if( mpImage == 0 )
		{
			mpImage = new cUITransformImage;
			mpImage->SetTexture( pskin->mpTexture );
		}

		/// ÷ 
		mpImage->SetColor( pskin->mColor );

		/// ؽó  
		unsigned int tx = pskin->mSkinInfo->mTexX;
		unsigned int ty = pskin->mSkinInfo->mTexY;
		unsigned int tw = pskin->mSkinInfo->mTexWidth;
		unsigned int th = pskin->mSkinInfo->mTexHeight;

		mpImage->SetTextureRect( tx, ty, tx + tw, ty + th );
	}
	else
	{
		delete mpImage;
		mpImage = 0;
	}

	unsigned int x = pskin->mSkinInfo->mX;
	unsigned int y = pskin->mSkinInfo->mY;
	unsigned int w = pskin->mSkinInfo->mWidth;
	unsigned int h = pskin->mSkinInfo->mHeight;
	SetRelativeRect( cUIRect(x, y, x + w, y + h) );

	/// 
	cLabelSkin* p = (cLabelSkin*)pskin;
	mpSkin = (cUINodeSkin*)pskin;
	mTextAlign = p->mTextAlign;

	/// ڰ  ǥ  
	/// ؽƮ  켱 
	mEditPos.mX = p->mEditPos.mX;
	mEditPos.mY = p->mEditPos.mY;

	/// 
	mHoverTipIndex = pskin->mSkinInfo->mHoverTipIndex;

	/// ؽƮ ǥ Ʈ
	if( p->mText )
	{
		SetText( (LPCTSTR)p->mText.Cstr() );
		UpdateText();
	}	
	return true;
}

/// ǻ : 
bool cLabel::HandleEvent( const cUIEvent& event )
{
	if( !mpImage )
	{
		/// ̹   , ش ̺Ʈ óѴ
		if( !(event.mType == eUIEVENT_MOUSE_HOVERED || event.mType == eUIEVENT_MOUSE_LEFT) )
		{
			return mpParent->HandleEvent( event );
		}
	}

	return cUINode::HandleEvent( event );
}

void cLabel::SetTranslate( short x, short y )
{
	if( mpImage )
	{
		float hw = (float)GetAbsoluteRect().GetWidth()/(float)GetScreenWidth() * 0.5f;
		float hh = (float)GetAbsoluteRect().GetHeight()/(float)GetScreenHeight() * 0.5f;

		unsigned int px = x + GetAbsoluteRect().mLeft;
		unsigned int py = y + GetAbsoluteRect().mTop;

		mpImage->SetTranslate( (float)px/(float)GetScreenWidth() + hw, (float)py/GetScreenHeight() + hh );

		SetRelativePos( cUIPos( x, y ) );
	}
}

void cLabel::SetRotate( float angle )
{
	if( mpImage )
		mpImage->SetRotate( angle );
}

void cLabel::ChangeImage( cUINodeSkin* pSkin )
{
	if( mpSkin == pSkin )
		return;

	if( pSkin )
	{
		mpSkin = pSkin;

		unsigned int texX = mpSkin->mSkinInfo->mTexX;
		unsigned int texY = mpSkin->mSkinInfo->mTexY;
		unsigned int w = mpSkin->mSkinInfo->mTexWidth;
		unsigned int h = mpSkin->mSkinInfo->mTexHeight;

		if( mpImage )
			mpImage->SetTextureRect( texX, texY, texX + w, texY + h );
	}
	else
	{
		assert(0);
	}
}

void cLabel::ChangeImage( unsigned int texX, unsigned int texY )
{
	if( mpSkin == 0 )
		return;

	unsigned int w = mpSkin->mSkinInfo->mTexWidth;
	unsigned int h = mpSkin->mSkinInfo->mTexHeight;

	if( mpImage )
		mpImage->SetTextureRect( texX, texY, texX + w, texY + h );
}

void cLabel::ChangeImage( unsigned int texX, unsigned int texY, unsigned int texW, unsigned int texH )
{
	if( mpSkin == 0 )
	{
		assert(0);
		return;
	}

	if( mpImage )
		mpImage->SetTextureRect( texX, texY, texX + texW, texY + texH );
}

void cLabel::OnMouseHovered( const cUIPos& pos )
{
	cUINode::OnMouseHovered( pos );

	if( mpParent && mpImage )
	{
		cUIEvent event;
		event.mpCaller = this;
		event.mID = mID;
		event.mPos = pos;
		event.mType = eUIEVENT_MOUSE_HOVERED;
		mpParent->HandleEvent( event );
	}
}

void cLabel::OnMouseLeft( const cUIPos& pos )
{
	cUINode::OnMouseLeft( pos );

	if( mpParent && mpImage )
	{
		cUIEvent event;
		event.mpCaller = this;
		event.mID = mID;
		event.mType = eUIEVENT_MOUSE_LEFT;
		mpParent->HandleEvent( event );
	}
}

/// ǻ : 
void cLabel::SetText( LPCTSTR str )
{
	/// ڿ  ϱ
	unsigned int len = ::_tcslen( str );
	if( len <= 0 )
		return;

	mText = str;
	mTextArr.Clear();

	unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, str, len );

	///  
	unsigned int descWidth = 0;
	if( mDescNode )
	{
		descWidth = mDescNode->GetAbsoluteRect().GetWidth();
	}
	else if( GetAbsoluteRect().GetWidth() > 0 )
	{
		///   ڽ  
		descWidth = GetAbsoluteRect().GetWidth();
	}
	else
	{
		///   ׳  
		descWidth = width;
	}

	/// ˻  
	unsigned int cutWidth = 0;
	unsigned int cutlen = 0;
	unsigned int startIndex = 0;

	/// Կ ڿ
	TCHAR	text[256] = {0,};
	LPTSTR newtext = text;

	///  ũ ߶󳽴.
	while( len != cutlen )
	{
		///  ˻   ϱ
		cutlen++;
		cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, str + startIndex, cutlen );

		///  ڰ˻縦 Ѵ
		TCHAR temp[3] = {0,};
		::_tcsncpy( temp, &str[startIndex + cutlen], 2 );

		/// ͺȣ  ٳѱ
		if( ::_tcsncmp( temp, _T("\\n"), 2 ) == 0 )
		{
			/// 
			Sstrncpy( newtext, 256, str + startIndex, cutlen );
			mTextArr.PushBack( newtext );

			///
			width -= cutWidth; 
			startIndex += cutlen + 2;
			len -= (cutlen + 2);
			cutWidth = 0;
			cutlen = 0;
		}
		else
		{
			if( cutWidth > descWidth )	
			{
				if( cutlen > 1 )
				{
					/// UNICODE ϱ  ̸ 1 
					int minusWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, str + startIndex + cutlen - 1, 1 );
					cutWidth -= minusWidth;
					cutlen -= 1;
				}

				Sstrncpy( newtext, 256, str + startIndex, cutlen );
				mTextArr.PushBack( newtext );

				///
				width -= cutWidth;
				startIndex += cutlen;
				len -= cutlen;
				cutWidth = 0;
				cutlen = 0;
			}
		}
	}

	if( len > 0 )
	{
		Sstrncpy( newtext, 256, str + startIndex, len );
		mTextArr.PushBack( newtext );
	}

	///
	UpdateText();
}

/// ǻ : 
void cLabel::OnProcess( unsigned long, unsigned long /*accumTime*/ )
{
}

void cLabel::UpdateRect()
{
	cUINode::UpdateRect();

	///
	UpdateText();
}

void cLabel::UpdateText()
{
	if( mTextArr.GetSize() <= 0 )
		return;

	cUIRect rc;
	///   
	if( mDescNode )
	{
		rc = mDescNode->GetAbsoluteRect();
	}
	else
	{
		///   ڽ  
		rc = GetAbsoluteRect();
	}

	switch( mTextAlign )
	{
	case eALIGN_NONE:
		{
			mTextPosX = rc.mLeft + mEditPos.mX;
			mTextPosY = rc.mTop + mEditPos.mY;
		}
		break;
	case eALIGN_LEFT:
		{
			mTextPosX = rc.mLeft;
			mTextPosY = rc.mTop;
		}
		break;
	case eALIGN_RIGHT:
		{
			mTextPosX = rc.mRight - FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, (LPTSTR)mTextArr[0].Cstr(), mTextArr[0].GetLength());
			mTextPosY = rc.mTop + ( rc.GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_UI) ) / 2;
		}
		break;
	case eALIGN_CENTER:		/// ,  ̸
		{
			mTextPosX = rc.mLeft + ( rc.GetWidth() - FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, (LPTSTR)mTextArr[0].Cstr(), mTextArr[0].GetLength()) ) / 2;
			mTextPosY = rc.mTop + ( rc.GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_UI) ) / 2;
		}
		break;
	}
}

/// ǻ : 
void cLabel::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mpImage )
		mpImage->Draw();

	if( mTextArr.GetSize() <= 0 )
		return;

	unsigned short fontIdx = mUseBoldText? cFontAgent::eFont_UI_BOLD:cFontAgent::eFont_UI;

	/// Ϲ ϳ ϴ ̸ ׳ 
	if( mTextArr.GetSize() == 1 )
	{
		pKeeper->AddFontItem( fontIdx, (LPTSTR)mTextArr[0].Cstr(), mTextPosX, mTextPosY, mTextColor );//, true, mBackColor );
	}	
	else
	{
		cUIRect rc;

		///  ϴ  
		for( unsigned int i = 0; i < mTextArr.GetSize(); ++i )
		{
			LPTSTR text = (LPTSTR)mTextArr[i].Cstr();
			int len = ::_tcslen( text );

			///   
			if( mDescNode )
			{
				rc = mDescNode->GetAbsoluteRect();
			}
			else
			{
				///   ڽ  
				rc = GetAbsoluteRect();
			}

			int editX = rc.mLeft;
			int editY = rc.mTop + ( i * FONTAGENT->GetTextHeight( fontIdx ) );

			/// ߾̸
			if( mTextAlign == eALIGN_CENTER )
			{
				editX += ( rc.GetWidth() - FONTAGENT->GetTextExtent( fontIdx, text, len ) ) / 2;
				editY += ( rc.GetHeight() - (int)(FONTAGENT->GetTextHeight( fontIdx ) * mTextArr.GetSize()) ) / 2;
			}
			///
			else if( mTextAlign == eALIGN_RIGHT )
			{
				editX = rc.mRight - FONTAGENT->GetTextExtent( fontIdx, text, len );
				editY = rc.mTop + ( rc.GetHeight() - (int)(FONTAGENT->GetTextHeight( fontIdx ) * mTextArr.GetSize()) ) / 2;
			}

			pKeeper->AddFontItem( fontIdx, text, editX, editY, mTextColor ); //, true, mBackColor );
		}
	}
}

///
void cLabel::SetValue( int value, eText_Color textColor, eText_Color backColor )
{
	cStringT buf;
	buf.Format( _T("%d"), value );
	
	SetTextColor( textColor, backColor );
	SetText( (LPCTSTR)buf.Cstr() );
}

///////////////////////////////////////////////////////////////////////////
/// ǻ : 
cLabelSkin::cLabelSkin( eUINodeType type )
: cUINodeSkin( type )
, mTextAlign( eALIGN_NONE )
, mEditPos(0, 0)
{
}

cLabelSkin::~cLabelSkin()
{

}

/// ǻ : 
bool cLabelSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
			break;

		switch( token.mType )
		{
		case eTOKEN_EDITPOS:
			{
				/// ڿ ġ  
				mEditPos.mX = parser.ParseInt();
				mEditPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_TEXT_ALIGN:
			{
				///
				lexer->GetNextToken( &token );

				///  
				mTextAlign = eALIGN_LEFT;

				if( token.mType == eTOKEN_CENTER )
				{
					mTextAlign = eALIGN_CENTER;
				}
				else if( token.mType == eTOKEN_RIGHT )
				{
					mTextAlign = eALIGN_RIGHT;
				}
			}
			break;
		case eTOKEN_TEXT:
			{
				int i = parser.ParseInt();
				if( UIMAN->GetUIText( &mText, i ) == false )
				{
					return false;
				}
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}

	return true;
}
