/* ==========================================================================
*      : Label.h
*      : 
*    : 谡
*    : 2006-10-12
* ǻ : 
*===========================================================================*/
#pragma once
#include "UINode.h"
#include "UINodeData.h"

class cLabel : public cUINode
{
public:
	cLabel( eUINodeType type = eUINODE_LABEL );
	virtual ~cLabel();

	/// ڿ Ŭ 
	void Clear();

	/// ܺο   ( , Ǽ  )
	void SetValue( int value, eText_Color textColor = eCOLOR_WHITE, eText_Color backColor = eCOLOR_BLACK );

	/// ܺο ؽƮ 
	void SetText( LPCTSTR text );

	/// ؽƮ ÷  
	void SetTextColor( long textColor, unsigned long backColor = eCOLOR_BLACK );

	/// ǥ쿡 Ĺ  
	void SetAlign( cUINode* pnode, int align = 0 );

	///
	LPCTSTR GetText() const	{ return mText.Cstr(); }
	
	cUINodeSkin* GetNodeSkin() { return mpSkin; }

	/// ȸ
	virtual void SetTranslate( short x, short y );
	virtual void SetRotate( float angle );

	/// ش罺Ų ̹ ٲٱ
	void ChangeImage( cUINodeSkin* pSkin );
	void ChangeImage( unsigned int texX, unsigned int texY, unsigned int texW, unsigned int texH );
	void ChangeImage( unsigned int texX, unsigned int texY );

protected:
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual bool HandleEvent( const cUIEvent& event );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void OnMouseHovered(const cUIPos& pos );
	virtual void OnMouseLeft(const cUIPos& pos );
	virtual void UpdateRect();

	void UpdateText();
	
protected:
	/// ؽƮ 
	typedef tArray<cStringT> cTextLen;
	cTextLen mTextArr;

	/// ؽƮ
	cStringT mText;

	/// Ҷ  Ǵ 
	cUINode* mDescNode;

	/// ؽƮ 
	int mTextAlign;

	/// ؽƮ ġ 
	int mTextPosX, mTextPosY;

	/// ؽƮ  ġ
	cUIPos mEditPos;

	/// ÷
	unsigned long mTextColor;
	unsigned long mBackColor;

	/// ڽ Ų 
	cUINodeSkin* mpSkin;
};

inline void cLabel::SetTextColor( long textColor, unsigned long backColor )
{
	mTextColor = textColor;
	mBackColor = backColor;
}

inline void cLabel::SetAlign( cUINode* pnode, int align )
{
	mDescNode = pnode;
	mTextAlign = align;
	UpdateText();
}

//////////////////////////////////////////////////////////////////////////
/// Label Ų ( static Ų )
class cLabelSkin : public cUINodeSkin
{
public:
	cLabelSkin( eUINodeType type = eUINODE_LABEL );
	virtual ~cLabelSkin();
	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ؽƮ
	cStringT mText;
	/// ؽƮ 
	int mTextAlign;
	/// ؽƮ ġ
	cUIPos mEditPos;
};
