/* ====================================================================
 *      :	LightAgent.h
 *      :	ü  ȯ Light   ó
 *    :	̹
 *    :	2006.05
 *
 * ߰ :
 *		߰¥ 	۾		߰
 *		2006.05     ̹	    ׽Ʈ 
 * 
 * ǻ :	Dynamic Light  ߰ м  ؾ Ѵ.
 * =================================================================== */
#pragma once

class cLightAgent
{
public:
	static cLightAgent*	mpLightAgent;

	cLightAgent();
	~cLightAgent();

	/// ʱȭ
	bool Init();

	void Close();

	///
	void AttachSkyLight( NiNode* pNode );

	/// ϴ ֺ
	void SetSkyAmbientLight( const NiColor& ambient, float dimmer );
	void SetSkyAmbient( const NiColor& ambient );
	void SetSkyDimmer( float dimmer );

	///  ֺ
	void SetTerrainAmbientLight( const NiColor& ambient, float dimmer );
	void SetTerrainAmbient( const NiColor& ambient );
	void SetTerrainDimmer( float dimmer );

	///  ֺ
	void SetSceneAmbient( unsigned int i, const NiColor& ambient );
	void SetSceneDimmer( unsigned int i, float dimmer );

	///  Ɽ
	NiDirectionalLight* GetSceneDirLight( unsigned int i ) const;

	/// Dimmer 
	//void	SetDimmer( unsigned int lightType, float dimmer );
	//float	GetDimmer( unsigned int lightType );

	/// Color 
	//void			SetNiColor( unsigned int lightType, NiColor color );
	//const NiColor&	GetNiColor( unsigned int lightType );

	/// ֺ 
	NiAmbientLight* GetTerrainAmbientLight() const;
	NiAmbientLight* GetSceneAmbientLight( unsigned int i ) const;

	NiAmbientLight* GetSelectAmbientLight() const;

	///  ü ⺻ Light
	//NiDirectionalLight* GetWorldLight() { return mpCharacterDirLight[eLIGHT_MAIN]; }

//protected:
	/// ⺻ LightŬ  ʰ  ϰ  غ.
	/// ׽Ʈ
	//template <class T>
	//T* GetLight( NiNode* pNode, T* dummy = 0 );

protected:
	NiAmbientLightPtr mSkyAmbientLight;
	NiAmbientLightPtr mTerrainAmbientLight;

	NiAmbientLightPtr mSceneAmbientLight[2];
	NiDirectionalLightPtr mSceneDirLight[2];

	NiAmbientLightPtr mSelectAmbientLight;
};

inline
NiAmbientLight* cLightAgent::GetTerrainAmbientLight() const
{
	return mTerrainAmbientLight;
}

inline
NiAmbientLight* cLightAgent::GetSceneAmbientLight( unsigned int i ) const
{
	assert( i == 0 || i == 1 );

	return mSceneAmbientLight[i];
}

inline
NiDirectionalLight* cLightAgent::GetSceneDirLight( unsigned int i ) const
{
	assert( i == 0 || i == 1 );

	return mSceneDirLight[i];
}

inline
NiAmbientLight* cLightAgent::GetSelectAmbientLight() const
{
	return mSelectAmbientLight;
}

#define LIGHTAGENT cLightAgent::mpLightAgent
