#include "StdAfx.h"
#include "ListBox.h"
#include "UIManager.h"
#include "UISkinLexer.h"
#include "RenderSystem.h"
#include "Token.h"
#include "Parser.h"

#include "UIEvent.h"
#include "UIImage.h"
#include "PlaneObject.h"
#include "UIContainer.h"
#include "FontAgent.h"

#include "ScrollBar.h"

cListBox::cListBox( eUINodeType type )
: cListCtrl( type )
, mpSelectImage(0)
, mpScrollBar(0)
, mpSkin(0)
, mChange( false )
, mSelectBarWidth(0)
, mContinueEvent( false )
, mShowImage( true )
, mPrintPos(0, 0)
, mPrintSize(0, 0)
{
	mMaxRowInPage = 0;
	mTotalMaxNum = 0;

	mSelectedRowIdx = 0;
	mHoveredRowIdx = -1;
	mImageHoveredIdx = -1;

	mTopRowIdx = 0;
	mRowHeight = 0;

	mImageHovered = false;

	mHoverTextColor = eCOLOR_WHITE;
}

cListBox::~cListBox()
{
	mpScrollBar = 0;

	SAFE_DELETE( mpSelectImage );
}

void cListBox::Clear()
{
	mSelectedRowIdx = 0;
	mHoveredRowIdx = -1;

	mImageHoveredIdx = -1;
	mImageHovered = false;

	mTopRowIdx = 0;

	UpdateScrollBar();

	/// ù
	if( mpSelectImage )
		UpdateSelectImage();

	cListCtrl::Clear();
}

/// ǻ : ڸ ؾ  ó
bool cListBox::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
	{
		return false;
	}

	/// Ų 
	if( mScrollSkin )
	{
		mpScrollBar = new cScrollBar;
		if( mpScrollBar->CreateBySkinName( mScrollSkin, this, eLIST_SCROLL ) == false )
		{
			assert( 0 && "failed to create scroll bar" );
			return false;
		}
	}

	if( mpScrollBar )
	{
		/// ũѹ  
		mpScrollBar->SetHeight( GetAbsoluteRect().GetHeight() );

		/// ũѹ x ġ  
		mpScrollBar->SetPosX( GetRelativeRect().mRight -  GetRelativeRect().mLeft - mpScrollBar->GetAbsoluteRect().GetWidth() );

		/// ũѹ 
		UpdateScrollBar();
	}
	return true;
}


/// ǻ :
bool cListBox::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_LISTBOX ) == false )
	{
		assert( 0 && "not list skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	/// ũƮκ ؽ ̹ Ӽ ޴´
	cListBoxSkin* p = (cListBoxSkin*)pskin;
	
	/// Ų  
	mpSkin = pskin;
	mScrollSkin = p->mScrollSkin;

	/// ƮƮѿ    
	mRowHeight = p->mRowHeight;
	assert( mRowHeight );

	/// Ʈ ִ  ִ  
	mTotalMaxNum = p->mTotalMaxNum;
	mSelectBarWidth = p->mSelectBarWidth;

	mPrintPos = p->mPrintPos;
	mPrintSize = p->mPrintSize;

	/// Ʈ  ִ  ִ  
	mMaxRowInPage = ( mPrintSize.mHeight > 0 ) ? (mPrintSize.mHeight / mRowHeight) : (pskin->mSkinInfo->mHeight / mRowHeight);
	if( mMaxRowInPage == 0 )
		mMaxRowInPage = p->mTotalMaxNum;

	assert( mMaxRowInPage );
		
	///   ̹ ؽ 
	if( p->mpSelectBarTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)p->mSelectBarSkin->mTexX;
		unsigned short ty = (unsigned short)p->mSelectBarSkin->mTexY;
		unsigned short tw = (unsigned short)p->mSelectBarSkin->mTexWidth;
		unsigned short th = (unsigned short)p->mSelectBarSkin->mTexHeight;

		if( mpSelectImage == 0 )
		{
			mpSelectImage = new cPlaneObject;

			if( mpSelectImage->Create( p->mpSelectBarTexture, (short)GetAbsoluteRect().mLeft, (short)GetAbsoluteRect().mTop, tw, th,
				tx, ty, tx + tw, ty + th ) == false )
			{
				assert( 0 && "failed to create select image");
				return false;
			}
		}
		else
		{
			mpSelectImage->SetTextureRect( tx, ty, tx + tw, ty + th );
		}
	}
	return true;
}

///
int cListBox::AddRow( LPCTSTR str, unsigned long color, void* pExtraData, cUIImage* pImage )
{
	/// 밹 Ѿ  
	if( GetRowCount() >= mTotalMaxNum )
		return -1;

	sData* data = new sData;
	data->mText = str;
	data->mTextColor = color;

	unsigned int ret = AddRowData( data, pExtraData, pImage );

	/// ũѹ 
	UpdateScrollBar();
	
	if( mpSelectImage )
		UpdateSelectImage();
	return ret;
}

///
bool cListBox::AddColume( unsigned int rowIdx, LPCTSTR str, unsigned long color )
{
	/// 밹 Ѿ ÷ ˻ 
	if( GetRowCount() >= mTotalMaxNum )
	{
		unsigned int count = GetColumnCount( rowIdx - 1 );
		unsigned int countNow = GetColumnCount( rowIdx );

		if( countNow > count )
			return 0;
	}
	
	sData* data = new sData;
	data->mText = str;
	data->mTextColor = color;

	return AddColumeData( rowIdx, data );
}

///
void cListBox::SetExtraData( unsigned int rowIdx, void* pExtraData )
{
	if( rowIdx < GetRowCount() )
	{
		sRowData* p = (sRowData*)mRows[rowIdx];
		p->mExtraData = pExtraData;
	}
}

///
void cListBox::ToggleCheck( unsigned int rowIdx )
{
	if( rowIdx < GetRowCount() )
	{
		sRowData* p = (sRowData*)mRows[rowIdx];
		p->mCheck = (!p->mCheck);
	}
}

///
LPCTSTR cListBox::GetText( unsigned int rowIdx, unsigned int colIdx )
{
	sData* data = GetColumeData( rowIdx, colIdx );
	if( data )
		return data->mText.Cstr();
	else
		return _T("");
}

/// ǻ : ػ 濡  
void cListBox::UpdateSkin()
{
	/// Ų ǥ Ʈ 
	cUIWindow::UpdateSkin();

	///  ̹ ʱȭ 
	if( mpSelectImage )
		UpdateSelectImage();

	/// ũѹٰ  ũѹٵ 缼
	if( mpScrollBar )
	{
		/// ũѹ   
		mpScrollBar->SetHeight( GetAbsoluteRect().GetHeight() );

		/// ũѹ x ġ  
		mpScrollBar->SetPosX( GetRelativeRect().mRight - GetRelativeRect().mLeft - mpScrollBar->GetAbsoluteRect().GetWidth() );

		/// ũѹ 
		UpdateScrollBar();
	}

	mHoveredRowIdx = -1;
}

/// ǻ :
void cListBox::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpSelectImage )
	{
		/// ù ̹  Ʈ
		UpdateSelectImage();
		CheckShowImage();
	}	
}

/// ǻ :
void cListBox::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		if( ((cUINode*)(*i))->IsVisible() == true )
		{
			((cUINode*)(*i))->OnRender(pKeeper);
		}
	}

	if( mpSelectImage && GetRowCount() )
	{
		/// ̹ ٰ, Ʈڽ Ѿ ʵ Ѵ.
		if( mShowImage == true )
			mpSelectImage->Draw();
	}

	/// Ʈ ڽ  ׷.
	RenderData( pKeeper );

	pKeeper->DrawAll();
}

/// ǻ : 콺 ϶ õȰ ٲ۴
void cListBox::OnMouseMove( const cUIPos& pos )
{
	cUINode::OnMouseMove( pos );

	unsigned int row = (pos.mY - GetAbsoluteRect().mTop) / mRowHeight;
	if( row > mMaxRowInPage - 1 )
	{
		mHoveredRowIdx = -1;
		return;
	}

	if( row >= GetRowCount() )
	{
		mHoveredRowIdx = -1;

		if( mImageHovered )
		{
			cUIEvent event;
			event.mpCaller = this;
			event.mID = mID;
			event.mType = eUIEVENT_LISTBOX_IMAGE_LEFT;
			mpParent->HandleEvent( event );

			mImageHoveredIdx = -1;
			mImageHovered = false;
		}

		cUIEvent event;
		event.mpCaller = this;
		event.mID = mID;
		event.mType = eUIEVENT_LISTBOX_ROW_LEFT;
		mpParent->HandleEvent( event );
		return;
	}

	/// ̹  üũ  ̺Ʈ
	unsigned int curRow = mTopRowIdx + row;
	if( curRow >= GetRowCount() )
		curRow = GetRowCount() - 1;

	sRowData* data = GetRowData( curRow );
	
	/// üũ ̹ ƴ϶ ̺Ʈ ߻
	if( data->mImage && mChange == false )
	{
		/// Ų ޾ƿ 
		cListBoxSkin* pListSkin = (cListBoxSkin*)mpSkin;
		assert( pListSkin );
		sListCtrlParam* pParam = pListSkin->mpImgParam;

		int x1 = pParam->mColumnX + GetAbsoluteRect().mLeft;
		int x2 = x1 + pParam->mColumnW;

		if( pos.mX > x1 && pos.mX < x2 )
		{
			if( (unsigned int)mImageHoveredIdx != row )
			{
				cUIEvent event;
				event.mpCaller = this;
				event.mID = mID;
				event.mPos = pos;
				event.mExtraData = GetExtraData( curRow );
				event.mType = eUIEVENT_LISTBOX_IMAGE_HOVERED;
				mpParent->HandleEvent( event );

				mImageHoveredIdx = row;
				mImageHovered = true;
			}
		}
		else
		{
			if( mImageHovered )
			{
				cUIEvent event;
				event.mpCaller = this;
				event.mID = mID;
				event.mType = eUIEVENT_LISTBOX_IMAGE_LEFT;
				mpParent->HandleEvent( event );

				mImageHoveredIdx = -1;
				mImageHovered = false;
			}
		}
	}

	if( mHoveredRowIdx != row )
	{
		cUIEvent event;
		event.mpCaller = this;
		event.mID = mID;
		event.mPos = pos;
		event.mType = eUIEVENT_LISTBOX_ROW_HOVERED;
		event.mExtraData = GetExtraData( curRow );
		mpParent->HandleEvent( event );
	}

	mHoveredRowIdx = row;
}

void cListBox::OnMouseLeft( const cUIPos& pos )
{
	cListCtrl::OnMouseLeft( pos );

	mHoveredRowIdx = -1;

	if( mImageHovered )
	{
		cUIEvent event;
		event.mpCaller = this;
		event.mID = mID;
		event.mType = eUIEVENT_LISTBOX_IMAGE_LEFT;
		mpParent->HandleEvent( event );

		mImageHoveredIdx = -1;
		mImageHovered = false;
	}

	cUIEvent event;
	event.mpCaller = this;
	event.mID = mID;
	event.mType = eUIEVENT_LISTBOX_ROW_LEFT;
	mpParent->HandleEvent( event );
}

/// ǻ : 
void cListBox::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUINode::OnLButtonDown( pos, ctrl, alt, shift );

	unsigned int row = (pos.mY - GetAbsoluteRect().mTop) / mRowHeight + mTopRowIdx;
	if( row >= GetRowCount() )
		return;

	mHoveredRowIdx = row - mTopRowIdx;

	sRowData* data = GetRowData( mSelectedRowIdx );
    
	/// Ʈ ̹  ̹  ̺Ʈ üũ 
	if( data->mImage && mChange )
	{
		/// Ų ޾ƿ 
		cListBoxSkin* pListSkin = (cListBoxSkin*)mpSkin;
		assert( pListSkin );
		sListCtrlParam* pParam = pListSkin->mpImgParam;
	
		int x1 = pParam->mColumnX + GetAbsoluteRect().mLeft;
		int x2 = x1 + pParam->mColumnW;
		
		if( pos.mX > x1 && pos.mX < x2 )
		{
			/// ̹ Ŭȴٸ,
			ToggleCheck( row );
		}		
	}	

	/// ο  õǸ ̺Ʈ 
	if( mContinueEvent == true || mSelectedRowIdx != row )
	{
		mSelectedRowIdx = row;

		/// ̺Ʈ  
		cUIEvent event;
		event.mType = eUIEVENT_LISTBOX_CHANGED;
		event.mpCaller = this;
		event.mID = mID;
		event.mPos = pos;
		mpParent->HandleEvent( event );

		/// 콺   κ ٸ ĥѴ 
		if( mpSelectImage )
		{
			UpdateSelectImage();
			CheckShowImage();
		}
	}
}

void cListBox::OnRButtonDown(const cUIPos& pos, bool, bool, bool )
{
	OnLButtonDoubleClick( pos );
}

/// ǻ : 
void cListBox::OnLButtonDoubleClick( const cUIPos& pos )
{
	cUINode::OnLButtonDoubleClick( pos );

	unsigned int row = (pos.mY - GetAbsoluteRect().mTop) / mRowHeight + mTopRowIdx;
	if( row >= GetRowCount() )
		return;

	mSelectedRowIdx = row;
	mHoveredRowIdx = row - mTopRowIdx;

	/// ̺Ʈ  
	cUIEvent event;
	event.mType = eUIEVENT_LISTBOX_SELECTED;
	event.mpCaller = this;
	event.mID = mID;
	mpParent->HandleEvent( event );

	/// 콺   κ ٸ ĥѴ 
	if( mpSelectImage )
	{
		UpdateSelectImage();
		CheckShowImage();
	}
}

/// ǻ : ũѹٰ ̸, Ʈ ڽ    
void cListBox::OnScrollbarMoved( const cUIPos& )
{	
	if( mpScrollBar == 0)
		return;

	assert( GetRowCount() > mMaxRowInPage );

	///  ư ġ .
	unsigned int barbuttonPos = mpScrollBar->GetBarButtonPosY();
	double h = mpScrollBar->GetScrollMarginHeight() / (double)(GetRowCount()-mMaxRowInPage);

	///   ư ġ شϴ  ε ϱ
	double x = ((double)barbuttonPos / h);

	mTopRowIdx = (int)x;
	mHoveredRowIdx = -1;

	if( mpSelectImage )
	{
		UpdateSelectImage();
		CheckShowImage();
	}
}

///
void cListBox::OnMouseWheel( const cUIPos& /*pos*/, int wheel )
{
	if( !mpScrollBar || mpScrollBar->IsVisible() == false )
	{
		return;
	}
	assert(GetRowCount() > mMaxRowInPage);

	/// ũѹ    
	if( wheel > 0 )
	{
		if( mTopRowIdx > 0 )
		{
			mTopRowIdx--;

			if( mpSelectImage )
				UpdateSelectImage();
		}
	}
	/// Ʒ   
	else if ( wheel < 0 )
	{
		///   Բ ũ
		if( GetRowCount() - mTopRowIdx > mMaxRowInPage )
		{
			mTopRowIdx++;

			if( mpSelectImage )
				UpdateSelectImage();
		}		
	}
	else
	{
		assert( 0 && "error mouse wheel message" );
		return;
	}

	/// ũѹ Ʈ 
	UpdateScrollBar();

	if( mImageHovered )
	{
		cUIEvent event;
		event.mpCaller = this;
		event.mID = mID;
		event.mType = eUIEVENT_LISTBOX_IMAGE_LEFT;
		mpParent->HandleEvent( event );

		mImageHovered = false;
		mImageHoveredIdx = -1;
	}

	CheckShowImage();
}

/// ǻ : ư  üũ 
void cListBox::CheckButtonEvent( unsigned int id )
{
	if( !mpScrollBar )
	{
		///  ´ٸ ߸ κδ.
		assert(0);
		return;
	}
	/// ũѹٰ ׷ ʴ ¸ 
	if( mpScrollBar->IsVisible() == false )
	{
		///  ´ٸ ߸ κδ.
		assert(0);
		return;
	}
	assert(GetRowCount() > mMaxRowInPage);

	switch( id )
	{
	case eSCROOLBAR_UP:
		if( mTopRowIdx > 0 )
		{
			mTopRowIdx--;

			if( mpSelectImage )
				UpdateSelectImage();
		}
		break;
	case eSCROOLBAR_DOWN:
		///   Բ ũ
		if( GetRowCount() - mTopRowIdx > mMaxRowInPage )
		{
			mTopRowIdx++;
			
			if( mpSelectImage )
				UpdateSelectImage();
		}		
		break;
	default:
		return;
	}

	/// ũѹ ư ġ Ʈ 
	UpdateScrollBar();
	CheckShowImage();
} 

///
bool cListBox::ChangeSelectRow( unsigned int rowIdx, bool changeTop )
{
	if( rowIdx >= GetRowCount() )
		return false;
	if( mContinueEvent == false && mSelectedRowIdx == rowIdx )
		return true;

	mSelectedRowIdx = rowIdx;

	if( changeTop )
	{
		///  Ѿ ٸ  ü ֻ ø.
		if( rowIdx >= mMaxRowInPage )
		{
			///  ȳԲ  
			if( GetRowCount() - rowIdx >= mMaxRowInPage )
				mTopRowIdx = mSelectedRowIdx;
			else
				mTopRowIdx = GetRowCount() - mMaxRowInPage;

			/// ũѹٸ Ѵ.
			UpdateScrollBar();
		}
	}

	/// 콺  ε  
	mHoveredRowIdx = -1;

	///  ̹ 
	if( mpSelectImage )
	{
		UpdateSelectImage();
		CheckShowImage();
	}
	return true;
}

/// ǻ : Ʈ ½ žε  
bool cListBox::ChangeTopIndex( unsigned int topIdx, bool changeSel )
{
	if( topIdx >= GetRowCount() )
		return false;
	if( mTopRowIdx == topIdx )
		return true;

	mTopRowIdx = topIdx;

	if( changeSel == true )
		mSelectedRowIdx = mTopRowIdx;
	else
		UpdateScrollBar();

	/// 콺  ε  
	mHoveredRowIdx = -1;

	///  ̹ 
	if( mpSelectImage )
	{
		UpdateSelectImage();
		CheckShowImage();
	}
	return true;
}

/// ǻ : Ʈ  ׷ֱ
void cListBox::RenderData( cUIFontItemKeeper* pKeeper )
{
	/// ü Ʈ  
 	if( GetRowCount() <= 0 )
		return;

	/// Ų ޾ƿ 
	cListBoxSkin* pListSkin = (cListBoxSkin*)mpSkin;
	if( !pListSkin )
	{
		assert(0);
		return;
	}

    /// Ʈ ڽ ǥ ޾ƿ
	int textposX = 0;
	int textPosY = GetAbsoluteRect().mTop + mPrintPos.mY;

	unsigned int rowCount = ( mMaxRowInPage > GetRowCount() )? GetRowCount() : mMaxRowInPage;
	for( unsigned int row = mTopRowIdx; row < mTopRowIdx + rowCount; ++row )
	{
		sRowData* rData = GetRowData( row );
		if( !rData )
			continue;
		
		/// image  
		if( rData->mImage )
		{
			cUIImage* image = rData->mImage;

			sListCtrlParam* pParam = pListSkin->mpImgParam;
			unsigned int imageX = pParam->mColumnX;
			unsigned int imageY = textPosY + (int)((mRowHeight-image->GetHeight())*0.5f);

			image->SetPos( GetAbsoluteRect().mLeft + imageX, imageY );
			image->Draw();
		}

		/// Ʈ  
		unsigned int colCount = rData->mColumes.GetSize();
		for( unsigned int col = 0; col< colCount; ++col )
		{
			///  ÷  
			sData* data = rData->mColumes[col];

			///  ÷ param data  ( ġ  )
			sListCtrlParam* pParam = pListSkin->GetCtrlParam( col );

			unsigned int tX = 0;
			unsigned int tW = 0;
			eText_Align align = eALIGN_LEFT;

			if( pParam )
			{
				tX = pParam->mColumnX;
				tW = pParam->mColumnW;
				align = pParam->mAlign;
			}

			///   ǥ  
			unsigned int strWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, (LPTSTR)data->mText.Cstr(), data->mText.GetLength() );
			textposX = UpdateTextPos( align, strWidth, tX, tW );
			
			/// Hover   ٸ  ǥ
			unsigned color = data->mTextColor;
			if( mHoveredRowIdx != -1 && row - mTopRowIdx == (unsigned int)mHoveredRowIdx )
				color = mHoverTextColor;

			int addY = (int)((mRowHeight-FONTAGENT->GetTextHeight(cFontAgent::eFont_UI))*0.5f);
			pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPTSTR)data->mText.Cstr(), textposX, textPosY + addY, color );
		}

		textPosY += mRowHeight;
	}

}

/// ǻ : Ŀ   ǥ  
unsigned int cListBox::UpdateTextPos( eText_Align align, unsigned int strWidth, unsigned int x, unsigned int w )
{
	unsigned int drawX = GetAbsoluteRect().mLeft + x + mPrintPos.mX;

	if( align == eALIGN_RIGHT )
	{
		drawX += (int)(w - strWidth);
	}
	else if( align == eALIGN_CENTER )
	{
		drawX += (int)(w - strWidth) / 2;
	}
	return drawX;
}

///
void cListBox::UpdateScrollBar()
{
	if( !mpScrollBar )
		return;

	if( GetRowCount() > mMaxRowInPage )
	{
		/// ũѹ  ư ׸ 
		mpScrollBar->Show();

		unsigned int scrollHeight = mpScrollBar->GetScrollBarHeight();
		double hsize = scrollHeight - scrollHeight * (double)GetRowCount() / (double)mTotalMaxNum;

		///  ư ּһ   
		unsigned int minsize = mpScrollBar->GetMinimumHeight();
		if( hsize < minsize )
		{
			hsize = minsize;
		}

		/// ũѹ ġ ..
		///  ۴ ũѹٰ ̴ Ÿ ϱ 
		double h = mpScrollBar->GetScrollMarginHeight() / (double)(GetRowCount()-mMaxRowInPage);

		///  žε * Ѱ = ο ũѹ ġ 
		double newposY = h * mTopRowIdx;
		double oldY = mpScrollBar->GetBarButtonPosY();

		///  ġ ؼ ũѹ ġ Ѵ. 
		int value = (int)(newposY-oldY);
		if( newposY > oldY )
		{
			mpScrollBar->MoveScrollDown( value );
		}
		else
		{
			mpScrollBar->MoveScrollUp( -value );
		}
	}
	else
	{
		mpScrollBar->Hide();
	}
}

/// ǻ : õ ̹  Ʈ 
void cListBox::UpdateSelectImage()
{
	int scrollWidth = 0;
	if( mpScrollBar && mpScrollBar->IsVisible() )
	{
		scrollWidth = mpScrollBar->GetAbsoluteRect().GetWidth();
	}

    cUIRect imageRc;
	imageRc.mLeft   = GetAbsoluteRect().mLeft;

	/// Ų󿡼  ù   .
	if( mSelectBarWidth == 0 )
		imageRc.mRight  = imageRc.mLeft + GetAbsoluteRect().GetWidth() - scrollWidth;
	else
		imageRc.mRight  = imageRc.mLeft + mSelectBarWidth;

	imageRc.mTop    = GetAbsoluteRect().mTop + ( mRowHeight * ( mSelectedRowIdx - mTopRowIdx) ) + mPrintPos.mY;
	imageRc.mBottom = imageRc.mTop + mRowHeight;

	/// ġ  
	if( mpSelectImage )
	{
		mpSelectImage->SetScreenXY( (unsigned short)imageRc.mLeft, (unsigned short)imageRc.mTop );
		mpSelectImage->SetScreenWH( (unsigned short)imageRc.GetWidth(), (unsigned short)imageRc.GetHeight() );
	}
}

void cListBox::CheckShowImage()
{
	/// ̹ ٰ, Ʈڽ Ѿ ʵ Ѵ.
	if( mSelectedRowIdx >= mTopRowIdx && mSelectedRowIdx < mTopRowIdx + mMaxRowInPage )
		mShowImage = true;
	else
		mShowImage = false;
}

/// ǻ :
bool cListBox::HandleEvent( const cUIEvent& event )
{
	if( mEnabled == false || mVisible == false )
		return mpParent->HandleEvent( event );

 	switch( event.mType )
	{
	case eUIEVENT_COMMAND:
	case eUIEVENT_BUTTON_DOWNED:
		CheckButtonEvent( event.mID );
		break;
	case eUIEVENT_SCROLLBAR_MOVE:
		OnScrollbarMoved( event.mPos );
		break;
	default:
		cUIWindow::HandleEvent( event );
		break;
	}
	return true;
}

void cListBox::ChangeTextColor( unsigned int rowIdx, unsigned long color )
{
	sRowData* rData = GetRowData( rowIdx );
	if( rData )
	{
		unsigned int colCount = rData->mColumes.GetSize();
		for( unsigned int col = 0; col< colCount; ++col )
		{
			///  ÷  
			sData* data = rData->mColumes[col];
			if( data )
				data->mTextColor = color;
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
cListBoxSkin::cListBoxSkin( eUINodeType type )
: cUINodeSkin( type )
, mTotalMaxNum( 0 )
, mRowHeight( 0 )
, mSelectBarSkin(0)
, mpImgParam(0)
, mpSelectBarTexture(0)
, mSelectBarWidth(0)
, mPrintPos(0, 0)
, mPrintSize(0, 0)
{
	mSelectBarSkin = new sSkinInfo;
	mpImgParam = new sListCtrlParam;

	mRowHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_UI);
}

cListBoxSkin::~cListBoxSkin()
{
	///
	for( unsigned int i = 0; i < mCtrlParamArr.GetSize(); ++i)
	{
		delete (sListCtrlParam*)mCtrlParamArr[i];
	}
	mCtrlParamArr.Clear();

	SAFE_DELETE( mpImgParam );
	SAFE_DELETE( mSelectBarSkin );
}

/// ǻ : 
bool cListBoxSkin::Load( cParser& parser )
{
	for( unsigned int i = 0; i < mCtrlParamArr.GetSize(); ++i)
	{
		delete (sListCtrlParam*)mCtrlParamArr[i];
	}
	mCtrlParamArr.Clear();

	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			///  Ż ^^
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_PRINTPOS:
			{
				mPrintPos.mX = parser.ParseInt();
				mPrintPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_PRINTSIZE:
			{
				mPrintSize.mWidth = parser.ParseInt();
				mPrintSize.mHeight = parser.ParseInt();
			}
			break;
		case eTOKEN_IMGCOLX:
			{
				mpImgParam->mColumnX = parser.ParseInt();
				mpImgParam->mColumnW = parser.ParseInt();
				if( mpImgParam->mColumnW <= 0 )
				{
					assert(0);
					return 0;
				}
			}
			break;
		case eTOKEN_COLUMNX:
			{
				/// ǥ 
				unsigned columnX = parser.ParseInt();

				///  
				unsigned columnW = parser.ParseInt();
				if( columnW <= 0 )
				{
					assert(0);
					return 0;
				}

				///
				lexer->GetNextToken( &token );

				///  
				eText_Align align = eALIGN_LEFT;

				if( token.mType == eTOKEN_CENTER )
				{
					align = eALIGN_CENTER;
				}
				else if( token.mType == eTOKEN_RIGHT )
				{
					align = eALIGN_RIGHT;
				}

				///  
				sListCtrlParam* pCtrlParam = new sListCtrlParam;
				pCtrlParam->mColumnX = columnX;
				pCtrlParam->mColumnW = columnW;
				pCtrlParam->mAlign = align;
				mCtrlParamArr.PushBack( pCtrlParam );
			}
			break;
		case eTOKEN_ROWHEIGHT:
			{
				mRowHeight = parser.ParseInt();
			}
			break;
		case eTOKEN_MAXITEMNUM:
			{
				mTotalMaxNum = parser.ParseInt();
			}
			break;
			/// ui image  
		case eTOKEN_CHILD_IMAGEINDEX:
			{
				int i = parser.ParseInt();
				mpSelectBarTexture = UIMAN->GetSkin()->GetTexture( i );
				if( mpSelectBarTexture == 0 )
				{
					assert( 0 && "failed to load texture" );
					return false;
				}
			}
			break;
		case eTOKEN_CHILD_SIZE:
			{
				mSelectBarSkin->mWidth = mSelectBarSkin->mTexWidth = (unsigned short)parser.ParseInt();
				mSelectBarSkin->mHeight = mSelectBarSkin->mTexHeight = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_CHILD_TEXPOS:
			{
				mSelectBarSkin->mTexX = (unsigned short)parser.ParseInt();
				mSelectBarSkin->mTexY = (unsigned short)parser.ParseInt();
			}
			break;
		case eTOKEN_SELECTWIDTH:
			{
				mSelectBarWidth = parser.ParseInt();
			}
			break;
		case eTOKEN_SCROLLSKIN:
			{
				mScrollSkin = parser.ParseString();
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}
	return true;
}

///
sListCtrlParam*	cListBoxSkin::GetCtrlParam( unsigned int index )
{
	if( mCtrlParamArr.GetSize() == 0 )
		return 0;

	if( index > mCtrlParamArr.GetSize() - 1 )
	{
		assert(0);
		return 0;
	}

	sListCtrlParam* pParam = (sListCtrlParam*)mCtrlParamArr[index];
	assert( pParam );

	return pParam;
}