#include "Stdafx.h"
#include "ListCtrl.h"
#include "UIImage.h"

cListCtrl::cListCtrl( eUINodeType type )
: cUIWindow( type )
{
}

cListCtrl::~cListCtrl()
{
	Clear();
}

/// ǻ : ü 
void cListCtrl::Clear()
{
	cRowDataArray::cIterator i = mRows.Begin();
	cRowDataArray::cIterator end = mRows.End();

	sRowData* p = 0;
	for( ; i != end; ++i )
	{
		p = (sRowData*)(*i);
		if( p )
		{
			for( unsigned int b = 0; b < p->mColumes.GetSize(); ++b )
			{
				sData* data = (sData*)p->mColumes[b];
				SAFE_DELETE( data );
			}
			p->mColumes.Clear();

			p->mExtraData = 0;
			SAFE_DELETE(p);
		}
	}
	mRows.Clear();
}

/// ο  ϰ ϳ  ߰Ѵ.
unsigned int cListCtrl::AddRowData( sData* colData, void* pExtraData, cUIImage* pImage )
{
	///   
	sRowData* pNew = new sRowData;

	///  
	pNew->mColumes.PushBack(colData);
	pNew->mExtraData = pExtraData;
	pNew->mImage = pImage;
	pNew->mCheck = false;

	///   
	mRows.PushBack( pNew );

	///  ε ..
	return mRows.GetSize() - 1;
}

/// Ư ο  ߰Ѵ.
bool cListCtrl::AddColumeData( unsigned int rowIdx, sData* colData )
{
	if( rowIdx > mRows.GetSize()-1 )
		return false;

	sRowData* pRow = (sRowData*)mRows[rowIdx];
	pRow->mColumes.PushBack( colData );
	return true;
}

///
void* cListCtrl::GetExtraData( unsigned int rowIdx )
{
	if( mRows.GetSize() <= 0 )
		return 0;

	if( rowIdx > mRows.GetSize()-1 )
	{
		assert(0);
		return 0;
	}

	sRowData* pRow = (sRowData*)mRows[rowIdx];
	return ( pRow != 0 ) ? pRow->mExtraData : 0;
}

///
bool cListCtrl::GetCheck( unsigned int rowIdx )
{
	if( mRows.GetSize() <= 0 )
		return 0;

	if( rowIdx > mRows.GetSize()-1 )
	{
		assert(0);
		return 0;
	}

	sRowData* pRow = (sRowData*)mRows[rowIdx];
	assert(pRow);

	return pRow->mCheck;
}

sRowData* cListCtrl::GetRowData( unsigned int rowIdx ) 
{
	if( mRows.GetSize() <= 0 )
		return 0;

	if( rowIdx > mRows.GetSize()-1 )
		return 0;

	return (sRowData*)mRows[rowIdx]; 
}

sData* cListCtrl::GetColumeData( unsigned int rowIdx, unsigned int columeIdx )
{
	if( mRows.GetSize() <= 0 )
		return 0;

	if( rowIdx > mRows.GetSize()-1 )
	{
		assert(0);
		return 0;
	}

	sRowData* pRow = (sRowData*)mRows[rowIdx];
	return pRow->mColumes[columeIdx];
}

unsigned int cListCtrl::GetColumnCount( unsigned int rowIdx )
{
	if( mRows.GetSize() <= 0 )
		return 0;

	if( rowIdx > mRows.GetSize()-1 )
	{
		assert(0);
		return 0;
	}

	sRowData* pRow = (sRowData*)mRows[rowIdx];
	return pRow->mColumes.GetSize();
}

bool Compare( const void* arg1, const void* arg2 )
{
	sRowData* rowData1 = (sRowData*)arg1;
	sRowData* rowData2 = (sRowData*)arg2;

	sData* data1 = rowData1->mColumes[0];
	sData* data2 = rowData2->mColumes[0];
	if( ::_tcscmp( (LPCTSTR)data1->mText.Cstr(), (LPCTSTR)data2->mText.Cstr() ) )
		return false;
	return true;
}

void cListCtrl::Sort()
{
	int i = mRows.GetSize();
	sort( mRows.Begin(), mRows.End(), Compare );
}