#include "StdAfx.h"
#include "ListFolderBox.h"
#include "UIManager.h"
#include "UISkinLexer.h"
#include "Token.h"
#include "Parser.h"
#include "UIEvent.h"
#include "ListBox.h"
#include "ScrollBar.h"
#include "FontAgent.h"
#include "UIImage.h"
#include "PlaneObject.h"
#include "GameResourceManager.h"

cListFolderBox::cListFolderBox( eUINodeType type )
:cListCtrl( type )
, mpScrollBar(0)
, mpSelectImage(0)
, mTopColumnIdx(0)
, mSelectedColumnIdx(0)
, mRowHeight(0)
, mMaxRowInPage(0)
, mTotalMaxNum(0)
, mHighCheckPos(0, 0)
, mHighNoCheckPos(0, 0)
, mLowCheckPos(0, 0)
, mLowNoCheckPos(0, 0)
, mClickLowImgRow(0)
, mClickLowImgColumn(0)
, mSelectedRow(0)
, mSelectedRowColumn(0)
, mColumnCount(0)
, mRenderRow(0)
, mRenderStartColumn(0)
, mLowGap(0)
{
}

cListFolderBox::~cListFolderBox()
{
	mpScrollBar = 0;
	SAFE_DELETE( mpSelectImage );
}

void cListFolderBox::Clear()
{
	mSelectedColumnIdx = 0;
	mSelectedRow = 0;
	mSelectedRowColumn = 0;

	mTopColumnIdx = 0;
	mClickLowImgRow = 0;
	mClickLowImgColumn = 0;
	mColumnCount = 0;

	UpdateScrollBar();
	UpdateSelectImage();

	cListCtrl::Clear();
}

bool cListFolderBox::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;
	
	/// ũѹ 
	if( mScrollSkin )
	{
		mpScrollBar = new cScrollBar;
		if( mpScrollBar->CreateBySkinName( mScrollSkin, this, eLIST_SCROLL ) == false )
		{
			assert( 0 && "failed to create scroll bar" );
			return false;
		}
	}

	if( mpScrollBar )
	{
		mpScrollBar->SetHeight( GetAbsoluteRect().GetHeight() );
		mpScrollBar->SetPosX( GetRelativeRect().mRight -  GetRelativeRect().mLeft - mpScrollBar->GetAbsoluteRect().GetWidth() );
		UpdateScrollBar();
	}
	return true;
}

bool cListFolderBox::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_LISTBOX ) == false )
	{
		assert( 0 && "not list skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
		return false;

	/// ũƮκ ؽ ̹ Ӽ ޴´
	cListBoxSkin* p = (cListBoxSkin*)pskin;

	mScrollSkin = p->mScrollSkin;

	/// ƮƮѿ    
	mRowHeight = p->mRowHeight;

	/// Ʈ ִ  ִ  
	mTotalMaxNum = p->mTotalMaxNum;

	/// Ʈ  ִ  ִ  
	mMaxRowInPage = pskin->mSkinInfo->mHeight / mRowHeight;
	assert( mMaxRowInPage );

	if( p->mpSelectBarTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)p->mSelectBarSkin->mTexX;
		unsigned short ty = (unsigned short)p->mSelectBarSkin->mTexY;
		unsigned short tw = (unsigned short)p->mSelectBarSkin->mTexWidth;
		unsigned short th = (unsigned short)p->mSelectBarSkin->mTexHeight;

		if( mpSelectImage == 0 )
		{
			mpSelectImage = new cPlaneObject;

			if( mpSelectImage->Create( p->mpSelectBarTexture, (short)GetAbsoluteRect().mLeft, (short)GetAbsoluteRect().mTop, tw, th,
				tx, ty, tx + tw, ty + th ) == false )
			{
				assert( 0 && "failed to create select image");
				return false;
			}
		}
		else
		{
			mpSelectImage->SetTextureRect( tx, ty, tx + tw, ty + th );
		}
	}
	return true;
}

/// ǻ :
bool cListFolderBox::HandleEvent( const cUIEvent& event )
{
	if( mEnabled == false || mVisible == false )
		return mpParent->HandleEvent( event );

	switch( event.mType )
	{
	case eUIEVENT_COMMAND:
	case eUIEVENT_BUTTON_DOWNED:
		CheckButtonEvent( event.mID );
		break;
	case eUIEVENT_SCROLLBAR_MOVE:
		OnScrollbarMoved( event.mPos );
		break;
	default:
		cUIWindow::HandleEvent( event );
		break;
	}
	return true;
}

void cListFolderBox::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpSelectImage )
		UpdateSelectImage();
}

void cListFolderBox::OnProcess(unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mVisible == false )
		return;

	/// mTopColumnIdx ش row row ÷ ã´
	if( mColumnCount > 0 )
	{
		mRenderRow = 0;
		mRenderStartColumn = 0;
		unsigned int totalColumn = 0;
		for( unsigned int i = 0; i < GetRowCount(); ++i )
		{
			sRowData* p = GetRowData(i);
			if( p )
			{
				/// ش row ÷īƮ
				mRenderRow = i;
				mRenderStartColumn = mTopColumnIdx - totalColumn;

				/// Ʈ ִ ˻.
				sFolderData* data = (sFolderData*)p->mColumes[0];
				if( data->mCheck == true )
					totalColumn += p->mColumes.GetSize();
				else
					totalColumn += 1;

				if( totalColumn > mTopColumnIdx )
					break;

				mRenderStartColumn = 0;
			}
		}
	}
}

void cListFolderBox::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		if( ((cUINode*)(*i))->IsVisible() == true )
		{
			((cUINode*)(*i))->OnRender(pKeeper);
		}
	}

	/// ü Ʈ  
	if( mColumnCount > 0 )
	{
		/// ̹ ٰ, Ʈڽ Ѿ ʵ Ѵ.
		if( mSelectedColumnIdx >= mTopColumnIdx && mSelectedColumnIdx < mTopColumnIdx + mMaxRowInPage )
			mpSelectImage->Draw();

		int textposX = GetAbsoluteRect().mLeft + 1;
		int textPosY = GetAbsoluteRect().mTop + 1;
		unsigned int addX = 0;
		unsigned int addY = 0;

		/// 
		unsigned int maxLine = ( mMaxRowInPage > mColumnCount )? mColumnCount : mMaxRowInPage;
		unsigned int line = 0;

		for( unsigned int i=mRenderRow; i<GetRowCount(); i++ )
		{
			if( line >= maxLine )
				break;

			sRowData* rData = GetRowData( i );
			if( rData == 0 )
				continue;

			unsigned int colCount = rData->mColumes.GetSize();
			for( unsigned int col = mRenderStartColumn; col < colCount; ++col )
			{
				sFolderData* data = (sFolderData*)rData->mColumes[col];
				if( data == 0 )
					break;

				addX = 0;

				cUIImage* image = data->mCheckImg;
				if( image )
				{
					/// ̹ ؽ ǥ 
					cUIPos texPos = mLowCheckPos;
					if( col == 0 && data->mCheck == true )
						texPos = mHighCheckPos;
					else if( col == 0 && data->mCheck == false )
						texPos = mHighNoCheckPos;
					else if( data->mCheck == false )
						texPos = mLowNoCheckPos;

					image->SetTextureRect( cUIRect( texPos.mX, texPos.mY,texPos.mX + image->GetWidth(), texPos.mY + image->GetHeight() ) );
					image->SetPos( GetAbsoluteRect().mLeft, textPosY );
					image->Draw();

					addX += (image->GetWidth() + IMAGE_GAP);
				}

				/// ̸
				if( col == 0 )
				{
					TCHAR temp[256] = {0,};
					::_stprintf( temp, GAMERESOURCEMAN->GetGameText(470), (LPTSTR)data->mText.Cstr(), colCount-1 );

					pKeeper->AddFontItem( cFontAgent::eFont_UI, temp, textposX + addX, textPosY, data->mTextColor );
				}
				/// ̸
				else
				{
					pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPTSTR)data->mText.Cstr(), textposX + addX + mLowGap, textPosY, data->mTextColor );
				}

				textPosY += mRowHeight;
				line++;

				if( line >= maxLine )
					break;

				///  ؿ ¾
				if( col == 0 && data->mCheck == false )
					break;
			}

			mRenderStartColumn = 0;
		}
	}

	pKeeper->DrawAll();
}

/// ǻ : 
void cListFolderBox::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUINode::OnLButtonDown( pos, ctrl, alt, shift );

	unsigned int column = (pos.mY - GetAbsoluteRect().mTop) / mRowHeight + mTopColumnIdx;
	if( column >= mColumnCount )
		return;

	sRowData* p = 0;
	unsigned int row = 0;
	unsigned int rowColumn = 0;
	unsigned int totalColumn = 0;
	for( unsigned int i = 0; i < GetRowCount(); ++i )
	{
		p = GetRowData( i );
		if( p )
		{			
			/// ش row ÷īƮ
			row = i;
			rowColumn = totalColumn;

			/// Ʈ ִ ˻.
			sFolderData* data = (sFolderData*)p->mColumes[0];
			if( data->mCheck == true )
				totalColumn += p->mColumes.GetSize();
			else
				totalColumn += 1;

			if( totalColumn > column )
				break;
		}
	}

	mSelectedRow = row;
	mSelectedRowColumn = column - rowColumn;

	/// õ  ̸,[üũ] 
	if( rowColumn == column )
	{
		sRowData* p = GetRowData( mSelectedRow );
		if( p )
		{
			sFolderData* data = (sFolderData*)p->mColumes[0];
			data->mCheck = !data->mCheck;
		}

		/// ÷   
		UpdateColumnCount();

		///    
		if( mColumnCount < mMaxRowInPage )
		{
			mTopColumnIdx = 0;
		}
		else if( mColumnCount - rowColumn <= mMaxRowInPage  )
		{
			mTopColumnIdx = mColumnCount - mMaxRowInPage;
		}

		mSelectedColumnIdx = column;
		UpdateScrollBar();
	}
	else
	{
		sRowData* data = GetRowData( mSelectedRow );
		if( data )
		{
			sFolderData* colData = (sFolderData*)data->mColumes[mSelectedRowColumn];
			if( colData )
			{
				/// Ʈ ̹  ̹  ̺Ʈ üũ 
				if( colData->mCheckImg )
				{
					//int x1 = GetAbsoluteRect().mLeft + LOW_GAP;
					int x1 = GetAbsoluteRect().mLeft;
					int x2 = x1 + colData->mCheckImg->GetWidth();

					if( pos.mX > x1 && pos.mX < x2 )
					{
						mClickLowImgRow = mSelectedRow;
						mClickLowImgColumn = mSelectedRowColumn;

						/// ̹  ̺Ʈ ߻
						cUIEvent event;
						event.mpCaller = this;
						event.mID = mID;
						event.mType = eUIEVENT_IMAGE_CLICKED;
						mpParent->HandleEvent( event );
					}		
				}	
			}
		}

		/// ̸ ̺Ʈ 
		if( mSelectedColumnIdx != column )
		{
			mSelectedColumnIdx = column;

			/// ̺Ʈ  
			cUIEvent event;
			event.mType = eUIEVENT_LISTBOX_CHANGED;
			event.mpCaller = this;
			event.mID = mID;
			mpParent->HandleEvent( event );
		}
	}

	/// ú 
	UpdateSelectImage();
}

void cListFolderBox::OnScrollbarMoved( const cUIPos& )
{	
	if( mpScrollBar == 0)
		return;

	assert( mColumnCount > mMaxRowInPage );

	///  ư ġ .
	unsigned int barbuttonPos = mpScrollBar->GetBarButtonPosY();
	double h = mpScrollBar->GetScrollMarginHeight() / (double)(mColumnCount-mMaxRowInPage);

	///   ư ġ شϴ  ε ϱ
	double x = ((double)barbuttonPos / h);

	mTopColumnIdx = (int)x;

	UpdateSelectImage();
}

///
void cListFolderBox::OnMouseWheel( const cUIPos& /*pos*/, int wheel )
{
	if( !mpScrollBar || mpScrollBar->IsVisible() == false )
		return;

	assert( mColumnCount > mMaxRowInPage );

	/// ũѹ    
	if( wheel > 0 )
	{
		if( mTopColumnIdx > 0 )
		{
			mTopColumnIdx--;
			UpdateSelectImage();
		}
	}
	/// Ʒ   
	else if ( wheel < 0 )
	{
		///   Բ ũ
		if( mColumnCount - mTopColumnIdx > mMaxRowInPage )
		{
			mTopColumnIdx++;
			UpdateSelectImage();
		}		
	}

	/// ũѹ Ʈ 
	UpdateScrollBar();
}


/// ǻ : ư  üũ 
void cListFolderBox::CheckButtonEvent( unsigned int id )
{
	if( !mpScrollBar )
	{
		///  ´ٸ ߸ κδ.
		assert(0);
		return;
	}
	/// ũѹٰ ׷ ʴ ¸ 
	if( mpScrollBar->IsVisible() == false )
	{
		///  ´ٸ ߸ κδ.
		assert(0);
		return;
	}
	assert(mColumnCount > mMaxRowInPage);

	switch( id )
	{
	case eSCROOLBAR_UP:
		if( mTopColumnIdx > 0 )
		{
			mTopColumnIdx--;
			UpdateSelectImage();
		}
		break;
	case eSCROOLBAR_DOWN:
		///   Բ ũ
		if( mColumnCount - mTopColumnIdx > mMaxRowInPage )
		{
			mTopColumnIdx++;
			UpdateSelectImage();
		}		
		break;
	}

	/// ũѹ ư ġ Ʈ 
	UpdateScrollBar();
} 

///  ߰
int cListFolderBox::AddHighData( int key, LPCTSTR str, unsigned long color, cUIImage* pImage )
{
	/// 밹 Ѿ  
	if( mColumnCount >= mTotalMaxNum )
		return -1;

	/// ̹ Ͱ ִ ˻
	for( unsigned int i = 0; i < mRows.GetSize(); ++i )
	{
		sRowData* p = (sRowData*)mRows[i];
		if( p && (int)p->mExtraData == key )
			return -1;
	}
	
	///  
	sFolderData* data = new sFolderData;
	data->mText = str;
	data->mTextColor = color;
	data->mCheck = true;
	data->mCheckImg = pImage;
	data->mExtraData = 0;
	
	int ret = cListCtrl::AddRowData( data, (void*)key );

	UpdateColumnCount();
	UpdateScrollBar();
	return ret;
}

///  ߰
bool cListFolderBox::AddLowData( int key, LPCTSTR str, unsigned long color, void* pExtraData, cUIImage* pImage, bool check )
{
	/// ش   
	int row = -1;
	for( unsigned int i = 0; i < mRows.GetSize(); ++i )
	{
		sRowData* p = (sRowData*)mRows[i];
		if( p && (int)p->mExtraData == key )
		{
			row = i;
			break;
		}
	}

	if( row == -1 )
	{
		assert(0);
		return false;
	}

	sFolderData* data = new sFolderData;
	data->mText = str;
	data->mTextColor = color;
	data->mCheck = check;
	data->mCheckImg = pImage;
	data->mExtraData = pExtraData;

	bool ret = cListCtrl::AddColumeData( row, data );

	UpdateColumnCount();
	UpdateScrollBar();
	return ret;
}

bool cListFolderBox::UpdateLowData( int key, LPCTSTR changeStr, void* extraData )
{
	int rowSize = mRows.GetSize();
	for( int ri = 0; ri < rowSize; ++ri )
	{
		sRowData* p = (sRowData*)mRows[ri];
		if( p && (int)p->mExtraData == key )
		{
			int colSize = p->mColumes.GetSize();
			for( int ci = 0; ci < colSize; ++ci )
			{
				sFolderData* data = (sFolderData*)p->mColumes[ci];
				if( ci > 0 && data && data->mExtraData == extraData )
				{
					data->mText = changeStr;
					return true;
				}
			}
			break;
		}
	}
	return false;
}

bool cListFolderBox::UpdateLowCheck( int key, bool check, void* extraData )
{
	int rowSize = mRows.GetSize();
	for( int ri = 0; ri < rowSize; ++ri )
	{
		sRowData* p = (sRowData*)mRows[ri];
		if( p && (int)p->mExtraData == key )
		{
			int colSize = p->mColumes.GetSize();
			for( int ci = 0; ci < colSize; ++ci )
			{
				sFolderData* data = (sFolderData*)p->mColumes[ci];
				if( ci > 0 && data && data->mExtraData == extraData )
				{
					data->mCheck = check;
					return true;
				}
			}
			break;
		}
	}
	return false;
}

/// ǻ : õ ̹  Ʈ 
void cListFolderBox::UpdateSelectImage()
{
	int scrollWidth = 0;
	if( mpScrollBar && mpScrollBar->IsVisible() )
		scrollWidth = mpScrollBar->GetAbsoluteRect().GetWidth();

	cUIRect imageRc;
	imageRc.mLeft   = GetAbsoluteRect().mLeft;
	imageRc.mRight  = imageRc.mLeft + GetAbsoluteRect().GetWidth() - scrollWidth;
	imageRc.mTop    = GetAbsoluteRect().mTop + ( mRowHeight * ( mSelectedColumnIdx - mTopColumnIdx) );
	imageRc.mBottom = imageRc.mTop + mRowHeight;

	/// ġ  
	mpSelectImage->SetScreenXY( (unsigned short)imageRc.mLeft, (unsigned short)imageRc.mTop );
	mpSelectImage->SetScreenWH( (unsigned short)imageRc.GetWidth(), (unsigned short)imageRc.GetHeight() );
}

///
void cListFolderBox::UpdateScrollBar()
{
	if( !mpScrollBar )
		return;

	if( mColumnCount > mMaxRowInPage )
	{
		/// ũѹ  ư ׸ 
		mpScrollBar->Show();

		unsigned int scrollHeight = mpScrollBar->GetScrollBarHeight();
		double hsize = scrollHeight - scrollHeight * (double)mColumnCount / (double)mTotalMaxNum;

		///  ư ּһ   
		unsigned int minsize = mpScrollBar->GetMinimumHeight();
		if( hsize < minsize )
		{
			hsize = minsize;
		}

		/// ũѹ ġ ..
		///  ۴ ũѹٰ ̴ Ÿ ϱ 
		double h = mpScrollBar->GetScrollMarginHeight() / (double)(mColumnCount-mMaxRowInPage);

		///  žε * Ѱ = ο ũѹ ġ 
		double newposY = h * mTopColumnIdx;
		double oldY = mpScrollBar->GetBarButtonPosY();

		///  ġ ؼ ũѹ ġ Ѵ. 
		int value = (int)(newposY-oldY);
		if( newposY > oldY )
		{
			mpScrollBar->MoveScrollDown( value );
		}
		else
		{
			mpScrollBar->MoveScrollUp( -value );
		}
	}
	else
	{
		mpScrollBar->Hide();
	}
}

void cListFolderBox::SetClickLowImage( int row, int column, bool check )
{
	if( mClickLowImgColumn == 0 )
		return;

	sRowData* p = GetRowData( row );
	if( p )
	{
		sFolderData* data = (sFolderData*)p->mColumes[column];
		data->mCheck = check;
	}
}

void cListFolderBox::UpdateColumnCount()
{
	mColumnCount = 0;

	///  ÷ 
	for( unsigned int i = 0; i < mRows.GetSize(); ++i )
	{
		sRowData* p = (sRowData*)mRows[i];
		if( p )
		{
			sFolderData* data = (sFolderData*)p->mColumes[0];
			if( !data )
			{
				assert(0);
				break;
			}

			if( data->mCheck == true )
				mColumnCount += p->mColumes.GetSize();
			else
				mColumnCount += 1;
		}
	}
}

///
void* cListFolderBox::GetExtraData( unsigned int row, unsigned int column )
{
	if( mColumnCount == 0 )
		return 0;

	if( mRows.GetSize() <= 0 )
		return 0;

	sRowData* data = (sRowData*)mRows[row];
	if( !data )
		return 0;

	sFolderData* colData = (sFolderData*)data->mColumes[column];
	if( !colData )
		return 0;

	return colData->mExtraData;
}


//////////////////////////////////////////////////////////
cListFolderBoxSkin::cListFolderBoxSkin( eUINodeType type )
: cUINodeSkin( type )
{
}

cListFolderBoxSkin::~cListFolderBoxSkin()
{
}

/// ǻ : 
bool cListFolderBoxSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			///  Ż ^^
			break;
		}

		if( cUINodeSkin::ParseLine( parser, token ) == false )
		{
			return false;
		}
		
	}
	return true;
}