/* ==========================================================================
*      : ListFolderBox.h
*      : 
*    : 谡
*    : 2008-03-18
* ǻ :
*===========================================================================*/
#pragma once
#include "ListCtrl.h"

const unsigned int IMAGE_GAP = 2;
const unsigned int LOW_GAP = 15;

struct sFolderData : sData
{
	tPointerArray<sData*>		mColumes;

	/// ̹ ÷
	bool mCheck;
	cUIImage*	mCheckImg;

	/// ߰ 
	void* mExtraData; 

	sFolderData()
	{
		mExtraData = 0;
	}
	~sFolderData(){}
};

/// Ʈ  ڽ ui 
class cScrollBar;
class cPlaneObject;
class cListFolderBox : public cListCtrl
{
public:
	cListFolderBox( eUINodeType type = eUINODE_LISTFOLDERBOX );
	virtual ~cListFolderBox();

	void Clear();

	///  ߰ ( key :  ε )
	int AddHighData( int key, LPCTSTR str, unsigned long color, cUIImage* pImage = 0 );

	///  ߰ ( key :  ε )
	bool AddLowData( int key, LPCTSTR str, unsigned long color, void* pExtraData = 0, cUIImage* pImage = 0, bool check = false );

	/// extraData ִ  ãƼ changeStr 
	bool UpdateLowData( int key, LPCTSTR changeStr, void* extraData );

	/// extraData ִ  ãƼ check 
	bool UpdateLowCheck( int key, bool check, void* extraData );

	///
	void* GetExtraData( unsigned int row, unsigned int column );

	///  ̹ 
	void SetHighCheckPos( unsigned int texX, unsigned int texY );
	void SetHighNoCheckPos( unsigned int texX, unsigned int texY );
	void SetLowCheckPos( unsigned int texX, unsigned int texY );
	void SetLowNoCheckPos( unsigned int texX, unsigned int texY );

	///  ̹ 
	void SetClickLowImage( int row, int column, bool check );

	///  ۵ 
	unsigned int GetSelectRow() { return mSelectedRow; }
	unsigned int GetSelectRowColumn() { return mSelectedRowColumn; }

	/// õ  ̹ 
	unsigned int GetClickImgRow() { return mClickLowImgRow; }
	unsigned int GetClickImgRowColumn() { return mClickLowImgColumn; }

	///    x ġ 
	void SetLowGap( unsigned int gap ) { mLowGap = gap; }

	///  ̹ ǥ Ʈ 
	void UpdateSelectImage();

protected:
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual bool HandleEvent( const cUIEvent& event );
	virtual void OnProcess(unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void UpdateRect();
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	virtual void OnScrollbarMoved( const cUIPos& pos );
	virtual void OnMouseWheel( const cUIPos& pos, int wheel );
	void CheckButtonEvent( unsigned int id );

	/// ũѹ  
	void UpdateScrollBar();

	/// ÷   
	void UpdateColumnCount();

private:
	/// ũѹ 
	cString mScrollSkin;
	cScrollBar* mpScrollBar;

	///  ý  ̹ 
	cPlaneObject* mpSelectImage;

	/// ǥ  
	unsigned int	mTopColumnIdx;

	///   ( mTopColumnIdx    ȭ ̴ ÷ )
	unsigned int	mSelectedColumnIdx;

	///  õ row.  column
	unsigned int	mSelectedRow;
	unsigned int	mSelectedRowColumn; /// row  ÷

	///  
	unsigned int	mRowHeight;

	/// ִ 
	unsigned int	mMaxRowInPage;

	/// Ʈ  ϴ  
	unsigned int	mTotalMaxNum;

	/// üũ, üũ ؽ ġ
	cUIPos			mHighCheckPos;
	cUIPos			mHighNoCheckPos;
	cUIPos			mLowCheckPos;
	cUIPos			mLowNoCheckPos;

	/// ̹ Ŭ 
	unsigned int	mClickLowImgRow;
	unsigned int	mClickLowImgColumn; /// row  ÷

	///   
	unsigned int mColumnCount;

	///    ġ 
	unsigned int mRenderRow;
	unsigned int mRenderStartColumn;

	///   x ǥ 
	unsigned int mLowGap;
};

inline
void cListFolderBox::SetHighCheckPos( unsigned int texX, unsigned int texY )
{
	mHighCheckPos.mX = texX;
	mHighCheckPos.mY = texY;
}

inline
void cListFolderBox::SetHighNoCheckPos( unsigned int texX, unsigned int texY )
{
	mHighNoCheckPos.mX = texX;
	mHighNoCheckPos.mY = texY;
}

inline
void cListFolderBox::SetLowCheckPos( unsigned int texX, unsigned int texY )
{
	mLowCheckPos.mX = texX;
	mLowCheckPos.mY = texY;
}

inline
void cListFolderBox::SetLowNoCheckPos( unsigned int texX, unsigned int texY )
{
	mLowNoCheckPos.mX = texX;
	mLowNoCheckPos.mY = texY;
}

/////////////////////////////////////////////
/// Ʈ  ڽŲ
class cListFolderBoxSkin : public cUINodeSkin
{
public:
	cListFolderBoxSkin( eUINodeType type = eUINODE_LISTFOLDERBOX );
	virtual ~cListFolderBoxSkin();

	virtual bool Load( cParser& parser );
};