#include "stdafx.h"
#include "LoadUIManager.h"
#include "UIBackWindow.h"
#include "LoadingWindow.h"

#include "GameResourceManager.h"
#include "ResourceManager.h"
#include "RenderSystem.h"

cLoadUIManager::cLoadUIManager(void)
: mpBackWindow(0)
, mpLoadingWindow(0)
{
}

cLoadUIManager::~cLoadUIManager(void)
{
}

void cLoadUIManager::Init()
{
	UIMAN->SetCurrentStage( eStage_Load );

	/// ε  
	mpBackWindow = new cUIBackWindow;
	mpBackWindow->CreateByPropertyName( "P_LoadingBack", 0 );

	/// ε â 
	mpLoadingWindow = new cLoadingWindow;
	mpLoadingWindow->CreateByPropertyName( "P_LoadingWindow", 0 );

	mpBackWindow->SetOnlyBackground( true );
}

void cLoadUIManager::Exit()
{	
	mpLoadingWindow = 0;
	mpBackWindow = 0;
}

void cLoadUIManager::Open( unsigned long mapIdx )
{
	UIMAN->SetCurrentStage( eStage_Load );

	cString pathName;
	LPCTSTR texname = GAMERESOURCEMAN->GetMapLoadTexture( mapIdx );
	pathName.Format( "./Data/2DData/%s", texname );
	NiTexture* tex = RESOURCEMAN->LoadMapTexture( pathName, false );
	if( tex )
	{
		mpBackWindow->SetBackTexture( tex );
		RESOURCEMAN->ChangeStageImageTexture( tex );
	}

	mpBackWindow->SetEnabled( false );
	mpBackWindow->Show();

	mpLoadingWindow->InitGauge( 100.0f );
	mpLoadingWindow->ShowTop();
}

void cLoadUIManager::Close()
{
	UIMAN->SetCurrentStage( eStage_Load );

	mpBackWindow->SetEnabled( false );
	mpBackWindow->Hide();
	mpLoadingWindow->Hide();
	mpBackWindow->SetBackTexture( 0 );
}

void cLoadUIManager::Process()
{

}

bool cLoadUIManager::UpdateLoadingGauge( float inc, float curMax )
{
	assert(mpLoadingWindow);

	if( mpLoadingWindow->GetCurrentValue() <= curMax )
        mpLoadingWindow->IncreaseGaugeValue( inc );

	return mpLoadingWindow->IsGaugeEnd();
}
