#include "stdafx.h"
#include "LoadingWindow.h"
#include "StageManager.h"
#include "Gauge.h"
#include "UIImage.h"
#include "TipManager.h"
#include "ResourceManager.h"
#include "Label.h"

cLoadingWindow::cLoadingWindow()
: mpLoadGauge(0)
, mpTipImage(0)
, mpLogo(0)
{
}

cLoadingWindow::~cLoadingWindow()
{
	SAFE_DELETE( mpTipImage );
}

void cLoadingWindow::OnShow()
{
	cUIWindow::OnShow();

	/// ̹ 
	sLoadTipData* data = TIPMAN->GetLoadTipData();
	if( data )
	{
		cString path;
		path.Format("./Data/2DData/%s", data->mTexName.Cstr() );
		NiTexture* tex = RESOURCEMAN->LoadMapTexture( path, false );
		if( tex )
		{
			mpTipImage = new cUIImage( tex );
			unsigned int tx = data->mTexX;
			unsigned int ty = data->mTexY;
			unsigned int x = (unsigned int)((GetScreenWidth() - TIPIMG_W) * 0.5f);
			unsigned int y = mAbsoluteRect.mTop + 34;

			mpTipImage->SetTextureRect( tx, ty, tx + TIPIMG_W, ty + TIPIMG_H );
			mpTipImage->SetScreenRect( cUIRect( x, y, x + TIPIMG_W, y + TIPIMG_H ) );
		}
	}
}

void cLoadingWindow::OnHide()
{
	cUIWindow::OnHide();

	SAFE_DELETE( mpTipImage );
}

bool cLoadingWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpLoadGauge = new cGauge;
	((cUINode*)mpLoadGauge)->CreateBySkinName( "Loading_GaugeBar", this, 100 );

	mpLogo = new cLabel;
	mpLogo->CreateBySkinName( "Loding_Logo", this, 101 );

	///  
	SetRelativeSize( cUISize(GetScreenWidth(), mAbsoluteRect.GetHeight() ) );

	///  
	if( mpLoadGauge )
	{
		int x = (int)(( GetScreenWidth() - mpLoadGauge->GetAbsoluteRect().GetWidth() ) * 0.5f);
		int y = (int)( mpLoadGauge->GetRelativeRect().mTop );
		mpLoadGauge->SetRelativePos( cUIPos( x, y) );
	}

	if( mpLogo )
	{
		int x = (int)(( GetScreenWidth() - mpLogo->GetAbsoluteRect().GetWidth() ) * 0.5f);
		int y = (int)( mpLogo->GetRelativeRect().mTop );
		mpLogo->SetRelativePos( cUIPos( x, y) );
	}

	return true;
}

void cLoadingWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	///  
	SetRelativeSize( cUISize(GetScreenWidth(), mAbsoluteRect.GetHeight() ) );

	///  
	if( mpLoadGauge )
	{
		int x = (int)(( GetScreenWidth() - mpLoadGauge->GetAbsoluteRect().GetWidth() ) * 0.5f);
		int y = (int)( mpLoadGauge->GetRelativeRect().mTop );
		mpLoadGauge->SetRelativePos( cUIPos( x, y) );
	}

	if( mpLogo )
	{
		int x = (int)(( GetScreenWidth() - mpLogo->GetAbsoluteRect().GetWidth() ) * 0.5f);
		int y = (int)( mpLogo->GetRelativeRect().mTop );
		mpLogo->SetRelativePos( cUIPos( x, y) );
	}
}

void cLoadingWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mpTipImage )
		mpTipImage->Draw();

	cUIWindow::OnRender( pKeeper );
}

void cLoadingWindow::InitGauge( float maxValue )
{
	if( mpLoadGauge )
	{
		mpLoadGauge->ClearFront();
		mpLoadGauge->SetMaxValue( maxValue );
	}
}

float cLoadingWindow::GetCurrentValue()
{
	if( mpLoadGauge )
		return mpLoadGauge->GetValue();

	return 0.0f;
}

///
void cLoadingWindow::IncreaseGaugeValue( float value )
{
	if( mpLoadGauge )
	{
		float curValue = mpLoadGauge->GetValue() + value;

		if( curValue > mpLoadGauge->GetMaxValue() )
			curValue = mpLoadGauge->GetMaxValue();

		mpLoadGauge->SetGaugeNoAni( curValue );
	}
}

bool cLoadingWindow::IsGaugeEnd()
{
	if( mpLoadGauge == 0 )
		return true;
	if( mpLoadGauge->GetValue() >= mpLoadGauge->GetMaxValue() )
		return true;

	return false;
}
