#include "stdafx.h"
#include "LoginStage.h"
#include "LoginUIManager.h"
#include "StageManager.h"
#include "IntroStage.h"
#include "DramaturgyManager.h"

#include "UIMsgboxEvent.h"
#include "UIID.h"

#include "GameResourceManager.h"
#include "ObjectManager.h"
#include "worldmanager.h"
#include "SceneManager.h"
#include "StaticSceneNode.h"

#include "CameraManager.h"
#include "Application.h"

#ifdef _GMTOOL
#include "GMTool.h"
#endif

cLoginStage::cLoginStage()
: mpLoginUIManager(0)
{	
}

cLoginStage::~cLoginStage()
{
}

/// ǻ :
void cLoginStage::Init( cStageManager* pStageManager )
{	
	mpStageManager = pStageManager;
}

/// ǻ :
void cLoginStage::InitStage()
{
	if( mInit )	return;

	if( GAMERESOURCEMAN->InitLogin() == false )
	{
		assert(0);
	}

	/// UI
	mpLoginUIManager = new cLoginUIManager;
	mpLoginUIManager->Init();
	
#ifdef _GMTOOL
	if( THEAPP->InitGMTool() == false )
	{
		assert(0);
	}

	if( GMTOOL->LoadData() == false )
	{
		assert(0);
	}
#endif


	mInit = true;
}

/// ǻ :
void cLoginStage::Exit()
{
	GAMERESOURCEMAN->LoadEnd();

	SAFE_DELETE( mpLoginUIManager );
	mpStageManager = 0;
}

/// ǻ :
void cLoginStage::Open()
{
	if( !mpStageManager )	return;

	mLoadComplete = false;
	mCheckLoginComplete = false;

	OBJECTMAN->ClearHeroData();
	WORLDMAN->Close();	

	/// ui
	mpLoginUIManager->Open();

	if( GAMERESOURCEMAN->LoadInitData2() == false )
	{
		assert(0);
	}

//	SCENEMAN->Init( NiPoint3(1000.0f,1000.0f,1000.0f), 100.0f, 100000.0f );

#ifndef NOCONNECT_SERVER
	///   

//	if( NETWORK->PostConnect( "116.125.70.52", 14400 ) == false )
	if( NETWORK->PostConnect( THEAPP->GetIP(), 14400 ) == false )
	{
		///  ۾ ߰ ؾߵ.
		assert(0);
		mpLoginUIManager->Close();
		return;
	}

	///  â 
	UIMAN->CreateModal( eStage_Login,
		eMBEVENT_CONNECT_LOGINSRV, 
		GAMERESOURCEMAN->GetGameText( 0 ), //   ޼
		GAMERESOURCEMAN->GetGameText( 2 ), // ˸
		eSKIN_NONE
		);

#else
	/// Ʈp   ӽ÷ Ѵ κ
	mpStageManager->ChangeStage( eStage_Select );
#endif
}

/// ǻ :
void cLoginStage::Close()
{
	/// UI
	mpLoginUIManager->Close();
}

/// ǻ :
void cLoginStage::Process( unsigned long /*deltaTime*/, unsigned long accumTime )
{
	cIntroStage* intro = (cIntroStage*)STAGEMAN->GetStage( eStage_Intro );
	if( intro && intro->IsProcessEnd() )
	{
		unsigned int flag = GAMERESOURCEMAN->CheckInitData();
		if( flag == eData_Error )
		{
			assert(0);
			NiMessageBox( "Failed load gameData. Please reinstall client or patch.", "GameData Error" );
			::SendMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
			::PostQuitMessage(0);
			return;
		}
		else if( flag == eData_End )
		{
			mLoadComplete = true;
			GAMERESOURCEMAN->LoadEnd();
		}
	}

	if( mLoadComplete == true && mCheckLoginComplete == true )
	{
		///  ó
		UIMAN->ModalEventFromGameSystem( true );

		///  
		STAGEMAN->ChangeStage( eStage_Server );
	}

	/// UI
	mpLoginUIManager->Process( accumTime );
}

/// ǻ :
void cLoginStage::NetworkMsgParser( unsigned long , char* pMsg, unsigned long /*length*/ )
{
	/// 070403 ߰ - ö [α   -  / ]
	MSGROOT* pMsgRoot = (MSGROOT*)pMsg;

	switch( pMsgRoot->Category )
	{
	case NM_USER:
		{
			switch( pMsgRoot->Protocol )
			{
			case NM_USER_LOGIN_RES:
				{
					MSG_DIST_USERINFO* pMsgDistUserinfo = (MSG_DIST_USERINFO*)pMsgRoot;
					
					mpLoginUIManager->SetSendLoginFlag( false );

					if( pMsgDistUserinfo->ErrorCode == ERROR_DIST_USERINFO_SUCCESS )
					{
						/// 
						STAGEMAN->SetUserIdx( pMsgDistUserinfo->UserIdx );
						STAGEMAN->SetLoginIdx( pMsgDistUserinfo->LoginIdx );

						mCheckLoginComplete = true;
						if( mLoadComplete == true )
						{
							///  ó
							UIMAN->ModalEventFromGameSystem( true );

							///  
							STAGEMAN->ChangeStage( eStage_Server );
						}
					}
					else
					{
						///     Ѵ.
						UIMAN->ModalEventFromGameSystem( false );

						/// ο   .
						LPCTSTR msg;
						switch( pMsgDistUserinfo->ErrorCode )
						{
						case ERROR_DIST_USERINFO_ID_PWD: /// -ID/PWD
							msg = GAMERESOURCEMAN->GetGameText(5);
							break;
						case ERROR_DIST_USERINFO_SLEVEL: /// -ȵ 
							msg = GAMERESOURCEMAN->GetGameText(6);
							break;
						case ERROR_DIST_USERINFO_BLOCK:  /// -BLOCK 
							msg = GAMERESOURCEMAN->GetGameText(7);
							break;
						case ERROR_DIST_USERINFO_EXISTS: /// -
							msg = GAMERESOURCEMAN->GetGameText(8);
							break;
						case ERROR_DIST_USERINFO_FAIL:	/// 
							msg = GAMERESOURCEMAN->GetGameText(183);
							break;
						default:
							return;
						};

						if( pMsgDistUserinfo->ErrorCode == 3 )
						{
							/// ߺ αο  Ȯ
							UIMAN->CreateModal( eStage_Login, eMBEVENT_DOUBLE_LOGIN, msg, GAMERESOURCEMAN->GetGameText(2), eSKIN_YESNO );
						}
						else if( pMsgDistUserinfo->ErrorCode == 2 )
						{
							///    Ȯ
							UIMAN->CreateModal( eStage_Login, eMBEVENT_PWD_FAIL, msg, GAMERESOURCEMAN->GetGameText(2), eSKIN_OK );
						}
						else
						{
							UIMAN->CreateModal( eStage_Login, eMBEVENT_LOGIN_ERROR, msg, GAMERESOURCEMAN->GetGameText(2), eSKIN_OK );
						}

					}
				}
				break;
			}
		}
		break;
	}
}

void cLoginStage::MsgBoxEventParser( unsigned int event, unsigned int result, void* /*exData*/ )
{
	switch( event )
	{
	case eMBEVENT_LOGIN_ERROR:
		{
			mpLoginUIManager->FocusIDEdit();
		}
		break;
	case eMBEVENT_PWD_FAIL:
		{
			mpLoginUIManager->FocusPassEdit();
		}
		break;
	case eMBEVENT_DOUBLE_LOGIN:
		{
			if( result == eMESSAGE_BUTTON_YES )
			{
				///    ϴ ƾ ִ´.
			}
			else
			{
				///   Ѵ.
				mpLoginUIManager->FocusIDEdit();
			}
		}
		break;
	case eMBEVENT_CONNECT_LOGINSRV:
		{
			if( result == eMESSAGE_BUTTON_YES )
			{
				/// 
				mpLoginUIManager->Visible();
			}
//			else
//			{
				/// н
				///    ٴ ޼  
//			}
		}
		break;
	case eMBEVENT_CONNECT_DEAD:
	case eMBEVENT_CONNECT_LOGINFAILE:
		{
			::SendMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
			::PostQuitMessage(0);
		}
		break;
	}

}

void cLoginStage::CreateLoginMap()
{
	///  
	cStaticSceneNodeParam param;

	/// ⺻ Ӽ ڵ 
	param.mPathName = "./Map/MapBegin/character_select_bg.nif";
	param.mOccludeLevel = 3;
	param.mNoAttachLight = true;
	param.mFogApplied = false;
	param.mDisableAnimation = false;

	///  ʱȭ
	SCENEMAN->Init( NiPoint3::ZERO, 100.0f, 100000.0f );

	/// 带 
	cStaticSceneNode* n = SCENEMAN->CreateStatic( param );
	if( n == 0 )
		return;

	NiNode* orien = NiDynamicCast( NiNode, n->GetNiObj()->GetObjectByName("SelectCamera") );
	if( orien == 0 )
	{
		assert(0);
		return;
	}

	NiAVObject* child = 0;
	NiCamera* cam = 0;
	for(unsigned int i=0;i<orien->GetArrayCount();i++)
	{
		child = orien->GetAt(i);
		if( child && NiIsKindOf( NiCamera, child ) == true )
		{
			cam = (NiCamera*)child;
			break;
		}
	}
	if( cam == 0 )
	{
		assert(0);
		return;
	}

	CAMERAMAN->GetCurrent()->ChangeNiCamera( NiSmartPointerCast( NiCamera, cam->CreateDeepCopy() ) );

	NiNode* node = CAMERAMAN->GetCurrent()->GetOrientNode();
	node->SetWorldTranslate( orien->GetWorldTranslate() );
	node->SetWorldRotate( orien->GetWorldRotate() );
	node->SetWorldScale( orien->GetWorldScale() );
	node->SetLocalTransform( orien->GetLocalTransform() );
}
