#include "stdafx.h"
#include "LoginWindow.h"
#include "StageManager.h"
#include "BaseStage.h"

#include "EditBox.h"
#include "Button.h"
#include "UIMsgboxEvent.h"
#include "Application.h"
#include "UIImage.h"

cLoginWindow::cLoginWindow()
: mpLogoImage(0)
, mpID(0)
, mpPass(0)
, mpConnect(0)
, mSendLogin( false )
, mpLogoSkin(0)
{
}

cLoginWindow::~cLoginWindow()
{
	SAFE_DELETE( mpLogoImage );
}

void cLoginWindow::UIStageIn()
{
	/// COPY & PASTE  .
	if( mpID )
		mpID->SetCopyPaste( false );

	if( mpPass )
	{
		mpPass->SetCopyPaste( false );	
		mpPass->Clear();
	}
	
	mSendLogin = false;

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = GetRelativeRect().mTop;
	SetRelativePos( cUIPos( x, y) );
}

bool cLoginWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	///   ..
	mpID = (cEditBox*)GetChild( eUIID_LOGIN_ID_EDIT );
	mpPass = (cEditBox*)GetChild( eUIID_LOGIN_PASS_EDIT );
	mpConnect = (cButton*)GetChild( eUIID_LOGIN_CONNECT_BUTTON );

	/// ΰ ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	mpLogoSkin = pSkin->GetNodeSkin( "Login_Logo" );
	if( mpLogoSkin )
	{
		mpLogoImage = new cUIImage( mpLogoSkin->mpTexture );
		unsigned int x = (int)(( GetScreenWidth() - mpLogoSkin->mSkinInfo->mWidth ) * 0.5f);
		unsigned int y = mpLogoSkin->mSkinInfo->mY;
		unsigned int tx = mpLogoSkin->mSkinInfo->mTexX;
		unsigned int ty = mpLogoSkin->mSkinInfo->mTexY;
		unsigned int w = mpLogoSkin->mSkinInfo->mWidth;
		unsigned int h = mpLogoSkin->mSkinInfo->mHeight;
		mpLogoImage->SetTextureRect( cUIRect( tx, ty, tx + w, ty + h ) );
		mpLogoImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}
	return true;
}

void cLoginWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	if( mpLogoSkin && mpLogoImage )
	{
		/// ȭ ߾ӿ 
		unsigned int x = (int)(( GetScreenWidth() - mpLogoSkin->mSkinInfo->mWidth ) * 0.5f);
		unsigned int y = mpLogoSkin->mSkinInfo->mY;
		mpLogoImage->SetPos( x, y );
	}

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = GetRelativeRect().mTop;
	SetRelativePos( cUIPos( x, y) );
}

void cLoginWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mpLogoImage )
		mpLogoImage->Draw();
}

void cLoginWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_LOGIN_CONNECT_BUTTON:
		{
			SendLoginMsg();
		}
		break;
	case eUIID_LOGIN_CANCEL_BUTTON:
		{
			/// α׷ 
			::SendMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
			::PostQuitMessage(0);
		}
		break;
	}
	return;
}

void cLoginWindow::OnEditBoxEntered( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_LOGIN_ID_EDIT:
		{
			mpPass->SetFocus();
		}
		break;
	case eUIID_LOGIN_PASS_EDIT:
		{
			/// text  ϸ  
			if( mpID && mpPass )
			{
				if( mpID->IsText() && mpPass->IsText() )
				{
					SendLoginMsg();
				}
			}
		}
		break;
	}
}

void cLoginWindow::SendLoginMsg()
{
	if( NETWORK->IsConnected() == false )
	{
		assert(0);
		return;
	}

	/// Ʈ ü Ŀ ..
	mpID->ReleaseFocus();
	mpPass->ReleaseFocus();

	mSendLogin = true;

	/// 070403 ߰ - ö [α  û]
	MSG_IDPASS msg;
	::memset( &msg, 0, sizeof(msg) );

	msg.Category = NM_USER;
	msg.Protocol = NM_USER_LOGIN_REQ;

	ConvertToAscii( mpID->GetText(), msg.uid, MAX_ID_BUFFER_SIZE );
	ConvertToAscii( mpPass->GetText(), msg.pwd, MAX_PASS_BUFFER_SIZE );

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	///  â ..
	UIMAN->CreateModal( eStage_Login,
		eMBEVENT_NONE, 
		GAMERESOURCEMAN->GetGameText( 4 ), //  ó 
		GAMERESOURCEMAN->GetGameText( 2 ), // ˸
		eSKIN_NONE
		);
}

/// 
void cLoginWindow::ClearID( bool focus )
{
	if( mpID )
	{
		mpID->Clear();

		if( focus )
			mpID->SetFocus();
	}
}

/// 
void cLoginWindow::ClearPass( bool focus )
{
	if( mpPass )
	{
		mpPass->Clear();

		if( focus )
			mpPass->SetFocus();
	}
}

// 
void cLoginWindow::SetSendLoginFlag( bool set )
{
	mSendLogin = set;
}

/// 
void cLoginWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mVisible == false )
		return;

	if( mpID && mpPass && mpConnect )
	{
		/// ؽƮ ִ  ư Ȱȭ  
		if( !mSendLogin && mpID->IsText() && mpPass->IsText() )
			mpConnect->SetEnabled( true );
		else
			mpConnect->SetEnabled( false );
	}
}

void cLoginWindow::OnShow()
{
	if( mpID )
		mpID->SetFocus();

	///
	cUIWindow::OnShow();
}
