#include "StdAfx.h"
#include "LootingListBox.h"
#include "ListBox.h"
#include "UIImageFont.h"
#include "FontAgent.h"
#include "LootingWindow.h"
#include "ItemManager.h"

cLootingListBox::cLootingListBox( eUINodeType type )
: cListBox( type )
{

}

cLootingListBox::~cLootingListBox()
{

}

/// ǻ : Ʈ  ׷ֱ
void cLootingListBox::RenderData( cUIFontItemKeeper* pKeeper )
{
	/// ü Ʈ  
	if( GetRowCount() <= 0 )
		return;

	/// Ų ޾ƿ 
	cListBoxSkin* pListSkin = (cListBoxSkin*)mpSkin;
	if( !pListSkin )
	{
		assert(0);
		return;
	}

	/// Ʈ ڽ ǥ ޾ƿ
	int textposX = 0;
	int textPosY = GetAbsoluteRect().mTop + 1;

	unsigned int rowCount = ( mMaxRowInPage > GetRowCount() )? GetRowCount() : mMaxRowInPage;
	for( unsigned int row = mTopRowIdx; row < mTopRowIdx + rowCount; ++row )
	{
		sRowData* rData = GetRowData( row );
		if( !rData )
			continue;

		/// image  
		if( rData->mImage )
		{
			cUIImage* image = rData->mImage;
			sListCtrlParam* pParam = pListSkin->mpImgParam;
			unsigned int imageX = pParam->mColumnX;
			unsigned int imageY = textPosY + (int)((mRowHeight-image->GetHeight())*0.5f);

			image->SetPos( GetAbsoluteRect().mLeft + imageX, imageY );
			image->Draw();

			/// ̹Ʈ  ( øƮ )
			sLootData* lootData = (sLootData*)GetExtraData( row );
			if( lootData )
			{
				cItemDefine* define = ITEMMAN->GetItemDefine( lootData->itemDefineIndex );
				if( !define )
					continue;

				/// ħ ϸ 
				if( define->GetCapacity() > 1 )
				{
					cString Number;
					Number.Format( "%d", lootData->count );

					cUIImageFont* font = lootData->mFont;

					int right = GetAbsoluteRect().mLeft + imageX + image->GetWidth();
					int bottom = imageY + image->GetHeight();
					font->DrawText( right - 1 - font->GetTextWidth(lootData->count), bottom -1 - font->GetTextHeight(), Number.Cstr() );
				}
			}
		}

		/// Ʈ  
		unsigned int colCount = rData->mColumes.GetSize();
		for( unsigned int col = 0; col< colCount; ++col )
		{
			///  ÷  
			sData* data = rData->mColumes[col];

			///  ÷ param data  ( ġ  )
			sListCtrlParam* pParam = pListSkin->GetCtrlParam( col );

			unsigned int tX = 0;
			unsigned int tW = 0;
			eText_Align align = eALIGN_LEFT;

			if( pParam )
			{
				tX = pParam->mColumnX;
				tW = pParam->mColumnW;
				align = pParam->mAlign;
			}

			///   ǥ  
			unsigned int strWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, (LPTSTR)data->mText.Cstr(), data->mText.GetLength() );
			textposX = UpdateTextPos( align, strWidth, tX, tW );

			/// ̹  ؽƮ yġ 缳
			unsigned color = data->mTextColor;
			if( mHoveredRowIdx != -1 && row - mTopRowIdx == (unsigned int)mHoveredRowIdx )
				color = eCOLOR_RED;

			int addY = (int)((mRowHeight-FONTAGENT->GetTextHeight(cFontAgent::eFont_UI))*0.5f);
			pKeeper->AddFontItem( cFontAgent::eFont_System, (LPTSTR)data->mText.Cstr(), textposX, textPosY + addY, color );
		}

		textPosY += mRowHeight;
	}

}