#include "StdAfx.h"
#include "LootingWindow.h"
#include "ListBox.h"
#include "ItemManager.h"
#include "UIImage.h"
#include "ItemIcon.h"
#include "TipWindow.h"
#include "GameUIManager.h"
#include "Button.h"
#include "GameResourceManager.h"
#include "UIMsgboxEvent.h"

cLootingWindow::cLootingWindow()
: mpItemList(0)
, mSelecetRow(0)
, mpGetButton(0)
, mpCloseButton(0)
{

}
cLootingWindow::~cLootingWindow()
{
	///    
	cItemLootList::cIterator i = mItemLootList.Begin();
	cItemLootList::cIterator end = mItemLootList.End();
	for( ; i != end; ++i )
	{
		sLootData* data = (sLootData*)(*i);
		if( data && data->mpImage )
			SAFE_DELETE( data->mpImage );
		SAFE_DELETE( data );
	}
	mItemLootList.Clear();
}

void cLootingWindow::Clear()
{
	UIMAN->HideTip();

	///    
	cItemLootList::cIterator i = mItemLootList.Begin();
	cItemLootList::cIterator end = mItemLootList.End();
	for( ; i != end; ++i )
	{
		sLootData* data = (sLootData*)(*i);
		if( data && data->mpImage )
			SAFE_DELETE( data->mpImage );
		SAFE_DELETE( data );
	}
	mItemLootList.Clear();

	if( mpItemList )
		mpItemList->Clear();
}

bool cLootingWindow::AddItem( sLootData* data, bool addlootlist )
{
	if( !data )
	{
		assert(0);
		return false;
	}

	cItemDefine* itemDefine = ITEMMAN->GetItemDefine( data->itemDefineIndex );
	if( itemDefine == 0 )
	{
		assert(0);
		return false;
	}

	/// ó  Ʈ ö Ѵ.
	sLootData* p = 0;
	if( addlootlist == true )
	{
		cUIImageFont* pFont = UIMAN->GetImageFont( 0 );
		if( pFont )
		{
			p = new sLootData;
			p->itemDefineIndex = data->itemDefineIndex;
			p->count = data->count;
			p->mFont = pFont;
			mItemLootList.PushBack( p );
		}
	}

	cIconParam* iconParam = itemDefine->GetIconParam();
	if( iconParam == 0 )
	{
		assert(0);
		return false;
	}

	if( !mpItemList )
		return false;

	///  ̹ 
	cUIImage* pImage = new cUIImage( iconParam->mpTexture );
	if( pImage )
	{
		unsigned int tx = iconParam->mTexPos.mX;
		unsigned int ty = iconParam->mTexPos.mY;
		pImage->SetTextureRect( tx, ty, tx + ICONSIZE, ty + ICONSIZE );
		cUIRect desc( 0, 0, ICONSIZE, ICONSIZE ); 
		pImage->SetScreenRect( desc );

		/// ̸  
		TCHAR name[ITENNAME_LEN] = {0,};
		bool ret = ITEMMAN->ModifyItemName( itemDefine->GetName(), name );

		///  
		sLootData* lootData = ( addlootlist ) ? p : data;
		lootData->mpImage = pImage;

		if( ret == true )
			mpItemList->AddRow( name, mDefaultColor, lootData, pImage );
		else
			mpItemList->AddRow( itemDefine->GetName(), mDefaultColor, lootData, pImage );
	}
	return true;
}

void cLootingWindow::OnShow()
{
	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.5f);

	SetRelativePos( cUIPos( x, y) );

	cUIWindow::OnShow();
}

void cLootingWindow::Close()
{
	/// 츸 ݱ 
	SetVisible( false );
	UIMAN->HideTip();

	///
	NetUnLock( eLOCK_CLOSE );

	cUIWindow::OnHide();
}

void cLootingWindow::OnHide()
{
	UIMAN->HideTip();

	/// ݱ û
	MSG_REQ_ITEM_GET_CLOSE msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_ITEM;
	msg.Protocol = NM_ITEM_GET_CLOSE_REQ;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	///  ɱ
	NetLock( eLOCK_CLOSE );

	cUIWindow::OnHide();
}

void cLootingWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.5f);

	SetRelativePos( cUIPos( x, y) );
}

bool cLootingWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpItemList = (cListBox*)GetChild( eUIID_GAME_LOOTING_LIST );
	mpGetButton = (cButton*)GetChild( eUIID_GAME_LOOTING_ALL );
	mpCloseButton = (cButton*)GetChild( eUIID_GAME_LOOTING_CLOSE );
	return true;
}

/// ǻ : 
void cLootingWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_LOOTING_CLOSE:
		Hide();
		break;
	case eUIID_GAME_LOOTING_ALL:
		{
			/// ü  ó
			/// ŷҰ  ˻
			cItemLootList::cIterator i = mItemLootList.Begin();
			cItemLootList::cIterator end = mItemLootList.End();
			for( ; i != end; ++i )
			{
				sLootData* data = (sLootData*)(*i);
				cItemDefine* define = ITEMMAN->GetItemDefine( data->itemDefineIndex );
				if( define && define->GetExchange() == 1 )	/// ŷҰ : 1
				{
					UIMAN->CreateModal(	eStage_Game,
										eMBEVENT_ITEM_NOTEXCHANGE_GET, 
										GAMERESOURCEMAN->GetGameText( 246 ),
										GAMERESOURCEMAN->GetGameText( 301 ),
										eSKIN_YESNO,
										(void*)ITEM_GET_ALL
										);
					return;
				}
			}

			mSelecetRow = 0;

			/// ü ȹ û
			ITEMMAN->TryToGetItem( (unsigned int)ITEM_GET_ALL, 0 );
		}
		break;
	default:
		assert(0);
		return;
	}
}

sLootData* cLootingWindow::GetSelectData()
{
	sLootData* data = (sLootData*)mpItemList->GetExtraData( mSelecetRow );
	return data;
}

///
void cLootingWindow::OnListBoxSelected( cUINode*, unsigned int )
{
	/// ڵ̸ ̺Ʈ 
	if( !mpItemList )
		return;

	/// Ʈκ 
	mSelecetRow = mpItemList->GetSelectIndex();
	sLootData* data = (sLootData*)mpItemList->GetExtraData( mSelecetRow );
	cItemDefine* define = ITEMMAN->GetItemDefine( data->itemDefineIndex );
	if( data && define )
	{
		/// ŷ
		if( define->GetExchange() == 0 )
			ITEMMAN->TryToGetItem( data->itemDefineIndex, data->count );
		else
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_ITEM_NOTEXCHANGE_GET, 
								GAMERESOURCEMAN->GetGameText( 246 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_YESNO
								);
		}
	}
}

///
void cLootingWindow::OnListBoxImageHorvered(cUINode*, unsigned int, const cUIPos& pos, void* extraData )
{
	sLootData* data = (sLootData*)extraData;
	if( data )
        UIMAN->ShowItemTip( eTIP_ITEM, pos, data->itemDefineIndex, UINT_MAX, 0 );
}

///
void cLootingWindow::OnListBoxImageLeft(cUINode* , unsigned int )
{
	UIMAN->HideTip();
}

float cLootingWindow::GetWeight()
{
	float weight = 0;

	cItemLootList::cIterator i = mItemLootList.Begin();
	cItemLootList::cIterator end = mItemLootList.End();
	for( ; i != end; ++i )
	{
		sLootData* data = (sLootData*)(*i);

		cItemDefine* define = ITEMMAN->GetItemDefine( data->itemDefineIndex );
		if( define )
		{
			weight += ( data->count * define->GetWeight() );	
		}
	}

	return weight;
}

void cLootingWindow::OnNetLock( int lockTry )
{
	if( lockTry == eLOCK_CLOSE )
	{
		if( mpCloseButton )
			mpCloseButton->NetLock( lockTry );
	}
	else if( lockTry == eLOCK_GETITEM )
	{
		if( mpGetButton )
			mpGetButton->NetLock( lockTry );
	}
}

void cLootingWindow::OnNetUnLock( int lockTry )
{
	if( lockTry == eLOCK_CLOSE )
	{
		if( mpCloseButton )
			mpCloseButton->NetUnLock( lockTry );
	}
	else if( lockTry == eLOCK_GETITEM )
	{
		if( mpGetButton )
			mpGetButton->NetUnLock( lockTry );
	}
}
