#include "stdafx.h"
#include "MakeWindow.h"
#include "StageManager.h"
#include "MakeStage.h"

#include "UIImage.h"
#include "EditBox.h"
#include "SpinBox.h"
#include "Label.h"
#include "Button.h"
#include "GameResourceManager.h"
#include "Player_Common.h"
#include "UIImage.h"

#include "UIMsgboxEvent.h"
#include "StatusScript.h"

cMakeRotateWindow::cMakeRotateWindow()
: mpButtonBackImg(0)
, mpButtonSkin(0)
, mpRotateRight(0)
, mpRotateLeft(0)
{

}

cMakeRotateWindow::~cMakeRotateWindow()
{
	SAFE_DELETE( mpButtonBackImg );
}

bool cMakeRotateWindow::OnCreate(cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpRotateRight = (cButton*)GetChild( eUIID_MAKE_RIGHTROTATE );
	mpRotateLeft = (cButton*)GetChild( eUIID_MAKE_LEFTROTATE );

	/// ȸư ̺Ʈ 
	if( mpRotateLeft && mpRotateRight )
	{
		mpRotateRight->SetContinueEvent( true );
		mpRotateLeft->SetContinueEvent( true );
	}

	/// ػ󵵿  ġ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	/// ư Ų ̹
	mpButtonSkin = pSkin->GetNodeSkin( "Make_Rotate_BackImage" );
	if( mpButtonSkin && mpButtonSkin->mpTexture )
	{
		mpButtonBackImg = new cUIImage( mpButtonSkin->mpTexture );
		unsigned int x = mpButtonSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpButtonSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		unsigned int tx = mpButtonSkin->mSkinInfo->mTexX;
		unsigned int ty = mpButtonSkin->mSkinInfo->mTexY;
		unsigned int w = mpButtonSkin->mSkinInfo->mWidth;
		unsigned int h = mpButtonSkin->mSkinInfo->mHeight;
		mpButtonBackImg->SetTextureRect( cUIRect( tx, ty, tx + w, ty + h ) );
		mpButtonBackImg->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}
	return true;
}

void cMakeRotateWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	if( mpButtonSkin && mpButtonBackImg )
	{
		unsigned int x = mpButtonSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpButtonSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpButtonBackImg->SetPos( x, y );
	}
}

void cMakeRotateWindow::OnRender(cUIFontItemKeeper* pKeeper )
{
	if( mpButtonBackImg )
		mpButtonBackImg->Draw();

	cUIWindow::OnRender( pKeeper );
}

void cMakeRotateWindow::OnCommand(cUINode* , unsigned int id )
{
	switch( id )
	{
	case eUIID_MAKE_LEFTROTATE:
		{
			///  ȸ
			/// ȭ
			cMakeStage* p = (cMakeStage*)STAGEMAN->GetStage( eStage_Make );
			if( p )
				p->RotateMakeCharacter( -20 );
		}
		break;
	case eUIID_MAKE_RIGHTROTATE:
		{
			///  ȸ
			/// ȭ
			cMakeStage* p = (cMakeStage*)STAGEMAN->GetStage( eStage_Make );
			if( p )
				p->RotateMakeCharacter( 20 );
		}
		break;
	}
}


/// ư    ߻
void cMakeRotateWindow::OnButtonContinueDowned( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_MAKE_LEFTROTATE:
		{
			///  ȸ
			/// ȭ
			cMakeStage* p = (cMakeStage*)STAGEMAN->GetStage( eStage_Make );
			if( p )
				p->RotateMakeCharacter( -5 );
		}
		break;
	case eUIID_MAKE_RIGHTROTATE:
		{
			///  ȸ
			/// ȭ
			cMakeStage* p = (cMakeStage*)STAGEMAN->GetStage( eStage_Make );
			if( p )
				p->RotateMakeCharacter( 5 );
		}
		break;
	default:
		assert(0);
		break;
	}
}


//------------------------------------------------------------------
cMakeInfoWindow::cMakeInfoWindow()
: mpMakeSelect(0)
, mRacePos(0, 0)
, mJobPos(0, 0)
, mCurrentRace(0)
, mCurrentJob(0)
, mpRaceSkin(0)
, mpJobSkin(0)
{
	::memset( mpRaceImage, 0, sizeof(mpRaceImage) );
	::memset( mpJobImage, 0, sizeof(mpJobImage) );
}

cMakeInfoWindow::~cMakeInfoWindow()
{
	for( int i = 0; i < MAX_RACE; ++i )
		SAFE_DELETE( mpRaceImage[i] );

	for( int i = 0; i < MAX_JOB; ++i )
		SAFE_DELETE( mpJobImage[i] );
}

void cMakeInfoWindow::UIStageIn()
{
	SetExceptEvent( true );
}

///
bool cMakeInfoWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMakeSelect = (cButton*)GetChild( eUIID_MAKE_SELECT );

	/// ػ󵵿   
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	/*cUINodeSkin* winSkin = pSkin->GetNodeSkin( mSkinName );
	if( winSkin )
	{
		int x = ( GetScreenWidth() * winSkin->mSkinInfo->mX ) / mDefaultWidth;
		int y = ( GetScreenHeight() * winSkin->mSkinInfo->mY ) / mDefaultHeight;
		int w = ( GetScreenWidth() * winSkin->mSkinInfo->mWidth ) / mDefaultWidth;
		int h = ( GetScreenHeight() * winSkin->mSkinInfo->mHeight ) / mDefaultHeight;

		SetRelativeRect( cUIRect( x, y, x+w, y+h) );
	}

	if( mpMakeSelect )
	{
		cUINodeSkin* pskin = pSkin->GetNodeSkin( mpMakeSelect->GetSkinName() );
		if( pskin )
		{
			int x = ( GetScreenWidth() * pskin->mSkinInfo->mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * pskin->mSkinInfo->mY ) / mDefaultHeight;
			mpMakeSelect->SetRelativePos( cUIPos( x, y ) );
		}
	}*/

	///  ̹ 
	cString str;
	for( int i = 0; i < MAX_RACE; ++i )
	{
		str.Format( "MakeInfo_Race%02d", i );
		mpRaceSkin = pSkin->GetNodeSkin( str );
		if( mpRaceSkin )
		{
			mpRaceImage[i] = new cUIImage( mpRaceSkin->mpTexture );
			unsigned int x = mpRaceSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			unsigned int y = mpRaceSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
			unsigned int tx = mpRaceSkin->mSkinInfo->mTexX;
			unsigned int ty = mpRaceSkin->mSkinInfo->mTexY;
			unsigned int w = mpRaceSkin->mSkinInfo->mWidth;
			unsigned int h = mpRaceSkin->mSkinInfo->mHeight;
			mpRaceImage[i]->SetTextureRect( cUIRect( tx, ty, tx + w, ty + h ) );
			mpRaceImage[i]->SetScreenRect( cUIRect( x, y, x + w, y + h ) );

			mRacePos.mX = mpRaceSkin->mSkinInfo->mX;
			mRacePos.mY = mpRaceSkin->mSkinInfo->mY;
		}
	}

	///  ̹ 
	for( int i = 0; i < MAX_JOB; ++i )
	{
		str.Format( "MakeInfo_Job%02d", i );
		mpJobSkin = pSkin->GetNodeSkin( str );
		if( mpJobSkin )
		{
			mpJobImage[i] = new cUIImage( mpJobSkin->mpTexture );
			unsigned int x = mpJobSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			unsigned int y = mpJobSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
			unsigned int tx = mpJobSkin->mSkinInfo->mTexX;
			unsigned int ty = mpJobSkin->mSkinInfo->mTexY;
			unsigned int w = mpJobSkin->mSkinInfo->mWidth;
			unsigned int h = mpJobSkin->mSkinInfo->mHeight;
			mpJobImage[i]->SetTextureRect( cUIRect( tx, ty, tx + w, ty + h ) );
			mpJobImage[i]->SetScreenRect( cUIRect( x, y, x + w, y + h ) );

			mJobPos.mX = mpJobSkin->mSkinInfo->mX;
			mJobPos.mY = mpJobSkin->mSkinInfo->mY;
		}
	}
	
	return true;
}

void cMakeInfoWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ػ󵵿   
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	for( int i = 0; i < MAX_RACE; ++i )
	{
		if( mpRaceImage[i] )
		{
			int x = mpRaceSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			int y = mpRaceSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
			mpRaceImage[i]->SetPos( x, y );
		}
	}

	for( int i = 0; i < MAX_JOB; ++i )
	{
		if( mpJobImage[i] )
		{
			int x = mpJobSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			int y = mpJobSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
			mpJobImage[i]->SetPos( x, y );
		}
	}

	/*cUINodeSkin* winSkin = pSkin->GetNodeSkin( mSkinName );
	if( winSkin )
	{
		int x = ( GetScreenWidth() * winSkin->mSkinInfo->mX ) / mDefaultWidth;
		int y = ( GetScreenHeight() * winSkin->mSkinInfo->mY ) / mDefaultHeight;
		int w = ( GetScreenWidth() * winSkin->mSkinInfo->mWidth ) / mDefaultWidth;
		int h = ( GetScreenHeight() * winSkin->mSkinInfo->mHeight ) / mDefaultHeight;

		SetRelativeRect( cUIRect( x, y, x+w, y+h) );
	}

	if( mpMakeSelect )
	{
		cUINodeSkin* pskin = pSkin->GetNodeSkin( mpMakeSelect->GetSkinName() );
		if( pskin )
		{
			int x = ( GetScreenWidth() * pskin->mSkinInfo->mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * pskin->mSkinInfo->mY ) / mDefaultHeight;
			mpMakeSelect->SetRelativePos( cUIPos( x, y ) );
		}
	}*/

	/*for( int i = 0; i < MAX_RACE; ++i )
	{
		if( mpRaceImage[i] )
		{
			int x = ( GetScreenWidth() * mRacePos.mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * mRacePos.mY ) / mDefaultHeight;
			mpRaceImage[i]->SetPos( x, y );
		}
	}

	for( int i = 0; i < MAX_JOB; ++i )
	{
		if( mpJobImage[i] )
		{
			int x = ( GetScreenWidth() * mJobPos.mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * mJobPos.mY ) / mDefaultHeight;
			mpJobImage[i]->SetPos( x, y );
		}
	}*/
}

void cMakeInfoWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mpRaceImage[mCurrentRace] )
		mpRaceImage[mCurrentRace]->Draw();

	if( mpJobImage[mCurrentJob] )
		mpJobImage[mCurrentJob]->Draw();

}

void cMakeInfoWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_MAKE_SELECT:
		/// ȭ
		STAGEMAN->ChangeStage( eStage_Select );
		break;
	default:
		assert(0);
		break;
	}
}

///  ̹ 
void cMakeInfoWindow::UpdateRaceImage( int i )
{
	if( i < MAX_RACE )
		mCurrentRace = i;
}

///  ̹ 
void cMakeInfoWindow::UpdateJobImage( int i )
{
	if( i < MAX_JOB )
		mCurrentJob = i;
}

//////////////////////////////////////////////
cMakeWindow::cMakeWindow()
: mpName(0)
, mpHairSpin(0)
, mpFaceSpin(0)
, mpGenderSpin(0)
, mpRaceSpin(0)
, mpJobSpin(0)
, mpCreate(0)
, mUpdaetSize(0, 0)
, mpInfoWindow(0)
{
}

cMakeWindow::~cMakeWindow()
{
}

void cMakeWindow::UIStageIn()
{
	SetExceptEvent( true );
}

void cMakeWindow::OnShow()
{
	if( mpName )
	{
		mpName->Clear();
		mpName->SetFocus();
	}

	if( mpJobSpin )
	{
		mpJobSpin->Clear();

		mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1010 ), (void*)ePLAYER_FIGHTER );
		mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1015 ), (void*)ePLAYER_MAGE );
	}

	mDisplayUpdate = false;

	cUIWindow::OnShow();
}

void cMakeWindow::OnHide()
{
	cUIWindow::OnHide();

	ResetSpinBox();
}

void cMakeWindow::SetEnableCreate( bool enable )
{
	if( mpCreate )
		mpCreate->SetEnabled( enable );
}

///
bool cMakeWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	cUINode* n = GetChild( eUIID_MAKE_BACK );
	n->SetEnabled( false );

	mpName = (cEditBox*)GetChild( eUIID_MAKE_NAMEEDIT );
	mpHairSpin = (cSpinBox*)GetChild( eUIID_MAKE_HAIR_SPIN );
	mpFaceSpin = (cSpinBox*)GetChild( eUIID_MAKE_FACE_SPIN );
	mpGenderSpin = (cSpinBox*)GetChild( eUIID_MAKE_GENDER_SPIN );
	mpRaceSpin = (cSpinBox*)GetChild( eUIID_MAKE_RACE_SPIN );
	mpJobSpin = (cSpinBox*)GetChild( eUIID_MAKE_JOB_SPIN );
	mpCreate = GetChild( eUIID_MAKE_CREATE );
		
	/// ̸Ʈ copy & paste  
	if( mpName )
	{
		mpName->SetTextColor( eCOLOR_WHITE );
		mpName->SetCopyPaste( false );
	}

	/// Ӹ &   Ѵ.
	unsigned int hairCnt = GAMERESOURCEMAN->GetDefaultHairCount();
	unsigned int faceCnt = GAMERESOURCEMAN->GetDefaultFaceCount();

	///  700  
	for( unsigned int i=0; i<hairCnt; ++i )
	{
		if( mpHairSpin )
			mpHairSpin->AddData( GAMERESOURCEMAN->GetGameText( 700 + i ) );
	}

	///  720  
	for( unsigned int i=0; i<faceCnt; ++i )
	{
		if( mpFaceSpin )
			mpFaceSpin->AddData( GAMERESOURCEMAN->GetGameText( 720 + i ) );
	}

	///  744  
	if( mpRaceSpin )
	{
		mpRaceSpin->AddData( GAMERESOURCEMAN->GetGameText( 744 ) );
		mpRaceSpin->AddData( GAMERESOURCEMAN->GetGameText( 745 ) );
		mpRaceSpin->AddData( GAMERESOURCEMAN->GetGameText( 746 ) );
	}

	if( mpJobSpin )
	{
		mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1010 ), (void*)ePLAYER_FIGHTER );
		mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1015 ), (void*)ePLAYER_MAGE );
	}

	if( mpGenderSpin )
	{
		mpGenderSpin->AddData( GAMERESOURCEMAN->GetGameText( 747 ) );
		mpGenderSpin->AddData( GAMERESOURCEMAN->GetGameText( 748 ) );
	}

	/// ػ󵵿  ġ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	/*cUINodeSkin* winSkin = pSkin->GetNodeSkin( mSkinName );
	if( winSkin )
	{
		int x = ( GetScreenWidth() * winSkin->mSkinInfo->mX ) / mDefaultWidth;
		int y = ( GetScreenHeight() * winSkin->mSkinInfo->mY ) / mDefaultHeight;
		int w = ( GetScreenWidth() * winSkin->mSkinInfo->mWidth ) / mDefaultWidth;
		int h = ( GetScreenHeight() * winSkin->mSkinInfo->mHeight ) / mDefaultHeight;

		SetRelativeRect( cUIRect( x, y, x+w, y+h) );
	}

	if( mpCreate )
	{
		cUINodeSkin* pskin = pSkin->GetNodeSkin( mpCreate->GetSkinName() );
		if( pskin )
		{
			int x = ( GetScreenWidth() * pskin->mSkinInfo->mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * pskin->mSkinInfo->mY ) / mDefaultHeight;
			mpCreate->SetRelativePos( cUIPos( x, y ) );
		}
	}*/
	return true;
}

void cMakeWindow::UpdateRect()
{
	cUIWindow::UpdateRect();
}

void cMakeWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	///   
	/*cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	cUINodeSkin* winSkin = pSkin->GetNodeSkin( mSkinName );
	if( winSkin )
	{

	}*/
	/*{
		int x = ( GetScreenWidth() * winSkin->mSkinInfo->mX ) / mDefaultWidth;
		int y = ( GetScreenHeight() * winSkin->mSkinInfo->mY ) / mDefaultHeight;
		int w = ( GetScreenWidth() * winSkin->mSkinInfo->mWidth ) / mDefaultWidth;
		int h = ( GetScreenHeight() * winSkin->mSkinInfo->mHeight ) / mDefaultHeight;

		SetRelativeRect( cUIRect( x, y, x+w, x+h) );
	}*/

	/*if( mpCreate )
	{
		cUINodeSkin* pskin = pSkin->GetNodeSkin( mpCreate->GetSkinName() );
		if( pskin )
		{
			int x = ( GetScreenWidth() * pskin->mSkinInfo->mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * pskin->mSkinInfo->mY ) / mDefaultHeight;
			mpCreate->SetRelativePos( cUIPos( x, y ) );
		}
	}*/
}

void cMakeWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );
}

void cMakeWindow::OnCommand( cUINode* pCaller, unsigned int id )
{
	switch( id )
	{
	case eUIID_MAKE_CREATE:
		{
			if( mpName == 0 )
				return;
			cMakeStage* p = (cMakeStage*)STAGEMAN->GetStage( eStage_Make );
			if( p )
				p->SendMakeCharacter( mpName->GetText(),
									  mpGenderSpin->GetSelectedIdx(),
									  mpHairSpin->GetSelectedIdx(),
									  mpFaceSpin->GetSelectedIdx() + 1 );
		}
		break;
	case eSPINBOX_LEFTBTN:
	case eSPINBOX_RIGNTBTN:
		{
			if( pCaller == mpGenderSpin )
			{
				mDisplayUpdate = eChange_Object;
			}
			else if( pCaller == mpRaceSpin )
			{
				mDisplayUpdate = eChange_Object;

				mpJobSpin->Clear();

				int race = mpRaceSpin->GetSelectedIdx();
				switch( race )
				{
				case eRACE_HUMAN:
					{
						mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1010 ), (void*)ePLAYER_FIGHTER );
						mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1015 ), (void*)ePLAYER_MAGE );
					}
					break;
				case eRACE_BEAST:
					{
						mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1030 ), (void*)ePLAYER_WARRIOR );
						mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1035 ), (void*)ePLAYER_ROGUE );
					}
					break;
				case eRACE_ELF:
					{
						mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1020 ), (void*)ePLAYER_RANGER );
						mpJobSpin->AddData( GAMERESOURCEMAN->GetGameText( 1025 ), (void*)ePLAYER_SHAMAN );
					}
					break;
				}

				if( mpInfoWindow )
				{
					mpInfoWindow->UpdateRaceImage(race);
					mpInfoWindow->UpdateJobImage( race * 2 );
				}
			}
			else if( pCaller == mpJobSpin )
			{
				mDisplayUpdate = eChange_Form;
				
				if( mpInfoWindow )
				{
					int race = mpRaceSpin->GetSelectedIdx();
					int i = mpJobSpin->GetSelectedIdx();
					mpInfoWindow->UpdateJobImage( (race*2) + i );
				}
				
			}
			else
			{
				mDisplayUpdate = eChange_Form;
			}
		}
		break;
	}
}

/// 
void cMakeWindow::ResetSpinBox()
{
	if( mpGenderSpin )
		mpGenderSpin->SetSelectIdx(0);

	if( mpHairSpin )
		mpHairSpin->SetSelectIdx(0);

	if( mpFaceSpin )
		mpFaceSpin->SetSelectIdx(0);

	if( mpRaceSpin )
		mpRaceSpin->SetSelectIdx(0);

	if( mpJobSpin )
		mpJobSpin->SetSelectIdx(0);

	if( mpInfoWindow )
	{
		mpInfoWindow->UpdateRaceImage(0);
		mpInfoWindow->UpdateJobImage(0);
	}
}

void cMakeWindow::GetDisplayInfo( sPlayerInfo* info )
{
	if( mpGenderSpin )
		info->Gender = mpGenderSpin->GetSelectedIdx();

	if( mpHairSpin )
		info->HeadInfo[eHEAD_HAIR] = mpHairSpin->GetSelectedIdx();

	if( mpFaceSpin )
		info->HeadInfo[eHEAD_FACE] = mpFaceSpin->GetSelectedIdx() + 1;

	if( mpRaceSpin )
		info->Race	= mpRaceSpin->GetSelectedIdx();

	if( mpJobSpin )
	{
		int job = (int)mpJobSpin->GetExtraData( mpJobSpin->GetSelectedIdx() );
		info->Job = (ePLAYER_JOB)job;
	}
}