/* ==========================================================================
*      : MakeWindow.h
*      : 
*    : 谡
*    : 2006-12-04
* ǻ :
*===========================================================================*/
#pragma once
#include "UIBackWindow.h"

enum 
{
	eChange_None = 0,
	eChange_Object,
	eChange_Form,
};

class cEditBox;
class cSpinBox;
class cLabel;
class cButton;
class cUIImage;
struct sPlayerInfo;

const unsigned int MAX_RACE = 3;
const unsigned int MAX_JOB = 6;

/// ȸư 
class cMakeRotateWindow : public cUIWindow
{
public:
	cMakeRotateWindow();
	virtual ~cMakeRotateWindow();

protected:
	bool OnCreate(cUINodeProperty* pproperty );
	void OnRender(cUIFontItemKeeper* pKeeper );
	void OnCommand( cUINode* , unsigned int );
	void OnButtonContinueDowned(cUINode* , unsigned int id );
	void UpdateSkin();

private:
	/// ư  ̹
	cUIImage*	mpButtonBackImg;
	cUINodeSkin*	mpButtonSkin;

	/// U ȸ
	cButton* mpRotateRight;

	/// ȸ
	cButton* mpRotateLeft;
};

///   
class cMakeInfoWindow : public cUIWindow
{
public:
	cMakeInfoWindow();
	virtual ~cMakeInfoWindow();

	void UIStageIn();
	void UpdateRaceImage( int i );
	void UpdateJobImage( int i );

protected:
	/// ̺Ʈ
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* pcaller, unsigned int id );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void UpdateSkin();

private:
	cButton*		mpMakeSelect;

	///  ̹
	cUIImage*	mpRaceImage[MAX_RACE];

	///  ̹
	cUIImage*	mpJobImage[MAX_JOB];

	cUINodeSkin*	mpRaceSkin;
	cUINodeSkin*	mpJobSkin;

	cUIPos		mRacePos;
	cUIPos		mJobPos;

	int		mCurrentRace;
	int		mCurrentJob;
};

///  
class cMakeWindow : public cUIWindow
{
public:
	cMakeWindow();
	virtual ~cMakeWindow();

	void UIStageIn();

	/// ư Ȱȭ 
	void SetEnableCreate( bool enable );

	void GetDisplayInfo( sPlayerInfo* info );
	inline unsigned char CheckDisplayUpdate();

	void SetMakeInfoWindow( cMakeInfoWindow* win );

protected:
	/// ̺Ʈ
	bool OnCreate( cUINodeProperty* pproperty );
	void OnRender(cUIFontItemKeeper* pKeeper );
	void OnCommand( cUINode* pcaller, unsigned int id );
	void UpdateRect();
	void UpdateSkin();
	void OnShow();
	void OnHide();

	///
	void ResetSpinBox();

protected:
	unsigned char	mDisplayUpdate;

protected:
	/// ̸
	cEditBox*	mpName;

	///  ɹڽ
	cSpinBox* mpHairSpin;

	///   ڽ 
	cSpinBox* mpFaceSpin;

	/// gender  ڽ 
	cSpinBox* mpGenderSpin;
	
	///   ڽ 
	cSpinBox* mpRaceSpin;

	///   ڽ 
	cSpinBox* mpJobSpin;

	/// ĳ  ư 
	cUINode* mpCreate;

	///
	cUISize mUpdaetSize;

	///
	cMakeInfoWindow*	mpInfoWindow;
};

inline unsigned char cMakeWindow::CheckDisplayUpdate()
{
	unsigned char r = mDisplayUpdate;
	if( mDisplayUpdate != eChange_None )
		mDisplayUpdate = eChange_None;
	return r;
}

inline void cMakeWindow::SetMakeInfoWindow( cMakeInfoWindow* win )
{
	if( win )
		mpInfoWindow = win;
}