#include "StdAfx.h"
#include "mapchangeuimanager.h"
#include "UIBackWindow.h"
#include "LoadingWindow.h"

#include "GameResourceManager.h"
#include "ResourceManager.h"


cMapChangeUIManager::cMapChangeUIManager()
: mpBackWindow(0)
, mpLoadingWindow(0)
{
}

cMapChangeUIManager::~cMapChangeUIManager()
{
}

void cMapChangeUIManager::Init()
{
	UIMAN->SetCurrentStage( eStage_MapChange );

	/// ε  
	mpBackWindow = new cUIBackWindow;
	mpBackWindow->CreateByPropertyName( "P_LoadingBack2", 0 );

	mpLoadingWindow = new cLoadingWindow;
	mpLoadingWindow->CreateByPropertyName( "P_LoadingWindow2", 0 );

	mpBackWindow->SetOnlyBackground( true );
}

void cMapChangeUIManager::Exit()
{
	mpLoadingWindow = 0;
	mpBackWindow = 0;
}

void cMapChangeUIManager::Open( unsigned long mapIdx )
{
	UIMAN->SetCurrentStage( eStage_MapChange );

	cString pathName;
	LPCTSTR texname = GAMERESOURCEMAN->GetMapLoadTexture( mapIdx );
	pathName.Format( "./Data/2DData/%s", texname );
	NiTexture* tex = RESOURCEMAN->LoadMapTexture( pathName, false );
	if( tex )
	{
		mpBackWindow->SetBackTexture( tex );
		RESOURCEMAN->ChangeStageImageTexture( tex );
	}

	mpBackWindow->SetEnabled( false );
	mpBackWindow->Show();

	mpLoadingWindow->InitGauge( 100.0f );
	mpLoadingWindow->ShowTop();
}

void cMapChangeUIManager::Close()
{
	UIMAN->SetCurrentStage( eStage_MapChange );

	mpBackWindow->SetEnabled( false );
	mpBackWindow->Hide();
	mpLoadingWindow->Hide();

	mpBackWindow->SetBackTexture( 0 );
}

void cMapChangeUIManager::Process()
{

}

bool cMapChangeUIManager::UpdateLoadingGauge( float inc, float curMax )
{
	assert(mpLoadingWindow);

	if( mpLoadingWindow->GetCurrentValue() <= curMax )
		mpLoadingWindow->IncreaseGaugeValue( inc );

	return mpLoadingWindow->IsGaugeEnd();
}