#include "StdAfx.h"
#include ".\mapportalscenenode.h"

#include "ResourceManager.h"
#include "CameraManager.h"
#include "SceneManager.h"
#include "LightAgent.h"
#include "FogAgent.h"
#include "NifAnimationInfo.h"

#include "ObjectNameCard.h"
#include "StageScript.h"
#include "GameResourceManager.h"
#include "RenderSystem.h"

#include "ObjectManager.h"
#include "hero.h"

cMapPortalSceneNode::cMapPortalSceneNode( eType type )
: cManagedStaticSceneNode(type)
, mpNameCard(0)
{
	mPosScriptIdx = 0;
}

cMapPortalSceneNode::~cMapPortalSceneNode()
{
	SAFE_DELETE(mpNameCard);
}

void cMapPortalSceneNode::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	/// ݺ     带 ó
	if( mNifAniInfo )
	{
		mNeedUpdateTransform = true;
		mNifAniInfo->Update( deltaTime, accumTime );
	}
	else
		mNeedUpdateTransform = false;

	mPickedByCamera = false;

	cManagedStaticSceneNode::OnProcess( deltaTime, accumTime );

	if( mAlpha < 0.000001f )
		mCheckFrustum = false;
	else
		mCheckFrustum = true;
}

bool cMapPortalSceneNode::Init( const cMapPortalSceneNodeParam& param )
{
	mPosScriptIdx = param.mPosScriptIdx;

	sStageChangePos* pInfo = STAGESCRIPT->GetPosScriptInfo( mPosScriptIdx );
	if( pInfo == 0 )
		return false;

	///  ε
	param.mPathName += pInfo->mFileName;
	if( RESOURCEMAN->LoadNIF( param.mPathName.Cstr() ) == false )
	{
		assert( 0 && "failed to load nif file" );
		return false;
	}

	/// ҽ ڷκ  带 
	NiNode* n = RESOURCEMAN->CloneObjectByName( param.mPathName.Cstr() );
	if( n == 0 )
	{
		assert( 0 && "failed to clone node from resource manager" );
		return false;
	}

	///  ʱȭ
	mSceneNiNode = n;
	if( cSceneNode::Init( param ) == false )
	{
		return false;
	}

	/// Ӽ 
	CollectProperties( n );

	NiFogProperty* pFog = NiNew NiFogProperty;
	pFog->SetFog( false );
	n->AttachProperty( pFog );

	///  带 
	bool selectiveUpdate = true;
	bool rigid = false;
	n->SetSelectiveUpdateFlags( selectiveUpdate, mNifAniInfo!=0, rigid );

	///  带 ó
	n->UpdateProperties();
	n->UpdateEffects();
	n->Update( 0.f );
	n->UpdateNodeBound();

	/// create name card
	if( pInfo->mTargetInfo )
	{
		mpNameCard = new cNameCard;
		mpNameCard->SetName( (LPTSTR)GAMERESOURCEMAN->GetMapName( pInfo->mTargetInfo->mMapNumber ), 0xFF19F0A0 );
	}

	/// ִϸ̼ Ʈѷ  
	mNifAniInfo->CollectData( n );

	if( mNifAniInfo->GetNumberOfControllers() )
	{
		mNifAniInfo->SetAnimType( NiTimeController::APP_INIT );
		mNifAniInfo->SetLooping( true );
	}
	else
	{
		/// ִ  ٸ ޸ 
		SAFE_DELETE(mNifAniInfo);
	}

	return true;
}

void cMapPortalSceneNode::AddToVisibleArray()
{
	if( IsViewNode() == false )
		return;

	cSceneNode::AddToVisibleArray();

	if( mpNameCard )
	{
		NiPoint3 pos = this->GetWorldTranslate();
		pos.z += 720.0f;

		bool showName = false;

		if( mIsMouseOver == false )
		{
			NiPoint3 camPos = CAMERAMAN->GetCurrentNi()->GetWorldTranslate();
			float distCam = (pos - camPos).Length();
			float distHero = distCam;
			if( HERO )
				distHero = (pos - HERO->GetPos()).Length();

			if( distHero < 1500.0f )
				distHero = 1500.0f;
			if( distHero > 10000.0f )
				distHero = 10000.0f;

			if( distHero <= 3000.0f )
				showName = true;
		}
		else
		{
			showName = true;
		}

		if( showName )
		{
			float x,y;
			cPlane::WorldPtToScreenPt( CAMERAMAN->GetCurrentNi(), pos, x, y, false );
			int ScreenPosX = (int)( x * RENDERSYS->GetScreenWidth() );
			int ScreenPosY = (int)( (1.0f - y) * RENDERSYS->GetScreenHeight() );

			mpNameCard->Set2DPos( ScreenPosX, ScreenPosY, 0, 0 );
			SCENEMAN->AddPlane( mpNameCard );
		}


	}
}
