#include "StdAfx.h"
#include "MenuWindow.h"
#include "GameUIManager.h"
#include "Label.h"
#include "Button.h"

cMenuButtonWindow::cMenuButtonWindow()
{
	memset( mpMenu, 0, sizeof(mpMenu) );
}
cMenuButtonWindow::~cMenuButtonWindow()
{
}

bool cMenuButtonWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	UIMAN->AddEventOtherClick( this );
	return true;
}

void cMenuButtonWindow::AddMenu( unsigned int i, cUIWindow* p )
{
	if( i < eMENU_MAX && p )
	{
		mpMenu[i] = p;
	}
	else
	{
		assert(0);
	}
}

void cMenuButtonWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	for( int i = 0; i < eMENU_MAX; ++i )
	{
		if( mpMenu[i] )
		{
			cUIPos pos;
			pos.mX = mpMenu[i]->GetRelativeRect().mLeft;
			pos.mY = GetRelativeRect().mTop - mpMenu[i]->GetRelativeRect().GetHeight();
			mpMenu[i]->SetRelativePos( pos );
		}
	}
}

/// ǻ : 
void cMenuButtonWindow::OnCommand( cUINode*, unsigned int id )
{
	if( GAMEUI->IsShowCardBook() == true )
		return;

	eMenuType menuType = eMENU_MAX;

	switch( id )
	{
	case eUIID_GAME_MENUBUTTON_MALL:		menuType = eMENU_MALL;		break;
	case eUIID_GAME_MENUBUTTON_HERO:		menuType = eMENU_HERO;		break;
	case eUIID_GAME_MENUBUTTON_COMMU:		menuType = eMENU_COMMU;		break;
	case eUIID_GAME_MENUBUTTON_OPTION:		menuType = eMENU_OPTION;	break;
	default: assert(0); return;
	}

	if( menuType == eMENU_MAX )
		return;

	if( mpMenu[menuType] )
	{
		if( mpMenu[menuType]->IsVisible() )
		{
			mpMenu[menuType]->Hide();
		}
		else
		{
			///  ޴ 
			for( int i = 0; i < eMENU_MAX; ++i )
			{
				if( mpMenu[i] && i != menuType )
					mpMenu[i]->Hide();
			}

			mpMenu[menuType]->ShowTop();
		}
	}
}

///-------------------------------------------------------------------------
cMenuHeroWindow::cMenuHeroWindow()
{
}

cMenuHeroWindow::~cMenuHeroWindow()
{
}

bool cMenuHeroWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	UIMAN->AddEventOtherClick( this );
	return true;
}

void cMenuHeroWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	cUIWindow* win = (cUIWindow*)GAMEUI->GetMenuButtonWindow();
	if( win )
	{
		cUIPos pos;
		pos.mX = GetRelativeRect().mLeft;
		pos.mY = win->GetRelativeRect().mTop - GetRelativeRect().GetHeight();
		SetRelativePos( pos );
	}
}

void cMenuHeroWindow::OnCommand( cUINode* pcaller, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_MENUHERO_CLOSE:
		break;
	case eUIID_GAME_MENUHERO_INFO:
		GAMEUI->ShowHeroInfoWindow();
		break;
	case eUIID_GAME_MENUHERO_INVENTORY:
		GAMEUI->ShowInventoryWindow();
		break;
	case eUIID_GAME_MENUHERO_BOOK:
		GAMEUI->ShowCardBookWindow();
		break;
	case eUIID_GAME_MENUHERO_SKILL:
		GAMEUI->ShowSkillWindow();
		break;
	case eUIID_GAME_MENUHERO_QUEST:
		GAMEUI->ShowQuestWindow();
		break;
	}

	Hide();
}

void cMenuHeroWindow::OnMouseOtherClick( const cUIPos& pos )
{
	cUIWindow* win = GAMEUI->GetMenuButtonWindow();
	if( win )
	{
		cUIRect winRc = win->GetAbsoluteRect();
		if( winRc.ContainPoint( pos ) == false && 
			mAbsoluteRect.ContainPoint( pos ) == false )
		{
			Hide();
		}
	}
}

///-------------------------------------------------------------------------
cMenuCommuityWindow::cMenuCommuityWindow()
{
}

cMenuCommuityWindow::~cMenuCommuityWindow()
{
}

bool cMenuCommuityWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	UIMAN->AddEventOtherClick( this );
	return true;
}

void cMenuCommuityWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	cUIWindow* win = (cUIWindow*)GAMEUI->GetMenuButtonWindow();
	if( win )
	{
		cUIPos pos;
		pos.mX = GetRelativeRect().mLeft;
		pos.mY = win->GetRelativeRect().mTop - GetRelativeRect().GetHeight();
		SetRelativePos( pos );
	}
}

void cMenuCommuityWindow::OnCommand( cUINode* pcaller, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_MENUCOMMU_CLOSE:
		break;
	case eUIID_GAME_MENUCOMMU_NOTE:
		GAMEUI->ShowNoteWindow();
		break;
	case eUIID_GAME_MENUCOMMU_FRIEND:
		GAMEUI->ShowFriendWindow();
		break;
	case eUIID_GAME_MENUCOMMU_GUILD:
		GAMEUI->ShowGuildWindow();
		break;
	}

	Hide();
}

void cMenuCommuityWindow::OnMouseOtherClick( const cUIPos& pos )
{
	cUIWindow* win = GAMEUI->GetMenuButtonWindow();
	if( win )
	{
		cUIRect winRc = win->GetAbsoluteRect();
		if( winRc.ContainPoint( pos ) == false && 
			mAbsoluteRect.ContainPoint( pos ) == false )
		{
			Hide();
		}
	}
}

///-------------------------------------------------------------------------
cMenuOptionWindow::cMenuOptionWindow()
{
}

cMenuOptionWindow::~cMenuOptionWindow()
{
}

bool cMenuOptionWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	UIMAN->AddEventOtherClick( this );
	return true;
}

void cMenuOptionWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	cUIWindow* win = (cUIWindow*)GAMEUI->GetMenuButtonWindow();
	if( win )
	{
		cUIPos pos;
		pos.mX = GetRelativeRect().mLeft;
		pos.mY = win->GetRelativeRect().mTop - GetRelativeRect().GetHeight();
		SetRelativePos( pos );
	}
}

void cMenuOptionWindow::OnCommand( cUINode* pcaller, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_MENUOPTION_CLOSE:
		break;
	case eUIID_GAME_MENUOPTION_HELP:
		break;
	case eUIID_GAME_MENUOPTION_SETTING:
		GAMEUI->ShowOptionWindow();
		break;
	case eUIID_GAME_MENUOPTION_CHANGE:
		GAMEUI->ReqFinish( false );
		break;
	case eUIID_GAME_MENUOPTION_EXIT:
		GAMEUI->ReqFinish( true );
		break;
	}

	Hide();
}

void cMenuOptionWindow::OnMouseOtherClick( const cUIPos& pos )
{
	cUIWindow* win = GAMEUI->GetMenuButtonWindow();
	if( win )
	{
		cUIRect winRc = win->GetAbsoluteRect();
		if( winRc.ContainPoint( pos ) == false && 
			mAbsoluteRect.ContainPoint( pos ) == false )
		{
			Hide();
		}
	}
}

void cMenuOptionWindow::OnNetLock( int lockTry )
{
	cUINode* change = GetChild( eUIID_GAME_MENUOPTION_CHANGE );
	if( change )
		change->NetLock( lockTry );

	cUINode* exit = GetChild( eUIID_GAME_MENUOPTION_EXIT );
	if( exit )
		exit->NetLock( lockTry );
}

void cMenuOptionWindow::OnNetUnLock( int lockTry )
{
	cUINode* change = GetChild( eUIID_GAME_MENUOPTION_CHANGE );
	if( change )
		change->NetUnLock( lockTry );

	cUINode* exit = GetChild( eUIID_GAME_MENUOPTION_EXIT );
	if( exit )
		exit->NetUnLock( lockTry );
}
