///    http://serious-code.net/moin.cgi/MiniDump
///				 http://www.codeproject.com/threads/StackWalker.asp
#pragma once

#ifndef _WINDOWS_
#include <windows.h>
#endif

////////////////////////////////////////////////////////////////////////////////
/// \class cMiniDump
/// \brief ̴  ϱ  Ŭ. Ư   ־  
/// Ŭ ƴϰ,   Լ  ֱ    ̽ 
///  Ŭ̴. 
///
///  ʱȭ Install Լ  ̷. α׷  κ ƹ 
///  cMiniDump::Install(...) Լ ȣָ ȴ. 
///
/// <pre>
/// int main()
/// {
///     ...
///     cMiniDump::Install(cMiniDump::DUMP_LEVEL_LIGHT);
///     ...
/// }
/// </pre>
///
/// GUI   ִ α׷ , ڿ    θ 
/// ͵ ٰ ؼ, ȭâ ݹ Լ ϳ  ־. Install Լ 
///  ȭâ ݹ Լ ϸ,   ̸ Ȯ  ȭâ 
/// . ȭâ IDOK ,   ϰ, ׿   
///    ʴ´. ⺻ ȭâ Լ ڸ  Ʒ 
///  ̴.
///
/// <pre>
/// BOOL CALLBACK CrashDialogProc(
///     HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM /*lParam*/)
/// {
///     RECT parent, dlg;
///     int x, y;
/// 
///     switch (iMessage)
///     {
///     case WM_INITDIALOG:
///         ::GetWindowRect(::GetForegroundWindow(), &parent);
///         ::GetWindowRect(hDlg, &dlg);
///         x = (parent.left + parent.right - dlg.right) / 2;
///         y = (parent.top + parent.bottom - dlg.bottom) / 2;
///         ::MoveWindow(hDlg, x, y, dlg.right, dlg.bottom, FALSE);
//          ...
///         return TRUE;
///     case WM_COMMAND:
///         switch (LOWORD(wParam))
///         {
///         case IDOK: EndDialog(hDlg, IDOK); break;
///         case IDCANCEL: EndDialog(hDlg, IDCANCEL); break;
///         default: break;
///         }
///         return FALSE;
///     default:
///         break;
///     }
/// 
///     return FALSE;
/// }
/// </pre>
////////////////////////////////////////////////////////////////////////////////


class cMiniDump
{
public:
	///   
	enum DumpLevel
	{
		DUMP_LEVEL_LIGHT,  ///< MiniDumpNormal 
		DUMP_LEVEL_MEDIUM, ///< MiniDumpWithDataSegs 
		DUMP_LEVEL_HEAVY   ///< MiniDumpWithFullMemory 
	};


private:
	static DumpLevel ms_DumpLevel;          ///<  .
	static bool      ms_AddTimeStamp;       ///< ¥    ̸ 
	static TCHAR     ms_AppName[_MAX_PATH]; ///<   ̸
	static TCHAR     ms_CallStack[8192];    ///< ݽ ڿ
	static TCHAR     ms_Modules[8192];      ///<  ڿ
	static LPCTSTR   ms_DialogTemplate;     ///< ȭâ ø
	static DLGPROC   ms_DialogProc;         ///< ȭâ ν


public:
	/// \brief ̴   ʱȭѴ.
	static void Install(DumpLevel dumpLevel, bool addTimestamp=true, 
		LPCTSTR dialogTemplate=NULL, DLGPROC dialogProc=NULL);

	/// \brief ݽ ڿ ȯѴ.
	static LPCTSTR GetCallStack() { return ms_CallStack; }

	/// \brief  ڿ ȯѴ.
	static LPCTSTR GetModules() { return ms_Modules; }


private:
	/// \brief ܿ   ޾Ƽ, ̴   Ѵ. 
	static LONG WINAPI WriteDump(PEXCEPTION_POINTERS exPtrs);

	/// \brief  
	cMiniDump() {}

	/// \brief   
	cMiniDump(const cMiniDump&) {}

	/// \brief   
	cMiniDump& operator = (const cMiniDump&) { return *this; }
};



/*
#pragma once

#ifndef __NONCOPYABLE_H__
#include "Noncopyable.h"
#endif

class cMiniDumper : private Noncopyable
{
public:
	/// \brief   
	enum DumpLevel
	{
		DUMP_LEVEL_0, ///< MiniDumpNormal 
		DUMP_LEVEL_1, ///< MiniDumpWithDataSegs 
		DUMP_LEVEL_2  ///< MiniDumpWithFullMemory 
	};

private:
	///  .
	static DumpLevel ms_eDumpLevel;            

	///   ̸ٰ    ¥ ִ° .
	static BOOL ms_bAddTimeStamp;

	///   ̸ ڿ.
	static TCHAR ms_acAppName[_MAX_PATH];

	///  ߻ 
	static TCHAR ms_acFaultReason[2048];

public:
	/// \brief 
	cMiniDumper(DumpLevel DL, BOOL bAddTimestamp=TRUE);

	/// \brief Ҹ
	~cMiniDumper();

private:
	/// \brief ܿ   ޾Ƽ, ̴   Ѵ. 
	static LONG WINAPI TopLevelFilter(struct _EXCEPTION_POINTERS* pExPtrs);

	/// \brief  ο  ڿ ȯѴ.
	static LPCTSTR GetFaultReason(struct _EXCEPTION_POINTERS* pExPtrs);
};
*/