/* ==========================================================================
*      : Monster.h
*      :  
*    : ڰ
*    : 2006-10-12
* ǻ :
*===========================================================================*/
#pragma once

#include "BaseObject.h"
#include "Monster_Common.h"

class cPathNodeSet;

struct sTextItem;

/// Ʈ  
enum eMONSTER_ANIMATIONTYPE
{ 
	M_ANITYPE_IDLE1 = 1,	/// 
	M_ANITYPE_IDLE2,		/// ⺸
	M_ANITYPE_WORK,			/// ȱ
	M_ANITYPE_RUN,			/// ޸
	M_ANITYPE_ATTACK1,		/// 1
	M_ANITYPE_ATTACK2,		/// 2
	M_ANITYPE_ATTACK3,		/// 3
	M_ANITYPE_CASTING,		/// ĳ
	M_ANITYPE_SKILL1,		/// ų1
	M_ANITYPE_SKILL2,		/// ų2
	M_ANITYPE_DAMAGE1,		/// 1
	M_ANITYPE_DAMAGE2,		/// 2
	M_ANITYPE_DIE1,			/// 1
	M_ANITYPE_DIE2,			/// 2

	M_ANITYPE_MODEANI = 21,
};

class cMonster : public cBaseObject
{
public:

	cMonster( unsigned char type = eOBJECTTYPE_MONSTER );
	virtual ~cMonster();

	inline virtual unsigned long	GetObjectID() { return mMonsterIdx; }
	inline unsigned long			GetMonsterClassIdx() { return mpMonsterInfo->mMonsterClassIdx; }

	/// ü ó
	virtual bool		Create( sMonsterData* baseInfo, NiPoint3 pos, NiMatrix3 rotate = NiMatrix3::IDENTITY );
	virtual void		Update( unsigned long deltaTime, unsigned long accumTime );
	/// ü ũ
	unsigned int		SetLinkdObject( unsigned int num, char* nif );
	void				UnLinkdObject( unsigned int num );
	/// ȯ
	bool				SetDesiredDir(NiPoint3 CurrentPos, NiPoint3 TargetPos, unsigned long delay = 0 );


	/// ̵
	virtual bool		Move( float x, float y );


	///  ̸ 
	inline LPTSTR		GetName() { return mpMonsterInfo->mName; }
	///  
	unsigned char		GetLevel()	{ return mpMonsterInfo->mLevel; }


	/// ͽ ó
	unsigned long		GetHP()	{ return mHP; }
	unsigned long		GetMaxHP()	{ return mMaxHP; }
	/// Է   ŭ hp/mp 
	virtual void		HPChange( sTargetDamageHP* damage, cBaseObject* attacker = 0 );
	void				HPChange( unsigned long objectHP, unsigned long objectMaxHP, bool die );
	void				MPChange( unsigned long objectMP, unsigned long objectMaxMP );
	/// ̵ӵ
	void				SetMoveSpeed( unsigned int moveSpeed, eMOVE_SPEED_TYPE moveSpeedType = eMOVESPEED_STOP );

	///  ó
	virtual void				SetState( unsigned int state, bool bShowAni = true );
	virtual unsigned int		GetState() { return mState; }

	/// ã ó
	/// ̵   
	void				SetLastGoto( float x, float y) { mLastGotoX = x; mLastGotoY = y; }
	/// ̵ 
	void				SetPathArray( NiPoint2* moveArray, unsigned int count );
	/// ̵ 
	void				MoveStop( float x, float y );
	/// ̵ǥ     
	void				SetMoveStopRange( float moveStopRange ) { mMoveStopRange = moveStopRange; }


	///  ó
	void				MonsterAttack( unsigned long uIdx, unsigned long skillIdx, cBaseObject* pTarget, float attackSpeedFactor );

	virtual void		ApplyDamageDrama( unsigned int damage, unsigned int damageType, cBaseObject* pAttacker = 0 );

	/// Ʈ Ÿ üũ  Ÿ -  
	float				GetFixedObjectSize()	{ return mFixedObjectSize; }

	bool				IsPrecedeAttack();

	/// ⵿2 
	void				PlayIdle2Ani();

	void ActiveChatBubble( sTextItem* text );

	virtual bool IsDie() { return (GetState()==eOBJECT_STATE_DIE); }

	void ChangeMonsterMode( long modeIdx );

protected:

	/// ִϸ̼  
	virtual void		Interpret( unsigned long time );

protected:

	/// monster ȣ
	unsigned long		mMonsterIdx;
	///  
	sMonsterScript*		mpMonsterInfo;


	/// ̵ӵ
	unsigned int		mMoveSpeed;
	/// HP/MP 
	unsigned long		mHP;
	unsigned long		mMP;
	unsigned long		mMaxHP;
	unsigned long		mMaxMP;


	/// ̵  ǥ
	float				mGotoX;
	float				mGotoY;
	/// ̵ ġ
	float				mLastGotoX;
	float				mLastGotoY;
	/// ̵   
	NiPoint3			mDesiredDir;
	/// ̵ǥ     
	float				mMoveStopRange;

	unsigned long		mMoveOverTime;		///   ̵ μ ݿ Ѿ ð

	///  
	eOBJECTSTATE		mState;
	/// ü  ð
	unsigned long		mMonsterDieTime;

	eMOVE_SPEED_TYPE	mMoveSpeedType;

	/// ã
	static const unsigned int MAX_PATH_COUNT = 2048;
	NiPoint2			mPathArray[MAX_PATH_COUNT];
	unsigned int		mPathIndex;
	unsigned int		mPathCount;

	/// 
	unsigned long		mDelay;
	float				mAngle;
	float				mAccumAngle;
	NiPoint3			mAxis;

	/// Ʈ Ÿ üũ  Ÿ -  
	float				mFixedObjectSize;

	unsigned int		mDamageAfterAnim;

	typedef tList<unsigned long> cModeLoopList;
	cModeLoopList mModeLoopEffectList;
	cModeLoopList mModeLoopSoundList;
};
