/* ==========================================================================
*      : MsgBox.h
*      : 
*    : 谡
*    : 2007-04-02
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "UIMsgboxEvent.h"
#include "UINodeData.h"

class cBaseStage;
class cButton;
class cLabel;
class cEditBox;

class cMsgBox : public cUIWindow
{
	friend class cUIManager;
public:
	virtual ~cMsgBox();

	bool InitWindow();

	/// Ʈ ؽƮ ´
	LPCTSTR GetEditText() const;
	unsigned int GetLength() const;

	/// Ʈڽ ִ ̸ 
	void SetMaxLength( int length );

	eBoxSkin_Type GetSkinType() { return mSkinType; }

protected:
	/// Msgڽ  UIMANAGER Ѵ.
	cMsgBox( eUINodeType type = eUINODE_MESSAGEBOX );

	/// ޽ ڽ  	
	bool Create( cBaseStage* msgHandler, eMSGBox_Event eventtype, eBoxSkin_Type skintype, eMSGBox_Type boxtype, void* extraData = 0, 
				 unsigned long totaltime = 0, bool printTime = false, bool success = false );

	/// ϴ · ޽ڽ  ֱ
	void SetText( LPCTSTR text, LPCTSTR caption );
	void SetMessage( LPCTSTR text );
		
protected:
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual bool IsValid() const;
	virtual bool HandleEvent( const cUIEvent& event );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );   
	virtual void OnKeyDown( eKeyCode code );
	virtual void OnShow();
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void UpdateRect();
	virtual void UpdateSkin();
	virtual void UpdateText();
	
protected:
	/// ڽ Ʈ Ų 
	cString mOkButtonSkin;
	cString mYesButtonSkin;
	cString mNoButtonSkin;
	cString mEditSkin;

	/// ڽ Ʈ 
	cButton*	mpYesButton;
	cButton*	mpNoButton;

	/// Ʈڽ
	cEditBox*	mpEdit;

	/// ؽƮ  
	cLabel*		mpLabel;

	/// Ų Ÿ 
	eBoxSkin_Type mSkinType;

	/// ޽ڽ Ÿ
	eMSGBox_Type mModalType;

	/// ؽƮ ġ 
	int mTextPosX, mTextPosY;
	int mCaptionPosX, mCaptionPosY;

	/// ĸ ؽƮ
	cStringT mCaptionText;
	LPCTSTR mText;
	void*		mExtraData;

	/// ð  ֱ
	unsigned long	mStartTime;
	unsigned long	mTotalTime;
	bool			mTimePrint;			/// ð   

	bool			mResultEvent;		///  or  ޼
};


//////////////////////////////////////////////////////////////////////////
class cMessageBoxSkin : public cUINodeSkin
{
public:
	cMessageBoxSkin( eUINodeType type = eUINODE_MESSAGEBOX );
	virtual ~cMessageBoxSkin();

	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ̵ 
	bool mMoveable;

	/// ĸǿ 
	cUIRect mCaptionRect;

	/// ư ڽ Ų 
	cString mOkButtonSkin;
	cString mYesButtonSkin;
	cString mNoButtonSkin;
	cString mEditSkin;
};
